/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.sql.DatabaseMetaData;
import java.util.Properties;
import org.datanucleus.jdo.spatial.SpatialHelper;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.PostgreSQLAdapter;
import org.datanucleus.store.rdbms.adapter.SpatialRDBMSAdapter;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.schema.PostGISTypeInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class PostGISAdapter
extends PostgreSQLAdapter
implements SpatialRDBMSAdapter {
    protected static final Localiser LOCALISER_POSTGIS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.adapter.Localisation_PostGIS", (ClassLoader)SpatialHelper.class.getClassLoader());
    public static final String HAS_MEASURE_EXTENSION_KEY = "postgis-hasMeasure";

    public PostGISAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.remove("PrimaryKeyInCreateStatements");
    }

    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        PostGISTypeInfo sqlType = PostGISTypeInfo.TYPEINFO_PROTOTYPE;
        this.addSQLTypeForJDBCType(handler, mconn, (short)1111, sqlType, true);
    }

    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return "ALTER TABLE " + pk.getTable().toString() + " ADD " + pk;
    }

    public String getAddColumnStatement(Table table, Column column) {
        if (this.isGeometryColumn(column)) {
            return this.getAddGeometryColumnStatement(table, column);
        }
        return super.getAddColumnStatement(table, column);
    }

    public String getCreateTableStatement(TableImpl table, Column[] columns, Properties props, IdentifierFactory factory) {
        boolean hasGeometryColumn = false;
        for (int i = 0; i < columns.length; ++i) {
            if (!this.isGeometryColumn(columns[i])) continue;
            hasGeometryColumn = true;
            break;
        }
        if (!hasGeometryColumn) {
            return super.getCreateTableStatement(table, columns, null, factory);
        }
        StringBuffer createStatements = new StringBuffer();
        createStatements.append("CREATE TABLE ").append(table.toString()).append(" ();").append(this.getContinuationString());
        for (int i = 0; i < columns.length; ++i) {
            String stmt = this.getAddColumnStatement((Table)table, columns[i]);
            createStatements.append(stmt).append(";").append(this.getContinuationString());
        }
        return createStatements.toString();
    }

    @Override
    public String getRetrieveCrsWktStatement(Table table, int srid) {
        return "SELECT srtext FROM #schema . spatial_ref_sys WHERE srid = #srid".replace("#schema", table.getSchemaName()).replace("#srid", "" + srid);
    }

    @Override
    public String getRetrieveCrsNameStatement(Table table, int srid) {
        return "SELECT auth_name || ':' || auth_srid FROM #schema . spatial_ref_sys WHERE srid = #srid".replace("#schema", table.getSchemaName()).replace("#srid", "" + srid);
    }

    @Override
    public String getCalculateBoundsStatement(Table table, Column column) {
        return "SELECT min(xmin(box2d(#column))), min(ymin(box2d(#column))), max(xmax(box2d(#column))), max(ymax(box2d(#column)))" + "FROM #schema . #table".replace("#schema", table.getSchemaName()).replace("#table", "" + table.getIdentifier().getIdentifierName()).replace("#column", "" + column.getIdentifier().getIdentifierName());
    }

    private String getAddGeometryColumnStatement(Table table, Column column) {
        int srid = -1;
        int dimension = 2;
        boolean hasMeasure = false;
        String extensionValue = MetaDataUtils.getValueForExtensionRecursively((MetaData)column.getColumnMetaData(), (String)"spatial-srid");
        if (extensionValue != null) {
            try {
                srid = Integer.parseInt(extensionValue);
            }
            catch (NumberFormatException nfe) {
                NucleusLogger.DATASTORE.warn((Object)LOCALISER_POSTGIS.msg("RDBMS.Adapter.InvalidExtensionValue", (Object)"spatial-srid", (Object)extensionValue), (Throwable)nfe);
            }
        }
        if ((extensionValue = MetaDataUtils.getValueForExtensionRecursively((MetaData)column.getColumnMetaData(), (String)"spatial-dimension")) != null) {
            try {
                dimension = Byte.parseByte(extensionValue);
            }
            catch (NumberFormatException nfe) {
                NucleusLogger.DATASTORE.warn((Object)LOCALISER_POSTGIS.msg("RDBMS.Adapter.InvalidExtensionValue", (Object)"spatial-dimension", (Object)extensionValue), (Throwable)nfe);
            }
        }
        if ((extensionValue = MetaDataUtils.getValueForExtensionRecursively((MetaData)column.getColumnMetaData(), (String)HAS_MEASURE_EXTENSION_KEY)) != null) {
            try {
                hasMeasure = Boolean.parseBoolean(extensionValue);
            }
            catch (NumberFormatException nfe) {
                NucleusLogger.DATASTORE.warn((Object)LOCALISER_POSTGIS.msg("RDBMS.Adapter.InvalidExtensionValue", (Object)HAS_MEASURE_EXTENSION_KEY, (Object)extensionValue), (Throwable)nfe);
            }
        }
        if (hasMeasure) {
            dimension = (byte)(dimension + 1);
        }
        return "SELECT AddGeometryColumn( '#schema', '#table', '#column', #srid, '#type', #dimension )".replace("#schema", table.getSchemaName() == null ? "" : table.getSchemaName()).replace("#table", table.getIdentifier().getIdentifierName()).replace("#column", column.getIdentifier().getIdentifierName()).replace("#srid", "" + srid).replace("#type", column.getTypeInfo().getLocalTypeName().concat(hasMeasure ? "M" : "")).replace("#dimension", "" + dimension);
    }

    @Override
    public boolean isGeometryColumn(Column column) {
        SQLTypeInfo typeInfo = column.getTypeInfo();
        return typeInfo == null ? false : typeInfo.getTypeName().equalsIgnoreCase("geometry");
    }
}

