/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.expression.GeometryExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.sql.method.SpatialMethodHelper;

public class SpatialGeometryNMethod2
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (expr == null && (args == null || args.size() != 2)) {
            throw new NucleusUserException("Cannot invoke Spatial.geometryN without 2 arguments");
        }
        if (expr != null && args != null && args.size() != 1) {
            throw new NucleusUserException("Cannot invoke geom.getGeometryN() without 1 argument");
        }
        SQLExpression geomExpr = expr;
        SQLExpression distExpr = expr;
        if (expr == null) {
            geomExpr = (SQLExpression)args.get(0);
            distExpr = (SQLExpression)args.get(1);
        } else {
            geomExpr = expr;
            distExpr = (SQLExpression)args.get(0);
        }
        ArrayList<SQLExpression> geomFuncArgs = new ArrayList<SQLExpression>();
        geomFuncArgs.add(geomExpr);
        GeometryExpression geomSdoExpr = new GeometryExpression(this.stmt, null, "geometry.from_sdo_geom", geomFuncArgs, null);
        ArrayList<GeometryExpression> treatFuncArgs = new ArrayList<GeometryExpression>();
        treatFuncArgs.add(geomSdoExpr);
        ArrayList<String> treatFuncTypeArgs = new ArrayList<String>();
        treatFuncTypeArgs.add("GeometryCollection");
        GeometryExpression treatExpr = new GeometryExpression(this.stmt, null, "treat", treatFuncArgs, treatFuncTypeArgs);
        ArrayList<SQLExpression> startFuncArgs = new ArrayList<SQLExpression>();
        startFuncArgs.add(treatExpr);
        startFuncArgs.add(distExpr);
        GeometryExpression startExpr = new GeometryExpression(this.stmt, null, "geometryN", startFuncArgs, null);
        ArrayList<GeometryExpression> funcArgs = new ArrayList<GeometryExpression>();
        funcArgs.add(startExpr);
        JavaTypeMapping geomMapping = SpatialMethodHelper.getGeometryMapping(this.clr, geomExpr);
        return new GeometryExpression(this.stmt, geomMapping, "geometry.get_sdo_geom", funcArgs, null);
    }
}

