/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.jts2postgis;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.jts2postgis.LineStringRDBMSMapping;
import org.datanucleus.store.rdbms.table.Column;

public class LinearRingRDBMSMapping
extends LineStringRDBMSMapping {
    public LinearRingRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(mapping, storeMgr, col);
    }

    @Override
    public Object getObject(ResultSet rs, int exprIndex) {
        LineString lineString = (LineString)super.getObject(rs, exprIndex);
        if (lineString == null) {
            return null;
        }
        LinearRing linearRing = new LinearRing(lineString.getCoordinateSequence(), lineString.getFactory());
        linearRing.setSRID(lineString.getSRID());
        return linearRing;
    }

    @Override
    public void setObject(PreparedStatement ps, int exprIndex, Object value) {
        LineString lineString = null;
        if (value != null) {
            LinearRing linearRing = (LinearRing)value;
            lineString = new LineString(linearRing.getCoordinateSequence(), linearRing.getFactory());
            lineString.setSRID(linearRing.getSRID());
        }
        super.setObject(ps, exprIndex, lineString);
    }
}

