/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.ao2postgis;

import com.esri.arcgis.geometry.GeometryEnvironment;
import com.esri.arcgis.geometry.IGeometry;
import com.esri.arcgis.geometry.ISpatialReference;
import com.esri.arcgis.geometry.SpatialReferenceEnvironment;
import com.linar.jintegra.AutomationException;
import com.linar.jintegra.Variant;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.PostGISTypeInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;

public abstract class GeometryRDBMSMapping
extends AbstractDatastoreMapping {
    private static final SQLTypeInfo typeInfo = (SQLTypeInfo)PostGISTypeInfo.TYPEINFO_PROTOTYPE.clone();

    public GeometryRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        this.initTypeInfo();
    }

    public SQLTypeInfo getTypeInfo() {
        return typeInfo;
    }

    public abstract Object getObject(ResultSet var1, int var2);

    public void setObject(PreparedStatement ps, int exprIndex, Object value) {
        try {
            if (value == null) {
                ps.setNull(exprIndex, this.getTypeInfo().getDataType(), this.getTypeInfo().getTypeName());
            } else {
                byte[] wkb = this.convertToWkb(value);
                ps.setBytes(exprIndex, wkb);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.failureMessage("setObject", value, e), (Throwable)e);
        }
    }

    public IGeometry getFromWkb(byte[] wkb) {
        IGeometry[] iGeom = new IGeometry[1];
        int[] byteCount = new int[]{wkb.length};
        GeometryEnvironment geoEnvironment = new GeometryEnvironment();
        geoEnvironment.createGeometryFromWkb(byteCount, wkb, iGeom);
        if (iGeom[0] != null) {
            int srid = 4326;
            ISpatialReference sRef = new SpatialReferenceEnvironment().createSpatialReference(srid);
            iGeom[0].setSpatialReferenceByRef(sRef);
        }
        return iGeom[0];
    }

    public byte[] convertToWkb(Object geom) {
        GeometryEnvironment geoEnvironment = new GeometryEnvironment();
        Variant var = geoEnvironment.createWkbVariantFromGeometry((IGeometry)geom);
        if (var.getVT() == 16) {
            return var.getI1Array();
        }
        if (var.getVT() == 17) {
            return var.getUI1Array();
        }
        return null;
    }

    public int getSRID(Object geom) {
        try {
            return ((IGeometry)geom).getSpatialReference().getSpatialReferenceImpl();
        }
        catch (AutomationException e) {
            return -1;
        }
    }

    static {
        typeInfo.setLocalTypeName("GEOMETRY");
    }
}

