/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.sql.DatabaseMetaData;
import org.datanucleus.store.rdbms.adapter.OracleAdapter;
import org.datanucleus.store.rdbms.adapter.SpatialRDBMSAdapter;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;

public class OracleSpatialAdapter
extends OracleAdapter
implements SpatialRDBMSAdapter {
    public OracleSpatialAdapter(DatabaseMetaData metadata) {
        super(metadata);
    }

    @Override
    public boolean isGeometryColumn(Column c) {
        return c.getTypeInfo().getDataType() == -123;
    }

    @Override
    public String getRetrieveCrsNameStatement(Table table, int srid) {
        return "SELECT CS_NAME FROM MDSYS.CS_SRS WHERE SRID = #srid".replace("#srid", "" + srid);
    }

    @Override
    public String getRetrieveCrsWktStatement(Table table, int srid) {
        return "SELECT WKTEXT FROM MDSYS.CS_SRS WHERE SRID = #srid".replace("#srid", "" + srid);
    }

    @Override
    public String getCalculateBoundsStatement(Table table, Column column) {
        return "SELECT SDO_GEOM.SDO_MIN_MBR_ORDINATE(SDO_AGGR_MBR(#column), 1), SDO_GEOM.SDO_MIN_MBR_ORDINATE(SDO_AGGR_MBR(#column), 2), SDO_GEOM.SDO_MAX_MBR_ORDINATE(SDO_AGGR_MBR(#column), 1), SDO_GEOM.SDO_MAX_MBR_ORDINATE(SDO_AGGR_MBR(#column), 2) " + "FROM #table".replace("#column", column.getIdentifier().getIdentifierName()).replace("#table", table.getIdentifier().getIdentifierName());
    }
}

