/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.inmemory.method;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.query.expression.InvokeExpression;
import org.datanucleus.store.query.expression.Literal;
import org.datanucleus.store.query.expression.ParameterExpression;
import org.datanucleus.store.query.expression.PrimaryExpression;
import org.datanucleus.store.query.inmemory.InMemoryExpressionEvaluator;
import org.datanucleus.store.query.inmemory.InvocationEvaluator;

public class SubstringFunction
implements InvocationEvaluator {
    @Override
    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        String method = expr.getOperation();
        Expression param = expr.getArguments().get(0);
        Object paramValue = null;
        if (param instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)param;
            paramValue = eval.getValueForPrimaryExpression(primExpr);
        } else if (param instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)param;
            paramValue = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
        } else if (param instanceof Literal) {
            paramValue = ((Literal)param).getLiteral();
        } else {
            throw new NucleusException(method + "(param, num1, num2) where param is instanceof " + param.getClass().getName() + " not supported");
        }
        if (paramValue == null) {
            return null;
        }
        Expression num1 = expr.getArguments().get(1);
        int num1Value = -1;
        if (!(num1 instanceof Literal)) {
            throw new NucleusException(method + "(param, num1, num2) where num1 is instanceof " + num1.getClass().getName() + " not supported");
        }
        num1Value = eval.getIntegerForLiteral((Literal)num1);
        Expression num2 = expr.getArguments().get(2);
        int num2Value = -1;
        if (!(num2 instanceof Literal)) {
            throw new NucleusException(method + "(param, num1, num2) where num2 is instanceof " + num2.getClass().getName() + " not supported");
        }
        num2Value = eval.getIntegerForLiteral((Literal)num2);
        return ((String)paramValue).substring(num1Value, num2Value);
    }
}

