/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.expression;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.store.query.compiler.Symbol;
import org.datanucleus.store.query.compiler.SymbolTable;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.util.StringUtils;

public class ArrayExpression
extends Expression {
    private static final long serialVersionUID = -1145090859293765860L;
    List<Expression> elements = new ArrayList<Expression>();

    public ArrayExpression(Expression[] elements) {
        if (elements != null) {
            for (Expression elem : elements) {
                this.elements.add(elem);
                elem.parent = this;
            }
        }
    }

    public Expression getElement(int index) {
        if (index < 0 || index >= this.elements.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.elements.get(index);
    }

    public int getArraySize() {
        return this.elements.size();
    }

    @Override
    public Symbol bind(SymbolTable symtbl) {
        for (Expression expr : this.elements) {
            expr.bind(symtbl);
        }
        return this.symbol;
    }

    public String toString() {
        return "ArrayExpression{" + StringUtils.collectionToString(this.elements) + "}";
    }
}

