/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistableObjectType;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.StateManagerImpl;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.containers.ContainerHandler;
import org.datanucleus.store.types.containers.ElementContainerAdapter;
import org.datanucleus.store.types.containers.MapContainerAdapter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class L2CacheRetrieveFieldManager
extends AbstractFieldManager {
    protected final DNStateManager sm;
    protected final ExecutionContext ec;
    protected final CachedPC cachedPC;
    protected List<Integer> fieldsNotLoaded = null;

    public L2CacheRetrieveFieldManager(DNStateManager sm, CachedPC cachedpc) {
        this.sm = sm;
        this.ec = sm.getExecutionContext();
        this.cachedPC = cachedpc;
    }

    public int[] getFieldsNotLoaded() {
        if (this.fieldsNotLoaded == null) {
            return null;
        }
        return this.fieldsNotLoaded.stream().mapToInt(i -> i).toArray();
    }

    @Override
    public boolean fetchBooleanField(int fieldNumber) {
        return (Boolean)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public byte fetchByteField(int fieldNumber) {
        return (Byte)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public char fetchCharField(int fieldNumber) {
        return ((Character)this.cachedPC.getFieldValue(fieldNumber)).charValue();
    }

    @Override
    public double fetchDoubleField(int fieldNumber) {
        return (Double)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public float fetchFloatField(int fieldNumber) {
        return ((Float)this.cachedPC.getFieldValue(fieldNumber)).floatValue();
    }

    @Override
    public int fetchIntField(int fieldNumber) {
        return (Integer)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public long fetchLongField(int fieldNumber) {
        return (Long)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public short fetchShortField(int fieldNumber) {
        return (Short)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public String fetchStringField(int fieldNumber) {
        return (String)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public Object fetchObjectField(int fieldNumber) {
        Object value = this.cachedPC.getFieldValue(fieldNumber);
        if (value == null) {
            return null;
        }
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        return mmd.hasContainer() ? this.processContainerField(mmd, value) : this.processField(mmd, value);
    }

    protected Object processContainerField(AbstractMemberMetaData mmd, Object container) {
        Object containerHandler = this.sm.getExecutionContext().getTypeManager().getContainerHandler(mmd.getType());
        return mmd.hasMap() ? this.processMapContainer(mmd, container, (ContainerHandler<Object, MapContainerAdapter<Object>>)containerHandler) : this.processElementContainer(mmd, container, (ContainerHandler<Object, ElementContainerAdapter<Object>>)containerHandler);
    }

    protected Object processMapContainer(AbstractMemberMetaData mmd, Object cachedMapContainer, ContainerHandler<Object, MapContainerAdapter<Object>> containerHandler) {
        try {
            MapContainerAdapter<Object> cachedMapContainerAdapter = containerHandler.getAdapter(cachedMapContainer);
            Object newContainer = L2CacheRetrieveFieldManager.newContainer(cachedMapContainer, mmd, containerHandler);
            MapContainerAdapter<Object> fieldMapContainerAdapter = containerHandler.getAdapter(newContainer);
            boolean keyIsPersistent = mmd.getMap().keyIsPersistent();
            boolean keyIsEmbedded = mmd.getMap().isEmbeddedKey();
            boolean keyIsSerialised = mmd.getMap().isSerializedKey();
            boolean valueIsPersistent = mmd.getMap().valueIsPersistent();
            boolean valueIsEmbedded = mmd.getMap().isEmbeddedValue();
            boolean valueIsSerialised = mmd.getMap().isSerializedValue();
            for (Map.Entry<Object, Object> entry : cachedMapContainerAdapter.entries()) {
                Object mapKey = null;
                mapKey = keyIsPersistent ? (keyIsEmbedded || keyIsSerialised || mmd.isSerialized() ? this.convertCachedPCToPersistable((CachedPC)entry.getKey(), mmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_MAP_KEY_PC) : this.getObjectFromCachedId(entry.getKey())) : entry.getKey();
                Object mapValue = null;
                Object mapValueId = entry.getValue();
                if (mapValueId != null) {
                    mapValue = valueIsPersistent ? (valueIsEmbedded || valueIsSerialised || mmd.isSerialized() ? this.convertCachedPCToPersistable((CachedPC)entry.getValue(), mmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_MAP_VALUE_PC) : this.getObjectFromCachedId(entry.getValue())) : entry.getValue();
                }
                fieldMapContainerAdapter.put(mapKey, mapValue);
            }
            return SCOUtils.wrapSCOField(this.sm, mmd.getAbsoluteFieldNumber(), fieldMapContainerAdapter.getContainer(), true);
        }
        catch (Exception e) {
            if (this.fieldsNotLoaded == null) {
                this.fieldsNotLoaded = new ArrayList<Integer>();
            }
            this.fieldsNotLoaded.add(mmd.getAbsoluteFieldNumber());
            NucleusLogger.CACHE.error("Exception thrown creating value for field " + mmd.getFullFieldName() + " of type " + cachedMapContainer.getClass().getName(), e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object processElementContainer(AbstractMemberMetaData mmd, Object cachedContainer, ContainerHandler<Object, ElementContainerAdapter<Object>> containerHandler) {
        try {
            Object newContainer = mmd.hasArray() ? containerHandler.newContainer(mmd) : L2CacheRetrieveFieldManager.newContainer(cachedContainer, mmd, containerHandler);
            ElementContainerAdapter<Object> fieldContainerAdapter = containerHandler.getAdapter(newContainer);
            RelationType relType = mmd.getRelationType(this.ec.getClassLoaderResolver());
            ElementContainerAdapter<Object> cachedContainerAdapter = containerHandler.getAdapter(cachedContainer);
            if (relType == RelationType.NONE) {
                String elementType = mmd.hasCollection() ? mmd.getCollection().getElementType() : mmd.getArray().getElementType();
                boolean bl = this.ec.getTypeManager().isSecondClassMutableType(elementType);
                if (bl) {
                    for (Object t : cachedContainerAdapter) {
                        fieldContainerAdapter.add(SCOUtils.copyValue(t));
                    }
                } else {
                    for (Object t : cachedContainerAdapter) {
                        fieldContainerAdapter.add(t);
                    }
                }
            } else if ((containerHandler.isSerialised(mmd) || containerHandler.isEmbedded(mmd)) && this.ec.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.cache.level2.cacheembedded")) {
                for (Object t : cachedContainerAdapter) {
                    void var11_21;
                    CachedPC elementCachedPC = (CachedPC)t;
                    Object var11_22 = null;
                    if (elementCachedPC != null) {
                        Object object = this.convertCachedPCToPersistable(elementCachedPC, mmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_COLLECTION_ELEMENT_PC);
                    }
                    fieldContainerAdapter.add(var11_21);
                }
            } else {
                for (Object t : cachedContainerAdapter) {
                    Object element = t == null ? null : this.getObjectFromCachedId(t);
                    fieldContainerAdapter.add(element);
                }
            }
            return SCOUtils.wrapSCOField(this.sm, mmd.getAbsoluteFieldNumber(), fieldContainerAdapter.getContainer(), true);
        }
        catch (Exception e) {
            if (this.fieldsNotLoaded == null) {
                this.fieldsNotLoaded = new ArrayList<Integer>();
            }
            this.fieldsNotLoaded.add(mmd.getAbsoluteFieldNumber());
            NucleusLogger.CACHE.error("Exception thrown creating value for field " + mmd.getFullFieldName() + " of type " + cachedContainer.getClass().getName(), e);
            return null;
        }
    }

    protected Object processField(AbstractMemberMetaData mmd, Object value) {
        RelationType relType = mmd.getRelationType(this.ec.getClassLoaderResolver());
        if (relType == RelationType.NONE) {
            return SCOUtils.wrapSCOField(this.sm, mmd.getAbsoluteFieldNumber(), SCOUtils.copyValue(value), true);
        }
        if ((mmd.isSerialized() || MetaDataUtils.isMemberEmbedded(mmd, relType, this.ec.getClassLoaderResolver(), this.ec.getMetaDataManager())) && this.ec.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.cache.level2.cacheembedded") && value instanceof CachedPC) {
            return this.convertCachedPCToPersistable((CachedPC)value, mmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_PC);
        }
        try {
            return this.getObjectFromCachedId(value);
        }
        catch (NucleusObjectNotFoundException nonfe) {
            if (this.fieldsNotLoaded == null) {
                this.fieldsNotLoaded = new ArrayList<Integer>();
            }
            this.fieldsNotLoaded.add(mmd.getAbsoluteFieldNumber());
            return null;
        }
    }

    protected Object getObjectFromCachedId(Object cachedId) {
        Object pcId = null;
        String pcClassName = null;
        if (cachedId instanceof CachedPC.CachedId) {
            CachedPC.CachedId cId = (CachedPC.CachedId)cachedId;
            pcId = cId.getId();
            pcClassName = cId.getClassName();
        } else {
            pcId = cachedId;
            pcClassName = IdentityUtils.getTargetClassNameForIdentity(pcId);
        }
        Class pcCls = this.ec.getClassLoaderResolver().classForName(pcClassName);
        return this.ec.findObject(pcId, null, pcCls, false, false);
    }

    static <T> T newContainer(Object container, AbstractMemberMetaData mmd, ContainerHandler containerHandler) {
        try {
            return (T)container.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return (T)containerHandler.newContainer(mmd);
        }
    }

    protected Object convertCachedPCToPersistable(CachedPC cachedPC, int memberNumber, PersistableObjectType objectType) {
        AbstractClassMetaData valueCmd = this.ec.getMetaDataManager().getMetaDataForClass(cachedPC.getObjectClass(), this.ec.getClassLoaderResolver());
        DNStateManager valueSM = this.ec.getNucleusContext().getStateManagerFactory().newForEmbedded(this.ec, valueCmd, this.sm, memberNumber, objectType);
        int[] fieldsToLoad = ClassUtils.getFlagsSetTo(cachedPC.getLoadedFields(), valueCmd.getAllMemberPositions(), true);
        if (fieldsToLoad != null && fieldsToLoad.length > 0) {
            valueSM.replaceFields(fieldsToLoad, this.constructNew(valueSM, cachedPC));
        }
        return valueSM.getObject();
    }

    protected L2CacheRetrieveFieldManager constructNew(DNStateManager valueSM, CachedPC cachedPC) {
        if (valueSM instanceof StateManagerImpl) {
            return ((StateManagerImpl)valueSM).constructL2CacheRetrieveFieldManager(valueSM, cachedPC);
        }
        return new L2CacheRetrieveFieldManager(valueSM, cachedPC);
    }
}

