/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.cache;

import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.PropertyNames;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.cache.QueryCompilationCache;
import org.datanucleus.store.query.compiler.QueryCompilation;
import org.datanucleus.util.NucleusLogger;

public class JavaxCacheQueryCompilationCache
implements QueryCompilationCache,
Serializable {
    private static final long serialVersionUID = 6184328064337729891L;
    private Cache<String, QueryCompilation> cache;

    public JavaxCacheQueryCompilationCache(NucleusContext nucleusCtx) {
        Configuration conf = nucleusCtx.getConfiguration();
        String cacheName = conf.getStringProperty(PropertyNames.PROPERTY_CACHE_QUERYCOMPILE_NAME);
        if (cacheName == null) {
            cacheName = "datanucleus-query-compilation";
            NucleusLogger.CACHE.warn("No 'datanucleus.cache.queryCompilation.cacheName' specified so using name of '" + cacheName + "'");
        }
        try {
            CachingProvider cacheProvider = Caching.getCachingProvider();
            CacheManager cacheMgr = cacheProvider.getCacheManager();
            Cache tmpcache = cacheMgr.getCache(cacheName);
            if (tmpcache == null) {
                MutableConfiguration cacheConfig = new MutableConfiguration();
                cacheMgr.createCache(cacheName, (javax.cache.configuration.Configuration)cacheConfig);
                tmpcache = cacheMgr.getCache(cacheName);
            }
            this.cache = tmpcache;
        }
        catch (CacheException e) {
            throw new NucleusException("Error creating cache", e);
        }
    }

    @Override
    public void close() {
        this.cache.removeAll();
        this.cache = null;
    }

    @Override
    public void evict(String queryKey) {
        this.cache.remove((Object)queryKey);
    }

    @Override
    public void clear() {
        this.cache.removeAll();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("size() method not supported by this plugin");
    }

    @Override
    public QueryCompilation get(String queryKey) {
        return (QueryCompilation)this.cache.get((Object)queryKey);
    }

    @Override
    public QueryCompilation put(String queryKey, QueryCompilation compilation) {
        if (queryKey == null || compilation == null) {
            return null;
        }
        try {
            this.cache.put((Object)queryKey, (Object)compilation);
        }
        catch (RuntimeException re) {
            NucleusLogger.CACHE.info("Query results with key '" + queryKey + "' not cached. " + re.getMessage());
        }
        return compilation;
    }

    @Override
    public boolean contains(String queryKey) {
        return this.get(queryKey) != null;
    }
}

