/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.nio.ByteBuffer;
import org.datanucleus.store.types.converters.ArrayConversionHelper;
import org.datanucleus.store.types.converters.TypeConverter;

public class ByteObjectArrayByteBufferConverter
implements TypeConverter<Byte[], ByteBuffer> {
    private static final long serialVersionUID = -6958778367541419692L;

    @Override
    public ByteBuffer toDatastoreType(Byte[] memberValue) {
        if (memberValue == null) {
            return null;
        }
        byte[] bytes = ArrayConversionHelper.getByteArrayFromByteObjectArray(memberValue);
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public Byte[] toMemberType(ByteBuffer datastoreValue) {
        if (datastoreValue == null) {
            return null;
        }
        byte[] dataStoreValueInBytes = new byte[datastoreValue.remaining()];
        datastoreValue.get(dataStoreValueInBytes);
        return ArrayConversionHelper.getByteObjectArrayFromByteArray(datastoreValue.array());
    }
}

