/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.Serializable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.StringUtils;

class ContainerComponent
implements Serializable {
    private static final long serialVersionUID = -5662004381416396246L;
    protected Boolean embedded;
    protected Boolean serialized;
    protected Boolean dependent;
    protected String typeName;
    protected AbstractClassMetaData classMetaData;

    public Boolean getEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(Boolean embedded) {
        this.embedded = embedded;
    }

    public Boolean getSerialized() {
        return this.serialized;
    }

    public void setSerialized(Boolean serialized) {
        this.serialized = serialized;
    }

    public Boolean getDependent() {
        return this.dependent;
    }

    public void setDependent(Boolean dependent) {
        this.dependent = dependent;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String type) {
        this.typeName = StringUtils.isWhitespace(type) ? null : type;
    }

    void populate(String packageName, ClassLoaderResolver clr, ClassLoader primary) {
        if (this.typeName != null && !ClassUtils.isPrimitiveType(this.typeName) && !ClassUtils.isPrimitiveArrayType(this.typeName)) {
            try {
                clr.classForName(this.typeName, primary, false);
            }
            catch (ClassNotResolvedException cnre) {
                String name = ClassUtils.createFullClassName(packageName, this.typeName);
                try {
                    clr.classForName(name, primary, false);
                    this.typeName = name;
                }
                catch (ClassNotResolvedException cnre2) {
                    name = ClassUtils.getJavaLangClassForType(this.typeName);
                    clr.classForName(name, primary, false);
                    this.typeName = name;
                }
            }
        }
    }

    public String toString() {
        return "Type=" + this.typeName + " embedded=" + this.embedded + " serialized=" + this.serialized + " dependent=" + this.dependent + " cmd=" + this.classMetaData;
    }
}

