/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers.backed;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistableObjectType;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.flush.CollectionAddOperation;
import org.datanucleus.flush.CollectionClearOperation;
import org.datanucleus.flush.CollectionRemoveOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.BackedSCOStoreManager;
import org.datanucleus.store.types.SCOCollection;
import org.datanucleus.store.types.SCOCollectionIterator;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.scostore.SetStore;
import org.datanucleus.store.types.scostore.Store;
import org.datanucleus.store.types.wrappers.backed.BackedSCO;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class SortedSet<E>
extends org.datanucleus.store.types.wrappers.SortedSet<E>
implements BackedSCO {
    protected transient SetStore<E> backingStore;
    protected transient boolean allowNulls = false;
    protected transient boolean useCache = true;
    protected transient boolean isCacheLoaded = false;
    protected transient boolean initialising = false;

    public SortedSet(DNStateManager sm, AbstractMemberMetaData mmd) {
        super(sm, mmd);
        Comparator comparator;
        this.allowNulls = SCOUtils.allowNullsInContainer(this.allowNulls, mmd);
        this.useCache = SCOUtils.useContainerCache(sm, mmd);
        if (!SCOUtils.collectionHasSerialisedElements(mmd) && mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
            this.backingStore = (SetStore)((BackedSCOStoreManager)((Object)this.ownerSM.getStoreManager())).getBackingStoreForField(clr, mmd, java.util.SortedSet.class);
        }
        this.delegate = (comparator = SCOUtils.getComparator(mmd, sm.getExecutionContext().getClassLoaderResolver())) != null ? new TreeSet(comparator) : new TreeSet();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(this.ownerSM, this.ownerMmd.getName(), this, this.useCache, this.allowNulls, SCOUtils.useCachedLazyLoading(this.ownerSM, this.ownerMmd)));
        }
    }

    @Override
    public void initialise(java.util.SortedSet<E> newValue, Object oldValue) {
        if (newValue != null) {
            Collection oldColl;
            if (SCOUtils.collectionHasSerialisedElements(this.ownerMmd) && this.ownerMmd.getCollection().elementIsPersistent()) {
                ExecutionContext ec = this.ownerSM.getExecutionContext();
                for (Object pc : newValue) {
                    DNStateManager objSM = ec.findStateManager(pc);
                    if (objSM != null) continue;
                    objSM = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, pc, false, this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_COLLECTION_ELEMENT_PC);
                }
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023008", this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName(), "" + newValue.size()));
            }
            this.initialising = true;
            if (this.useCache) {
                oldColl = (Collection)oldValue;
                if (oldColl != null) {
                    this.delegate.addAll(oldColl);
                }
                this.isCacheLoaded = true;
                SCOUtils.updateCollectionWithCollection(this.ownerSM.getExecutionContext().getApiAdapter(), this, newValue);
            } else {
                oldColl = (Collection)oldValue;
                if (oldColl instanceof SCOCollection) {
                    oldColl = (Collection)((SCOCollection)((Object)oldColl)).getValue();
                }
                for (Object elem : newValue) {
                    if (oldColl != null && oldColl.contains(elem)) continue;
                    this.add(elem);
                }
                if (oldColl != null) {
                    for (Object elem : oldColl) {
                        if (newValue.contains(elem)) continue;
                        this.remove(elem);
                    }
                }
            }
            this.initialising = false;
        }
    }

    @Override
    public void initialise(java.util.SortedSet<E> c) {
        if (c != null) {
            if (SCOUtils.collectionHasSerialisedElements(this.ownerMmd) && this.ownerMmd.getCollection().elementIsPersistent()) {
                ExecutionContext ec = this.ownerSM.getExecutionContext();
                for (Object pc : c) {
                    DNStateManager objSM = ec.findStateManager(pc);
                    if (objSM != null) continue;
                    objSM = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, pc, false, this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_COLLECTION_ELEMENT_PC);
                }
            }
            if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
                this.isCacheLoaded = true;
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023007", this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName(), "" + c.size()));
            }
            this.delegate.clear();
            this.delegate.addAll(c);
        }
    }

    @Override
    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerSM, this.ownerMmd)) {
            this.loadFromStore();
        }
    }

    @Override
    public java.util.SortedSet<E> getValue() {
        this.loadFromStore();
        return super.getValue();
    }

    @Override
    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    @Override
    public boolean isLoaded() {
        return this.useCache ? this.isCacheLoaded : false;
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023006", this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName()));
            }
            this.delegate.clear();
            ExecutionContext ec = this.ownerSM.getExecutionContext();
            RelationType relType = this.ownerMmd.getRelationType(ec.getClassLoaderResolver());
            int relatedMemberNum = -1;
            if (RelationType.isBidirectional(relType) && relType == RelationType.ONE_TO_MANY_BI) {
                AbstractMemberMetaData[] relMmds = this.ownerMmd.getRelatedMemberMetaData(ec.getClassLoaderResolver());
                relatedMemberNum = relMmds != null && relMmds.length > 0 ? relMmds[0].getAbsoluteFieldNumber() : -1;
            }
            Iterator iter = this.backingStore.iterator(this.ownerSM);
            while (iter.hasNext()) {
                DNStateManager elemSM;
                Object element = iter.next();
                if (relatedMemberNum >= 0 && !(elemSM = ec.findStateManager(element)).isFieldLoaded(relatedMemberNum)) {
                    elemSM.storeFieldValue(relatedMemberNum, this.ownerSM.getExternalObjectId());
                }
                this.delegate.add(element);
            }
            this.isCacheLoaded = true;
        }
    }

    @Override
    public Store getBackingStore() {
        return this.backingStore;
    }

    @Override
    public void updateEmbeddedElement(E element, int fieldNumber, Object value, boolean makeDirty) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedElement(this.ownerSM, element, fieldNumber, value);
        }
    }

    @Override
    public void unsetOwner() {
        super.unsetOwner();
        if (this.backingStore != null) {
            this.backingStore = null;
        }
    }

    @Override
    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return ((TreeSet)this.delegate).clone();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.delegate.comparator();
    }

    @Override
    public boolean contains(Object element) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.contains(element);
        }
        if (this.backingStore != null) {
            return this.backingStore.contains(this.ownerSM, element);
        }
        return this.delegate.contains(element);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            TreeSet sorted = new TreeSet(c);
            Iterator<E> iter = this.iterator();
            while (iter.hasNext()) {
                sorted.remove(iter.next());
            }
            return sorted.isEmpty();
        }
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set s = (Set)o;
        return s.size() == this.size() && this.containsAll(s);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        for (E t : this) {
            action.accept(t);
        }
    }

    @Override
    public E first() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.first();
        }
        if (!this.useCache) {
            Iterator<E> iter = this.iterator();
            return iter.next();
        }
        this.loadFromStore();
        return this.delegate.first();
    }

    @Override
    public int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOCollectionIterator<E>(this, this.ownerSM, this.delegate, this.backingStore, this.useCache);
    }

    @Override
    public java.util.SortedSet<E> headSet(E toElement) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.headSet(toElement);
        }
        if (!this.useCache) {
            throw new NucleusUserException("Don't currently support SortedSet.headSet() when not using cached collections");
        }
        this.loadFromStore();
        return this.delegate.headSet(toElement);
    }

    @Override
    public java.util.SortedSet<E> subSet(E fromElement, E toElement) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.subSet(fromElement, toElement);
        }
        if (!this.useCache) {
            throw new NucleusUserException("Don't currently support SortedSet.subSet() when not using cached collections");
        }
        this.loadFromStore();
        return this.delegate.subSet(fromElement, toElement);
    }

    @Override
    public java.util.SortedSet<E> tailSet(E fromElement) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.headSet(fromElement);
        }
        if (!this.useCache) {
            throw new NucleusUserException("Don't currently support SortedSet.tailSet() when not using cached collections");
        }
        this.loadFromStore();
        return this.delegate.headSet(fromElement);
    }

    @Override
    public E last() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.last();
        }
        if (!this.useCache) {
            Iterator<E> iter = this.iterator();
            E last = null;
            while (iter.hasNext()) {
                last = iter.next();
            }
            return last;
        }
        this.loadFromStore();
        return this.delegate.last();
    }

    @Override
    public int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.size(this.ownerSM);
        }
        return this.delegate.size();
    }

    @Override
    public Object[] toArray() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM);
        }
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM, a);
        }
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(E element) {
        if (!this.allowNulls && element == null) {
            throw new NullPointerException("Nulls not allowed for collection at field " + this.ownerMmd.getName() + " but element is null");
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.contains(element)) {
            return false;
        }
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations() && !this.initialising) {
            this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM).relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionAddOperation<E>(this.ownerSM, this.backingStore, element));
            } else {
                try {
                    backingSuccess = this.backingStore.add(this.ownerSM, element, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    throw new IllegalArgumentException(Localiser.msg("023013", "add", this.ownerMmd.getName(), dse), dse);
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.add(element);
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations() && !this.initialising) {
            RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
            for (E elem : elements) {
                relMgr.relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), elem);
            }
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                for (E element : elements) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionAddOperation<E>(this.ownerSM, this.backingStore, element));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.addAll(this.ownerSM, elements, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    throw new IllegalArgumentException(Localiser.msg("023013", "addAll", this.ownerMmd.getName(), dse), dse);
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.addAll(elements);
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public void clear() {
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations() && !this.initialising) {
            RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
            for (Object elem : this.delegate) {
                relMgr.relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), elem);
            }
        }
        this.makeDirty();
        this.delegate.clear();
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionClearOperation(this.ownerSM, this.backingStore));
            } else {
                this.backingStore.clear(this.ownerSM);
            }
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public boolean remove(Object element) {
        return this.remove(element, true);
    }

    @Override
    public boolean remove(Object element, boolean allowCascadeDelete) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        boolean contained = this.delegate.contains(element);
        if (this.useCache && !contained) {
            return false;
        }
        boolean delegateSuccess = this.delegate.remove(element);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations() && !this.initialising) {
            this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM).relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                backingSuccess = contained;
                if (backingSuccess) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation<Object>(this.ownerSM, this.backingStore, element, allowCascadeDelete));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.remove(this.ownerSM, element, size, allowCascadeDelete);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(Localiser.msg("023013", "remove", this.ownerMmd.getName(), dse));
                    backingSuccess = false;
                }
            }
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public boolean removeAll(Collection<?> elements) {
        if (elements == null) {
            throw new NullPointerException();
        }
        if (elements.isEmpty()) {
            return true;
        }
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        boolean delegateSuccess = this.delegate.removeAll(elements);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations() && !this.initialising) {
            RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
            for (Object elem : elements) {
                relMgr.relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), elem);
            }
        }
        if (this.backingStore != null && this.ownerSM != null) {
            boolean backingSuccess = true;
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                HashSet contained = new HashSet();
                for (Object elem : elements) {
                    if (!this.contains(elem)) continue;
                    contained.add(elem);
                }
                if (!contained.isEmpty()) {
                    backingSuccess = false;
                    for (Object element : contained) {
                        backingSuccess = true;
                        this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation<Object>(this.ownerSM, this.backingStore, element, true));
                    }
                }
            } else {
                try {
                    backingSuccess = this.backingStore.removeAll(this.ownerSM, elements, size);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(Localiser.msg("023013", "removeAll", this.ownerMmd.getName(), dse));
                    backingSuccess = false;
                }
            }
            if (!this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
            return backingSuccess;
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return delegateSuccess;
    }

    @Override
    public boolean retainAll(Collection c) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean modified = false;
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            E element = iter.next();
            if (c.contains(element)) continue;
            iter.remove();
            modified = true;
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return modified;
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new TreeSet(this.delegate);
        }
        return new TreeSet(this.delegate);
    }

    @Override
    public Spliterator<E> spliterator() {
        if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
            this.loadFromStore();
        }
        return this.delegate.spliterator();
    }

    @Override
    public Stream<E> stream() {
        if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
            this.loadFromStore();
        }
        return this.delegate.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
            this.loadFromStore();
        }
        return this.delegate.parallelStream();
    }
}

