/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Currency;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import org.datanucleus.store.types.converters.LocaleStringConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class TypeConversionHelper {
    public static Object convertTo(Object value, Class type) {
        if (type == null || value == null) {
            return value;
        }
        if (type.isPrimitive()) {
            type = ClassUtils.getWrapperTypeForPrimitiveType(type);
        }
        if (type.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (type == Short.class) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            return Short.valueOf(value.toString());
        }
        if (type == Character.class) {
            return Character.valueOf(value.toString().charAt(0));
        }
        if (type == Integer.class) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.valueOf(value.toString());
        }
        if (type == Long.class) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.valueOf(value.toString());
        }
        if (type == Boolean.class) {
            if (value instanceof Long) {
                return (Long)value == 0L ? Boolean.FALSE : ((Long)value == 1L ? Boolean.TRUE : null);
            }
            if (value instanceof Integer) {
                return (Integer)value == 0 ? Boolean.FALSE : ((Integer)value == 1 ? Boolean.TRUE : null);
            }
            if (value instanceof Short) {
                return (Short)value == 0 ? Boolean.FALSE : ((Short)value == 1 ? Boolean.TRUE : null);
            }
            return Boolean.valueOf(value.toString());
        }
        if (type == Byte.class) {
            return Byte.valueOf(value.toString());
        }
        if (type == Float.class) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            return Float.valueOf(value.toString());
        }
        if (type == Double.class) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.valueOf(value.toString());
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(value.toString());
        }
        if (type == BigInteger.class) {
            return new BigInteger(value.toString());
        }
        if (type == String.class) {
            return value.toString();
        }
        if (type == java.util.Date.class) {
            if (value instanceof LocalDate) {
                LocalDate localDate = (LocalDate)value;
                return java.util.Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
            }
            if (value instanceof Date) {
                return new Date(((java.util.Date)value).getTime());
            }
        } else {
            if (type == Timestamp.class) {
                if (value instanceof java.util.Date) {
                    return new Timestamp(((java.util.Date)value).getTime());
                }
                return Timestamp.valueOf(value.toString());
            }
            if (type == Date.class) {
                if (value instanceof java.util.Date) {
                    return new Date(((java.util.Date)value).getTime());
                }
                if (value instanceof LocalDate) {
                    LocalDate localDate = (LocalDate)value;
                    return java.util.Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                }
                return Date.valueOf(value.toString());
            }
            if (type == Time.class) {
                if (value instanceof java.util.Date) {
                    return new Time(((java.util.Date)value).getTime());
                }
                return Time.valueOf(value.toString());
            }
            if (type == LocalDate.class) {
                if (value instanceof Timestamp) {
                    return ((Timestamp)value).toLocalDateTime().toLocalDate();
                }
                if (value instanceof Date) {
                    return ((Date)value).toLocalDate();
                }
                if (value instanceof java.util.Date) {
                    java.util.Date date = (java.util.Date)value;
                    return LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault()).toLocalDate();
                }
            } else if (type == LocalDateTime.class) {
                if (value instanceof Timestamp) {
                    return ((Timestamp)value).toLocalDateTime();
                }
                if (value instanceof java.util.Date) {
                    java.util.Date date = (java.util.Date)value;
                    return LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault()).toLocalDate();
                }
            } else if (type == LocalTime.class) {
                if (value instanceof Timestamp) {
                    return ((Timestamp)value).toLocalDateTime().toLocalTime();
                }
                if (value instanceof Time) {
                    return ((Time)value).toLocalTime();
                }
                if (value instanceof java.util.Date) {
                    java.util.Date date = (java.util.Date)value;
                    return LocalTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
                }
            } else if (type == UUID.class) {
                if (value instanceof String) {
                    return UUID.fromString((String)value);
                }
            } else if (type == TimeZone.class) {
                if (value instanceof String) {
                    return TimeZone.getTimeZone((String)value);
                }
            } else if (type == Currency.class) {
                if (value instanceof String) {
                    return Currency.getInstance((String)value);
                }
            } else if (type == Locale.class && value instanceof String) {
                return LocaleStringConverter.getLocaleFromString((String)value);
            }
        }
        NucleusLogger.PERSISTENCE.warn("Request to convert value of type " + value.getClass().getName() + " to type " + type.getName() + " but this is not yet supported. Raise an issue and contribute the code to support this conversion, with a testcase that demonstrates the problem");
        return value;
    }
}

