/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.PropertyNames;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.containers.ArrayHandler;
import org.datanucleus.store.types.containers.ArrayListHandler;
import org.datanucleus.store.types.containers.ContainerAdapter;
import org.datanucleus.store.types.containers.ContainerHandler;
import org.datanucleus.store.types.containers.HashMapHandler;
import org.datanucleus.store.types.containers.HashSetHandler;
import org.datanucleus.store.types.containers.HashtableHandler;
import org.datanucleus.store.types.containers.JDKCollectionHandler;
import org.datanucleus.store.types.containers.LinkedHashMapHandler;
import org.datanucleus.store.types.containers.LinkedHashSetHandler;
import org.datanucleus.store.types.containers.LinkedListHandler;
import org.datanucleus.store.types.containers.OptionalHandler;
import org.datanucleus.store.types.containers.PriorityQueueHandler;
import org.datanucleus.store.types.containers.PropertiesHandler;
import org.datanucleus.store.types.containers.StackHandler;
import org.datanucleus.store.types.containers.TreeMapHandler;
import org.datanucleus.store.types.containers.TreeSetHandler;
import org.datanucleus.store.types.containers.VectorHandler;
import org.datanucleus.store.types.converters.BigDecimalArrayByteBufferConverter;
import org.datanucleus.store.types.converters.BigDecimalDoubleConverter;
import org.datanucleus.store.types.converters.BigDecimalStringConverter;
import org.datanucleus.store.types.converters.BigIntegerArrayByteBufferConverter;
import org.datanucleus.store.types.converters.BigIntegerLongConverter;
import org.datanucleus.store.types.converters.BigIntegerStringConverter;
import org.datanucleus.store.types.converters.BitSetStringConverter;
import org.datanucleus.store.types.converters.BooleanArrayByteBufferConverter;
import org.datanucleus.store.types.converters.BooleanIntegerConverter;
import org.datanucleus.store.types.converters.BooleanYNConverter;
import org.datanucleus.store.types.converters.BufferedImageByteArrayConverter;
import org.datanucleus.store.types.converters.BufferedImageByteBufferConverter;
import org.datanucleus.store.types.converters.ByteArrayByteBufferConverter;
import org.datanucleus.store.types.converters.CalendarComponentsConverter;
import org.datanucleus.store.types.converters.CalendarDateConverter;
import org.datanucleus.store.types.converters.CalendarStringConverter;
import org.datanucleus.store.types.converters.CalendarTimestampConverter;
import org.datanucleus.store.types.converters.CharArrayByteBufferConverter;
import org.datanucleus.store.types.converters.CharacterStringConverter;
import org.datanucleus.store.types.converters.ClassStringConverter;
import org.datanucleus.store.types.converters.ColorComponentsConverter;
import org.datanucleus.store.types.converters.ColorStringConverter;
import org.datanucleus.store.types.converters.CurrencyStringConverter;
import org.datanucleus.store.types.converters.DateLongConverter;
import org.datanucleus.store.types.converters.DateStringConverter;
import org.datanucleus.store.types.converters.DoubleArrayByteBufferConverter;
import org.datanucleus.store.types.converters.DurationDoubleConverter;
import org.datanucleus.store.types.converters.DurationLongConverter;
import org.datanucleus.store.types.converters.DurationStringConverter;
import org.datanucleus.store.types.converters.FloatArrayByteBufferConverter;
import org.datanucleus.store.types.converters.InstantDateConverter;
import org.datanucleus.store.types.converters.InstantLongConverter;
import org.datanucleus.store.types.converters.InstantStringConverter;
import org.datanucleus.store.types.converters.InstantTimestampConverter;
import org.datanucleus.store.types.converters.IntArrayByteBufferConverter;
import org.datanucleus.store.types.converters.IntegerStringConverter;
import org.datanucleus.store.types.converters.LocalDateDateConverter;
import org.datanucleus.store.types.converters.LocalDateSqlDateConverter;
import org.datanucleus.store.types.converters.LocalDateStringConverter;
import org.datanucleus.store.types.converters.LocalDateTimeDateConverter;
import org.datanucleus.store.types.converters.LocalDateTimeStringConverter;
import org.datanucleus.store.types.converters.LocalDateTimeTimestampConverter;
import org.datanucleus.store.types.converters.LocalTimeDateConverter;
import org.datanucleus.store.types.converters.LocalTimeLongConverter;
import org.datanucleus.store.types.converters.LocalTimeSqlTimeConverter;
import org.datanucleus.store.types.converters.LocalTimeStringConverter;
import org.datanucleus.store.types.converters.LocaleStringConverter;
import org.datanucleus.store.types.converters.LongArrayByteBufferConverter;
import org.datanucleus.store.types.converters.LongStringConverter;
import org.datanucleus.store.types.converters.MonthDayComponentsConverter;
import org.datanucleus.store.types.converters.MonthDayDateConverter;
import org.datanucleus.store.types.converters.MonthDaySqlDateConverter;
import org.datanucleus.store.types.converters.MonthDayStringConverter;
import org.datanucleus.store.types.converters.OffsetDateTimeDateConverter;
import org.datanucleus.store.types.converters.OffsetDateTimeStringConverter;
import org.datanucleus.store.types.converters.OffsetDateTimeTimestampConverter;
import org.datanucleus.store.types.converters.OffsetTimeLongConverter;
import org.datanucleus.store.types.converters.OffsetTimeSqlTimeConverter;
import org.datanucleus.store.types.converters.OffsetTimeStringConverter;
import org.datanucleus.store.types.converters.PeriodComponentsConverter;
import org.datanucleus.store.types.converters.PeriodStringConverter;
import org.datanucleus.store.types.converters.SerializableByteArrayConverter;
import org.datanucleus.store.types.converters.SerializableByteBufferConverter;
import org.datanucleus.store.types.converters.SerializableStringConverter;
import org.datanucleus.store.types.converters.ShortArrayByteBufferConverter;
import org.datanucleus.store.types.converters.SqlDateLongConverter;
import org.datanucleus.store.types.converters.SqlDateStringConverter;
import org.datanucleus.store.types.converters.SqlTimeStringConverter;
import org.datanucleus.store.types.converters.SqlTimestampStringConverter;
import org.datanucleus.store.types.converters.StringBufferStringConverter;
import org.datanucleus.store.types.converters.StringBuilderStringConverter;
import org.datanucleus.store.types.converters.TimeZoneStringConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.store.types.converters.URIStringConverter;
import org.datanucleus.store.types.converters.URLStringConverter;
import org.datanucleus.store.types.converters.UUIDStringConverter;
import org.datanucleus.store.types.converters.YearIntegerConverter;
import org.datanucleus.store.types.converters.YearMonthComponentsConverter;
import org.datanucleus.store.types.converters.YearMonthDateConverter;
import org.datanucleus.store.types.converters.YearMonthSqlDateConverter;
import org.datanucleus.store.types.converters.YearMonthStringConverter;
import org.datanucleus.store.types.converters.YearStringConverter;
import org.datanucleus.store.types.converters.ZoneIdStringConverter;
import org.datanucleus.store.types.converters.ZoneOffsetStringConverter;
import org.datanucleus.store.types.converters.ZonedDateTimeStringConverter;
import org.datanucleus.store.types.converters.ZonedDateTimeTimestampConverter;
import org.datanucleus.store.types.wrappers.ArrayList;
import org.datanucleus.store.types.wrappers.BitSet;
import org.datanucleus.store.types.wrappers.Collection;
import org.datanucleus.store.types.wrappers.Date;
import org.datanucleus.store.types.wrappers.GregorianCalendar;
import org.datanucleus.store.types.wrappers.Hashtable;
import org.datanucleus.store.types.wrappers.LinkedHashMap;
import org.datanucleus.store.types.wrappers.LinkedList;
import org.datanucleus.store.types.wrappers.List;
import org.datanucleus.store.types.wrappers.SortedMap;
import org.datanucleus.store.types.wrappers.SortedSet;
import org.datanucleus.store.types.wrappers.SqlDate;
import org.datanucleus.store.types.wrappers.SqlTime;
import org.datanucleus.store.types.wrappers.SqlTimestamp;
import org.datanucleus.store.types.wrappers.Stack;
import org.datanucleus.store.types.wrappers.TreeMap;
import org.datanucleus.store.types.wrappers.backed.HashMap;
import org.datanucleus.store.types.wrappers.backed.HashSet;
import org.datanucleus.store.types.wrappers.backed.LinkedHashSet;
import org.datanucleus.store.types.wrappers.backed.Map;
import org.datanucleus.store.types.wrappers.backed.PriorityQueue;
import org.datanucleus.store.types.wrappers.backed.Properties;
import org.datanucleus.store.types.wrappers.backed.Queue;
import org.datanucleus.store.types.wrappers.backed.Set;
import org.datanucleus.store.types.wrappers.backed.TreeSet;
import org.datanucleus.store.types.wrappers.backed.Vector;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class TypeManagerImpl
implements TypeManager,
Serializable {
    private static final long serialVersionUID = 8217508318434539002L;
    protected NucleusContext nucCtx;
    protected transient ClassLoaderResolver clr;
    private static final Class[] SCO_WRAPPER_CONSTRUCTOR_ARG_TYPES = new Class[]{DNStateManager.class, AbstractMemberMetaData.class};
    protected java.util.Map<String, JavaType> javaTypes = new ConcurrentHashMap<String, JavaType>();
    protected java.util.Map<Class, ContainerHandler> containerHandlersByClass = new ConcurrentHashMap<Class, ContainerHandler>();
    protected java.util.Set<Class> classesWithoutContainerHandler = Collections.synchronizedSet(new java.util.HashSet());
    protected java.util.Map<String, TypeConverter> typeConverterByName = new ConcurrentHashMap<String, TypeConverter>();
    protected java.util.Map<String, TypeConverter> autoApplyConvertersByType = null;
    protected java.util.Map<Class, java.util.Map<Class, TypeConverter>> typeConverterMap = new ConcurrentHashMap<Class, java.util.Map<Class, TypeConverter>>();
    protected java.util.Map<TypeConverter, Class> typeConverterDatastoreTypeByConverter = new ConcurrentHashMap<TypeConverter, Class>();
    protected java.util.Map<TypeConverter, Class> typeConverterMemberTypeByConverter = new ConcurrentHashMap<TypeConverter, Class>();
    private static Comparator<Class> ALPHABETICAL_ORDER = new Comparator<Class>(){

        @Override
        public int compare(Class cls1, Class cls2) {
            int res = String.CASE_INSENSITIVE_ORDER.compare(cls1.getName(), cls2.getName());
            if (res == 0) {
                res = cls1.getName().compareTo(cls2.getName());
            }
            return res;
        }
    };
    private static Comparator<String> ALPHABETICAL_ORDER_STRING = new Comparator<String>(){

        @Override
        public int compare(String cls1, String cls2) {
            int res = String.CASE_INSENSITIVE_ORDER.compare(cls1, cls2);
            if (res == 0) {
                res = cls1.compareTo(cls2);
            }
            return res;
        }
    };

    public TypeManagerImpl(NucleusContext nucCtx) {
        this.nucCtx = nucCtx;
        this.clr = nucCtx.getClassLoaderResolver(null);
        this.loadJavaTypes(nucCtx.getPluginManager());
        this.loadTypeConverters(nucCtx.getPluginManager());
    }

    @Override
    public void close() {
        this.containerHandlersByClass = null;
        this.javaTypes = null;
        this.typeConverterByName.clear();
        this.typeConverterMap.clear();
        this.typeConverterMemberTypeByConverter.clear();
        this.typeConverterDatastoreTypeByConverter.clear();
        this.autoApplyConvertersByType = null;
    }

    @Override
    public java.util.Set<String> getSupportedSecondClassTypes() {
        return Collections.unmodifiableSet(this.javaTypes.keySet());
    }

    @Override
    public boolean isSupportedSecondClassType(String className) {
        if (className == null) {
            return false;
        }
        JavaType type = this.javaTypes.get(className);
        if (type == null) {
            try {
                Class cls = this.clr.classForName(className);
                type = this.findJavaTypeForClass(cls);
                return type != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String[] filterOutSupportedSecondClassNames(String[] inputClassNames) {
        int numFilteredClasses = 0;
        for (int i = 0; i < inputClassNames.length; ++i) {
            if (!this.isSupportedSecondClassType(inputClassNames[i])) continue;
            inputClassNames[i] = null;
            ++numFilteredClasses;
        }
        if (numFilteredClasses == 0) {
            return inputClassNames;
        }
        String[] restClasses = new String[inputClassNames.length - numFilteredClasses];
        int m = 0;
        for (int i = 0; i < inputClassNames.length; ++i) {
            if (inputClassNames[i] == null) continue;
            restClasses[m++] = inputClassNames[i];
        }
        return restClasses;
    }

    @Override
    public boolean isDefaultPersistent(Class c) {
        if (c == null) {
            return false;
        }
        JavaType type = this.javaTypes.get(c.getName());
        if (type != null) {
            return true;
        }
        type = this.findJavaTypeForClass(c);
        return type != null;
    }

    @Override
    public boolean isDefaultFetchGroup(Class c) {
        if (c == null) {
            return false;
        }
        if (this.nucCtx.getApiAdapter().isPersistable(c)) {
            return this.nucCtx.getApiAdapter().getDefaultDFGForPersistableField();
        }
        JavaType type = this.javaTypes.get(c.getName());
        if (type != null) {
            return type.dfg;
        }
        type = this.findJavaTypeForClass(c);
        if (type != null) {
            return type.dfg;
        }
        return false;
    }

    @Override
    public boolean isDefaultFetchGroupForCollection(Class c, Class genericType) {
        if (c != null && genericType == null) {
            return this.isDefaultFetchGroup(c);
        }
        if (c == null) {
            return false;
        }
        String name = c.getName() + "<" + genericType.getName() + ">";
        JavaType type = this.javaTypes.get(name);
        if (type != null) {
            return type.dfg;
        }
        type = this.findJavaTypeForCollectionClass(c, genericType);
        if (type != null) {
            return type.dfg;
        }
        return false;
    }

    @Override
    public boolean isDefaultEmbeddedType(Class c) {
        if (c == null) {
            return false;
        }
        JavaType type = this.javaTypes.get(c.getName());
        if (type != null) {
            return type.embedded;
        }
        type = this.findJavaTypeForClass(c);
        if (type != null) {
            return type.embedded;
        }
        return false;
    }

    @Override
    public boolean isSecondClassMutableType(String className) {
        return this.getWrapperTypeForType(className) != null;
    }

    @Override
    public Class<? extends SCO> getWrapperTypeForType(String className) {
        if (className == null) {
            return null;
        }
        JavaType type = this.javaTypes.get(className);
        return type == null ? null : type.wrapperType;
    }

    @Override
    public Class<? extends SCO> getWrappedTypeBackedForType(String className) {
        if (className == null) {
            return null;
        }
        JavaType type = this.javaTypes.get(className);
        return type == null ? null : type.wrapperTypeBacked;
    }

    @Override
    public boolean isSecondClassWrapper(String className) {
        if (className == null) {
            return false;
        }
        for (JavaType type : this.javaTypes.values()) {
            if (type.wrapperType != null && type.wrapperType.getName().equals(className)) {
                return true;
            }
            if (type.wrapperTypeBacked == null || !type.wrapperTypeBacked.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SCO createSCOWrapper(DNStateManager ownerSM, AbstractMemberMetaData mmd, Class instantiatedType) {
        Class<? extends SCO> wrapperType;
        String typeName = instantiatedType != null ? instantiatedType.getName() : mmd.getTypeName();
        StoreManager storeMgr = ownerSM.getExecutionContext().getStoreManager();
        boolean backedWrapper = mmd.isSerialized() ? false : storeMgr.useBackedSCOWrapperForMember(mmd, ownerSM.getExecutionContext());
        Class<? extends SCO> clazz = wrapperType = backedWrapper ? this.getBackedWrapperTypeForType(mmd.getType(), instantiatedType, typeName) : this.getSimpleWrapperTypeForType(mmd.getType(), instantiatedType, typeName);
        if (wrapperType == null) {
            throw new NucleusUserException(Localiser.msg("023011", mmd.getTypeName(), typeName, mmd.getFullFieldName()));
        }
        try {
            return ClassUtils.newInstance(wrapperType, SCO_WRAPPER_CONSTRUCTOR_ARG_TYPES, new Object[]{ownerSM, mmd});
        }
        catch (UnsupportedOperationException uoe) {
            if (backedWrapper) {
                NucleusLogger.PERSISTENCE.warn("Creation of backed wrapper for " + mmd.getFullFieldName() + " unsupported, so trying simple wrapper");
                wrapperType = this.getSimpleWrapperTypeForType(mmd.getType(), instantiatedType, typeName);
                return ClassUtils.newInstance(wrapperType, SCO_WRAPPER_CONSTRUCTOR_ARG_TYPES, new Object[]{ownerSM, mmd});
            }
            throw uoe;
        }
    }

    private Class<? extends SCO> getBackedWrapperTypeForType(Class declaredType, Class instantiatedType, String typeName) {
        Class<? extends SCO> wrapperType = this.getWrappedTypeBackedForType(typeName);
        if (wrapperType == null) {
            if (instantiatedType != null) {
                wrapperType = this.getWrappedTypeBackedForType(instantiatedType.getName());
            }
            if (wrapperType == null) {
                wrapperType = this.getWrappedTypeBackedForType(declaredType.getName());
            }
        }
        return wrapperType;
    }

    private Class<? extends SCO> getSimpleWrapperTypeForType(Class declaredType, Class instantiatedType, String typeName) {
        Class<? extends SCO> wrapperType = this.getWrapperTypeForType(typeName);
        if (wrapperType == null) {
            if (instantiatedType != null) {
                wrapperType = this.getWrapperTypeForType(instantiatedType.getName());
            }
            if (wrapperType == null) {
                wrapperType = this.getWrapperTypeForType(declaredType.getName());
            }
        }
        return wrapperType;
    }

    @Override
    public Class getTypeForSecondClassWrapper(String className) {
        for (JavaType type : this.javaTypes.values()) {
            if (type.wrapperType != null && type.wrapperType.getName().equals(className)) {
                return type.cls;
            }
            if (type.wrapperTypeBacked == null || !type.wrapperTypeBacked.getName().equals(className)) continue;
            return type.cls;
        }
        return null;
    }

    @Override
    public ContainerAdapter getContainerAdapter(Object container) {
        Object containerHandler = this.getContainerHandler(container.getClass());
        return containerHandler == null ? null : (ContainerAdapter)containerHandler.getAdapter((Object)container);
    }

    @Override
    public <H extends ContainerHandler> H getContainerHandler(Class containerClass) {
        if (this.classesWithoutContainerHandler.contains(containerClass)) {
            return null;
        }
        ContainerHandler containerHandler = this.containerHandlersByClass.get(containerClass);
        if (containerHandler != null) {
            return (H)containerHandler;
        }
        JavaType type = this.findJavaTypeForClass(containerClass);
        if (type != null) {
            if (type.containerHandlerType == null) {
                this.classesWithoutContainerHandler.add(containerClass);
                return null;
            }
            Class[] parameterTypes = null;
            Object[] parameters = null;
            Class[] classParameterTypes = new Class[]{Class.class};
            if (ClassUtils.getConstructorWithArguments(type.containerHandlerType, classParameterTypes) != null) {
                parameterTypes = classParameterTypes;
                parameters = new Object[]{containerClass};
            }
            containerHandler = ClassUtils.newInstance(type.containerHandlerType, parameterTypes, parameters);
            this.containerHandlersByClass.put(containerClass, containerHandler);
            return (H)containerHandler;
        }
        return null;
    }

    @Override
    public TypeConverter getTypeConverterForName(String converterName) {
        return converterName == null ? null : this.typeConverterByName.get(converterName);
    }

    @Override
    public void registerConverter(String name, TypeConverter converter, Class memberType, Class dbType, boolean autoApply, String autoApplyType) {
        if (name != null) {
            this.typeConverterByName.put(name, converter);
        }
        this.typeConverterDatastoreTypeByConverter.put(converter, dbType);
        this.typeConverterMemberTypeByConverter.put(converter, memberType);
        java.util.Map<Class, TypeConverter> convertersForMember = this.typeConverterMap.get(memberType);
        if (convertersForMember == null) {
            convertersForMember = new ConcurrentHashMap<Class, TypeConverter>();
            this.typeConverterMap.put(memberType, convertersForMember);
        }
        convertersForMember.put(dbType, converter);
        if (converter instanceof ClassStringConverter) {
            ((ClassStringConverter)converter).setClassLoaderResolver(this.clr);
        }
        if (autoApply) {
            if (this.autoApplyConvertersByType == null) {
                this.autoApplyConvertersByType = new ConcurrentHashMap<String, TypeConverter>();
            }
            this.autoApplyConvertersByType.put(autoApplyType, converter);
        }
    }

    @Override
    public TypeConverter getAutoApplyTypeConverterForType(Class memberType) {
        return this.autoApplyConvertersByType == null ? null : this.autoApplyConvertersByType.get(memberType.getName());
    }

    @Override
    public void setDefaultTypeConverterForType(Class memberType, String converterName) {
        JavaType javaType = this.javaTypes.get(memberType.getName());
        if (javaType == null) {
            return;
        }
        String typeConverterName = javaType.typeConverterName;
        if (typeConverterName == null || !typeConverterName.equals(converterName)) {
            javaType.typeConverterName = converterName;
        }
    }

    @Override
    public TypeConverter getDefaultTypeConverterForType(Class memberType) {
        JavaType javaType = this.javaTypes.get(memberType.getName());
        if (javaType == null) {
            return null;
        }
        String typeConverterName = javaType.typeConverterName;
        if (typeConverterName == null) {
            return null;
        }
        return this.getTypeConverterForName(typeConverterName);
    }

    @Override
    public TypeConverter getTypeConverterForType(Class memberType, Class datastoreType) {
        if (memberType == null) {
            return null;
        }
        java.util.Map<Class, TypeConverter> convertersForMember = this.typeConverterMap.get(memberType);
        return convertersForMember == null ? null : convertersForMember.get(datastoreType);
    }

    @Override
    public java.util.Collection<TypeConverter> getTypeConvertersForType(Class memberType) {
        if (memberType == null) {
            return null;
        }
        java.util.Map<Class, TypeConverter> convertersForMember = this.typeConverterMap.get(memberType);
        return convertersForMember == null ? null : convertersForMember.values();
    }

    @Override
    public Class getDatastoreTypeForTypeConverter(TypeConverter conv, Class memberType) {
        return this.typeConverterDatastoreTypeByConverter.get(conv);
    }

    @Override
    public Class getMemberTypeForTypeConverter(TypeConverter conv, Class datastoreType) {
        return this.typeConverterMemberTypeByConverter.get(conv);
    }

    protected JavaType findJavaTypeForClass(Class cls) {
        if (cls == null) {
            return null;
        }
        JavaType typeForClass = this.javaTypes.get(cls.getName());
        if (typeForClass != null) {
            return typeForClass;
        }
        java.util.Collection<JavaType> supportedTypes = Collections.unmodifiableCollection(this.javaTypes.values());
        for (JavaType type : supportedTypes) {
            Class<?> componentCls;
            if (type.cls == cls && type.genericType == null) {
                return type;
            }
            if (type.cls.getName().equals("java.lang.Object") || type.cls.getName().equals("java.io.Serializable")) continue;
            Class<?> clazz = componentCls = cls.isArray() ? cls.getComponentType() : null;
            if (componentCls != null) {
                if (!type.cls.isArray() || !type.cls.getComponentType().isAssignableFrom(componentCls)) continue;
                this.javaTypes.put(cls.getName(), type);
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("016001", cls.getName(), type.cls.getName()));
                }
                return type;
            }
            if (!type.cls.isAssignableFrom(cls) || type.genericType != null || type.wrapperType != null && !type.wrapperType.isAssignableFrom(cls)) continue;
            this.javaTypes.put(cls.getName(), type);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("016001", cls.getName(), type.cls.getName()));
            }
            return type;
        }
        return null;
    }

    protected JavaType findJavaTypeForCollectionClass(Class cls, Class genericType) {
        if (cls == null) {
            return null;
        }
        if (genericType == null) {
            return this.findJavaTypeForClass(cls);
        }
        String typeName = cls.getName() + "<" + genericType.getName() + ">";
        JavaType type = this.javaTypes.get(typeName);
        if (type != null) {
            return type;
        }
        java.util.Collection<JavaType> supportedTypes = Collections.unmodifiableCollection(this.javaTypes.values());
        for (JavaType javaType : supportedTypes) {
            if (!javaType.cls.isAssignableFrom(cls) || javaType.genericType == null || !javaType.genericType.isAssignableFrom(genericType)) continue;
            this.javaTypes.put(typeName, javaType);
            return javaType;
        }
        return this.findJavaTypeForClass(cls);
    }

    private void loadJavaTypes(PluginManager mgr) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("016003"));
        }
        this.addJavaType(Boolean.TYPE, null, true, true, null, null, null, null);
        this.addJavaType(Byte.TYPE, null, true, true, null, null, null, null);
        this.addJavaType(Character.TYPE, null, true, true, null, null, null, null);
        this.addJavaType(Double.TYPE, null, true, true, null, null, null, null);
        this.addJavaType(Float.TYPE, null, true, true, null, null, null, null);
        this.addJavaType(Integer.TYPE, null, true, true, null, null, null, null);
        this.addJavaType(Long.TYPE, null, true, true, null, null, null, null);
        this.addJavaType(Short.TYPE, null, true, true, null, null, null, null);
        this.addJavaType(Boolean.class, null, true, true, null, null, null, null);
        this.addJavaType(Byte.class, null, true, true, null, null, null, null);
        this.addJavaType(Character.class, null, true, true, null, null, null, null);
        this.addJavaType(Double.class, null, true, true, null, null, null, null);
        this.addJavaType(Float.class, null, true, true, null, null, null, null);
        this.addJavaType(Integer.class, null, true, true, null, null, null, null);
        this.addJavaType(Long.class, null, true, true, null, null, null, null);
        this.addJavaType(Short.class, null, true, true, null, null, null, null);
        this.addJavaType(Number.class, null, true, true, null, null, null, null);
        this.addJavaType(String.class, null, true, true, null, null, null, null);
        this.addJavaType(Enum.class, null, true, true, null, null, null, null);
        this.addJavaType(StringBuffer.class, null, true, true, null, null, null, "dn.stringbuffer-string");
        this.addJavaType(StringBuilder.class, null, true, true, null, null, null, "dn.stringbuilder-string");
        this.addJavaType(Class.class, null, true, true, null, null, null, "dn.class-string");
        if (ClassUtils.isClassPresent("java.awt.Color", this.clr)) {
            this.addJavaType(BufferedImage.class, null, true, false, null, null, null, "dn.bufferedimage-bytearray");
            this.addJavaType(Color.class, null, true, true, null, null, null, "dn.color-string");
        }
        this.addJavaType(BigDecimal.class, null, true, true, null, null, null, null);
        this.addJavaType(BigInteger.class, null, true, true, null, null, null, null);
        this.addJavaType(URL.class, null, true, true, null, null, null, "dn.url-string");
        this.addJavaType(URI.class, null, true, true, null, null, null, "dn.uri-string");
        boolean javaUtilDateIsMutable = this.nucCtx.getConfiguration().getBooleanProperty(PropertyNames.PROPERTY_TYPE_TREAT_JAVA_UTIL_DATE_AS_MUTABLE);
        this.addJavaType(java.sql.Date.class, null, true, true, javaUtilDateIsMutable ? SqlDate.class : null, null, null, null);
        this.addJavaType(Time.class, null, true, true, javaUtilDateIsMutable ? SqlTime.class : null, null, null, null);
        this.addJavaType(Timestamp.class, null, true, true, javaUtilDateIsMutable ? SqlTimestamp.class : null, null, null, null);
        this.addJavaType(java.util.Date.class, null, true, true, javaUtilDateIsMutable ? Date.class : null, null, null, null);
        this.addJavaType(Calendar.class, null, true, true, GregorianCalendar.class, null, null, "dn.calendar-string");
        this.addJavaType(java.util.GregorianCalendar.class, null, true, true, GregorianCalendar.class, null, null, "dn.calendar-string");
        this.addJavaType(LocalDate.class, null, true, true, null, null, null, "dn.localdate-sqldate");
        this.addJavaType(LocalDateTime.class, null, true, true, null, null, null, "dn.localdatetime-timestamp");
        this.addJavaType(LocalTime.class, null, true, true, null, null, null, "dn.localtime-sqltime");
        this.addJavaType(OffsetTime.class, null, true, true, null, null, null, "dn.offsettime-sqltime");
        this.addJavaType(OffsetDateTime.class, null, true, true, null, null, null, "dn.offsetdatetime-timestamp");
        this.addJavaType(Duration.class, null, true, true, null, null, null, "dn.duration-long");
        this.addJavaType(Instant.class, null, true, true, null, null, null, "dn.instant-timestamp");
        this.addJavaType(Period.class, null, true, true, null, null, null, "dn.period-string");
        this.addJavaType(Year.class, null, true, true, null, null, null, "dn.year-integer");
        this.addJavaType(YearMonth.class, null, true, true, null, null, null, "dn.yearmonth-string");
        this.addJavaType(MonthDay.class, null, true, true, null, null, null, "dn.monthday-string");
        this.addJavaType(ZoneId.class, null, true, true, null, null, null, "dn.zoneid-string");
        this.addJavaType(ZoneOffset.class, null, true, true, null, null, null, "dn.zoneoffset-string");
        this.addJavaType(ZonedDateTime.class, null, true, true, null, null, null, "dn.zoneddatetime-timestamp");
        this.addJavaType(Locale.class, null, true, true, null, null, null, "dn.locale-string");
        this.addJavaType(Currency.class, null, true, true, null, null, null, "dn.currency-string");
        this.addJavaType(UUID.class, null, true, true, null, null, null, "dn.uuid-string");
        this.addJavaType(TimeZone.class, null, true, true, null, null, null, "dn.timezone-string");
        this.addJavaType(Optional.class, null, false, false, null, null, OptionalHandler.class, null);
        this.addJavaType(java.util.ArrayList.class, null, false, false, ArrayList.class, org.datanucleus.store.types.wrappers.backed.ArrayList.class, ArrayListHandler.class, null);
        this.addJavaType(this.clr.classForName("java.util.Arrays$ArrayList"), null, false, false, List.class, org.datanucleus.store.types.wrappers.backed.List.class, ArrayListHandler.class, null);
        this.addJavaType(java.util.BitSet.class, null, true, true, BitSet.class, null, null, "dn.bitset-string");
        this.addJavaType(java.util.Collection.class, null, false, false, Collection.class, org.datanucleus.store.types.wrappers.backed.Collection.class, JDKCollectionHandler.class, null);
        this.addJavaType(java.util.HashMap.class, null, false, false, org.datanucleus.store.types.wrappers.HashMap.class, HashMap.class, HashMapHandler.class, null);
        this.addJavaType(java.util.HashSet.class, null, false, false, org.datanucleus.store.types.wrappers.HashSet.class, HashSet.class, HashSetHandler.class, null);
        this.addJavaType(java.util.Hashtable.class, null, false, false, Hashtable.class, org.datanucleus.store.types.wrappers.backed.Hashtable.class, HashtableHandler.class, null);
        this.addJavaType(java.util.LinkedHashMap.class, null, false, false, LinkedHashMap.class, org.datanucleus.store.types.wrappers.backed.LinkedHashMap.class, LinkedHashMapHandler.class, null);
        this.addJavaType(java.util.LinkedHashSet.class, null, false, false, org.datanucleus.store.types.wrappers.LinkedHashSet.class, LinkedHashSet.class, LinkedHashSetHandler.class, null);
        this.addJavaType(java.util.LinkedList.class, null, false, false, LinkedList.class, org.datanucleus.store.types.wrappers.backed.LinkedList.class, LinkedListHandler.class, null);
        this.addJavaType(java.util.List.class, null, false, false, List.class, org.datanucleus.store.types.wrappers.backed.List.class, ArrayListHandler.class, null);
        this.addJavaType(java.util.Map.class, null, false, false, org.datanucleus.store.types.wrappers.Map.class, Map.class, HashMapHandler.class, null);
        this.addJavaType(java.util.PriorityQueue.class, null, false, false, org.datanucleus.store.types.wrappers.PriorityQueue.class, PriorityQueue.class, PriorityQueueHandler.class, null);
        this.addJavaType(java.util.Properties.class, null, false, false, org.datanucleus.store.types.wrappers.Properties.class, Properties.class, PropertiesHandler.class, null);
        this.addJavaType(java.util.Queue.class, null, false, false, org.datanucleus.store.types.wrappers.Queue.class, Queue.class, PriorityQueueHandler.class, null);
        this.addJavaType(java.util.Set.class, null, false, false, org.datanucleus.store.types.wrappers.Set.class, Set.class, HashSetHandler.class, null);
        this.addJavaType(java.util.SortedMap.class, null, false, false, SortedMap.class, org.datanucleus.store.types.wrappers.backed.SortedMap.class, TreeMapHandler.class, null);
        this.addJavaType(java.util.SortedSet.class, null, false, false, SortedSet.class, org.datanucleus.store.types.wrappers.backed.SortedSet.class, TreeSetHandler.class, null);
        this.addJavaType(java.util.Stack.class, null, false, false, Stack.class, org.datanucleus.store.types.wrappers.backed.Stack.class, StackHandler.class, null);
        this.addJavaType(java.util.TreeMap.class, null, false, false, TreeMap.class, org.datanucleus.store.types.wrappers.backed.TreeMap.class, TreeMapHandler.class, null);
        this.addJavaType(java.util.TreeSet.class, null, false, false, org.datanucleus.store.types.wrappers.TreeSet.class, TreeSet.class, TreeSetHandler.class, null);
        this.addJavaType(java.util.Vector.class, null, false, false, org.datanucleus.store.types.wrappers.Vector.class, Vector.class, VectorHandler.class, null);
        this.addJavaType(boolean[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(byte[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(char[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(double[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(float[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(int[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(long[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(short[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(Boolean[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(Byte[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(Character[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(Double[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(Float[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(Integer[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(Long[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(Short[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(Number[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(String[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(BigDecimal[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(BigInteger[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(java.util.Date[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(Locale[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(Enum[].class, null, true, false, null, null, ArrayHandler.class, null);
        this.addJavaType(Object[].class, null, true, false, null, null, ArrayHandler.class, null);
        ConfigurationElement[] elems = mgr.getConfigurationElementsForExtension("org.datanucleus.java_type", (String)null, (String)null);
        if (elems != null && elems.length > 0) {
            java.util.HashMap<Object, Integer> javaTypePriorities = new java.util.HashMap<Object, Integer>();
            for (int i = 0; i < elems.length; ++i) {
                String wrapperType;
                String embeddedString = elems[i].getAttribute("embedded");
                boolean embedded = embeddedString != null && embeddedString.equalsIgnoreCase("true");
                String dfgString = elems[i].getAttribute("dfg");
                boolean dfg = dfgString != null && dfgString.equalsIgnoreCase("true");
                String priorityString = elems[i].getAttribute("priority");
                int priority = 0;
                if (priorityString != null && !StringUtils.isWhitespace(priorityString)) {
                    try {
                        priority = Integer.parseInt(priorityString.trim());
                    }
                    catch (Exception e) {
                        priority = 0;
                    }
                }
                wrapperType = StringUtils.isWhitespace(wrapperType = elems[i].getAttribute("wrapper-type")) ? null : wrapperType.trim();
                String wrapperTypeBacked = elems[i].getAttribute("wrapper-type-backed");
                wrapperTypeBacked = StringUtils.isWhitespace(wrapperTypeBacked) ? null : wrapperTypeBacked.trim();
                String containerHandlerType = elems[i].getAttribute("container-handler");
                containerHandlerType = StringUtils.isWhitespace(containerHandlerType) ? null : containerHandlerType.trim();
                String javaName = elems[i].getAttribute("name").trim();
                String genericTypeName = elems[i].getAttribute("generic-type");
                String typeConverterName = elems[i].getAttribute("converter-name");
                try {
                    boolean doRegister;
                    Class cls = this.clr.classForName(javaName);
                    Class genericType = null;
                    Object javaTypeName = cls.getName();
                    if (!StringUtils.isWhitespace(genericTypeName)) {
                        genericType = this.clr.classForName(genericTypeName);
                        javaTypeName = (String)javaTypeName + "<" + genericTypeName + ">";
                    }
                    boolean bl = doRegister = !this.javaTypes.containsKey(javaTypeName);
                    if (!doRegister) {
                        int priorityToBeat = Optional.ofNullable((Integer)javaTypePriorities.get(javaTypeName)).orElse(0);
                        boolean bl2 = doRegister = priority > priorityToBeat;
                    }
                    if (!doRegister) continue;
                    Class wrapperClass = this.loadClass(mgr, elems[i], wrapperType, "016005");
                    Class wrapperClassBacked = this.loadClass(mgr, elems[i], wrapperTypeBacked, "016005");
                    Class containerHandlerClass = this.loadClass(mgr, elems[i], containerHandlerType, "016009");
                    Object typeName = cls.getName();
                    if (genericType != null) {
                        typeName = (String)typeName + "<" + genericType.getName() + ">";
                    }
                    this.javaTypes.put((String)typeName, new JavaType(cls, genericType, embedded, dfg, wrapperClass, wrapperClassBacked, containerHandlerClass, typeConverterName));
                    if (priority <= 0) continue;
                    javaTypePriorities.put(javaTypeName, priority);
                    continue;
                }
                catch (ClassNotResolvedException cnre) {
                    NucleusLogger.PERSISTENCE.debug("Not enabling java type support for " + javaName + " : java type not present in CLASSPATH");
                    continue;
                }
                catch (Exception e) {
                    NucleusLogger.PERSISTENCE.debug("Not enabling java type support for " + javaName + " : " + e.getMessage());
                }
            }
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            java.util.ArrayList<String> typesList = new java.util.ArrayList<String>(this.javaTypes.keySet());
            Collections.sort(typesList, ALPHABETICAL_ORDER_STRING);
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("016006", StringUtils.collectionToString(typesList)));
        }
    }

    private void addJavaType(Class cls, Class genericType, boolean embedded, boolean dfg, Class wrapperType, Class wrapperTypeBacked, Class containerHandlerType, String typeConverterName) {
        Object typeName = cls.getName();
        if (genericType != null) {
            typeName = (String)typeName + "<" + genericType.getName() + ">";
        }
        this.javaTypes.put((String)typeName, new JavaType(cls, genericType, embedded, dfg, wrapperType, wrapperTypeBacked, containerHandlerType, typeConverterName));
    }

    private Class loadClass(PluginManager mgr, ConfigurationElement elem, String className, String messageKey) {
        if (className == null) {
            return null;
        }
        try {
            return mgr.loadClass(elem.getExtension().getPlugin().getSymbolicName(), className);
        }
        catch (NucleusException ne) {
            NucleusLogger.PERSISTENCE.error(Localiser.msg(messageKey, className));
            throw new NucleusException(Localiser.msg(messageKey, className));
        }
    }

    private void loadTypeConverters(PluginManager mgr) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("016007"));
        }
        this.registerConverter("dn.boolean-yn", new BooleanYNConverter(), Boolean.class, Character.class, false, null);
        this.registerConverter("dn.boolean-integer", new BooleanIntegerConverter(), Boolean.class, Integer.class, false, null);
        this.registerConverter("dn.character-string", new CharacterStringConverter(), Character.class, String.class, false, null);
        this.registerConverter("dn.bigdecimal-string", new BigDecimalStringConverter(), BigDecimal.class, String.class, false, null);
        this.registerConverter("dn.bigdecimal-double", new BigDecimalDoubleConverter(), BigDecimal.class, Double.class, false, null);
        this.registerConverter("dn.biginteger-string", new BigIntegerStringConverter(), BigInteger.class, String.class, false, null);
        this.registerConverter("dn.biginteger-long", new BigIntegerLongConverter(), BigInteger.class, Long.class, false, null);
        this.registerConverter("dn.bitset-string", new BitSetStringConverter(), java.util.BitSet.class, String.class, false, null);
        if (ClassUtils.isClassPresent("java.awt.Color", this.clr)) {
            this.registerConverter("dn.color-string", new ColorStringConverter(), Color.class, String.class, false, null);
            this.registerConverter("dn.color-components", new ColorComponentsConverter(), Color.class, int[].class, false, null);
            this.registerConverter("dn.bufferedimage-bytearray", new BufferedImageByteArrayConverter(), BufferedImage.class, byte[].class, false, null);
            this.registerConverter("dn.bufferedimage-bytebuffer", new BufferedImageByteBufferConverter(), BufferedImage.class, ByteBuffer.class, false, null);
        }
        this.registerConverter("dn.class-string", new ClassStringConverter(), Class.class, String.class, false, null);
        this.registerConverter("dn.integer-string", new IntegerStringConverter(), Integer.class, String.class, false, null);
        this.registerConverter("dn.long-string", new LongStringConverter(), Long.class, String.class, false, null);
        this.registerConverter("dn.currency-string", new CurrencyStringConverter(), Currency.class, String.class, false, null);
        this.registerConverter("dn.locale-string", new LocaleStringConverter(), Locale.class, String.class, false, null);
        this.registerConverter("dn.stringbuffer-string", new StringBufferStringConverter(), StringBuffer.class, String.class, false, null);
        this.registerConverter("dn.stringbuilder-string", new StringBuilderStringConverter(), StringBuilder.class, String.class, false, null);
        this.registerConverter("dn.timezone-string", new TimeZoneStringConverter(), TimeZone.class, String.class, false, null);
        this.registerConverter("dn.uri-string", new URIStringConverter(), URI.class, String.class, false, null);
        this.registerConverter("dn.url-string", new URLStringConverter(), URL.class, String.class, false, null);
        this.registerConverter("dn.uuid-string", new UUIDStringConverter(), UUID.class, String.class, false, null);
        this.registerConverter("dn.date-long", new DateLongConverter(), java.util.Date.class, Long.class, false, null);
        this.registerConverter("dn.date-string", new DateStringConverter(), java.util.Date.class, String.class, false, null);
        this.registerConverter("dn.sqldate-long", new SqlDateLongConverter(), java.sql.Date.class, Long.class, false, null);
        this.registerConverter("dn.sqldate-string", new SqlDateStringConverter(), java.sql.Date.class, String.class, false, null);
        this.registerConverter("dn.sqldate-date", new SqlDateStringConverter(), java.sql.Date.class, java.util.Date.class, false, null);
        this.registerConverter("dn.sqltime-long", new SqlTimeStringConverter(), Time.class, Long.class, false, null);
        this.registerConverter("dn.sqltime-string", new SqlTimeStringConverter(), Time.class, String.class, false, null);
        this.registerConverter("dn.sqltime-date", new SqlTimeStringConverter(), Time.class, java.util.Date.class, false, null);
        this.registerConverter("dn.sqltimestamp-long", new SqlTimestampStringConverter(), Timestamp.class, Long.class, false, null);
        this.registerConverter("dn.sqltimestamp-date", new SqlTimestampStringConverter(), Timestamp.class, java.util.Date.class, false, null);
        this.registerConverter("dn.sqltimestamp-string", new SqlTimestampStringConverter(), Timestamp.class, String.class, false, null);
        this.registerConverter("dn.calendar-string", new CalendarStringConverter(), Calendar.class, String.class, false, null);
        this.registerConverter("dn.calendar-date", new CalendarDateConverter(), Calendar.class, java.util.Date.class, false, null);
        this.registerConverter("dn.calendar-timestamp", new CalendarTimestampConverter(), Calendar.class, Timestamp.class, false, null);
        this.registerConverter("dn.calendar-components", new CalendarComponentsConverter(), Calendar.class, Object[].class, false, null);
        this.registerConverter("dn.serializable-string", new SerializableStringConverter(), Serializable.class, String.class, false, null);
        this.registerConverter("dn.serializable-bytearray", new SerializableByteArrayConverter(), Serializable.class, byte[].class, false, null);
        this.registerConverter("dn.serializable-bytebuffer", new SerializableByteBufferConverter(), Serializable.class, ByteBuffer.class, false, null);
        this.registerConverter("dn.bytearray-bytebuffer", new ByteArrayByteBufferConverter(), byte[].class, ByteBuffer.class, false, null);
        this.registerConverter("dn.booleanarray-bytebuffer", new BooleanArrayByteBufferConverter(), boolean[].class, ByteBuffer.class, false, null);
        this.registerConverter("dn.chararray-bytebuffer", new CharArrayByteBufferConverter(), char[].class, ByteBuffer.class, false, null);
        this.registerConverter("dn.doublearray-bytebuffer", new DoubleArrayByteBufferConverter(), double[].class, ByteBuffer.class, false, null);
        this.registerConverter("dn.floatarray-bytebuffer", new FloatArrayByteBufferConverter(), float[].class, ByteBuffer.class, false, null);
        this.registerConverter("dn.intarray-bytebuffer", new IntArrayByteBufferConverter(), int[].class, ByteBuffer.class, false, null);
        this.registerConverter("dn.longarray-bytebuffer", new LongArrayByteBufferConverter(), long[].class, ByteBuffer.class, false, null);
        this.registerConverter("dn.shortarray-bytebuffer", new ShortArrayByteBufferConverter(), short[].class, ByteBuffer.class, false, null);
        this.registerConverter("dn.bigintegerarray-bytebuffer", new BigIntegerArrayByteBufferConverter(), BigInteger[].class, ByteBuffer.class, false, null);
        this.registerConverter("dn.bigdecimalarray-bytebuffer", new BigDecimalArrayByteBufferConverter(), BigDecimal[].class, ByteBuffer.class, false, null);
        this.registerConverter("dn.localdate-string", new LocalDateStringConverter(), LocalDate.class, String.class, false, null);
        this.registerConverter("dn.localdate-sqldate", new LocalDateSqlDateConverter(), LocalDate.class, java.sql.Date.class, false, null);
        this.registerConverter("dn.localdate-date", new LocalDateDateConverter(), LocalDate.class, java.util.Date.class, false, null);
        this.registerConverter("dn.localtime-string", new LocalTimeStringConverter(), LocalTime.class, String.class, false, null);
        this.registerConverter("dn.localtime-sqltime", new LocalTimeSqlTimeConverter(), LocalTime.class, Time.class, false, null);
        this.registerConverter("dn.localtime-date", new LocalTimeDateConverter(), LocalTime.class, java.util.Date.class, false, null);
        this.registerConverter("dn.localtime-long", new LocalTimeLongConverter(), LocalTime.class, Long.class, false, null);
        this.registerConverter("dn.localdatetime-string", new LocalDateTimeStringConverter(), LocalDateTime.class, String.class, false, null);
        this.registerConverter("dn.localdatetime-timestamp", new LocalDateTimeTimestampConverter(), LocalDateTime.class, Timestamp.class, false, null);
        this.registerConverter("dn.localdatetime-date", new LocalDateTimeDateConverter(), LocalDateTime.class, java.util.Date.class, false, null);
        this.registerConverter("dn.offsettime-string", new OffsetTimeStringConverter(), OffsetTime.class, String.class, false, null);
        this.registerConverter("dn.offsettime-long", new OffsetTimeLongConverter(), OffsetTime.class, Long.class, false, null);
        this.registerConverter("dn.offsettime-sqltime", new OffsetTimeSqlTimeConverter(), OffsetTime.class, Time.class, false, null);
        this.registerConverter("dn.offsetdatetime-string", new OffsetDateTimeStringConverter(), OffsetDateTime.class, String.class, false, null);
        this.registerConverter("dn.offsetdatetime-timestamp", new OffsetDateTimeTimestampConverter(), OffsetDateTime.class, Timestamp.class, false, null);
        this.registerConverter("dn.offsetdatetime-date", new OffsetDateTimeDateConverter(), OffsetDateTime.class, java.util.Date.class, false, null);
        this.registerConverter("dn.duration-string", new DurationStringConverter(), Duration.class, String.class, false, null);
        this.registerConverter("dn.duration-long", new DurationLongConverter(), Duration.class, Long.class, false, null);
        this.registerConverter("dn.duration-double", new DurationDoubleConverter(), Duration.class, Double.class, false, null);
        this.registerConverter("dn.period-string", new PeriodStringConverter(), Period.class, String.class, false, null);
        this.registerConverter("dn.period-components", new PeriodComponentsConverter(), Period.class, int[].class, false, null);
        this.registerConverter("dn.instant-timestamp", new InstantTimestampConverter(), Instant.class, Timestamp.class, false, null);
        this.registerConverter("dn.instant-date", new InstantDateConverter(), Instant.class, java.util.Date.class, false, null);
        this.registerConverter("dn.instant-string", new InstantStringConverter(), Instant.class, String.class, false, null);
        this.registerConverter("dn.instant-long", new InstantLongConverter(), Instant.class, Long.class, false, null);
        this.registerConverter("dn.year-string", new YearStringConverter(), Year.class, String.class, false, null);
        this.registerConverter("dn.year-integer", new YearIntegerConverter(), Year.class, Integer.class, false, null);
        this.registerConverter("dn.yearmonth-string", new YearMonthStringConverter(), YearMonth.class, String.class, false, null);
        this.registerConverter("dn.yearmonth-components", new YearMonthComponentsConverter(), YearMonth.class, int[].class, false, null);
        this.registerConverter("dn.yearmonth-sqldate", new YearMonthSqlDateConverter(), YearMonth.class, java.sql.Date.class, false, null);
        this.registerConverter("dn.yearmonth-date", new YearMonthDateConverter(), YearMonth.class, java.util.Date.class, false, null);
        this.registerConverter("dn.monthday-string", new MonthDayStringConverter(), MonthDay.class, String.class, false, null);
        this.registerConverter("dn.monthday-components", new MonthDayComponentsConverter(), MonthDay.class, int[].class, false, null);
        this.registerConverter("dn.monthday-sqldate", new MonthDaySqlDateConverter(), MonthDay.class, java.sql.Date.class, false, null);
        this.registerConverter("dn.monthday-date", new MonthDayDateConverter(), MonthDay.class, java.util.Date.class, false, null);
        this.registerConverter("dn.zoneid-string", new ZoneIdStringConverter(), ZoneId.class, String.class, false, null);
        this.registerConverter("dn.zoneoffset-string", new ZoneOffsetStringConverter(), ZoneOffset.class, String.class, false, null);
        this.registerConverter("dn.zoneddatetime-string", new ZonedDateTimeStringConverter(), ZonedDateTime.class, String.class, false, null);
        this.registerConverter("dn.zoneddatetime-timestamp", new ZonedDateTimeTimestampConverter(), ZonedDateTime.class, Timestamp.class, false, null);
        ConfigurationElement[] elems = mgr.getConfigurationElementsForExtension("org.datanucleus.type_converter", (String)null, (String)null);
        if (elems != null) {
            for (int i = 0; i < elems.length; ++i) {
                String name = elems[i].getAttribute("name").trim();
                String memberTypeName = elems[i].getAttribute("member-type").trim();
                String datastoreTypeName = elems[i].getAttribute("datastore-type").trim();
                String converterClsName = elems[i].getAttribute("converter-class").trim();
                Class memberType = null;
                try {
                    TypeConverter conv = (TypeConverter)mgr.createExecutableExtension("org.datanucleus.type_converter", "name", name, "converter-class", null, null);
                    memberType = this.clr.classForName(memberTypeName);
                    Class datastoreType = this.clr.classForName(datastoreTypeName);
                    this.registerConverter(name, conv, memberType, datastoreType, false, null);
                    continue;
                }
                catch (Exception e) {
                    if (!NucleusLogger.PERSISTENCE.isDebugEnabled()) continue;
                    if (memberType != null) {
                        NucleusLogger.PERSISTENCE.debug("TypeConverter for " + memberTypeName + "<->" + datastoreTypeName + " using " + converterClsName + " not instantiable (missing dependencies?) so ignoring");
                        continue;
                    }
                    NucleusLogger.PERSISTENCE.debug("TypeConverter for " + memberTypeName + "<->" + datastoreTypeName + " ignored since java type not present in CLASSPATH");
                }
            }
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("016008"));
            if (this.typeConverterMap != null) {
                java.util.ArrayList<Class> typesList = new java.util.ArrayList<Class>(this.typeConverterMap.keySet());
                Collections.sort(typesList, ALPHABETICAL_ORDER);
                for (Class javaType : typesList) {
                    java.util.Set<Class> datastoreTypes = this.typeConverterMap.get(javaType).keySet();
                    StringBuilder str = new StringBuilder();
                    for (Class datastoreCls : datastoreTypes) {
                        if (str.length() > 0) {
                            str.append(',');
                        }
                        str.append(StringUtils.getNameOfClass(datastoreCls));
                    }
                    NucleusLogger.PERSISTENCE.debug("TypeConverter(s) available for " + StringUtils.getNameOfClass(javaType) + " to : " + str.toString());
                }
            }
        }
    }

    static class JavaType
    implements Serializable {
        private static final long serialVersionUID = -811442140006259453L;
        final Class cls;
        final Class genericType;
        final boolean embedded;
        final boolean dfg;
        final Class<? extends SCO> wrapperType;
        final Class<? extends SCO> wrapperTypeBacked;
        String typeConverterName;
        final Class<? extends ContainerHandler> containerHandlerType;

        public JavaType(Class cls, Class genericType, boolean embedded, boolean dfg, Class wrapperType, Class wrapperTypeBacked, Class containerHandlerType, String typeConverterName) {
            this.cls = cls;
            this.genericType = genericType;
            this.embedded = embedded;
            this.dfg = dfg;
            this.wrapperType = wrapperType;
            this.wrapperTypeBacked = wrapperTypeBacked != null ? wrapperTypeBacked : wrapperType;
            this.containerHandlerType = containerHandlerType;
            this.typeConverterName = typeConverterName;
        }
    }
}

