/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.util.Map;
import java.util.Set;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.JPQLSingleStringParser;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.query.compiler.JPQLCompiler;
import org.datanucleus.store.query.compiler.JavaQueryCompiler;
import org.datanucleus.store.query.compiler.QueryCompilation;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractJPQLQuery
extends AbstractJavaQuery {
    private static final long serialVersionUID = 3365033406094223177L;

    public AbstractJPQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        super(storeMgr, ec);
    }

    public AbstractJPQLQuery(StoreManager storeMgr, ExecutionContext ec, AbstractJPQLQuery q) {
        super(storeMgr, ec);
        this.candidateClass = q != null ? q.candidateClass : null;
        this.candidateClassName = q != null ? q.candidateClassName : null;
        this.from = q != null ? q.from : null;
        this.subclasses = q != null ? q.subclasses : true;
        this.filter = q != null ? q.filter : null;
        this.imports = q != null ? q.imports : null;
        this.explicitVariables = q != null ? q.explicitVariables : null;
        this.explicitParameters = q != null ? q.explicitParameters : null;
        this.grouping = q != null ? q.grouping : null;
        this.ordering = q != null ? q.ordering : null;
        this.update = q != null ? q.update : null;
        this.result = q != null ? q.result : null;
        this.resultClass = q != null ? q.resultClass : null;
        this.resultDistinct = q != null ? q.resultDistinct : false;
        this.range = q != null ? q.range : null;
        this.fromInclNo = q != null ? q.fromInclNo : 0L;
        this.toExclNo = q != null ? q.toExclNo : Long.MAX_VALUE;
        this.fromInclParam = q != null ? q.fromInclParam : null;
        String string = this.toExclParam = q != null ? q.toExclParam : null;
        if (q != null) {
            this.ignoreCache = q.ignoreCache;
        }
        if (q != null && q.subqueries != null && !q.subqueries.isEmpty()) {
            for (Query.SubqueryDefinition subquery : q.subqueries.values()) {
                this.addSubquery(subquery.query, subquery.variableDecl, subquery.candidateExpression, subquery.parameterMap);
            }
        }
    }

    public AbstractJPQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec);
        JPQLSingleStringParser parser = new JPQLSingleStringParser(this, query);
        if (this.getBooleanExtensionProperty("datanucleus.query.jpql.allowrange", false)) {
            parser.allowRange();
        }
        parser.parse();
    }

    @Override
    public Set<String> getSupportedExtensions() {
        Set<String> supported = super.getSupportedExtensions();
        supported.add("datanucleus.query.jpql.strict");
        return supported;
    }

    @Override
    public void setResult(String result) {
        this.discardCompiled();
        this.assertIsModifiable();
        if (result == null) {
            this.result = null;
            this.resultDistinct = false;
            return;
        }
        String str = result.trim();
        if (str.toUpperCase().startsWith("DISTINCT ")) {
            this.resultDistinct = true;
            this.result = str.substring(8).trim();
        } else {
            this.resultDistinct = false;
            this.result = str;
        }
    }

    protected String getQueryCacheKey() {
        String multiTenancyId;
        Object queryCacheKey = this.toString();
        if (this.range != null) {
            queryCacheKey = (String)queryCacheKey + " RANGE " + this.range;
        } else if (this.fromInclNo > 0L || this.toExclNo != Long.MAX_VALUE) {
            queryCacheKey = (String)queryCacheKey + " RANGE " + this.fromInclNo + "," + this.toExclNo;
        }
        if (this.getFetchPlan() != null) {
            queryCacheKey = (String)queryCacheKey + " " + this.getFetchPlan().toString();
        }
        if (!this.subclasses) {
            queryCacheKey = (String)queryCacheKey + " EXCLUDE SUBCLASSES";
        }
        if ((multiTenancyId = this.ec.getTenantId()) != null) {
            queryCacheKey = (String)queryCacheKey + " " + multiTenancyId;
        }
        return queryCacheKey;
    }

    @Override
    public String getSingleStringQuery() {
        if (this.singleString != null) {
            return this.singleString;
        }
        StringBuilder str = new StringBuilder();
        if (this.type == Query.QueryType.BULK_INSERT) {
            str.append("INSERT INTO ").append(this.from);
            str.append(" (").append(this.insertFields).append(") ");
            str.append(this.insertSelectQuery);
        } else if (this.type == Query.QueryType.BULK_UPDATE) {
            str.append("UPDATE ").append(this.from).append(" SET ").append(this.update).append(' ');
            if (!StringUtils.isWhitespace(this.filter)) {
                str.append("WHERE ").append(this.dereferenceFilter(this.filter));
            }
        } else if (this.type == Query.QueryType.BULK_DELETE) {
            str.append("DELETE FROM ").append(this.from).append(' ');
            if (!StringUtils.isWhitespace(this.filter)) {
                str.append("WHERE ").append(this.dereferenceFilter(this.filter));
            }
        } else {
            str.append("SELECT ");
            if (this.result != null) {
                if (this.resultDistinct) {
                    str.append("DISTINCT ");
                }
                str.append(this.result).append(' ');
            } else if (this.compilation != null && this.compilation.getCandidateAlias() != null) {
                str.append(this.compilation.getCandidateAlias()).append(' ');
            }
            str.append("FROM " + this.from + " ");
            if (this.filter != null) {
                str.append("WHERE " + this.dereferenceFilter(this.filter)).append(' ');
            }
            if (this.grouping != null) {
                str.append("GROUP BY ").append(this.grouping).append(' ');
            }
            if (this.having != null) {
                str.append("HAVING ").append(this.having).append(' ');
            }
            if (this.ordering != null) {
                str.append("ORDER BY ").append(this.ordering).append(' ');
            }
        }
        this.singleString = str.toString().trim();
        return this.singleString;
    }

    @Override
    public void compileGeneric(Map parameterValues) {
        QueryCompilation cachedCompilation;
        if (this.compilation != null) {
            return;
        }
        QueryManager queryMgr = this.getQueryManager();
        String queryCacheKey = this.getQueryCacheKey();
        if (this.useCaching() && queryCacheKey != null && (cachedCompilation = queryMgr.getQueryCompilationForQuery(this.getLanguage(), queryCacheKey)) != null) {
            this.compilation = cachedCompilation;
            if (this.compilation.getExprResult() == null) {
                this.result = null;
            }
            this.checkParameterTypesAgainstCompilation(parameterValues);
            return;
        }
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug(Localiser.msg("021044", this.getLanguage(), this.getSingleStringQuery()));
        }
        Object from = this.from;
        if (this.type == Query.QueryType.BULK_INSERT) {
            from = (String)from + " this";
        }
        JPQLCompiler compiler = new JPQLCompiler(this.ec.getNucleusContext(), this.ec.getClassLoaderResolver(), (String)from, this.candidateClass, this.candidateCollection, this.filter, this.getParsedImports(), this.ordering, this.result, this.grouping, this.having, this.explicitParameters, this.update);
        if (this.getBooleanExtensionProperty("datanucleus.query.jpql.strict", false)) {
            compiler.setOption("datanucleus.query.jpql.strict", "true");
        }
        this.compilation = ((JavaQueryCompiler)compiler).compile(parameterValues, this.subqueries);
        if (QueryUtils.queryReturnsSingleRow(this)) {
            this.compilation.setReturnsSingleRow();
        }
        if (this.resultDistinct) {
            this.compilation.setResultDistinct();
        }
        if (this.compilation.getExprResult() == null) {
            this.result = null;
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug(Localiser.msg("021045", this.getLanguage(), "" + (System.currentTimeMillis() - startTime)));
        }
        if (this.subqueries != null) {
            this.compileSubqueries(this.subqueries, this.compilation, compiler, parameterValues);
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug(this.compilation.toString());
        }
        if (this.implicitParameters != null) {
            for (Object paramKey : this.implicitParameters.keySet()) {
                String paramName = "" + paramKey;
                this.applyImplicitParameterValueToCompilation(paramName, this.implicitParameters.get(paramName));
            }
        }
        this.checkParameterTypesAgainstCompilation(parameterValues);
        if (this.useCaching() && queryCacheKey != null) {
            queryMgr.addQueryCompilation(this.getLanguage(), queryCacheKey, this.compilation);
        }
    }

    @Override
    protected void compileInternal(Map parameterValues) {
        this.compileGeneric(parameterValues);
    }

    protected void compileSubqueries(Map<String, Query.SubqueryDefinition> subqueryMap, QueryCompilation parentCompilation, JavaQueryCompiler parentCompiler, Map parameterValues) {
        long startTime = System.currentTimeMillis();
        for (Map.Entry<String, Query.SubqueryDefinition> entry : subqueryMap.entrySet()) {
            Query.SubqueryDefinition subqueryDefinition = entry.getValue();
            Query subquery = subqueryDefinition.getQuery();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
                NucleusLogger.QUERY.debug(Localiser.msg("021044", this.getLanguage(), ((AbstractJPQLQuery)subquery).getSingleStringQuery()));
            }
            JPQLCompiler subCompiler = new JPQLCompiler(this.ec.getNucleusContext(), this.ec.getClassLoaderResolver(), subquery.from, subquery.candidateClass, null, subquery.filter, this.getParsedImports(), subquery.ordering, subquery.result, subquery.grouping, subquery.having, null, null);
            if (this.getBooleanExtensionProperty("datanucleus.query.jpql.strict", false)) {
                subCompiler.setOption("datanucleus.query.jpql.strict", "true");
            }
            subCompiler.setLinkToParentQuery(parentCompiler, null);
            QueryCompilation subqueryCompilation = ((JavaQueryCompiler)subCompiler).compile(parameterValues, subquery.subqueries);
            parentCompilation.addSubqueryCompilation(entry.getKey(), subqueryCompilation);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(Localiser.msg("021045", this.getLanguage(), "" + (System.currentTimeMillis() - startTime)));
            }
            if (subquery.subqueries == null) continue;
            this.compileSubqueries(subquery.subqueries, subqueryCompilation, subCompiler, parameterValues);
        }
    }

    @Override
    public Class resolveClassDeclaration(String classDecl) {
        AbstractClassMetaData acmd = this.getStoreManager().getNucleusContext().getMetaDataManager().getMetaDataForEntityName(classDecl);
        if (acmd != null) {
            classDecl = acmd.getFullClassName();
        }
        return super.resolveClassDeclaration(classDecl);
    }

    @Override
    public String getLanguage() {
        return QueryLanguage.JPQL.name();
    }
}

