/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.federation;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.Configuration;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.flush.FlushProcess;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.SingleFieldId;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.state.ReferentialStateManagerImpl;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.NucleusSequence;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StoreManagerHelper;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.connection.ConnectionManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.federation.FederatedPersistenceHandler;
import org.datanucleus.store.federation.FederatedQueryManagerImpl;
import org.datanucleus.store.query.Extent;
import org.datanucleus.store.query.JDOQLQueryHelper;
import org.datanucleus.store.query.JPQLQueryHelper;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.store.schema.naming.NamingFactory;
import org.datanucleus.store.valuegenerator.ValueGenerationManager;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class FederatedStoreManager
implements StoreManager {
    public static final String PROPERTY_DATA_FEDERATION_DATASTORE_NAME = "DATA_FEDERATION_DATASTORE_NAME";
    protected StoreManager primaryStoreMgr;
    protected Map<String, StoreManager> secondaryStoreMgrMap = null;
    protected PersistenceNucleusContext nucleusContext;
    protected StorePersistenceHandler persistenceHandler = null;
    protected QueryManager queryMgr = null;

    public FederatedStoreManager(ClassLoaderResolver clr, PersistenceNucleusContext nucleusContext) {
        Set<String> propNamesWithDatastore;
        String reqdIsolation;
        this.nucleusContext = nucleusContext;
        Map<String, Object> datastoreProps = nucleusContext.getConfiguration().getDatastoreProperties();
        this.primaryStoreMgr = StoreManagerHelper.createStoreManagerForProperties(nucleusContext.getConfiguration().getPersistenceProperties(), datastoreProps, clr, nucleusContext);
        String transactionIsolation = nucleusContext.getConfiguration().getStringProperty("datanucleus.transaction.isolation");
        if (transactionIsolation != null && !transactionIsolation.equalsIgnoreCase(reqdIsolation = TransactionUtils.getTransactionIsolationForStoreManager(this.primaryStoreMgr, transactionIsolation))) {
            nucleusContext.getConfiguration().setProperty("datanucleus.transaction.isolation", reqdIsolation);
        }
        if ((propNamesWithDatastore = nucleusContext.getConfiguration().getPropertyNamesWithPrefix("datanucleus.datastore.")) != null) {
            this.secondaryStoreMgrMap = new HashMap<String, StoreManager>();
            for (String datastorePropName : propNamesWithDatastore) {
                String datastoreName = datastorePropName.substring("datanucleus.datastore.".length());
                String filename = nucleusContext.getConfiguration().getStringProperty(datastorePropName);
                Configuration datastoreConf = new Configuration(nucleusContext);
                datastoreConf.setPropertiesUsingFile(filename);
                datastoreConf.setProperty(PROPERTY_DATA_FEDERATION_DATASTORE_NAME, datastoreName);
                StoreManager storeMgr = StoreManagerHelper.createStoreManagerForProperties(datastoreConf.getPersistenceProperties(), datastoreConf.getDatastoreProperties(), clr, nucleusContext);
                this.secondaryStoreMgrMap.put(datastoreName, storeMgr);
            }
        }
        this.persistenceHandler = new FederatedPersistenceHandler(this);
    }

    @Override
    public PersistenceNucleusContext getNucleusContext() {
        return this.nucleusContext;
    }

    @Override
    public MetaDataManager getMetaDataManager() {
        return this.nucleusContext.getMetaDataManager();
    }

    @Override
    public FlushProcess getFlushProcess() {
        return this.primaryStoreMgr.getFlushProcess();
    }

    @Override
    public void close() {
        this.primaryStoreMgr.close();
        this.primaryStoreMgr = null;
        if (this.secondaryStoreMgrMap != null) {
            for (Map.Entry<String, StoreManager> secondaryStoreEntry : this.secondaryStoreMgrMap.entrySet()) {
                secondaryStoreEntry.getValue().close();
            }
            this.secondaryStoreMgrMap.clear();
            this.secondaryStoreMgrMap = null;
        }
        this.persistenceHandler.close();
        if (this.queryMgr != null) {
            this.queryMgr.close();
            this.queryMgr = null;
        }
        this.nucleusContext = null;
    }

    @Override
    public boolean isClosed() {
        return this.nucleusContext == null;
    }

    public StoreManager getStoreManagerForClass(AbstractClassMetaData cmd) {
        if (cmd.hasExtension("datastore")) {
            String datastoreName = cmd.getValueForExtension("datastore");
            if (this.secondaryStoreMgrMap == null || !this.secondaryStoreMgrMap.containsKey(datastoreName)) {
                throw new NucleusUserException("Class " + cmd.getFullClassName() + " specified to persist to datastore " + datastoreName + " yet not defined");
            }
            return this.secondaryStoreMgrMap.get(datastoreName);
        }
        return this.primaryStoreMgr;
    }

    public StoreManager getStoreManagerForClass(String className, ClassLoaderResolver clr) {
        AbstractClassMetaData cmd = this.nucleusContext.getMetaDataManager().getMetaDataForClass(className, clr);
        return this.getStoreManagerForClass(cmd);
    }

    @Override
    public void manageClasses(ClassLoaderResolver clr, String ... classNames) {
        if (classNames != null) {
            for (int i = 0; i < classNames.length; ++i) {
                this.getStoreManagerForClass(classNames[i], clr).manageClasses(clr, classNames[i]);
            }
        }
    }

    @Override
    public NamingFactory getNamingFactory() {
        return this.primaryStoreMgr.getNamingFactory();
    }

    @Override
    public ApiAdapter getApiAdapter() {
        return this.nucleusContext.getApiAdapter();
    }

    @Override
    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        return this.primaryStoreMgr.getClassNameForObjectID(id, clr, ec);
    }

    @Override
    public Date getDatastoreDate() {
        return this.primaryStoreMgr.getDatastoreDate();
    }

    public Extent getExtent(ExecutionContext ec, Class c, boolean subclasses) {
        return this.getStoreManagerForClass(c.getName(), ec.getClassLoaderResolver()).getExtent(ec, c, subclasses);
    }

    @Override
    public boolean isJdbcStore() {
        return this.primaryStoreMgr.isJdbcStore();
    }

    @Override
    public NucleusConnection getNucleusConnection(ExecutionContext ec) {
        return this.primaryStoreMgr.getNucleusConnection(ec);
    }

    @Override
    public NucleusSequence getNucleusSequence(ExecutionContext ec, SequenceMetaData seqmd) {
        return this.primaryStoreMgr.getNucleusSequence(ec, seqmd);
    }

    @Override
    public StoreSchemaHandler getSchemaHandler() {
        return this.primaryStoreMgr.getSchemaHandler();
    }

    @Override
    public StoreData getStoreDataForClass(String className) {
        return this.primaryStoreMgr.getStoreDataForClass(className);
    }

    @Override
    public StorePersistenceHandler getPersistenceHandler() {
        return this.persistenceHandler;
    }

    @Override
    public QueryManager getQueryManager() {
        if (this.queryMgr == null) {
            this.queryMgr = new FederatedQueryManagerImpl(this.nucleusContext, this);
        }
        return this.queryMgr;
    }

    @Override
    public Collection<String> getSupportedQueryLanguages() {
        return this.primaryStoreMgr.getSupportedQueryLanguages();
    }

    @Override
    public Query newQuery(String language, ExecutionContext ec) {
        return this.primaryStoreMgr.newQuery(language, ec);
    }

    @Override
    public Query newQuery(String language, ExecutionContext ec, String queryString) {
        AbstractClassMetaData entityCmd;
        String candidateEntityName;
        String candidateClassName = null;
        if (QueryLanguage.JDOQL.name().equalsIgnoreCase(language)) {
            candidateClassName = JDOQLQueryHelper.getCandidateFromJDOQLString(queryString);
        } else if (QueryLanguage.JPQL.name().equalsIgnoreCase(language) && (candidateEntityName = JPQLQueryHelper.getEntityNameFromJPQLString(queryString)) != null && (entityCmd = ec.getMetaDataManager().getMetaDataForEntityName(candidateEntityName)) != null) {
            candidateClassName = entityCmd.getFullClassName();
        }
        StoreManager storeMgr = this.primaryStoreMgr;
        if (candidateClassName != null) {
            storeMgr = this.getStoreManagerForClass(candidateClassName, ec.getClassLoaderResolver());
        }
        return storeMgr.newQuery(language, ec, queryString);
    }

    @Override
    public Query newQuery(String language, ExecutionContext ec, Query q) {
        return this.getStoreManagerForClass(q.getCandidateClassName(), ec.getClassLoaderResolver()).newQuery(language, ec, q);
    }

    @Override
    public ValueGenerationManager getValueGenerationManager() {
        return this.primaryStoreMgr.getValueGenerationManager();
    }

    @Override
    public String getStoreManagerKey() {
        return this.primaryStoreMgr.getStoreManagerKey();
    }

    @Override
    public String getQueryCacheKey() {
        return this.primaryStoreMgr.getQueryCacheKey();
    }

    @Override
    public Object getValueGenerationStrategyValue(ExecutionContext ec, AbstractClassMetaData cmd, AbstractMemberMetaData mmd) {
        return this.getStoreManagerForClass(cmd).getValueGenerationStrategyValue(ec, cmd, mmd);
    }

    @Override
    public boolean isValueGenerationStrategyDatastoreAttributed(AbstractClassMetaData cmd, int absFieldNumber) {
        return this.getStoreManagerForClass(cmd).isValueGenerationStrategyDatastoreAttributed(cmd, absFieldNumber);
    }

    @Override
    public String getValueGenerationStrategyForNative(AbstractClassMetaData cmd) {
        return this.primaryStoreMgr.getValueGenerationStrategyForNative(cmd);
    }

    @Override
    public String getValueGenerationStrategyForNative(AbstractMemberMetaData mmd) {
        return this.primaryStoreMgr.getValueGenerationStrategyForNative(mmd);
    }

    @Override
    public Collection<String> getSubClassesForClass(String className, boolean includeDescendents, ClassLoaderResolver clr) {
        return this.getStoreManagerForClass(className, clr).getSubClassesForClass(className, includeDescendents, clr);
    }

    @Override
    public String manageClassForIdentity(Object id, ClassLoaderResolver clr) {
        if (IdentityUtils.isSingleFieldIdentity(id)) {
            return this.getStoreManagerForClass(((SingleFieldId)id).getTargetClassName(), clr).manageClassForIdentity(id, clr);
        }
        if (IdentityUtils.isDatastoreIdentity(id)) {
            return this.getStoreManagerForClass(((DatastoreId)id).getTargetClassName(), clr).manageClassForIdentity(id, clr);
        }
        Collection<AbstractClassMetaData> cmds = this.getMetaDataManager().getClassMetaDataWithApplicationId(id.getClass().getName());
        if (cmds != null && !cmds.isEmpty()) {
            AbstractClassMetaData cmd = cmds.iterator().next();
            return this.getStoreManagerForClass(cmd).manageClassForIdentity(id, clr);
        }
        NucleusLogger.PERSISTENCE.debug("Unable to find the store that manages an id of type " + StringUtils.toJVMIDString(id) + "; using primary store");
        return this.primaryStoreMgr.manageClassForIdentity(id, clr);
    }

    @Override
    public boolean managesClass(String className) {
        return this.primaryStoreMgr.managesClass(className);
    }

    @Override
    public void printInformation(String category, PrintStream ps) throws Exception {
        this.primaryStoreMgr.printInformation(category, ps);
    }

    @Override
    public void unmanageAllClasses(ClassLoaderResolver clr) {
        this.primaryStoreMgr.unmanageAllClasses(clr);
        if (this.secondaryStoreMgrMap != null) {
            Collection<StoreManager> secStoreMgrs = this.secondaryStoreMgrMap.values();
            for (StoreManager storeMgr : secStoreMgrs) {
                storeMgr.unmanageAllClasses(clr);
            }
        }
    }

    @Override
    public void unmanageClass(ClassLoaderResolver clr, String className, boolean removeFromDatastore) {
        this.primaryStoreMgr.unmanageClass(clr, className, removeFromDatastore);
        if (this.secondaryStoreMgrMap != null) {
            Collection<StoreManager> secStoreMgrs = this.secondaryStoreMgrMap.values();
            for (StoreManager storeMgr : secStoreMgrs) {
                storeMgr.unmanageClass(clr, className, removeFromDatastore);
            }
        }
    }

    @Override
    public boolean supportsQueryLanguage(String language) {
        return this.primaryStoreMgr.supportsQueryLanguage(language);
    }

    @Override
    public String getNativeQueryLanguage() {
        return this.primaryStoreMgr.getNativeQueryLanguage();
    }

    @Override
    public boolean supportsValueGenerationStrategy(String language) {
        return this.primaryStoreMgr.supportsValueGenerationStrategy(language);
    }

    public Collection getSupportedOptions() {
        return this.primaryStoreMgr.getSupportedOptions();
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.primaryStoreMgr.getConnectionManager();
    }

    public ManagedConnection getConnection(ExecutionContext ec) {
        return this.primaryStoreMgr.getConnectionManager().getConnection(ec);
    }

    public ManagedConnection getConnection(ExecutionContext ec, Map options) {
        return this.primaryStoreMgr.getConnectionManager().getConnection(ec, options);
    }

    public ManagedConnection getConnection(int isolation_level) {
        return this.primaryStoreMgr.getConnectionManager().getConnection(isolation_level);
    }

    @Override
    public String getConnectionDriverName() {
        return this.primaryStoreMgr.getConnectionDriverName();
    }

    @Override
    public String getConnectionURL() {
        return this.primaryStoreMgr.getConnectionURL();
    }

    @Override
    public String getConnectionUserName() {
        return this.primaryStoreMgr.getConnectionUserName();
    }

    @Override
    public String getConnectionPassword() {
        return this.primaryStoreMgr.getConnectionPassword();
    }

    @Override
    public Object getConnectionFactory() {
        return this.primaryStoreMgr.getConnectionFactory();
    }

    @Override
    public Object getConnectionFactory2() {
        return this.primaryStoreMgr.getConnectionFactory2();
    }

    @Override
    public String getConnectionFactory2Name() {
        return this.primaryStoreMgr.getConnectionFactory2Name();
    }

    @Override
    public String getConnectionFactoryName() {
        return this.primaryStoreMgr.getConnectionFactoryName();
    }

    @Override
    public Object getProperty(String name) {
        return this.primaryStoreMgr.getProperty(name);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.primaryStoreMgr.hasProperty(name);
    }

    @Override
    public int getIntProperty(String name) {
        return this.primaryStoreMgr.getIntProperty(name);
    }

    @Override
    public boolean getBooleanProperty(String name) {
        return this.primaryStoreMgr.getBooleanProperty(name);
    }

    @Override
    public boolean getBooleanProperty(String name, boolean resultIfNotSet) {
        return this.primaryStoreMgr.getBooleanProperty(name, resultIfNotSet);
    }

    @Override
    public Boolean getBooleanObjectProperty(String name) {
        return this.primaryStoreMgr.getBooleanObjectProperty(name);
    }

    @Override
    public String getStringProperty(String name) {
        return this.primaryStoreMgr.getStringProperty(name);
    }

    @Override
    public void enableSchemaGeneration() {
        this.primaryStoreMgr.enableSchemaGeneration();
    }

    @Override
    public void resetSchemaGeneration() {
        this.primaryStoreMgr.resetSchemaGeneration();
    }

    @Override
    public void transactionStarted(ExecutionContext ec) {
        this.primaryStoreMgr.transactionStarted(ec);
    }

    @Override
    public void transactionCommitted(ExecutionContext ec) {
        this.primaryStoreMgr.transactionCommitted(ec);
    }

    @Override
    public void transactionRolledBack(ExecutionContext ec) {
        this.primaryStoreMgr.transactionRolledBack(ec);
    }

    @Override
    public boolean useBackedSCOWrapperForMember(AbstractMemberMetaData mmd, ExecutionContext ec) {
        return this.primaryStoreMgr.useBackedSCOWrapperForMember(mmd, ec);
    }

    @Override
    public boolean usesBackedSCOWrappers() {
        return this.primaryStoreMgr.usesBackedSCOWrappers();
    }

    @Override
    public String getDefaultStateManagerClassName() {
        return ReferentialStateManagerImpl.class.getName();
    }
}

