/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.datanucleus.ExecutionContextImpl;
import org.datanucleus.FetchPlanState;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.query.Extent;

public class ExecutionContextThreadedImpl
extends ExecutionContextImpl {
    protected Lock lock;
    int lockCounter = 0;

    public ExecutionContextThreadedImpl(PersistenceNucleusContext ctx, Object owner, Map<String, Object> options) {
        super(ctx, owner, options);
    }

    @Override
    public synchronized void threadLock() {
        if (this.lock == null) {
            this.lock = new ReentrantLock();
        }
        if (this.lockCounter == 0) {
            this.lock.lock();
        }
        ++this.lockCounter;
    }

    @Override
    public synchronized void threadUnlock() {
        --this.lockCounter;
        if (this.lockCounter == 0 && this.lock != null) {
            this.lock.unlock();
        }
    }

    @Override
    public boolean getMultithreaded() {
        return true;
    }

    @Override
    public void processNontransactionalUpdate() {
        try {
            this.threadLock();
            super.processNontransactionalUpdate();
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void enlistInTransaction(DNStateManager sm) {
        try {
            this.threadLock();
            super.enlistInTransaction(sm);
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void evictFromTransaction(DNStateManager sm) {
        try {
            this.threadLock();
            super.evictFromTransaction(sm);
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void addStateManagerToCache(DNStateManager sm) {
        try {
            this.threadLock();
            super.addStateManagerToCache(sm);
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void removeStateManagerFromCache(DNStateManager sm) {
        try {
            this.threadLock();
            super.removeStateManagerFromCache(sm);
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public DNStateManager findStateManager(Object pc) {
        try {
            this.threadLock();
            DNStateManager dNStateManager = super.findStateManager(pc);
            return dNStateManager;
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void close() {
        try {
            this.threadLock();
            super.close();
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void evictObject(Object obj) {
        try {
            this.threadLock();
            super.evictObject(obj);
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void refreshObject(Object obj) {
        try {
            this.threadLock();
            super.refreshObject(obj);
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void retrieveObjects(boolean useFetchPlan, Object ... pcs) {
        try {
            this.threadLock();
            super.retrieveObjects(useFetchPlan, pcs);
        }
        finally {
            this.threadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object persistObject(Object obj, boolean merging) {
        try {
            this.threadLock();
            Object object = super.persistObject(obj, merging);
            return object;
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public Object[] persistObjects(Object ... objs) {
        try {
            this.threadLock();
            Object[] objectArray = super.persistObjects(objs);
            return objectArray;
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void deleteObject(Object obj) {
        try {
            this.threadLock();
            super.deleteObject(obj);
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void deleteObjects(Object ... objs) {
        try {
            this.threadLock();
            super.deleteObjects(objs);
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void makeObjectTransient(Object obj, FetchPlanState state) {
        try {
            this.threadLock();
            super.makeObjectTransient(obj, state);
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void makeObjectTransactional(Object obj) {
        try {
            this.threadLock();
            super.makeObjectTransactional(obj);
        }
        finally {
            this.threadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachObject(DNStateManager ownerSM, Object pc, boolean sco) {
        try {
            this.threadLock();
            super.attachObject(ownerSM, pc, sco);
        }
        finally {
            this.threadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object attachObjectCopy(DNStateManager ownerSM, Object pc, boolean sco) {
        try {
            this.threadLock();
            Object object = super.attachObjectCopy(ownerSM, pc, sco);
            return object;
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void detachObject(FetchPlanState state, Object obj) {
        try {
            this.threadLock();
            super.detachObject(state, obj);
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void detachObjects(FetchPlanState state, Object ... objs) {
        try {
            this.threadLock();
            super.detachObjects(state, objs);
        }
        finally {
            this.threadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object detachObjectCopy(Object pc, FetchPlanState state) {
        try {
            this.threadLock();
            Object object = super.detachObjectCopy(state, pc);
            return object;
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void clearDirty(DNStateManager sm) {
        try {
            this.threadLock();
            super.clearDirty(sm);
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void clearDirty() {
        try {
            this.threadLock();
            super.clearDirty();
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void evictAllObjects() {
        this.assertIsOpen();
        try {
            this.threadLock();
            super.evictAllObjects();
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void markDirty(DNStateManager sm, boolean directUpdate) {
        try {
            this.threadLock();
            super.markDirty(sm, directUpdate);
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void flush() {
        try {
            this.threadLock();
            super.flush();
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void flushInternal(boolean flushToDatastore) {
        try {
            this.threadLock();
            super.flushInternal(flushToDatastore);
        }
        finally {
            this.threadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceObjectId(Persistable pc, Object oldID, Object newID) {
        try {
            this.threadLock();
            super.replaceObjectId(pc, oldID, newID);
        }
        finally {
            this.threadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extent getExtent(Class pcClass, boolean subclasses) {
        try {
            this.threadLock();
            Extent extent = super.getExtent(pcClass, subclasses);
            return extent;
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void evictObjects(Class cls, boolean subclasses) {
        try {
            this.threadLock();
            super.evictObjects(cls, subclasses);
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void refreshAllObjects() {
        try {
            this.threadLock();
            super.refreshAllObjects();
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public List<DNStateManager> getObjectsToBeFlushed() {
        try {
            this.threadLock();
            List<DNStateManager> list = super.getObjectsToBeFlushed();
            return list;
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void postBegin() {
        try {
            this.threadLock();
            super.postBegin();
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void preCommit() {
        try {
            this.threadLock();
            super.preCommit();
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void postCommit() {
        try {
            this.threadLock();
            super.postCommit();
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void preRollback() {
        try {
            this.threadLock();
            super.preRollback();
        }
        finally {
            this.threadUnlock();
        }
    }

    @Override
    public void postRollback() {
        try {
            this.threadLock();
            super.postRollback();
        }
        finally {
            this.threadUnlock();
        }
    }
}

