/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.transaction.jta;

import javax.transaction.TransactionManager;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.transaction.jta.AtomikosTransactionManagerLocator;
import org.datanucleus.transaction.jta.BTMTransactionManagerLocator;
import org.datanucleus.transaction.jta.CustomJNDITransactionManagerLocator;
import org.datanucleus.transaction.jta.JBossTransactionManagerLocator;
import org.datanucleus.transaction.jta.JOTMTransactionManagerLocator;
import org.datanucleus.transaction.jta.JOnASTransactionManagerLocator;
import org.datanucleus.transaction.jta.OC4JTransactionManagerLocator;
import org.datanucleus.transaction.jta.OrionTransactionManagerLocator;
import org.datanucleus.transaction.jta.ResinTransactionManagerLocator;
import org.datanucleus.transaction.jta.SAPWebASTransactionManagerLocator;
import org.datanucleus.transaction.jta.SunTransactionManagerLocator;
import org.datanucleus.transaction.jta.TransactionManagerLocator;
import org.datanucleus.transaction.jta.WebLogicTransactionManagerLocator;
import org.datanucleus.transaction.jta.WebSphereTransactionManagerLocator;

public class TransactionManagerFinder {
    NucleusContext nucleusContext;

    public TransactionManagerFinder(NucleusContext ctx) {
        this.nucleusContext = ctx;
    }

    public TransactionManager getTransactionManager(ClassLoaderResolver clr) {
        String jtaLocatorName = this.nucleusContext.getConfiguration().getStringProperty("datanucleus.transaction.jta.transactionmanagerlocator");
        PluginManager pluginMgr = this.nucleusContext.getPluginManager();
        if ("autodetect".equalsIgnoreCase(jtaLocatorName) || jtaLocatorName == null) {
            String[] builtinLocatorNames;
            for (String builtinLocatorName : builtinLocatorNames = new String[]{"jboss", "jonas", "jotm", "oc4j", "orion", "resin", "sap", "sun", "weblogic", "websphere", "custom_jndi", "atomikos", "bitronix"}) {
                try {
                    TransactionManager tm;
                    TransactionManagerLocator locator = this.getTransactionManagerLocatorForName(pluginMgr, builtinLocatorName);
                    if (locator == null || (tm = locator.getTransactionManager(clr)) == null) continue;
                    return tm;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String[] locatorNames = pluginMgr.getAttributeValuesForExtension("org.datanucleus.jta_locator", null, null, "name");
            if (locatorNames != null) {
                for (int i = 0; i < locatorNames.length; ++i) {
                    try {
                        TransactionManager tm;
                        TransactionManagerLocator locator = (TransactionManagerLocator)pluginMgr.createExecutableExtension("org.datanucleus.jta_locator", "name", locatorNames[i], "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.nucleusContext});
                        if (locator == null || (tm = locator.getTransactionManager(clr)) == null) continue;
                        return tm;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        } else {
            TransactionManagerLocator locator = this.getTransactionManagerLocatorForName(pluginMgr, jtaLocatorName);
            return locator.getTransactionManager(clr);
        }
        return null;
    }

    protected TransactionManagerLocator getTransactionManagerLocatorForName(PluginManager pluginMgr, String name) {
        if ("jboss".equalsIgnoreCase(name)) {
            return new JBossTransactionManagerLocator(this.nucleusContext);
        }
        if ("jonas".equalsIgnoreCase(name)) {
            return new JOnASTransactionManagerLocator(this.nucleusContext);
        }
        if ("jotm".equalsIgnoreCase(name)) {
            return new JOTMTransactionManagerLocator(this.nucleusContext);
        }
        if ("oc4j".equalsIgnoreCase(name)) {
            return new OC4JTransactionManagerLocator(this.nucleusContext);
        }
        if ("orion".equalsIgnoreCase(name)) {
            return new OrionTransactionManagerLocator(this.nucleusContext);
        }
        if ("resin".equalsIgnoreCase(name)) {
            return new ResinTransactionManagerLocator(this.nucleusContext);
        }
        if ("sap".equalsIgnoreCase(name)) {
            return new SAPWebASTransactionManagerLocator(this.nucleusContext);
        }
        if ("sun".equalsIgnoreCase(name)) {
            return new SunTransactionManagerLocator(this.nucleusContext);
        }
        if ("weblogic".equalsIgnoreCase(name)) {
            return new WebLogicTransactionManagerLocator(this.nucleusContext);
        }
        if ("websphere".equalsIgnoreCase(name)) {
            return new WebSphereTransactionManagerLocator(this.nucleusContext);
        }
        if ("custom_jndi".equalsIgnoreCase(name)) {
            return new CustomJNDITransactionManagerLocator(this.nucleusContext);
        }
        if ("atomikos".equalsIgnoreCase(name)) {
            return new AtomikosTransactionManagerLocator(this.nucleusContext);
        }
        if ("bitronix".equalsIgnoreCase(name)) {
            return new BTMTransactionManagerLocator(this.nucleusContext);
        }
        try {
            return (TransactionManagerLocator)pluginMgr.createExecutableExtension("org.datanucleus.jta_locator", "name", name, "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.nucleusContext});
        }
        catch (Exception e) {
            return null;
        }
    }
}

