/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.transaction;

import java.util.Collection;
import org.datanucleus.exceptions.TransactionIsolationNotSupportedException;
import org.datanucleus.store.StoreManager;

public class TransactionUtils {
    public static String getTransactionIsolationForStoreManager(StoreManager storeMgr, String transactionIsolation) {
        Collection<String> supportedOptions;
        if (transactionIsolation != null && !(supportedOptions = storeMgr.getSupportedOptions()).contains("TransactionIsolationLevel." + transactionIsolation)) {
            if (transactionIsolation.equals("read-uncommitted")) {
                if (supportedOptions.contains("TransactionIsolationLevel.read-committed")) {
                    return "read-committed";
                }
                if (supportedOptions.contains("TransactionIsolationLevel.repeatable-read")) {
                    return "repeatable-read";
                }
                if (supportedOptions.contains("TransactionIsolationLevel.serializable")) {
                    return "serializable";
                }
            } else if (transactionIsolation.equals("read-committed")) {
                if (supportedOptions.contains("TransactionIsolationLevel.repeatable-read")) {
                    return "repeatable-read";
                }
                if (supportedOptions.contains("TransactionIsolationLevel.serializable")) {
                    return "serializable";
                }
            } else if (transactionIsolation.equals("repeatable-read")) {
                if (supportedOptions.contains("TransactionIsolationLevel.serializable")) {
                    return "serializable";
                }
            } else {
                throw new TransactionIsolationNotSupportedException(transactionIsolation);
            }
        }
        return transactionIsolation;
    }

    public static String getNameForTransactionIsolationLevel(int isolation) {
        if (isolation == 0) {
            return "none";
        }
        if (isolation == 2) {
            return "read-committed";
        }
        if (isolation == 1) {
            return "read-uncommitted";
        }
        if (isolation == 4) {
            return "repeatable-read";
        }
        if (isolation == 8) {
            return "serializable";
        }
        return "UNKNOWN";
    }

    public static int getTransactionIsolationLevelForName(String isolationName) {
        if (isolationName.equalsIgnoreCase("none")) {
            return 0;
        }
        if (isolationName.equalsIgnoreCase("read-committed")) {
            return 2;
        }
        if (isolationName.equalsIgnoreCase("read-uncommitted")) {
            return 1;
        }
        if (isolationName.equalsIgnoreCase("repeatable-read")) {
            return 4;
        }
        if (isolationName.equalsIgnoreCase("serializable")) {
            return 8;
        }
        return -1;
    }
}

