/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.datanucleus.FetchPlanState;
import org.datanucleus.flush.CollectionAddOperation;
import org.datanucleus.flush.CollectionRemoveOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.types.SCOCollection;
import org.datanucleus.store.types.SCOCollectionIterator;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class SortedSet<E>
extends AbstractSet<E>
implements java.util.SortedSet<E>,
SCOCollection<java.util.SortedSet<E>, E>,
Cloneable,
Serializable {
    protected transient DNStateManager ownerSM;
    protected transient AbstractMemberMetaData ownerMmd;
    protected java.util.SortedSet<E> delegate;

    public SortedSet(DNStateManager sm, AbstractMemberMetaData mmd) {
        this.ownerSM = sm;
        this.ownerMmd = mmd;
    }

    @Override
    public void initialise(java.util.SortedSet<E> newValue, Object oldValue) {
        this.initialise(newValue);
    }

    @Override
    public void initialise(java.util.SortedSet c) {
        if (c != null) {
            this.initialiseDelegate();
            this.delegate.addAll(c);
        } else {
            this.initialiseDelegate();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("023003", this.getClass().getName(), this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName(), "" + this.size(), SCOUtils.getSCOWrapperOptionsMessage(true, false, true, false)));
        }
    }

    @Override
    public void initialise() {
        this.initialise(null);
    }

    protected void initialiseDelegate() {
        Comparator comparator = SCOUtils.getComparator(this.ownerMmd, this.ownerSM.getExecutionContext().getClassLoaderResolver());
        this.delegate = comparator != null ? new TreeSet(comparator) : new TreeSet();
    }

    @Override
    public java.util.SortedSet<E> getValue() {
        return this.delegate;
    }

    @Override
    public void setValue(java.util.SortedSet<E> value) {
        this.delegate = value;
    }

    @Override
    public void load() {
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public void updateEmbeddedElement(E element, int fieldNumber, Object value, boolean makeDirty) {
        if (makeDirty) {
            this.makeDirty();
        }
    }

    @Override
    public String getFieldName() {
        return this.ownerMmd.getName();
    }

    @Override
    public Object getOwner() {
        return this.ownerSM != null ? this.ownerSM.getObject() : null;
    }

    @Override
    public void unsetOwner() {
        if (this.ownerSM != null) {
            this.ownerSM = null;
            this.ownerMmd = null;
        }
    }

    public void makeDirty() {
        if (this.ownerSM != null) {
            this.ownerSM.makeDirty(this.ownerMmd.getAbsoluteFieldNumber());
        }
    }

    @Override
    public java.util.SortedSet detachCopy(FetchPlanState state) {
        Comparator comparator = SCOUtils.getComparator(this.ownerMmd, this.ownerSM.getExecutionContext().getClassLoaderResolver());
        TreeSet detached = null;
        detached = comparator != null ? new TreeSet(comparator) : new TreeSet();
        SCOUtils.detachCopyForCollection(this.ownerSM.getExecutionContext(), this.toArray(), state, detached);
        return detached;
    }

    @Override
    public void attachCopy(java.util.SortedSet value) {
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(this.ownerMmd);
        SCOUtils.attachCopyElements(this.ownerSM, this, value, elementsWithoutIdentity);
    }

    @Override
    public Object clone() {
        return ((TreeSet)this.delegate).clone();
    }

    @Override
    public Comparator comparator() {
        return this.delegate.comparator();
    }

    @Override
    public boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public E first() {
        return this.delegate.first();
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return new SCOCollectionIterator<E>(this, this.ownerSM, this.delegate, null, true);
    }

    @Override
    public java.util.SortedSet<E> headSet(E toElement) {
        return this.delegate.headSet(toElement);
    }

    @Override
    public java.util.SortedSet<E> subSet(E fromElement, E toElement) {
        return this.delegate.subSet(fromElement, toElement);
    }

    @Override
    public java.util.SortedSet<E> tailSet(E fromElement) {
        return this.delegate.headSet(fromElement);
    }

    @Override
    public E last() {
        return this.delegate.last();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(E element) {
        boolean success = this.delegate.add(element);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM).relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (success) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionAddOperation<E>(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), element));
            }
            this.makeDirty();
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public boolean addAll(Collection elements) {
        boolean success = this.delegate.addAll(elements);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            for (Object elem : elements) {
                this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM).relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), elem);
            }
        }
        if (success) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                for (Object elem : elements) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), elem));
                }
            }
            this.makeDirty();
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public void clear() {
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
            for (Object elem : this.delegate) {
                relMgr.relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), elem);
            }
        }
        if (this.ownerSM != null && !this.delegate.isEmpty()) {
            Iterator iter;
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                iter = this.delegate.iterator();
                while (iter.hasNext()) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), iter.next(), true));
                }
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                iter = this.delegate.iterator();
                while (iter.hasNext()) {
                    this.ownerSM.getExecutionContext().deleteObjectInternal(iter.next());
                }
            }
        }
        this.delegate.clear();
        this.makeDirty();
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public boolean remove(Object element) {
        return this.remove(element, true);
    }

    @Override
    public boolean remove(Object element, boolean allowCascadeDelete) {
        boolean success = this.delegate.remove(element);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM).relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (this.ownerSM != null && allowCascadeDelete) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation<Object>(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), element, allowCascadeDelete));
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                this.ownerSM.getExecutionContext().deleteObjectInternal(element);
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public boolean removeAll(Collection elements) {
        if (elements == null) {
            throw new NullPointerException();
        }
        if (elements.isEmpty()) {
            return true;
        }
        boolean success = this.delegate.removeAll(elements);
        if (this.ownerSM != null) {
            if (this.ownerSM.getExecutionContext().getManageRelations()) {
                RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
                for (Object elem : elements) {
                    relMgr.relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), elem);
                }
            }
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                for (Object elem : elements) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), elem, true));
                }
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                for (Object elem : elements) {
                    this.ownerSM.getExecutionContext().deleteObjectInternal(elem);
                }
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public boolean retainAll(Collection c) {
        if (c == null) {
            throw new NullPointerException("Input collection was null");
        }
        TreeSet collToRemove = new TreeSet();
        for (Object o : this.delegate) {
            if (c.contains(o)) continue;
            collToRemove.add(o);
        }
        boolean success = this.delegate.retainAll(c);
        if (success) {
            this.makeDirty();
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                for (Object elem : collToRemove) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), elem, true));
                }
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                for (Object elem : collToRemove) {
                    this.ownerSM.getExecutionContext().deleteObjectInternal(elem);
                }
            }
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new TreeSet<E>(this.delegate);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.delegate.forEach(action);
    }

    @Override
    public Stream stream() {
        return this.delegate.stream();
    }

    @Override
    public Stream parallelStream() {
        return this.delegate.parallelStream();
    }

    @Override
    public Spliterator spliterator() {
        return this.delegate.spliterator();
    }
}

