/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.ColumnLengthDefiningTypeConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class LocalDateTimeStringConverter
implements TypeConverter<LocalDateTime, String>,
ColumnLengthDefiningTypeConverter {
    private static final long serialVersionUID = 8882755544573190247L;

    @Override
    public LocalDateTime toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return LocalDateTime.parse(str);
        }
        catch (DateTimeParseException pe) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, LocalDateTime.class.getName()), pe);
        }
    }

    @Override
    public String toDatastoreType(LocalDateTime date) {
        return date != null ? date.toString() : null;
    }

    @Override
    public int getDefaultColumnLength(int columnPosition) {
        if (columnPosition != 0) {
            return -1;
        }
        return 19;
    }
}

