/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.ForeignKeyAction;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.IndexedValue;
import org.datanucleus.metadata.InvalidMemberMetaDataException;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.ValueGenerationStrategy;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractMemberMetaData
extends MetaData
implements Comparable,
ColumnMetaDataContainer {
    private static final long serialVersionUID = -7689828287704042919L;
    public static final boolean PERSIST_STATIC = false;
    public static final boolean PERSIST_FINAL = false;
    public static final boolean PERSIST_TRANSIENT = false;
    protected ColumnMetaData[] columnMetaData;
    protected ContainerMetaData containerMetaData;
    protected EmbeddedMetaData embeddedMetaData;
    protected JoinMetaData joinMetaData;
    protected ElementMetaData elementMetaData;
    protected KeyMetaData keyMetaData;
    protected ValueMetaData valueMetaData;
    protected IndexMetaData indexMetaData;
    protected IndexedValue indexed = null;
    protected UniqueMetaData uniqueMetaData;
    protected boolean uniqueConstraint = false;
    protected OrderMetaData orderMetaData;
    protected ForeignKeyMetaData foreignKeyMetaData;
    protected Boolean defaultFetchGroup;
    protected String column;
    protected String mappedBy;
    protected Boolean embedded;
    protected Boolean serialized;
    protected boolean cacheable = true;
    protected Boolean dependent;
    protected Boolean cascadePersist;
    protected Boolean cascadeDelete;
    protected Boolean cascadeAttach;
    protected Boolean cascadeDetach;
    protected Boolean cascadeRefresh;
    protected boolean cascadeRemoveOrphans = false;
    protected String loadFetchGroup;
    protected Integer recursionDepth = null;
    protected final String name;
    protected NullValue nullValue = NullValue.NONE;
    protected FieldPersistenceModifier persistenceModifier = FieldPersistenceModifier.DEFAULT;
    protected Boolean primaryKey;
    protected String table;
    protected String catalog;
    protected String schema;
    protected ValueGenerationStrategy valueStrategy;
    protected String valueGeneratorName;
    protected String sequence;
    protected String className = null;
    protected String fullFieldName = null;
    protected Class type;
    protected Member memberRepresented;
    protected int fieldId = -1;
    protected RelationType relationType = null;
    protected AbstractMemberMetaData[] relatedMemberMetaData = null;
    protected boolean ordered = false;
    protected List<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
    protected String targetClassName = null;
    protected boolean storeInLob = false;
    protected String mapsIdAttribute = null;
    protected String relationTypeString = null;
    protected byte persistenceFlags;
    public static final String EXTENSION_MEMBER_FETCH_FK_ONLY = "fetch-fk-only";

    public AbstractMemberMetaData(MetaData parent, AbstractMemberMetaData mmd) {
        super(parent, mmd);
        this.name = mmd.name;
        this.primaryKey = mmd.primaryKey;
        this.defaultFetchGroup = mmd.defaultFetchGroup;
        this.column = mmd.column;
        this.mappedBy = mmd.mappedBy;
        this.dependent = mmd.dependent;
        this.embedded = mmd.embedded;
        this.serialized = mmd.serialized;
        this.cascadePersist = mmd.cascadePersist;
        this.cascadeAttach = mmd.cascadeAttach;
        this.cascadeDelete = mmd.cascadeDelete;
        this.cascadeDetach = mmd.cascadeDetach;
        this.cascadeRefresh = mmd.cascadeRefresh;
        this.nullValue = mmd.nullValue;
        this.persistenceModifier = mmd.persistenceModifier;
        this.table = mmd.table;
        this.indexed = mmd.indexed;
        this.valueStrategy = mmd.valueStrategy;
        this.valueGeneratorName = mmd.valueGeneratorName;
        this.sequence = mmd.sequence;
        this.uniqueConstraint = mmd.uniqueConstraint;
        this.loadFetchGroup = mmd.loadFetchGroup;
        this.storeInLob = mmd.storeInLob;
        this.mapsIdAttribute = mmd.mapsIdAttribute;
        this.relationTypeString = mmd.relationTypeString;
        this.column = mmd.column;
        if (mmd.joinMetaData != null) {
            this.setJoinMetaData(new JoinMetaData(mmd.joinMetaData));
        }
        if (mmd.elementMetaData != null) {
            this.setElementMetaData(new ElementMetaData(mmd.elementMetaData));
        }
        if (mmd.keyMetaData != null) {
            this.setKeyMetaData(new KeyMetaData(mmd.keyMetaData));
        }
        if (mmd.valueMetaData != null) {
            this.setValueMetaData(new ValueMetaData(mmd.valueMetaData));
        }
        if (mmd.orderMetaData != null) {
            this.setOrderMetaData(new OrderMetaData(mmd.orderMetaData));
        }
        if (mmd.indexMetaData != null) {
            this.setIndexMetaData(new IndexMetaData(mmd.indexMetaData));
        }
        if (mmd.uniqueMetaData != null) {
            this.setUniqueMetaData(new UniqueMetaData(mmd.uniqueMetaData));
        }
        if (mmd.foreignKeyMetaData != null) {
            this.setForeignKeyMetaData(new ForeignKeyMetaData(mmd.foreignKeyMetaData));
        }
        if (mmd.embeddedMetaData != null) {
            this.setEmbeddedMetaData(new EmbeddedMetaData(mmd.embeddedMetaData));
        }
        if (mmd.containerMetaData != null) {
            if (mmd.containerMetaData instanceof CollectionMetaData) {
                this.setContainer(new CollectionMetaData((CollectionMetaData)mmd.containerMetaData));
            } else if (mmd.containerMetaData instanceof MapMetaData) {
                this.setContainer(new MapMetaData((MapMetaData)mmd.containerMetaData));
            } else if (mmd.containerMetaData instanceof ArrayMetaData) {
                this.setContainer(new ArrayMetaData((ArrayMetaData)mmd.containerMetaData));
            }
        }
        for (int i = 0; i < mmd.columns.size(); ++i) {
            this.addColumn(new ColumnMetaData(mmd.columns.get(i)));
        }
    }

    public AbstractMemberMetaData(MetaData parent, String name) {
        super(parent);
        if (name == null) {
            throw new NucleusUserException(Localiser.msg("044041", "name", this.getClassName(true), "field"));
        }
        if (name.indexOf(46) >= 0) {
            this.className = name.substring(0, name.lastIndexOf(46));
            this.name = name.substring(name.lastIndexOf(46) + 1);
        } else {
            this.name = name;
        }
    }

    public synchronized void populate(ClassLoaderResolver clr, Field field, Method method, ClassLoader primary, MetaDataManager mmgr) {
        AbstractClassMetaData memberCmd;
        TypeManager typeMgr;
        Object containerHandler;
        if (this.isPopulated() || this.isInitialised()) {
            return;
        }
        ApiAdapter apiAdapter = mmgr.getNucleusContext().getApiAdapter();
        if (this.cascadePersist == null) {
            this.cascadePersist = apiAdapter.getDefaultCascadePersistForField();
        }
        if (this.cascadeAttach == null) {
            this.cascadeAttach = apiAdapter.getDefaultCascadeAttachForField();
        }
        if (this.cascadeDelete == null) {
            this.cascadeDelete = apiAdapter.getDefaultCascadeDeleteForField();
        }
        if (this.cascadeDetach == null) {
            this.cascadeDetach = apiAdapter.getDefaultCascadeDetachForField();
        }
        if (this.cascadeRefresh == null) {
            this.cascadeRefresh = apiAdapter.getDefaultCascadeRefreshForField();
        }
        if (field == null && method == null) {
            NucleusLogger.METADATA.error(Localiser.msg("044106", this.getClassName(), this.getName()));
            throw new InvalidMemberMetaDataException("044106", this.getClassName(), this.getName());
        }
        if (clr == null) {
            NucleusLogger.METADATA.warn(Localiser.msg("044067", this.name, this.getClassName(true)));
            clr = mmgr.getNucleusContext().getClassLoaderResolver(null);
        }
        Member member = this.memberRepresented = field != null ? field : method;
        if (this.type == null) {
            if (field != null) {
                this.type = field.getType();
            } else if (method != null) {
                this.type = method.getReturnType();
            }
        }
        if (this.className != null) {
            Class thisClass = null;
            if (this.parent instanceof EmbeddedMetaData) {
                MetaData superMd = this.parent.getParent();
                thisClass = ((AbstractMemberMetaData)superMd).getType();
            } else {
                try {
                    thisClass = clr.classForName(this.getAbstractClassMetaData().getPackageName() + "." + this.getAbstractClassMetaData().getName());
                }
                catch (ClassNotResolvedException superMd) {
                    // empty catch block
                }
            }
            Class fieldClass = null;
            try {
                fieldClass = clr.classForName(this.className);
            }
            catch (ClassNotResolvedException cnre) {
                try {
                    fieldClass = clr.classForName(this.getAbstractClassMetaData().getPackageName() + "." + this.className);
                    this.className = this.getAbstractClassMetaData().getPackageName() + "." + this.className;
                }
                catch (ClassNotResolvedException cnre2) {
                    NucleusLogger.METADATA.error(Localiser.msg("044113", this.getClassName(), this.getName(), this.className));
                    InvalidMemberMetaDataException ne = new InvalidMemberMetaDataException("044113", this.getClassName(), this.getName(), this.className);
                    ne.setNestedException(cnre);
                    throw ne;
                }
            }
            if (fieldClass != null && !fieldClass.isAssignableFrom(thisClass)) {
                NucleusLogger.METADATA.error(Localiser.msg("044114", this.getClassName(), this.getName(), this.className));
                throw new InvalidMemberMetaDataException("044114", this.getClassName(), this.getName(), this.className);
            }
        }
        if (this.primaryKey == null) {
            this.primaryKey = Boolean.FALSE;
        }
        if (this.primaryKey == Boolean.FALSE && this.embedded == null) {
            Class<?> element_type = this.getType();
            if (element_type.isArray()) {
                element_type = element_type.getComponentType();
                if (mmgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(element_type)) {
                    this.embedded = Boolean.TRUE;
                }
            } else if (mmgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(element_type)) {
                this.embedded = Boolean.TRUE;
            }
        }
        if (this.embedded == null) {
            this.embedded = Boolean.FALSE;
        }
        if (FieldPersistenceModifier.DEFAULT.equals((Object)this.persistenceModifier)) {
            if (this.getTypeConverterName() != null) {
                this.persistenceModifier = FieldPersistenceModifier.PERSISTENT;
            } else {
                TypeConverter autoApplyTypeConv = mmgr.getNucleusContext().getTypeManager().getAutoApplyTypeConverterForType(this.getType());
                if (autoApplyTypeConv != null && !this.isTypeConversionDisabled()) {
                    this.persistenceModifier = FieldPersistenceModifier.PERSISTENT;
                } else {
                    boolean isPcClass;
                    boolean bl = isPcClass = this.getType().isArray() ? this.isFieldArrayTypePersistable(mmgr) : mmgr.isFieldTypePersistable(this.type);
                    if (!isPcClass) {
                        if (this.getType().isArray() && this.getType().getComponentType().isInterface()) {
                            isPcClass = mmgr.getMetaDataForClassInternal(this.getType().getComponentType(), clr) != null;
                        } else if (this.getType().isInterface()) {
                            isPcClass = mmgr.getMetaDataForClassInternal(this.getType(), clr) != null;
                        }
                    }
                    this.persistenceModifier = this.getDefaultFieldPersistenceModifier(this.getType(), this.memberRepresented.getModifiers(), isPcClass, mmgr);
                }
            }
        }
        if ((containerHandler = (typeMgr = mmgr.getNucleusContext().getTypeManager()).getContainerHandler(this.type)) == null) {
            if (this.hasContainer()) {
                NucleusLogger.METADATA.error(Localiser.msg("044212", this.getClassName(), this.getName(), this.type));
                InvalidMemberMetaDataException ne = new InvalidMemberMetaDataException("044212", this.getClassName(), this.getName(), this.type);
                throw ne;
            }
        } else {
            if (!this.hasContainer()) {
                this.setContainer((ContainerMetaData)containerHandler.newMetaData());
            }
            containerHandler.populateMetaData(clr, primary, this);
        }
        if (this.defaultFetchGroup == null) {
            if (this.persistenceModifier.equals((Object)FieldPersistenceModifier.NONE) || this.persistenceModifier.equals((Object)FieldPersistenceModifier.TRANSACTIONAL)) {
                this.defaultFetchGroup = Boolean.FALSE;
            } else {
                this.defaultFetchGroup = Boolean.FALSE;
                if (!this.primaryKey.equals(Boolean.TRUE)) {
                    if (this.hasContainer() && containerHandler != null) {
                        this.defaultFetchGroup = containerHandler.isDefaultFetchGroup(clr, typeMgr, this);
                    } else if (typeMgr.isDefaultFetchGroup(this.getType())) {
                        this.defaultFetchGroup = Boolean.TRUE;
                    }
                }
            }
        }
        if ((this.persistenceModifier.equals((Object)FieldPersistenceModifier.TRANSACTIONAL) || this.persistenceModifier.equals((Object)FieldPersistenceModifier.NONE)) && (this.defaultFetchGroup == Boolean.TRUE || this.primaryKey == Boolean.TRUE)) {
            throw new InvalidMemberMetaDataException("044109", this.getClassName(), this.name, this.getType().getName(), this.persistenceModifier.toString());
        }
        if (this.storeInLob) {
            boolean useClob = false;
            if (this.type == String.class || this.type.isArray() && this.type.getComponentType() == Character.class || this.type.isArray() && this.type.getComponentType() == Character.TYPE) {
                ColumnMetaData colmd;
                useClob = true;
                if (this.columns == null || this.columns.isEmpty()) {
                    colmd = new ColumnMetaData();
                    colmd.setName(this.column);
                    colmd.setJdbcType("CLOB");
                    this.addColumn(colmd);
                } else {
                    colmd = this.columns.get(0);
                    colmd.setJdbcType("CLOB");
                }
            }
            if (!useClob) {
                this.serialized = Boolean.TRUE;
            }
        }
        if (!mmgr.isDefaultNullable() && !this.hasContainer()) {
            ColumnMetaData colMmd;
            if (this.columns == null || this.columns.isEmpty()) {
                this.newColumnMetaData();
            }
            if ((colMmd = this.getColumnMetaData()[0]).getAllowsNull() == null) {
                colMmd.setAllowsNull(Boolean.FALSE);
            }
        }
        if (this.containerMetaData != null && this.dependent != null) {
            NucleusLogger.METADATA.error(Localiser.msg("044110", this.getClassName(), this.getName(), ((ClassMetaData)this.parent).getName()));
            throw new InvalidMemberMetaDataException("044110", this.getClassName(), this.getName(), ((ClassMetaData)this.parent).getName());
        }
        if (this.embedded == Boolean.TRUE && this.embeddedMetaData == null && (memberCmd = mmgr.getMetaDataForClassInternal(this.getType(), clr)) != null) {
            this.embeddedMetaData = new EmbeddedMetaData();
            this.embeddedMetaData.setParent(this);
        }
        if (this.embeddedMetaData != null) {
            if (this.hasExtension("null-indicator-column")) {
                this.embeddedMetaData.setNullIndicatorColumn(this.getValueForExtension("null-indicator-column"));
                if (this.hasExtension("null-indicator-value")) {
                    this.embeddedMetaData.setNullIndicatorValue(this.getValueForExtension("null-indicator-value"));
                }
            }
            this.embeddedMetaData.populate(clr, primary);
            this.embedded = Boolean.TRUE;
        }
        if (this.containerMetaData == null || this.persistenceModifier != FieldPersistenceModifier.PERSISTENT || this.containerMetaData instanceof CollectionMetaData || this.containerMetaData instanceof MapMetaData || this.containerMetaData instanceof ArrayMetaData) {
            // empty if block
        }
        if (mmgr.isFieldTypePersistable(this.type) && this.cascadeDelete.booleanValue()) {
            this.setDependent(true);
        }
        if (this.hasExtension("implementation-classes")) {
            StringBuilder str = new StringBuilder();
            String[] implTypes = this.getValuesForExtension("implementation-classes");
            for (int i = 0; i < implTypes.length; ++i) {
                String implTypeName = ClassUtils.createFullClassName(this.getAbstractClassMetaData().getPackageName(), implTypes[i]);
                if (i > 0) {
                    str.append(",");
                }
                try {
                    clr.classForName(implTypeName);
                    str.append(implTypeName);
                    continue;
                }
                catch (ClassNotResolvedException cnre) {
                    try {
                        String langClassName = ClassUtils.getJavaLangClassForType(implTypeName);
                        clr.classForName(langClassName);
                        str.append(langClassName);
                        continue;
                    }
                    catch (ClassNotResolvedException cnre2) {
                        throw new InvalidMemberMetaDataException("044116", this.getClassName(), this.getName(), implTypes[i]);
                    }
                }
            }
            this.addExtension("implementation-classes", str.toString());
        }
        int serializable = 0;
        if (Serializable.class.isAssignableFrom(this.getType()) || this.getType().isPrimitive()) {
            serializable = 16;
        }
        this.persistenceFlags = FieldPersistenceModifier.NONE.equals((Object)this.persistenceModifier) ? (byte)0 : (FieldPersistenceModifier.TRANSACTIONAL.equals((Object)this.persistenceModifier) && Modifier.isTransient(this.memberRepresented.getModifiers()) ? (byte)(4 | serializable) : (this.primaryKey != false ? (byte)(8 | serializable) : (this.defaultFetchGroup != false ? (byte)(5 | serializable) : (this.defaultFetchGroup == false ? (byte)(0xA | serializable) : (byte)0))));
        if (this.persistenceModifier != FieldPersistenceModifier.PERSISTENT) {
            this.relationType = RelationType.NONE;
        } else if (!(this.containerMetaData != null || mmgr.isFieldTypePersistable(this.type) || this.type.getName().equals(ClassNameConstants.Object) || this.type.isInterface())) {
            this.relationType = RelationType.NONE;
        }
        if (this.serialized == Boolean.TRUE && this.hasExtension("type-converter-name")) {
            NucleusLogger.METADATA.warn(Localiser.msg("044127", this.getClassName(), this.getName(), this.getValueForExtension("type-converter-name")));
            this.serialized = Boolean.FALSE;
        }
        this.setPopulated();
    }

    public String getPackageName() {
        String theClassName = this.className != null ? this.className : this.getClassName();
        return theClassName.substring(0, theClassName.lastIndexOf(46));
    }

    public final FieldPersistenceModifier getDefaultFieldPersistenceModifier(Class c, int modifier, boolean isPCclass, MetaDataManager mmgr) {
        if (Modifier.isFinal(modifier) && this instanceof FieldMetaData) {
            return FieldPersistenceModifier.NONE;
        }
        if (Modifier.isStatic(modifier)) {
            return FieldPersistenceModifier.NONE;
        }
        if (Modifier.isTransient(modifier)) {
            return FieldPersistenceModifier.NONE;
        }
        if (isPCclass) {
            return FieldPersistenceModifier.PERSISTENT;
        }
        if (c == null) {
            throw new NucleusException("class is null");
        }
        if (c.isArray() && mmgr.getNucleusContext().getApiAdapter().isPersistable(c.getComponentType())) {
            return FieldPersistenceModifier.PERSISTENT;
        }
        if (mmgr.getNucleusContext().getTypeManager().isDefaultPersistent(c)) {
            return FieldPersistenceModifier.PERSISTENT;
        }
        return FieldPersistenceModifier.NONE;
    }

    @Override
    public synchronized void initialise(ClassLoaderResolver clr) {
        int i;
        if (this.persistenceModifier == FieldPersistenceModifier.NONE) {
            this.setInitialised();
            return;
        }
        if (this.columns.isEmpty() && this.column != null) {
            this.columnMetaData = new ColumnMetaData[1];
            this.columnMetaData[0] = new ColumnMetaData();
            this.columnMetaData[0].setName(this.column);
            this.columnMetaData[0].parent = this;
            this.columnMetaData[0].initialise(clr);
        } else if (this.columns.size() == 1 && this.column != null) {
            this.columnMetaData = new ColumnMetaData[1];
            this.columnMetaData[0] = this.columns.get(0);
            if (this.columnMetaData[0].getName() == null) {
                this.columnMetaData[0].setName(this.column);
            }
            this.columnMetaData[0].initialise(clr);
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = this.columns.get(i);
                this.columnMetaData[i].initialise(clr);
            }
        }
        if (this.containerMetaData != null) {
            this.containerMetaData.initialise(clr);
            if (this.containerMetaData instanceof CollectionMetaData) {
                CollectionMetaData collmd = (CollectionMetaData)this.containerMetaData;
                if (collmd.element.classMetaData != null) {
                    if (collmd.element.classMetaData.isEmbeddedOnly()) {
                        if (this.elementMetaData == null) {
                            this.elementMetaData = new ElementMetaData();
                            this.elementMetaData.parent = this;
                            this.elementMetaData.populate(clr, null);
                        }
                        collmd.setEmbeddedElement(true);
                    }
                    if (this.embedded == Boolean.TRUE) {
                        collmd.setEmbeddedElement(true);
                        this.embedded = null;
                        this.embeddedMetaData = null;
                    }
                }
            } else if (this.containerMetaData instanceof ArrayMetaData) {
                ArrayMetaData arrmd = (ArrayMetaData)this.containerMetaData;
                if (arrmd.element.classMetaData != null) {
                    if (arrmd.element.classMetaData.isEmbeddedOnly()) {
                        if (this.elementMetaData == null) {
                            this.elementMetaData = new ElementMetaData();
                            this.elementMetaData.parent = this;
                            this.elementMetaData.populate(clr, null);
                        }
                        arrmd.setEmbeddedElement(true);
                    }
                    if (this.embedded == Boolean.TRUE) {
                        arrmd.setEmbeddedElement(true);
                        this.embedded = null;
                        this.embeddedMetaData = null;
                    }
                }
            } else if (this.containerMetaData instanceof MapMetaData) {
                MapMetaData mapmd = (MapMetaData)this.containerMetaData;
                if (mapmd.key.classMetaData != null && mapmd.key.classMetaData.isEmbeddedOnly()) {
                    if (this.keyMetaData == null) {
                        this.keyMetaData = new KeyMetaData();
                        this.keyMetaData.parent = this;
                        this.keyMetaData.populate(clr, null);
                    }
                    mapmd.setEmbeddedKey(true);
                }
                if (mapmd.value.classMetaData != null && mapmd.value.classMetaData.isEmbeddedOnly()) {
                    if (this.valueMetaData == null) {
                        this.valueMetaData = new ValueMetaData();
                        this.valueMetaData.parent = this;
                        this.valueMetaData.populate(clr, null);
                    }
                    mapmd.setEmbeddedValue(true);
                }
            }
        }
        if (this.embeddedMetaData != null) {
            this.embeddedMetaData.initialise(clr);
        }
        if (this.joinMetaData != null) {
            this.joinMetaData.initialise(clr);
        }
        if (this.elementMetaData != null) {
            this.elementMetaData.initialise(clr);
        }
        if (this.keyMetaData != null) {
            this.keyMetaData.initialise(clr);
        }
        if (this.valueMetaData != null) {
            this.valueMetaData.initialise(clr);
        }
        if (this.indexMetaData == null && this.columnMetaData != null && this.indexed != null && this.indexed != IndexedValue.FALSE) {
            this.indexMetaData = new IndexMetaData();
            this.indexMetaData.setUnique(this.indexed == IndexedValue.UNIQUE);
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.indexMetaData.addColumn(this.columnMetaData[i].getName());
            }
        } else if (this.indexed == IndexedValue.TRUE && this.indexMetaData != null) {
            this.indexMetaData = null;
        }
        if (this.uniqueMetaData == null && this.uniqueConstraint && this.joinMetaData == null) {
            this.uniqueMetaData = new UniqueMetaData();
            this.uniqueMetaData.setTable(this.column);
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.uniqueMetaData.addColumn(this.columnMetaData[i].getName());
            }
        }
        if (this.orderMetaData != null) {
            this.orderMetaData.initialise(clr);
        }
        if (this.hasExtension("cascade-persist")) {
            String cascadeValue = this.getValueForExtension("cascade-persist");
            if (cascadeValue.equalsIgnoreCase("true")) {
                this.cascadePersist = true;
            } else if (cascadeValue.equalsIgnoreCase("false")) {
                this.cascadePersist = false;
            }
        }
        if (this.hasExtension("cascade-attach")) {
            String cascadeValue = this.getValueForExtension("cascade-attach");
            if (cascadeValue.equalsIgnoreCase("true")) {
                this.cascadeAttach = true;
            } else if (cascadeValue.equalsIgnoreCase("false")) {
                this.cascadeAttach = false;
            }
        }
        if (this.hasExtension("cascade-detach")) {
            String cascadeValue = this.getValueForExtension("cascade-detach");
            if (cascadeValue.equalsIgnoreCase("true")) {
                this.cascadeDetach = true;
            } else if (cascadeValue.equalsIgnoreCase("false")) {
                this.cascadeDetach = false;
            }
        }
        if (this.hasExtension("cascade-refresh")) {
            String cascadeValue = this.getValueForExtension("cascade-refresh");
            if (cascadeValue.equalsIgnoreCase("true")) {
                this.cascadeRefresh = true;
            } else if (cascadeValue.equalsIgnoreCase("false")) {
                this.cascadeRefresh = false;
            }
        }
        this.setInitialised();
    }

    public boolean isFieldArrayTypePersistable(MetaDataManager mmgr) {
        AbstractClassMetaData cmd;
        if (!this.type.isArray()) {
            return false;
        }
        if (mmgr.isEnhancing() && (cmd = mmgr.readMetaDataForClass(this.type.getComponentType().getName())) != null && cmd instanceof ClassMetaData && cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            return true;
        }
        return mmgr.getNucleusContext().getApiAdapter().isPersistable(this.type.getComponentType());
    }

    public boolean isStatic() {
        if (!this.isPopulated() || this.memberRepresented == null) {
            return false;
        }
        return Modifier.isStatic(this.memberRepresented.getModifiers());
    }

    public boolean isFinal() {
        if (!this.isPopulated() || this.memberRepresented == null) {
            return false;
        }
        return Modifier.isFinal(this.memberRepresented.getModifiers());
    }

    public boolean isTransient() {
        if (!this.isPopulated() || this.memberRepresented == null) {
            return false;
        }
        return Modifier.isTransient(this.memberRepresented.getModifiers());
    }

    public boolean isPublic() {
        if (!this.isPopulated() || this.memberRepresented == null) {
            return false;
        }
        return Modifier.isPublic(this.memberRepresented.getModifiers());
    }

    public boolean isProtected() {
        if (!this.isPopulated() || this.memberRepresented == null) {
            return false;
        }
        return Modifier.isProtected(this.memberRepresented.getModifiers());
    }

    public boolean isPrivate() {
        if (!this.isPopulated() || this.memberRepresented == null) {
            return false;
        }
        return Modifier.isPrivate(this.memberRepresented.getModifiers());
    }

    public boolean isAbstract() {
        if (!this.isPopulated() || this.memberRepresented == null) {
            return false;
        }
        return Modifier.isAbstract(this.memberRepresented.getModifiers());
    }

    public ValueGenerationStrategy getValueStrategy() {
        return this.valueStrategy;
    }

    public void setValueStrategy(ValueGenerationStrategy valueStrategy) {
        this.valueStrategy = valueStrategy;
    }

    public void setValueStrategy(String strategy) {
        this.valueStrategy = strategy == null ? null : ValueGenerationStrategy.getIdentityStrategy(strategy);
    }

    public String getValueGeneratorName() {
        return this.valueGeneratorName;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = StringUtils.isWhitespace(sequence) ? null : sequence;
    }

    public boolean isCacheable() {
        if (this.hasExtension("cacheable")) {
            return !this.getValueForExtension("cacheable").equalsIgnoreCase("false");
        }
        return this.cacheable;
    }

    public void setCacheable(boolean cache) {
        this.cacheable = cache;
    }

    public String getLoadFetchGroup() {
        return this.loadFetchGroup;
    }

    public void setLoadFetchGroup(String loadFetchGroup) {
        if (!StringUtils.isWhitespace(loadFetchGroup)) {
            NucleusLogger.METADATA.warn("Metadata attribute 'load-fetch-group' is not currently utilised");
            this.loadFetchGroup = loadFetchGroup;
        }
    }

    public String getTypeConverterName() {
        if (this.hasExtension("type-converter-name")) {
            return this.getValueForExtension("type-converter-name");
        }
        return null;
    }

    public void setTypeConverterName(String name) {
        this.addExtension("type-converter-name", name);
    }

    public boolean isTypeConversionDisabled() {
        return this.hasExtension("type-converter-disabled");
    }

    public void setTypeConverterDisabled() {
        this.addExtension("type-converter-disabled", "true");
    }

    public Integer getRecursionDepth() {
        return this.recursionDepth;
    }

    public void setRecursionDepth(int depth) {
        this.recursionDepth = depth;
    }

    public void setRecursionDepth(String depth) {
        if (!StringUtils.isWhitespace(depth)) {
            try {
                this.recursionDepth = Integer.parseInt(depth);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public MetaData addExtensions(Map<String, String> exts) {
        if (exts != null && exts.containsKey(EXTENSION_MEMBER_FETCH_FK_ONLY)) {
            NucleusLogger.METADATA.warn("Use of 'fetch-fk-only' is now removed. Please make use of recursion-depth=0 for the fetch group in question");
        }
        return super.addExtensions(exts);
    }

    @Override
    public MetaData setExtensions(Map<String, String> exts) {
        if (exts != null && exts.containsKey(EXTENSION_MEMBER_FETCH_FK_ONLY)) {
            NucleusLogger.METADATA.warn("Use of 'fetch-fk-only' is now removed. Please make use of recursion-depth=0 for the fetch group in question");
        }
        return super.setExtensions(exts);
    }

    @Override
    public MetaData addExtension(String key, String value) {
        if (EXTENSION_MEMBER_FETCH_FK_ONLY.equalsIgnoreCase(key)) {
            NucleusLogger.METADATA.warn("Use of 'fetch-fk-only' is now removed. Please make use of recursion-depth=0 for the fetch group in question");
        }
        return super.addExtension(key, value);
    }

    protected static MetaData getOverallParentClassMetaData(MetaData metadata) {
        if (metadata == null) {
            return null;
        }
        if (metadata instanceof AbstractClassMetaData) {
            return metadata;
        }
        return AbstractMemberMetaData.getOverallParentClassMetaData(metadata.getParent());
    }

    public AbstractClassMetaData getAbstractClassMetaData() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof AbstractClassMetaData) {
            return (AbstractClassMetaData)this.parent;
        }
        if (this.parent instanceof EmbeddedMetaData) {
            return (AbstractClassMetaData)AbstractMemberMetaData.getOverallParentClassMetaData(this.parent.getParent().getParent());
        }
        return null;
    }

    public final OrderMetaData getOrderMetaData() {
        return this.orderMetaData;
    }

    public String getName() {
        return this.name;
    }

    public String getFullFieldName() {
        if (this.fullFieldName == null) {
            this.fullFieldName = this.className != null ? this.className + "." + this.name : this.getClassName(true) + "." + this.name;
        }
        return this.fullFieldName;
    }

    public boolean fieldBelongsToClass() {
        return this.className == null;
    }

    public String getClassName() {
        return this.getClassName(true);
    }

    void setClassName(String className) {
        this.className = className;
    }

    public String getClassName(boolean fully_qualified) {
        MetaData grandparent;
        if (this.className != null) {
            return this.className;
        }
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof AbstractClassMetaData) {
            AbstractClassMetaData cmd = (AbstractClassMetaData)this.parent;
            if (fully_qualified) {
                return cmd.getFullClassName();
            }
            return cmd.getName();
        }
        if (this.parent instanceof EmbeddedMetaData) {
            MetaData parentMd = ((EmbeddedMetaData)this.parent).getParent();
            String typeName = null;
            if (parentMd instanceof AbstractMemberMetaData) {
                typeName = ((AbstractMemberMetaData)parentMd).getTypeName();
            } else if (parentMd instanceof ElementMetaData) {
                AbstractMemberMetaData fmd = (AbstractMemberMetaData)((ElementMetaData)parentMd).getParent();
                typeName = fmd.getCollection().getElementType();
            } else if (parentMd instanceof KeyMetaData) {
                AbstractMemberMetaData fmd = (AbstractMemberMetaData)((KeyMetaData)parentMd).getParent();
                typeName = fmd.getMap().getKeyType();
            } else if (parentMd instanceof ValueMetaData) {
                AbstractMemberMetaData fmd = (AbstractMemberMetaData)((ValueMetaData)parentMd).getParent();
                typeName = fmd.getMap().getValueType();
            } else {
                return null;
            }
            if (!fully_qualified && typeName.indexOf(46) > 0) {
                return typeName.substring(typeName.lastIndexOf(46) + 1);
            }
            return typeName;
        }
        if (this.parent instanceof UniqueMetaData && (grandparent = ((UniqueMetaData)this.parent).getParent()) instanceof AbstractClassMetaData) {
            String fullClassName = ((AbstractClassMetaData)grandparent).getFullClassName();
            if (!fully_qualified && fullClassName.indexOf(46) > 0) {
                return fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
            }
            return fullClassName;
        }
        return null;
    }

    public FieldPersistenceModifier getPersistenceModifier() {
        return this.persistenceModifier;
    }

    public void setPersistenceModifier(FieldPersistenceModifier modifier) {
        this.persistenceModifier = modifier;
    }

    public void setNotPersistent() {
        this.persistenceModifier = FieldPersistenceModifier.NONE;
    }

    public void setTransactional() {
        this.persistenceModifier = FieldPersistenceModifier.TRANSACTIONAL;
    }

    public boolean isDefaultFetchGroup() {
        return this.defaultFetchGroup == null ? false : this.defaultFetchGroup;
    }

    public void setDefaultFetchGroup(boolean dfg) {
        this.defaultFetchGroup = dfg;
    }

    public boolean isEmbedded() {
        return this.embedded == null ? false : this.embedded;
    }

    public void setEmbedded(boolean val) {
        this.embedded = val;
    }

    public boolean isSerialized() {
        return this.serialized == null ? false : this.serialized;
    }

    public void setSerialised(boolean flag) {
        this.serialized = flag;
    }

    public String getMapsIdAttribute() {
        return this.mapsIdAttribute;
    }

    public boolean isDependent() {
        return this.dependent == null ? false : this.dependent;
    }

    public void setDependent(boolean dependent) {
        this.dependent = dependent;
    }

    public boolean isCascadePersist() {
        return this.cascadePersist;
    }

    public boolean isCascadeDelete() {
        return this.cascadeDelete;
    }

    public boolean isCascadeAttach() {
        return this.cascadeAttach;
    }

    public boolean isCascadeDetach() {
        return this.cascadeDetach;
    }

    public boolean isCascadeRefresh() {
        return this.cascadeRefresh;
    }

    public boolean isCascadeRemoveOrphans() {
        return this.cascadeRemoveOrphans;
    }

    public void setCascadePersist(boolean cascade) {
        this.cascadePersist = cascade;
    }

    public void setCascadeAttach(boolean cascade) {
        this.cascadeAttach = cascade;
    }

    public void setCascadeDelete(boolean cascade) {
        this.cascadeDelete = cascade;
    }

    public void setCascadeDetach(boolean cascade) {
        this.cascadeDetach = cascade;
    }

    public void setCascadeRefresh(boolean cascade) {
        this.cascadeRefresh = cascade;
    }

    public void setCascadeRemoveOrphans(boolean cascade) {
        this.cascadeRemoveOrphans = cascade;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey == null ? false : this.primaryKey;
    }

    public AbstractMemberMetaData setPrimaryKey(boolean flag) {
        this.primaryKey = flag;
        if (this.primaryKey.booleanValue()) {
            this.defaultFetchGroup = Boolean.TRUE;
        }
        return this;
    }

    public boolean isCreateUser() {
        return this.hasExtension("create-user");
    }

    public boolean isCreateTimestamp() {
        return this.hasExtension("create-timestamp");
    }

    public boolean isUpdateUser() {
        return this.hasExtension("update-user");
    }

    public boolean isUpdateTimestamp() {
        return this.hasExtension("update-timestamp");
    }

    public AbstractMemberMetaData setColumn(String col) {
        this.column = StringUtils.isWhitespace(col) ? null : col;
        return this;
    }

    public String getTable() {
        return this.table;
    }

    public AbstractMemberMetaData setTable(String table) {
        this.table = StringUtils.isWhitespace(table) ? null : table;
        return this;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public AbstractMemberMetaData setCatalog(String catalog) {
        this.catalog = StringUtils.isWhitespace(catalog) ? null : catalog;
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public AbstractMemberMetaData setSchema(String schema) {
        this.schema = StringUtils.isWhitespace(schema) ? null : schema;
        return this;
    }

    public boolean isUnique() {
        return this.uniqueConstraint;
    }

    public AbstractMemberMetaData setUnique(String unique) {
        if (!StringUtils.isWhitespace(unique)) {
            this.uniqueConstraint = Boolean.parseBoolean(unique);
        }
        return this;
    }

    public AbstractMemberMetaData setUnique(boolean unique) {
        this.uniqueConstraint = unique;
        return this;
    }

    public IndexedValue getIndexed() {
        return this.indexed;
    }

    public AbstractMemberMetaData setIndexed(IndexedValue val) {
        this.indexed = val;
        return this;
    }

    public NullValue getNullValue() {
        return this.nullValue;
    }

    public AbstractMemberMetaData setNullValue(NullValue val) {
        this.nullValue = val;
        return this;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public final String[] getFieldTypes() {
        return this.getValuesForExtension("implementation-classes");
    }

    public void setFieldTypes(String types) {
        if (!StringUtils.isWhitespace(types)) {
            this.addExtension("implementation-classes", types);
        }
    }

    public int getAbsoluteFieldNumber() {
        if (this.className == null) {
            return this.fieldId + this.getAbstractClassMetaData().getNoOfInheritedManagedMembers();
        }
        return this.getAbstractClassMetaData().getAbsolutePositionOfMember(this.name);
    }

    public Member getMemberRepresented() {
        return this.memberRepresented;
    }

    public Class getType() {
        return this.type;
    }

    public String getTypeName() {
        if (this.type == null) {
            return null;
        }
        return this.type.getName();
    }

    public ContainerMetaData getContainer() {
        return this.containerMetaData;
    }

    public ArrayMetaData getArray() {
        if (this.containerMetaData != null && this.containerMetaData instanceof ArrayMetaData) {
            return (ArrayMetaData)this.containerMetaData;
        }
        return null;
    }

    public CollectionMetaData getCollection() {
        if (this.containerMetaData != null && this.containerMetaData instanceof CollectionMetaData) {
            return (CollectionMetaData)this.containerMetaData;
        }
        return null;
    }

    public MapMetaData getMap() {
        if (this.containerMetaData != null && this.containerMetaData instanceof MapMetaData) {
            return (MapMetaData)this.containerMetaData;
        }
        return null;
    }

    public boolean hasContainer() {
        return this.containerMetaData != null;
    }

    public boolean hasArray() {
        return this.containerMetaData == null ? false : this.containerMetaData instanceof ArrayMetaData;
    }

    public boolean hasCollection() {
        return this.containerMetaData == null ? false : this.containerMetaData instanceof CollectionMetaData;
    }

    public boolean isSingleCollection() {
        return this.containerMetaData instanceof CollectionMetaData && ((CollectionMetaData)this.containerMetaData).singleElement;
    }

    public boolean hasMap() {
        return this.containerMetaData == null ? false : this.containerMetaData instanceof MapMetaData;
    }

    @Override
    public final ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public final ElementMetaData getElementMetaData() {
        return this.elementMetaData;
    }

    public final KeyMetaData getKeyMetaData() {
        return this.keyMetaData;
    }

    public final ValueMetaData getValueMetaData() {
        return this.valueMetaData;
    }

    public final EmbeddedMetaData getEmbeddedMetaData() {
        return this.embeddedMetaData;
    }

    public final String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = StringUtils.isWhitespace(mappedBy) ? null : mappedBy;
    }

    public void setDeleteAction(String action) {
        if (action != null) {
            this.foreignKeyMetaData = new ForeignKeyMetaData();
            this.foreignKeyMetaData.setDeleteAction(ForeignKeyAction.getForeignKeyAction(action));
        }
    }

    public final ForeignKeyMetaData getForeignKeyMetaData() {
        return this.foreignKeyMetaData;
    }

    public final IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public final UniqueMetaData getUniqueMetaData() {
        return this.uniqueMetaData;
    }

    public final JoinMetaData getJoinMetaData() {
        return this.joinMetaData;
    }

    @Override
    public void addColumn(ColumnMetaData colmd) {
        this.columns.add(colmd);
        colmd.parent = this;
        this.columnMetaData = new ColumnMetaData[this.columns.size()];
        for (int i = 0; i < this.columnMetaData.length; ++i) {
            this.columnMetaData[i] = this.columns.get(i);
        }
    }

    public void clearColumns() {
        this.columnMetaData = null;
        this.columns.clear();
        this.column = null;
    }

    public ColumnMetaData newColumnMetaData() {
        ColumnMetaData colmd = new ColumnMetaData();
        this.addColumn(colmd);
        return colmd;
    }

    public byte getPersistenceFlags() {
        return this.persistenceFlags;
    }

    public boolean isFieldToBePersisted() {
        if (this.isPopulated()) {
            if (this.isStatic()) {
                return false;
            }
            if (this.isFinal() && this instanceof FieldMetaData) {
                if (this.persistenceModifier == FieldPersistenceModifier.PERSISTENT) {
                    throw new InvalidMetaDataException("044118", this.getClassName(), this.getName());
                }
                return false;
            }
        }
        if (this.persistenceModifier == null) {
            return false;
        }
        return !this.persistenceModifier.equals((Object)FieldPersistenceModifier.NONE);
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public String getTargetClassName() {
        return this.targetClassName;
    }

    public void setOrdered() {
        this.ordered = true;
    }

    public void setTargetClassName(String target) {
        if (!StringUtils.isWhitespace(target)) {
            this.targetClassName = target;
        }
    }

    public void setStoreInLob() {
        this.storeInLob = true;
    }

    public void setMapsIdAttribute(String attr) {
        this.mapsIdAttribute = attr;
        if (this.mapsIdAttribute != null) {
            NucleusLogger.METADATA.warn("@MapsId specified on member " + this.getFullFieldName() + " yet not currently supported (" + this.mapsIdAttribute + ")");
        }
    }

    public void setRelationTypeString(String relType) {
        this.relationTypeString = relType;
    }

    public String getRelationTypeString() {
        return this.relationTypeString;
    }

    public void setValueGeneratorName(String generator) {
        this.valueGeneratorName = StringUtils.isWhitespace(generator) ? null : generator;
    }

    public void setContainer(ContainerMetaData conmd) {
        this.containerMetaData = conmd;
        this.containerMetaData.parent = this;
    }

    public CollectionMetaData newCollectionMetaData() {
        CollectionMetaData collmd = new CollectionMetaData();
        this.setContainer(collmd);
        return collmd;
    }

    public ArrayMetaData newArrayMetaData() {
        ArrayMetaData arrmd = new ArrayMetaData();
        this.setContainer(arrmd);
        return arrmd;
    }

    public MapMetaData newMapMetaData() {
        MapMetaData mapmd = new MapMetaData();
        this.setContainer(mapmd);
        return mapmd;
    }

    public final void setElementMetaData(ElementMetaData elementMetaData) {
        this.elementMetaData = elementMetaData;
        this.elementMetaData.parent = this;
    }

    public ElementMetaData newElementMetaData() {
        ElementMetaData elemmd = new ElementMetaData();
        this.setElementMetaData(elemmd);
        return elemmd;
    }

    public final void setKeyMetaData(KeyMetaData keyMetaData) {
        this.keyMetaData = keyMetaData;
        this.keyMetaData.parent = this;
    }

    public KeyMetaData newKeyMetaData() {
        KeyMetaData keymd = new KeyMetaData();
        this.setKeyMetaData(keymd);
        return keymd;
    }

    public final void setValueMetaData(ValueMetaData valueMetaData) {
        this.valueMetaData = valueMetaData;
        this.valueMetaData.parent = this;
    }

    public ValueMetaData newValueMetaData() {
        ValueMetaData valuemd = new ValueMetaData();
        this.setValueMetaData(valuemd);
        return valuemd;
    }

    public final void setOrderMetaData(OrderMetaData orderMetaData) {
        this.orderMetaData = orderMetaData;
        this.orderMetaData.parent = this;
    }

    public OrderMetaData newOrderMetaData() {
        OrderMetaData ordermd = new OrderMetaData();
        this.setOrderMetaData(ordermd);
        return ordermd;
    }

    public final void setEmbeddedMetaData(EmbeddedMetaData embeddedMetaData) {
        this.embeddedMetaData = embeddedMetaData;
        this.embeddedMetaData.parent = this;
    }

    public EmbeddedMetaData newEmbeddedMetaData() {
        EmbeddedMetaData embmd = new EmbeddedMetaData();
        this.setEmbeddedMetaData(embmd);
        return embmd;
    }

    public final void setForeignKeyMetaData(ForeignKeyMetaData foreignKeyMetaData) {
        this.foreignKeyMetaData = foreignKeyMetaData;
        this.foreignKeyMetaData.parent = this;
    }

    public ForeignKeyMetaData newForeignKeyMetaData() {
        ForeignKeyMetaData fkmd = new ForeignKeyMetaData();
        this.setForeignKeyMetaData(fkmd);
        return fkmd;
    }

    public final void setIndexMetaData(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
        this.indexMetaData.parent = this;
    }

    public IndexMetaData newIndexMetaData() {
        IndexMetaData idxmd = new IndexMetaData();
        this.setIndexMetaData(idxmd);
        return idxmd;
    }

    public final void setUniqueMetaData(UniqueMetaData uniqueMetaData) {
        this.uniqueMetaData = uniqueMetaData;
        this.uniqueMetaData.parent = this;
    }

    public UniqueMetaData newUniqueMetaData() {
        UniqueMetaData unimd = new UniqueMetaData();
        this.setUniqueMetaData(unimd);
        return unimd;
    }

    public final void setJoinMetaData(JoinMetaData joinMetaData) {
        this.joinMetaData = joinMetaData;
        this.joinMetaData.parent = this;
    }

    public JoinMetaData newJoinMetaData() {
        JoinMetaData joinmd = new JoinMetaData();
        this.setJoinMetaData(joinmd);
        return joinmd;
    }

    void setFieldId(int field_id) {
        this.fieldId = field_id;
    }

    protected void setRelation(ClassLoaderResolver clr) {
        if (this.relationType != null) {
            return;
        }
        MetaDataManager mmgr = this.getMetaDataManager();
        AbstractClassMetaData otherCmd = null;
        if (this.hasCollection()) {
            Class elementCls;
            otherCmd = mmgr.getMetaDataForClass(this.getCollection().getElementType(), clr);
            if (otherCmd == null && ClassUtils.isReferenceType(elementCls = clr.classForName(this.getCollection().getElementType()))) {
                try {
                    String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this, FieldRole.ROLE_COLLECTION_ELEMENT, clr, mmgr);
                    if (implNames != null && implNames.length > 0) {
                        otherCmd = mmgr.getMetaDataForClass(implNames[0], clr);
                    }
                }
                catch (NucleusUserException jpe) {
                    if (!this.getCollection().isSerializedElement() && this.mappedBy != null) {
                        throw jpe;
                    }
                    NucleusLogger.METADATA.debug("Field " + this.getFullFieldName() + " is a collection of elements of reference type yet no implementation-classes are provided. Assuming they arent persistable");
                }
            }
        } else if (this.hasMap()) {
            otherCmd = ((MapMetaData)this.containerMetaData).getValueClassMetaData(clr);
            if (otherCmd == null) {
                otherCmd = ((MapMetaData)this.containerMetaData).getKeyClassMetaData(clr);
            }
            if (otherCmd == null) {
                // empty if block
            }
        } else if (this.hasArray()) {
            otherCmd = ((ArrayMetaData)this.containerMetaData).getElementClassMetaData(clr);
        } else if (this.getType().isInterface()) {
            try {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this, FieldRole.ROLE_FIELD, clr, mmgr);
                if (implNames != null && implNames.length > 0) {
                    otherCmd = mmgr.getMetaDataForClass(implNames[0], clr);
                }
            }
            catch (NucleusUserException nue) {
                otherCmd = null;
            }
        } else {
            otherCmd = this.getType().getName().equals(ClassNameConstants.Object) && this.getFieldTypes() != null ? mmgr.getMetaDataForClass(this.getFieldTypes()[0], clr) : mmgr.getMetaDataForClass(this.getType(), clr);
        }
        if (otherCmd == null) {
            if (this.hasArray() && this.getArray().mayContainPersistableElements()) {
                this.relatedMemberMetaData = null;
                this.relationType = RelationType.ONE_TO_MANY_UNI;
            } else {
                this.relatedMemberMetaData = null;
                this.relationType = RelationType.NONE;
            }
        } else if (this.mappedBy != null) {
            AbstractMemberMetaData otherMmd = null;
            if (this.mappedBy.indexOf(46) > 0) {
                String remainingMappedBy = this.mappedBy;
                boolean first = true;
                while (remainingMappedBy.indexOf(46) > 0) {
                    int dotPosition = remainingMappedBy.indexOf(46);
                    String thisMappedBy = remainingMappedBy.substring(0, dotPosition);
                    otherMmd = otherCmd.getMetaDataForMember(thisMappedBy);
                    if (otherMmd == null) {
                        throw new NucleusUserException(Localiser.msg("044115", this.getAbstractClassMetaData().getFullClassName(), this.name, remainingMappedBy, otherCmd.getFullClassName())).setFatal();
                    }
                    if (!first && !otherMmd.isEmbedded()) {
                        throw new NucleusUserException("Member " + this.getFullFieldName() + " has mappedBy using DOT notation but intermediate member " + otherMmd.getFullFieldName() + " is not embedded");
                    }
                    remainingMappedBy = remainingMappedBy.substring(dotPosition + 1);
                    first = false;
                    otherCmd = this.getMetaDataManager().getMetaDataForClass(otherMmd.getTypeName(), clr);
                }
                otherMmd = otherCmd.getMetaDataForMember(remainingMappedBy);
            } else {
                otherMmd = otherCmd.getMetaDataForMember(this.mappedBy);
            }
            if (otherMmd == null) {
                throw new NucleusUserException(Localiser.msg("044115", this.getAbstractClassMetaData().getFullClassName(), this.name, this.mappedBy, otherCmd.getFullClassName())).setFatal();
            }
            this.relatedMemberMetaData = new AbstractMemberMetaData[]{otherMmd};
            if (this.isSingleCollection()) {
                if (this.relatedMemberMetaData[0].isSingleCollection()) {
                    this.relationType = RelationType.ONE_TO_ONE_BI;
                }
            } else {
                this.relationType = this.hasContainer() && this.relatedMemberMetaData[0].hasContainer() ? RelationType.MANY_TO_MANY_BI : (this.hasContainer() && !this.relatedMemberMetaData[0].hasContainer() ? RelationType.ONE_TO_MANY_BI : (!this.hasContainer() && this.relatedMemberMetaData[0].hasContainer() ? RelationType.MANY_TO_ONE_BI : RelationType.ONE_TO_ONE_BI));
            }
        } else {
            int[] otherFieldNumbers = otherCmd.getAllMemberPositions();
            HashSet<AbstractMemberMetaData> relatedFields = new HashSet<AbstractMemberMetaData>();
            for (int i = 0; i < otherFieldNumbers.length; ++i) {
                AbstractMemberMetaData otherFmd = otherCmd.getMetaDataForManagedMemberAtAbsolutePosition(otherFieldNumbers[i]);
                if (otherFmd.getMappedBy() == null || !otherFmd.getMappedBy().equals(this.name)) continue;
                if (otherFmd.hasContainer()) {
                    Class thisCls;
                    Class elementCls;
                    if (otherFmd.hasCollection() && otherFmd.getCollection().getElementType().equals(this.getClassName(true)) || otherFmd.hasArray() && otherFmd.getArray().getElementType().equals(this.getClassName(true)) || otherFmd.hasMap() && otherFmd.getMap().getKeyType().equals(this.getClassName(true)) || otherFmd.hasMap() && otherFmd.getMap().getValueType().equals(this.getClassName(true))) {
                        relatedFields.add(otherFmd);
                        if (this.isSingleCollection()) {
                            this.relationType = otherFmd.isSingleCollection() ? RelationType.ONE_TO_ONE_BI : RelationType.MANY_TO_ONE_BI;
                            continue;
                        }
                        if (this.hasContainer()) {
                            this.relationType = RelationType.MANY_TO_MANY_BI;
                            continue;
                        }
                        this.relationType = RelationType.MANY_TO_ONE_BI;
                        continue;
                    }
                    String elementType = null;
                    if (otherFmd.hasCollection()) {
                        elementType = otherFmd.getCollection().getElementType();
                    } else if (otherFmd.hasArray()) {
                        elementType = otherFmd.getArray().getElementType();
                    }
                    if (elementType == null || !(elementCls = clr.classForName(elementType)).isInterface() || !elementCls.isAssignableFrom(thisCls = clr.classForName(this.getClassName(true)))) continue;
                    relatedFields.add(otherFmd);
                    if (this.hasContainer()) {
                        this.relationType = RelationType.MANY_TO_MANY_BI;
                        continue;
                    }
                    this.relationType = RelationType.MANY_TO_ONE_BI;
                    continue;
                }
                Class cls = clr.classForName(this.getClassName(true));
                if (!otherFmd.getType().isAssignableFrom(cls) && !cls.isAssignableFrom(otherFmd.getType())) continue;
                relatedFields.add(otherFmd);
                this.relationType = this.hasContainer() ? RelationType.ONE_TO_MANY_BI : RelationType.ONE_TO_ONE_BI;
            }
            if (!relatedFields.isEmpty()) {
                this.relatedMemberMetaData = relatedFields.toArray(new AbstractMemberMetaData[relatedFields.size()]);
                relatedFields.clear();
                relatedFields = null;
            } else {
                this.relationType = this.hasContainer() ? (this.isSingleCollection() ? RelationType.ONE_TO_ONE_UNI : RelationType.ONE_TO_MANY_UNI) : (this.joinMetaData != null ? RelationType.MANY_TO_ONE_UNI : RelationType.ONE_TO_ONE_UNI);
            }
        }
    }

    public RelationType getRelationType(ClassLoaderResolver clr) {
        if (this.relationType == null) {
            this.setRelation(clr);
        }
        return this.relationType;
    }

    public boolean isPersistentInterface(ClassLoaderResolver clr) {
        MetaDataManager mmgr = this.getMetaDataManager();
        if (this.hasCollection()) {
            if (mmgr.isPersistentInterface(this.getCollection().getElementType())) {
                return true;
            }
        } else if (this.hasMap()) {
            if (mmgr.isPersistentInterface(this.getMap().getKeyType())) {
                return true;
            }
            if (mmgr.isPersistentInterface(this.getMap().getValueType())) {
                return true;
            }
        } else if (this.hasArray()) {
            if (mmgr.isPersistentInterface(this.getArray().getElementType())) {
                return true;
            }
        } else if (this.getType().isInterface()) {
            if (mmgr.isPersistentInterface(this.getTypeName())) {
                return true;
            }
            String[] fieldTypes = this.getFieldTypes();
            if (fieldTypes != null && mmgr.isPersistentInterface(fieldTypes[0])) {
                return true;
            }
        }
        return false;
    }

    public boolean isRelationOwner(ClassLoaderResolver clr) {
        if (this.relationType == null) {
            this.setRelation(clr);
        }
        if (this.relationType == RelationType.NONE) {
            return true;
        }
        if (this.relationType == RelationType.ONE_TO_MANY_UNI || this.relationType == RelationType.ONE_TO_ONE_UNI) {
            return true;
        }
        if (this.relationType == RelationType.MANY_TO_MANY_BI || this.relationType == RelationType.MANY_TO_ONE_BI || this.relationType == RelationType.ONE_TO_MANY_BI || this.relationType == RelationType.ONE_TO_ONE_BI) {
            return this.mappedBy == null;
        }
        return this.relationType == RelationType.MANY_TO_ONE_UNI;
    }

    public AbstractMemberMetaData[] getRelatedMemberMetaData(ClassLoaderResolver clr) {
        if (this.relationType == null) {
            this.setRelation(clr);
        }
        return this.relatedMemberMetaData;
    }

    public AbstractMemberMetaData getRelatedMemberMetaDataForObject(ClassLoaderResolver clr, Object thisPC, Object otherPC) {
        if (this.relationType == null) {
            this.setRelation(clr);
        }
        if (this.relatedMemberMetaData == null) {
            return null;
        }
        for (int i = 0; i < this.relatedMemberMetaData.length; ++i) {
            if (this.relationType == RelationType.ONE_TO_ONE_BI) {
                Class type;
                AbstractMemberMetaData relMmd = this.relatedMemberMetaData[i];
                Class relatedType = relMmd.isSingleCollection() ? clr.classForName(relMmd.getCollection().getElementType()) : relMmd.getType();
                Class clazz = type = this.isSingleCollection() ? clr.classForName(this.getCollection().getElementType()) : this.getType();
                if (!relatedType.isAssignableFrom(thisPC.getClass()) || !type.isAssignableFrom(otherPC.getClass())) continue;
                return this.relatedMemberMetaData[i];
            }
            if (this.relationType != RelationType.MANY_TO_ONE_BI) continue;
            if (this.relatedMemberMetaData[i].hasCollection()) {
                Class elementType = clr.classForName(this.relatedMemberMetaData[i].getCollection().getElementType());
                if (!elementType.isAssignableFrom(thisPC.getClass()) || !this.getType().isAssignableFrom(otherPC.getClass())) continue;
                return this.relatedMemberMetaData[i];
            }
            if (!this.relatedMemberMetaData[i].hasMap()) continue;
            Class valueType = clr.classForName(this.relatedMemberMetaData[i].getMap().getValueType());
            if (valueType.isAssignableFrom(thisPC.getClass()) && this.getType().isAssignableFrom(otherPC.getClass())) {
                return this.relatedMemberMetaData[i];
            }
            Class keyType = clr.classForName(this.relatedMemberMetaData[i].getMap().getKeyType());
            if (!keyType.isAssignableFrom(thisPC.getClass()) || !this.getType().isAssignableFrom(otherPC.getClass())) continue;
            return this.relatedMemberMetaData[i];
        }
        return null;
    }

    void getReferencedClassMetaData(List<AbstractClassMetaData> orderedCmds, Set<AbstractClassMetaData> referencedCmds, ClassLoaderResolver clr) {
        MetaDataManager mmgr = this.getMetaDataManager();
        AbstractClassMetaData theTypeCmd = mmgr.getMetaDataForClass(this.getType(), clr);
        if (theTypeCmd != null) {
            theTypeCmd.getReferencedClassMetaData(orderedCmds, referencedCmds, clr);
        }
        if (this.hasCollection()) {
            this.getCollection().getReferencedClassMetaData(orderedCmds, referencedCmds, clr);
        } else if (this.hasMap()) {
            this.getMap().getReferencedClassMetaData(orderedCmds, referencedCmds, clr);
        } else if (this.hasArray()) {
            this.getArray().getReferencedClassMetaData(orderedCmds, referencedCmds, clr);
        }
    }

    public boolean calcIsSecondClassMutable(MetaDataManager mmgr) {
        if (this.hasExtension("is-second-class")) {
            String isSecondClass = this.getValueForExtension("is-second-class");
            if (isSecondClass.equalsIgnoreCase("true")) {
                return true;
            }
            if (isSecondClass.equalsIgnoreCase("false")) {
                return false;
            }
            if (!isSecondClass.equalsIgnoreCase("default")) {
                throw new InvalidMetaDataException("044002", "is-second-class", "true/false/default", isSecondClass);
            }
        }
        return mmgr.getNucleusContext().getTypeManager().isSecondClassMutableType(this.getTypeName());
    }

    public boolean isInsertable() {
        if (this.hasCollection() || this.hasArray()) {
            if (this.elementMetaData != null && this.elementMetaData.getColumnMetaData() != null && this.elementMetaData.getColumnMetaData().length > 0) {
                return this.elementMetaData.getColumnMetaData()[0].getInsertable();
            }
        } else {
            if (this.hasMap()) {
                return true;
            }
            if (this.columnMetaData != null && this.columnMetaData.length > 0) {
                return this.columnMetaData[0].getInsertable();
            }
            String insertVal = this.getValueForExtension("insertable");
            if (!StringUtils.isWhitespace(insertVal)) {
                return Boolean.parseBoolean(insertVal);
            }
        }
        return true;
    }

    public boolean isUpdateable() {
        if (this.hasCollection() || this.hasArray()) {
            if (this.elementMetaData != null && this.elementMetaData.getColumnMetaData() != null && this.elementMetaData.getColumnMetaData().length > 0) {
                return this.elementMetaData.getColumnMetaData()[0].getUpdateable();
            }
        } else {
            if (this.hasMap()) {
                return true;
            }
            if (this.columnMetaData != null && this.columnMetaData.length > 0) {
                return this.columnMetaData[0].getUpdateable();
            }
            String updateVal = this.getValueForExtension("updateable");
            if (!StringUtils.isWhitespace(updateVal)) {
                return Boolean.parseBoolean(updateVal);
            }
        }
        return true;
    }

    public int compareTo(Object o) {
        if (o instanceof AbstractMemberMetaData) {
            AbstractMemberMetaData c = (AbstractMemberMetaData)o;
            return this.name.compareTo(c.name);
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }
}

