/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FetchGroupMemberMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class FetchPlanForClass {
    final FetchPlan plan;
    final AbstractClassMetaData cmd;
    int[] memberNumbers;
    boolean dirty = true;
    Map<Integer, Integer> recursionDepthByMemberNumber = new HashMap<Integer, Integer>();
    private Map<Integer, Set<FetchGroupMetaData>> fetchGroupsByMemberNumber = null;

    public FetchPlanForClass(AbstractClassMetaData cmd, FetchPlan fetchPlan) {
        this.cmd = cmd;
        this.plan = fetchPlan;
    }

    public final FetchPlan getFetchPlan() {
        return this.plan;
    }

    public final AbstractClassMetaData getAbstractClassMetaData() {
        return this.cmd;
    }

    public String toString() {
        return this.cmd.getFullClassName() + "[members=" + StringUtils.intArrayToString(this.getMemberNumbers()) + "]";
    }

    void markDirty() {
        this.dirty = true;
        this.recursionDepthByMemberNumber.clear();
        this.plan.invalidateCachedIsToCallPostLoadFetchPlan(this.cmd);
    }

    FetchPlanForClass getCopy(FetchPlan fp) {
        FetchPlanForClass fpCopy = new FetchPlanForClass(this.cmd, fp);
        if (this.memberNumbers != null) {
            fpCopy.memberNumbers = new int[this.memberNumbers.length];
            System.arraycopy(this.memberNumbers, 0, fpCopy.memberNumbers, 0, this.memberNumbers.length);
        }
        fpCopy.dirty = this.dirty;
        return fpCopy;
    }

    public int getRecursionDepthForMember(int memberNum) {
        Integer recursionDepth;
        if (this.dirty) {
            this.recursionDepthByMemberNumber.clear();
        }
        if ((recursionDepth = this.recursionDepthByMemberNumber.get(memberNum)) != null) {
            return recursionDepth;
        }
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberNum);
        recursionDepth = mmd.getRecursionDepth() != null ? mmd.getRecursionDepth() : 1;
        String memberName = mmd.getName();
        Set<FetchGroupMetaData> fetchGroupsContainingField = this.getFetchGroupsForMemberNumber(this.cmd.getFetchGroupMetaData(this.plan.getGroups()), memberNum);
        block0: for (FetchGroupMetaData fgmd : fetchGroupsContainingField) {
            Set<FetchGroupMemberMetaData> fgmmds = fgmd.getMembers();
            if (fgmmds == null) continue;
            for (FetchGroupMemberMetaData fgmmd : fgmmds) {
                if (!fgmmd.getName().equals(memberName)) continue;
                recursionDepth = fgmmd.getRecursionDepth();
                continue block0;
            }
        }
        if (this.plan.dynamicGroups != null) {
            for (FetchGroup group : this.plan.dynamicGroups) {
                if (!group.getType().getName().equals(this.cmd.getFullClassName()) || !group.getMembers().contains(memberName)) continue;
                recursionDepth = group.getRecursionDepth(memberName);
                break;
            }
        }
        this.recursionDepthByMemberNumber.put(memberNum, recursionDepth);
        return recursionDepth;
    }

    public boolean hasMember(int memberNumber) {
        if (this.dirty) {
            BitSet fieldsNumber = this.getMemberNumbersByBitSet();
            return fieldsNumber.get(memberNumber);
        }
        if (this.memberNumbers != null) {
            for (int i = 0; i < this.memberNumbers.length; ++i) {
                if (this.memberNumbers[i] != memberNumber) continue;
                return true;
            }
        }
        return false;
    }

    public int[] getMemberNumbers() {
        if (this.dirty) {
            this.dirty = false;
            BitSet fieldsNumber = this.getMemberNumbersByBitSet();
            int count = 0;
            for (int i = 0; i < fieldsNumber.length(); ++i) {
                if (!fieldsNumber.get(i)) continue;
                ++count;
            }
            this.memberNumbers = new int[count];
            int nextField = 0;
            for (int i = 0; i < fieldsNumber.length(); ++i) {
                if (!fieldsNumber.get(i)) continue;
                this.memberNumbers[nextField++] = i;
            }
        }
        return this.memberNumbers;
    }

    public BitSet getMemberNumbersByBitSet() {
        return this.getMemberNumbersByBitSet(this.cmd);
    }

    private BitSet getMemberNumbersByBitSet(AbstractClassMetaData cmd) {
        FetchPlanForClass fpc = this.plan.getFetchPlanForClass(cmd);
        BitSet bitSet = fpc.getMemberNumbersForFetchGroups(cmd.getFetchGroupMetaData());
        if (cmd.getPersistableSuperclass() != null) {
            AbstractClassMetaData superCmd = cmd.getSuperAbstractClassMetaData();
            FetchPlanForClass superFpc = this.plan.getFetchPlanForClass(superCmd);
            bitSet.or(superFpc.getMemberNumbersByBitSet(superCmd));
        } else {
            fpc.setAsNone(bitSet);
        }
        if (this.plan.dynamicGroups != null) {
            for (FetchGroup grp : this.plan.dynamicGroups) {
                if (!grp.getType().getName().equals(cmd.getFullClassName())) continue;
                Set<String> members = grp.getMembers();
                for (String memberName : members) {
                    int fieldPos = cmd.getAbsolutePositionOfMember(memberName);
                    if (fieldPos < 0) continue;
                    bitSet.set(fieldPos);
                }
            }
        }
        return bitSet;
    }

    private BitSet getMemberNumbersForFetchGroups(Set<FetchGroupMetaData> fgmds) {
        BitSet memberNumbers = new BitSet(0);
        if (fgmds != null) {
            for (FetchGroupMetaData fgmd : fgmds) {
                if (!this.plan.groupNames.contains(fgmd.getName())) continue;
                memberNumbers.or(this.getMemberNumbersForFetchGroup(fgmd));
            }
        }
        if (this.plan.groupNames.contains("default")) {
            this.setAsDefault(memberNumbers);
        }
        if (this.plan.groupNames.contains("all")) {
            this.setAsAll(memberNumbers);
        }
        if (this.plan.groupNames.contains("none")) {
            this.setAsNone(memberNumbers);
        }
        return memberNumbers;
    }

    private BitSet getMemberNumbersForFetchGroup(FetchGroupMetaData fgmd) {
        Set<FetchGroupMetaData> subFGs;
        BitSet memberNumbers = new BitSet(0);
        Set<FetchGroupMemberMetaData> subFGmmds = fgmd.getMembers();
        if (subFGmmds != null) {
            for (FetchGroupMemberMetaData subFGmmd : subFGmmds) {
                int fieldNumber = this.cmd.getAbsolutePositionOfMember(subFGmmd.getName());
                if (fieldNumber == -1) {
                    String msg = Localiser.msg("006000", subFGmmd.getName(), fgmd.getName(), this.cmd.getFullClassName());
                    NucleusLogger.PERSISTENCE.error(msg);
                    throw new NucleusUserException(msg).setFatal();
                }
                memberNumbers.set(fieldNumber);
            }
        }
        if ((subFGs = fgmd.getFetchGroups()) != null) {
            for (FetchGroupMetaData subFgmd : subFGs) {
                String nestedGroupName = subFgmd.getName();
                if (nestedGroupName.equals("default")) {
                    this.setAsDefault(memberNumbers);
                    continue;
                }
                if (nestedGroupName.equals("all")) {
                    this.setAsAll(memberNumbers);
                    continue;
                }
                if (nestedGroupName.equals("none")) {
                    this.setAsNone(memberNumbers);
                    continue;
                }
                FetchGroupMetaData nestedFGMD = this.cmd.getFetchGroupMetaData(nestedGroupName);
                if (nestedFGMD == null) {
                    throw new NucleusUserException(Localiser.msg("006001", subFgmd.getName(), fgmd.getName(), this.cmd.getFullClassName())).setFatal();
                }
                memberNumbers.or(this.getMemberNumbersForFetchGroup(nestedFGMD));
            }
        }
        return memberNumbers;
    }

    private void setAsDefault(BitSet memberNums) {
        int numDFGMembers = this.cmd.getDFGMemberPositions().length;
        for (int i = 0; i < numDFGMembers; ++i) {
            memberNums.set(this.cmd.getDFGMemberPositions()[i]);
        }
    }

    private void setAsAll(BitSet memberNums) {
        int numManagedMembers = this.cmd.getNoOfManagedMembers();
        for (int i = 0; i < numManagedMembers; ++i) {
            if (this.cmd.getMetaDataForManagedMemberAtRelativePosition(i).getPersistenceModifier() == FieldPersistenceModifier.NONE) continue;
            memberNums.set(this.cmd.getNoOfInheritedManagedMembers() + i);
        }
    }

    private void setAsNone(BitSet memberNums) {
        int numManagedMembers = this.cmd.getNoOfManagedMembers();
        for (int i = 0; i < numManagedMembers; ++i) {
            AbstractMemberMetaData mmd = this.cmd.getManagedMembers()[i];
            if (!mmd.isPrimaryKey()) continue;
            memberNums.set(mmd.getAbsoluteFieldNumber());
        }
    }

    public boolean isToCallPostLoadFetchPlan(boolean[] loadedMembers) {
        BitSet cacheKey = new BitSet(loadedMembers.length);
        for (int i = 0; i < loadedMembers.length; ++i) {
            cacheKey.set(i, loadedMembers[i]);
        }
        Boolean result = this.plan.getCachedIsToCallPostLoadFetchPlan(this.cmd, cacheKey);
        Set<String> fpGroups = this.plan.getGroups();
        if (result == null) {
            result = Boolean.FALSE;
            int[] fieldsInActualFetchPlan = this.getMemberNumbers();
            for (int i = 0; i < fieldsInActualFetchPlan.length; ++i) {
                int fieldNumber = fieldsInActualFetchPlan[i];
                if (loadedMembers[fieldNumber]) continue;
                AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                if (mmd.isDefaultFetchGroup() && fpGroups.contains("default")) {
                    result = Boolean.TRUE;
                    continue;
                }
                if (this.cmd.hasFetchGroupWithPostLoad()) {
                    Integer fieldNumberInteger = fieldNumber;
                    Set<FetchGroupMetaData> fetchGroups = null;
                    if (this.fetchGroupsByMemberNumber != null) {
                        fetchGroups = this.fetchGroupsByMemberNumber.get(fieldNumberInteger);
                    }
                    if (fetchGroups == null) {
                        fetchGroups = this.getFetchGroupsForMemberNumber(this.cmd.getFetchGroupMetaData(), fieldNumber);
                        if (this.fetchGroupsByMemberNumber == null) {
                            this.fetchGroupsByMemberNumber = new HashMap<Integer, Set<FetchGroupMetaData>>();
                        }
                        this.fetchGroupsByMemberNumber.put(fieldNumberInteger, fetchGroups);
                    }
                    for (FetchGroupMetaData fgmd : fetchGroups) {
                        if (!fgmd.getPostLoad().booleanValue()) continue;
                        result = Boolean.TRUE;
                        break;
                    }
                }
                if (result.booleanValue() || this.plan.dynamicGroups == null) continue;
                String fieldName = mmd.getName();
                Class cls = this.plan.clr.classForName(this.cmd.getFullClassName());
                for (FetchGroup group : this.plan.dynamicGroups) {
                    Set<String> groupMembers = group.getMembers();
                    if (!group.getType().isAssignableFrom(cls) || !groupMembers.contains(fieldName) || !group.getPostLoad()) continue;
                    result = Boolean.TRUE;
                }
            }
            if (result == null) {
                result = Boolean.FALSE;
            }
            this.plan.cacheIsToCallPostLoadFetchPlan(this.cmd, cacheKey, result);
        }
        return result;
    }

    private Set<FetchGroupMetaData> getFetchGroupsForMemberNumber(Set<FetchGroupMetaData> fgmds, int memberNum) {
        HashSet<FetchGroupMetaData> fetchGroups = new HashSet<FetchGroupMetaData>();
        if (fgmds != null) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberNum);
            for (FetchGroupMetaData fgmd : fgmds) {
                Set<FetchGroupMetaData> subFGmds;
                Set<FetchGroupMemberMetaData> fgmmds = fgmd.getMembers();
                if (fgmmds != null) {
                    for (FetchGroupMemberMetaData fgmmd : fgmmds) {
                        if (!fgmmd.getName().equals(mmd.getName())) continue;
                        fetchGroups.add(fgmd);
                        break;
                    }
                }
                if ((subFGmds = fgmd.getFetchGroups()) == null) continue;
                fetchGroups.addAll(this.getFetchGroupsForMemberNumber(subFGmds, memberNum));
            }
        }
        return fetchGroups;
    }
}

