/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers.backed;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistableObjectType;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.flush.CollectionAddOperation;
import org.datanucleus.flush.CollectionClearOperation;
import org.datanucleus.flush.CollectionRemoveOperation;
import org.datanucleus.flush.ListAddAtOperation;
import org.datanucleus.flush.ListRemoveAtOperation;
import org.datanucleus.flush.ListSetOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.BackedSCOStoreManager;
import org.datanucleus.store.types.SCOListIterator;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.scostore.ListStore;
import org.datanucleus.store.types.scostore.Store;
import org.datanucleus.store.types.wrappers.backed.BackedSCO;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class LinkedList<E>
extends org.datanucleus.store.types.wrappers.LinkedList<E>
implements BackedSCO {
    protected transient ListStore<E> backingStore;
    protected transient boolean allowNulls = false;
    protected transient boolean useCache = true;
    protected transient boolean isCacheLoaded = false;

    public LinkedList(DNStateManager ownerSM, AbstractMemberMetaData mmd) {
        super(ownerSM, mmd);
        this.delegate = new java.util.LinkedList();
        this.allowNulls = SCOUtils.allowNullsInContainer(this.allowNulls, mmd);
        this.useCache = SCOUtils.useContainerCache(ownerSM, mmd);
        if (!SCOUtils.collectionHasSerialisedElements(mmd) && mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            ClassLoaderResolver clr = ownerSM.getExecutionContext().getClassLoaderResolver();
            this.backingStore = (ListStore)((BackedSCOStoreManager)((Object)ownerSM.getStoreManager())).getBackingStoreForField(clr, mmd, java.util.LinkedList.class);
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(ownerSM, this.ownerMmd.getName(), this, this.useCache, this.allowNulls, SCOUtils.useCachedLazyLoading(ownerSM, this.ownerMmd)));
        }
    }

    @Override
    public void initialise(java.util.LinkedList newValue, Object oldValue) {
        if (newValue != null) {
            ExecutionContext ec = this.ownerSM.getExecutionContext();
            if (SCOUtils.collectionHasSerialisedElements(this.ownerMmd) && this.ownerMmd.getCollection().elementIsPersistent()) {
                for (Object pc : newValue) {
                    DNStateManager objSM = ec.findStateManager(pc);
                    if (objSM != null) continue;
                    objSM = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, pc, false, this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_COLLECTION_ELEMENT_PC);
                }
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023008", this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName(), "" + newValue.size()));
            }
            if (this.backingStore != null) {
                if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                    if (this.ownerSM.isFlushedToDatastore() || !this.ownerSM.getLifecycleState().isNew()) {
                        this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionClearOperation(this.ownerSM, this.backingStore));
                        for (Object element : newValue) {
                            this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionAddOperation<E>(this.ownerSM, this.backingStore, element));
                        }
                    }
                } else {
                    this.backingStore.clear(this.ownerSM);
                    try {
                        this.backingStore.addAll(this.ownerSM, newValue, this.useCache ? 0 : -1);
                    }
                    catch (NucleusDataStoreException dse) {
                        NucleusLogger.PERSISTENCE.warn(Localiser.msg("023013", "addAll", this.ownerMmd.getName(), dse));
                    }
                }
            }
            this.delegate.addAll(newValue);
            this.isCacheLoaded = true;
            this.makeDirty();
        }
    }

    @Override
    public void initialise(java.util.LinkedList c) {
        if (c != null) {
            ExecutionContext ec = this.ownerSM.getExecutionContext();
            if (SCOUtils.collectionHasSerialisedElements(this.ownerMmd) && this.ownerMmd.getCollection().elementIsPersistent()) {
                for (Object pc : c) {
                    DNStateManager objSM = ec.findStateManager(pc);
                    if (objSM != null) continue;
                    objSM = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, pc, false, this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_COLLECTION_ELEMENT_PC);
                }
            }
            if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
                this.isCacheLoaded = true;
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023007", this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName(), "" + c.size()));
            }
            this.delegate.clear();
            this.delegate.addAll(c);
        }
    }

    @Override
    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerSM, this.ownerMmd)) {
            this.loadFromStore();
        }
    }

    @Override
    public java.util.LinkedList getValue() {
        this.loadFromStore();
        return super.getValue();
    }

    @Override
    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    @Override
    public boolean isLoaded() {
        return this.useCache ? this.isCacheLoaded : false;
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023006", this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName()));
            }
            this.delegate.clear();
            ExecutionContext ec = this.ownerSM.getExecutionContext();
            RelationType relType = this.ownerMmd.getRelationType(ec.getClassLoaderResolver());
            int relatedMemberNum = -1;
            if (RelationType.isBidirectional(relType) && relType == RelationType.ONE_TO_MANY_BI) {
                AbstractMemberMetaData[] relMmds = this.ownerMmd.getRelatedMemberMetaData(ec.getClassLoaderResolver());
                relatedMemberNum = relMmds != null && relMmds.length > 0 ? relMmds[0].getAbsoluteFieldNumber() : -1;
            }
            Iterator iter = this.backingStore.iterator(this.ownerSM);
            while (iter.hasNext()) {
                DNStateManager elemSM;
                Object element = iter.next();
                if (relatedMemberNum >= 0 && !(elemSM = ec.findStateManager(element)).isFieldLoaded(relatedMemberNum)) {
                    elemSM.storeFieldValue(relatedMemberNum, this.ownerSM.getExternalObjectId());
                }
                this.delegate.add(element);
            }
            this.isCacheLoaded = true;
        }
    }

    @Override
    public Store getBackingStore() {
        return this.backingStore;
    }

    @Override
    public void updateEmbeddedElement(E element, int fieldNumber, Object value, boolean makeDirty) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedElement(this.ownerSM, element, fieldNumber, value);
        }
    }

    @Override
    public void unsetOwner() {
        super.unsetOwner();
        if (this.backingStore != null) {
            this.backingStore = null;
        }
    }

    @Override
    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.clone();
    }

    @Override
    public boolean contains(Object element) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.contains(element);
        }
        if (this.backingStore != null) {
            return this.backingStore.contains(this.ownerSM, element);
        }
        return this.delegate.contains(element);
    }

    @Override
    public boolean containsAll(Collection c) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            HashSet h = new HashSet(c);
            Iterator<E> iter = this.iterator();
            while (iter.hasNext()) {
                h.remove(iter.next());
            }
            return h.isEmpty();
        }
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        if (l.size() != this.size()) {
            return false;
        }
        Object[] elements = this.toArray();
        Object[] otherElements = l.toArray();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].equals(otherElements[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void forEach(Consumer action) {
        Objects.requireNonNull(action);
        for (E t : this) {
            action.accept(t);
        }
    }

    @Override
    public E get(int index) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.get(this.ownerSM, index);
        }
        return this.delegate.get(index);
    }

    @Override
    public E getFirst() {
        return this.get(0);
    }

    @Override
    public E getLast() {
        return this.get(this.size() - 1);
    }

    @Override
    public int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.hashCode();
    }

    @Override
    public int indexOf(Object element) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.indexOf(this.ownerSM, element);
        }
        return this.delegate.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOListIterator<E>(this, this.ownerSM, this.delegate, this.backingStore, this.useCache, -1);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOListIterator<E>(this, this.ownerSM, this.delegate, this.backingStore, this.useCache, index);
    }

    @Override
    public int lastIndexOf(Object element) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.lastIndexOf(this.ownerSM, element);
        }
        return this.delegate.lastIndexOf(element);
    }

    @Override
    public int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.size(this.ownerSM);
        }
        return this.delegate.size();
    }

    @Override
    public List<E> subList(int from, int to) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.subList(this.ownerSM, from, to);
        }
        return this.delegate.subList(from, to);
    }

    @Override
    public Object[] toArray() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM);
        }
        return this.delegate.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM, a);
        }
        return this.delegate.toArray(a);
    }

    @Override
    public void add(int index, E element) {
        if (!this.allowNulls && element == null) {
            throw new NullPointerException("Nulls not allowed for collection at field " + this.ownerMmd.getName() + " but element is null");
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new ListAddAtOperation<E>(this.ownerSM, this.backingStore, index, element));
            } else {
                try {
                    this.backingStore.add(this.ownerSM, element, index, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(Localiser.msg("023013", "add", this.ownerMmd.getName(), dse));
                }
            }
        }
        this.makeDirty();
        this.delegate.add(index, element);
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public boolean add(E element) {
        if (!this.allowNulls && element == null) {
            throw new NullPointerException("Nulls not allowed for collection at field " + this.ownerMmd.getName() + " but element is null");
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionAddOperation<E>(this.ownerSM, this.backingStore, element));
            } else {
                try {
                    backingSuccess = this.backingStore.add(this.ownerSM, element, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(Localiser.msg("023013", "add", this.ownerMmd.getName(), dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.add(element);
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public boolean addAll(Collection elements) {
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                for (Object element : elements) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionAddOperation<E>(this.ownerSM, this.backingStore, element));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.addAll(this.ownerSM, elements, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    throw new IllegalArgumentException(Localiser.msg("023013", "add", this.ownerMmd.getName(), dse), dse);
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.addAll(elements);
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public boolean addAll(int index, Collection elements) {
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                int pos = index;
                for (Object element : elements) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new ListAddAtOperation<E>(this.ownerSM, this.backingStore, pos++, element));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.addAll(this.ownerSM, elements, index, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    throw new IllegalArgumentException(Localiser.msg("023013", "addAll", this.ownerMmd.getName(), dse), dse);
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.addAll(index, elements);
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public void addFirst(E element) {
        this.add(0, element);
    }

    @Override
    public void addLast(E element) {
        this.add(this.size(), element);
    }

    @Override
    public void clear() {
        this.makeDirty();
        this.delegate.clear();
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionClearOperation(this.ownerSM, this.backingStore));
            } else {
                this.backingStore.clear(this.ownerSM);
            }
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public E remove(int index) {
        int size;
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int n = size = this.useCache ? this.delegate.size() : -1;
        if (this.useCache && (index < 0 || index >= size)) {
            throw new IndexOutOfBoundsException(index);
        }
        Object delegateObject = this.useCache ? this.delegate.remove(index) : null;
        Object backingObject = null;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                backingObject = delegateObject;
                this.ownerSM.getExecutionContext().addOperationToQueue(new ListRemoveAtOperation<E>(this.ownerSM, this.backingStore, index));
            } else {
                try {
                    backingObject = this.backingStore.remove(this.ownerSM, index, size);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(Localiser.msg("023013", "remove", this.ownerMmd.getName(), dse));
                    backingObject = null;
                }
            }
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingObject : delegateObject;
    }

    @Override
    public boolean remove(Object element) {
        return this.remove(element, true);
    }

    @Override
    public boolean remove(Object element, boolean allowCascadeDelete) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        boolean contained = this.delegate.contains(element);
        int indexOfElement = -1;
        if (this.useCache) {
            if (contained) {
                indexOfElement = this.delegate.indexOf(element);
            } else {
                return false;
            }
        }
        boolean delegateSuccess = this.delegate.remove(element);
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                backingSuccess = contained;
                if (backingSuccess) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation<Object>(this.ownerSM, this.backingStore, element, allowCascadeDelete));
                }
            } else if (indexOfElement >= 0) {
                E removedElement = this.backingStore.remove(this.ownerSM, indexOfElement, size);
                if (removedElement != null) {
                    backingSuccess = true;
                }
            } else {
                try {
                    backingSuccess = this.backingStore.remove(this.ownerSM, element, size, allowCascadeDelete);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(Localiser.msg("023013", "remove", this.ownerMmd.getName(), dse));
                    backingSuccess = false;
                }
            }
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public boolean removeAll(Collection elements) {
        if (elements == null) {
            throw new NullPointerException();
        }
        if (elements.isEmpty()) {
            return true;
        }
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int[] elementIndexes = this.useCache ? ClassUtils.getIndexesOfCollectionInList(this.delegate, elements) : null;
        int size = this.useCache ? this.delegate.size() : -1;
        boolean delegateSuccess = this.delegate.removeAll(elements);
        if (this.backingStore != null && this.ownerSM != null) {
            boolean backingSuccess = true;
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                HashSet contained = new HashSet();
                for (Object elem : elements) {
                    if (!this.contains(elem)) continue;
                    contained.add(elem);
                }
                if (!contained.isEmpty()) {
                    backingSuccess = false;
                    for (Object element : contained) {
                        backingSuccess = true;
                        this.ownerSM.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation<E>(this.ownerSM, this.backingStore, element, true));
                    }
                }
            } else {
                try {
                    backingSuccess = this.backingStore.removeAll(this.ownerSM, elements, size, elementIndexes);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(Localiser.msg("023013", "removeAll", this.ownerMmd.getName(), dse));
                    backingSuccess = false;
                }
            }
            if (!this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
            return backingSuccess;
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return delegateSuccess;
    }

    @Override
    public E removeFirst() {
        return this.remove(0);
    }

    @Override
    public E removeLast() {
        return this.remove(this.size() - 1);
    }

    @Override
    public boolean retainAll(Collection c) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean modified = false;
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            E element = iter.next();
            if (c.contains(element)) continue;
            iter.remove();
            modified = true;
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return modified;
    }

    @Override
    public E set(int index, E element, boolean allowDependentField) {
        if (!this.allowNulls && element == null) {
            throw new NullPointerException("Nulls not allowed for collection at field " + this.ownerMmd.getName() + " but element is null");
        }
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        E delegateReturn = this.delegate.set(index, element);
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new ListSetOperation<E>(this.ownerSM, this.backingStore, index, element, allowDependentField));
            } else {
                this.backingStore.set(this.ownerSM, index, element, allowDependentField);
            }
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return delegateReturn;
    }

    @Override
    public E set(int index, E element) {
        return this.set(index, element, !this.sorting);
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new java.util.LinkedList(this.delegate);
        }
        return new java.util.LinkedList(this.delegate);
    }

    @Override
    public Spliterator spliterator() {
        if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
            this.loadFromStore();
        }
        return this.delegate.spliterator();
    }

    @Override
    public Stream stream() {
        if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
            this.loadFromStore();
        }
        return this.delegate.stream();
    }

    @Override
    public Stream parallelStream() {
        if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
            this.loadFromStore();
        }
        return this.delegate.parallelStream();
    }
}

