/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.compiler;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.query.JDOQLQueryHelper;
import org.datanucleus.store.query.compiler.JDOQLParser;
import org.datanucleus.store.query.compiler.JavaQueryCompiler;
import org.datanucleus.store.query.compiler.PropertySymbol;
import org.datanucleus.store.query.compiler.QueryCompilation;
import org.datanucleus.store.query.compiler.SymbolTable;
import org.datanucleus.store.query.compiler.VarThisCompilationOptimiser;
import org.datanucleus.store.query.expression.DyadicExpression;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.query.expression.InvokeExpression;
import org.datanucleus.store.query.expression.Literal;
import org.datanucleus.store.query.expression.OrderExpression;
import org.datanucleus.store.query.expression.ParameterExpression;
import org.datanucleus.store.query.expression.PrimaryExpression;
import org.datanucleus.store.query.expression.VariableExpression;
import org.datanucleus.util.Imports;
import org.datanucleus.util.Localiser;

public class JDOQLCompiler
extends JavaQueryCompiler {
    boolean allowAll = false;

    public JDOQLCompiler(PersistenceNucleusContext nucCtx, ClassLoaderResolver clr, String from, Class candidateClass, Collection candidates, String filter, Imports imports, String ordering, String result, String grouping, String having, String params, String variables, String update) {
        super(nucCtx, clr, from, candidateClass, candidates, filter, imports, ordering, result, grouping, having, params, variables, update);
    }

    public void setAllowAll(boolean allow) {
        this.allowAll = allow;
    }

    @Override
    public QueryCompilation compile(Map parameters, Map subqueryMap) {
        Boolean val;
        int i;
        this.parser = new JDOQLParser();
        this.parser.setExplicitParameters(this.parameters != null);
        if (this.options != null && this.options.containsKey("datanucleus.query.jdoql.strict")) {
            this.parser.setStrict(Boolean.parseBoolean((String)this.options.get("datanucleus.query.jdoql.strict")));
        }
        this.symtbl = new SymbolTable();
        this.symtbl.setSymbolResolver(this);
        if (this.parentCompiler != null) {
            this.symtbl.setParentSymbolTable(this.parentCompiler.symtbl);
        }
        if (subqueryMap != null && !subqueryMap.isEmpty()) {
            for (String subqueryName : subqueryMap.keySet()) {
                PropertySymbol sym = new PropertySymbol(subqueryName);
                sym.setType(2);
                this.symtbl.addSymbol(sym);
            }
        }
        Expression[] exprFrom = this.compileFrom();
        this.compileCandidatesParametersVariables(parameters);
        Expression exprFilter = this.compileFilter();
        Expression[] exprOrdering = this.compileOrdering();
        Expression[] exprResult = this.compileResult();
        Expression[] exprGrouping = this.compileGrouping();
        Expression exprHaving = this.compileHaving();
        Expression[] exprUpdate = this.compileUpdate();
        if (exprGrouping != null) {
            if (exprResult != null) {
                for (i = 0; i < exprResult.length; ++i) {
                    if (JDOQLCompiler.isExpressionGroupingOrAggregate(exprResult[i], exprGrouping)) continue;
                    throw new NucleusUserException(Localiser.msg("021086", exprResult[i]));
                }
            }
            if (exprOrdering != null) {
                for (i = 0; i < exprOrdering.length; ++i) {
                    if (JDOQLCompiler.isExpressionGroupingOrAggregate(exprOrdering[i], exprGrouping)) continue;
                    throw new NucleusUserException(Localiser.msg("021087", exprOrdering[i]));
                }
            }
        }
        if (exprHaving != null && !JDOQLCompiler.containsOnlyGroupingOrAggregates(exprHaving, exprGrouping)) {
            throw new NucleusUserException(Localiser.msg("021088", exprHaving));
        }
        if (exprResult != null) {
            for (i = 0; i < exprResult.length; ++i) {
                List<Expression> args;
                InvokeExpression invokeExpr;
                if (!(exprResult[i] instanceof InvokeExpression) || !JDOQLCompiler.isMethodNameAggregate((invokeExpr = (InvokeExpression)exprResult[i]).getOperation()) || (args = invokeExpr.getArguments()) != null && args.size() == 1) continue;
                throw new NucleusUserException(Localiser.msg("021089", invokeExpr.getOperation()));
            }
        }
        QueryCompilation compilation = new QueryCompilation(this.candidateClass, this.candidateAlias, this.symtbl, exprResult, exprFrom, exprFilter, exprGrouping, exprHaving, exprOrdering, exprUpdate);
        compilation.setQueryLanguage(this.getLanguage());
        if (this.options != null && this.options.containsKey("datanucleus.query.compileOptimiseVarThis") && (val = (Boolean)this.options.get("datanucleus.query.compileOptimiseVarThis")) == Boolean.TRUE) {
            VarThisCompilationOptimiser optimiser = new VarThisCompilationOptimiser(compilation, this.metaDataManager, this.clr);
            optimiser.optimise();
        }
        return compilation;
    }

    @Override
    public Expression[] compileUpdate() {
        if (this.allowAll && this.update != null) {
            ((JDOQLParser)this.parser).allowSingleEquals(true);
        }
        Expression[] result = super.compileUpdate();
        ((JDOQLParser)this.parser).allowSingleEquals(false);
        return result;
    }

    private static boolean containsOnlyGroupingOrAggregates(Expression expr, Expression[] exprGrouping) {
        if (expr == null) {
            return true;
        }
        if (expr instanceof DyadicExpression) {
            Expression left = expr.getLeft();
            Expression right = expr.getRight();
            if (!JDOQLCompiler.containsOnlyGroupingOrAggregates(left, exprGrouping)) {
                return false;
            }
            return JDOQLCompiler.containsOnlyGroupingOrAggregates(right, exprGrouping);
        }
        if (expr instanceof InvokeExpression) {
            InvokeExpression invExpr = (InvokeExpression)expr;
            if (JDOQLCompiler.isExpressionGroupingOrAggregate(invExpr, exprGrouping)) {
                return true;
            }
            Expression invokedExpr = invExpr.getLeft();
            if (invokedExpr != null && !JDOQLCompiler.containsOnlyGroupingOrAggregates(invokedExpr, exprGrouping)) {
                return false;
            }
            List<Expression> invArgs = invExpr.getArguments();
            if (invArgs != null) {
                for (Expression argExpr : invArgs) {
                    if (JDOQLCompiler.containsOnlyGroupingOrAggregates(argExpr, exprGrouping)) continue;
                    return false;
                }
            }
            return true;
        }
        if (expr instanceof PrimaryExpression) {
            return JDOQLCompiler.isExpressionGroupingOrAggregate(expr, exprGrouping);
        }
        if (expr instanceof Literal) {
            return true;
        }
        if (expr instanceof ParameterExpression) {
            return true;
        }
        return expr instanceof VariableExpression;
    }

    private static boolean isMethodNameAggregate(String methodName) {
        return methodName.equals("avg") || methodName.equals("AVG") || methodName.equals("count") || methodName.equals("COUNT") || methodName.equals("sum") || methodName.equals("SUM") || methodName.equals("min") || methodName.equals("MIN") || methodName.equals("max") || methodName.equals("MAX");
    }

    private static boolean isExpressionGroupingOrAggregate(Expression expr, Expression[] exprGrouping) {
        if (expr instanceof InvokeExpression) {
            String methodName;
            InvokeExpression invExpr = (InvokeExpression)expr;
            if (invExpr.getLeft() == null && JDOQLCompiler.isMethodNameAggregate(methodName = invExpr.getOperation())) {
                return true;
            }
            for (int j = 0; j < exprGrouping.length; ++j) {
                if (!(exprGrouping[j] instanceof InvokeExpression) || !invExpr.toStringWithoutAlias().equalsIgnoreCase(exprGrouping[j].toString())) continue;
                return true;
            }
        } else if (expr instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)expr;
            String id = primExpr.getId();
            if (id.equals("this")) {
                return true;
            }
            for (int j = 0; j < exprGrouping.length; ++j) {
                String groupId;
                if (!(exprGrouping[j] instanceof PrimaryExpression) || !id.equals(groupId = ((PrimaryExpression)exprGrouping[j]).getId())) continue;
                return true;
            }
        } else {
            if (expr instanceof OrderExpression) {
                Expression orderExpr = ((OrderExpression)expr).getLeft();
                return JDOQLCompiler.isExpressionGroupingOrAggregate(orderExpr, exprGrouping);
            }
            if (expr instanceof Literal) {
                return true;
            }
            if (expr instanceof ParameterExpression) {
                return true;
            }
            if (expr instanceof VariableExpression) {
                return true;
            }
            String exprStr = expr.toString();
            for (int j = 0; j < exprGrouping.length; ++j) {
                if (!exprGrouping[j].toString().equals(exprStr)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsImplicitVariables() {
        return this.variables == null;
    }

    @Override
    public boolean caseSensitiveSymbolNames() {
        return true;
    }

    @Override
    public String getLanguage() {
        return "JDOQL";
    }

    @Override
    protected boolean isKeyword(String name) {
        if (name == null) {
            return false;
        }
        return JDOQLQueryHelper.isKeyword(name);
    }
}

