/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.types.SCOCollection;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.containers.ElementContainerHandler;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class RelationshipManagerImpl
implements RelationshipManager {
    final DNStateManager ownerSM;
    final ExecutionContext ec;
    final Object pc;
    final Map<Integer, List<RelationChange>> fieldChanges;

    public RelationshipManagerImpl(DNStateManager sm) {
        this.ownerSM = sm;
        this.ec = sm.getExecutionContext();
        this.pc = sm.getObject();
        this.fieldChanges = new HashMap<Integer, List<RelationChange>>();
    }

    @Override
    public void clearFields() {
        this.fieldChanges.clear();
    }

    @Override
    public void relationChange(int fieldNumber, Object oldValue, Object newValue) {
        block17: {
            Collection newColl;
            Collection oldColl;
            AbstractMemberMetaData mmd;
            RelationType relationType;
            List<RelationChange> changes;
            block18: {
                if (this.ec.isManagingRelations()) {
                    return;
                }
                Integer fieldKey = fieldNumber;
                changes = this.fieldChanges.get(fieldKey);
                if (changes == null) {
                    changes = new ArrayList<RelationChange>();
                    this.fieldChanges.put(fieldKey, changes);
                }
                if ((relationType = (mmd = this.ownerSM.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber)).getRelationType(this.ec.getClassLoaderResolver())) == RelationType.ONE_TO_ONE_BI || relationType == RelationType.MANY_TO_ONE_BI) {
                    if (changes.isEmpty()) {
                        changes.add(new RelationChange(ChangeType.CHANGE_OBJECT, newValue, oldValue));
                    }
                    return;
                }
                if (relationType != RelationType.ONE_TO_MANY_BI && relationType != RelationType.MANY_TO_MANY_BI || !mmd.hasCollection()) break block17;
                oldColl = (Collection)oldValue;
                newColl = (Collection)newValue;
                if (oldColl != null) break block18;
                if (newColl == null) break block17;
                for (Object newElem : newColl) {
                    changes.add(new RelationChange(ChangeType.ADD_OBJECT, newElem));
                }
                break block17;
            }
            if (newColl == null) {
                AbstractMemberMetaData relatedMmd = mmd.getRelatedMemberMetaData(this.ec.getClassLoaderResolver())[0];
                for (Object element : oldColl) {
                    if (this.ownerSM.getLifecycleState().isDeleted) {
                        this.ec.removeObjectFromLevel2Cache(this.ec.getApiAdapter().getIdForObject(element));
                        DNStateManager elementSM = this.ec.findStateManager(element);
                        if (relationType == RelationType.ONE_TO_MANY_BI) {
                            this.ec.getRelationshipManager(elementSM).relationChange(relatedMmd.getAbsoluteFieldNumber(), this.ownerSM.getObject(), null);
                            continue;
                        }
                        if (relationType != RelationType.MANY_TO_MANY_BI) continue;
                        this.ec.getRelationshipManager(elementSM).relationRemove(relatedMmd.getAbsoluteFieldNumber(), this.ownerSM.getObject());
                        continue;
                    }
                    changes.add(new RelationChange(ChangeType.REMOVE_OBJECT, element));
                }
            } else {
                for (Object newElem : newColl) {
                    boolean alreadyExists = false;
                    for (Object oldElem : oldColl) {
                        if (newElem != oldElem) continue;
                        alreadyExists = true;
                        break;
                    }
                    if (alreadyExists) continue;
                    DNStateManager elemSM = this.ec.findStateManager(newElem);
                    if (elemSM != null) {
                        DNStateManager oldOwnerSM;
                        AbstractMemberMetaData elemMmd = mmd.getRelatedMemberMetaData(this.ec.getClassLoaderResolver())[0];
                        Object oldOwner = elemSM.provideField(elemMmd.getAbsoluteFieldNumber());
                        if (!elemSM.isFieldLoaded(elemMmd.getAbsoluteFieldNumber())) {
                            elemSM.loadField(elemMmd.getAbsoluteFieldNumber());
                        }
                        if (oldOwner != null && (oldOwnerSM = this.ec.findStateManager(oldOwner)) != null) {
                            this.ec.getRelationshipManager(oldOwnerSM).relationRemove(fieldNumber, newElem);
                        }
                    }
                    this.relationAdd(fieldNumber, newElem);
                }
                for (Object oldElem : oldColl) {
                    boolean stillExists = false;
                    for (Object newElem : newColl) {
                        if (oldElem != newElem) continue;
                        stillExists = true;
                        break;
                    }
                    if (stillExists) continue;
                    this.relationRemove(fieldNumber, oldElem);
                }
            }
        }
    }

    @Override
    public void relationAdd(int fieldNumber, Object val) {
        Integer fieldKey;
        List<RelationChange> changeList;
        AbstractMemberMetaData relatedMmd;
        if (this.ec.isManagingRelations()) {
            return;
        }
        AbstractMemberMetaData mmd = this.ownerSM.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(this.ec.getClassLoaderResolver());
        if (relationType != RelationType.ONE_TO_MANY_BI && relationType != RelationType.MANY_TO_MANY_BI) {
            return;
        }
        DNStateManager elemSM = this.ec.findStateManager(val);
        if (elemSM != null && elemSM.isFieldLoaded((relatedMmd = mmd.getRelatedMemberMetaData(this.ec.getClassLoaderResolver())[0]).getAbsoluteFieldNumber())) {
            Object currentOwnerId = this.ec.getApiAdapter().getIdForObject(elemSM.provideField(relatedMmd.getAbsoluteFieldNumber()));
            this.ec.removeObjectFromLevel2Cache(currentOwnerId);
        }
        if ((changeList = this.fieldChanges.get(fieldKey = Integer.valueOf(fieldNumber))) == null) {
            changeList = new ArrayList<RelationChange>();
            this.fieldChanges.put(fieldKey, changeList);
        }
        this.ec.removeObjectFromLevel2Cache(this.ec.getApiAdapter().getIdForObject(val));
        changeList.add(new RelationChange(ChangeType.ADD_OBJECT, val));
    }

    @Override
    public void relationRemove(int fieldNumber, Object val) {
        if (this.ec.isManagingRelations()) {
            return;
        }
        AbstractMemberMetaData mmd = this.ownerSM.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(this.ec.getClassLoaderResolver());
        if (relationType != RelationType.ONE_TO_MANY_BI && relationType != RelationType.MANY_TO_MANY_BI) {
            return;
        }
        Integer fieldKey = fieldNumber;
        List<RelationChange> changeList = this.fieldChanges.get(fieldKey);
        if (changeList == null) {
            changeList = new ArrayList<RelationChange>();
            this.fieldChanges.put(fieldKey, changeList);
        }
        this.ec.removeObjectFromLevel2Cache(this.ec.getApiAdapter().getIdForObject(val));
        changeList.add(new RelationChange(ChangeType.REMOVE_OBJECT, val));
    }

    @Override
    public boolean managesField(int fieldNumber) {
        return this.fieldChanges.containsKey(fieldNumber);
    }

    @Override
    public void checkConsistency() {
        for (Map.Entry<Integer, List<RelationChange>> entry : this.fieldChanges.entrySet()) {
            ClassLoaderResolver clr;
            int fieldNumber = entry.getKey();
            List<RelationChange> changes = entry.getValue();
            AbstractMemberMetaData mmd = this.ownerSM.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            RelationType relationType = mmd.getRelationType(clr = this.ec.getClassLoaderResolver());
            if (relationType == RelationType.ONE_TO_ONE_BI) {
                this.checkOneToOneBidirectionalRelation(mmd, clr, this.ec, changes);
                continue;
            }
            if (relationType == RelationType.MANY_TO_ONE_BI) {
                this.checkManyToOneBidirectionalRelation(mmd, clr, this.ec, changes);
                continue;
            }
            if (relationType == RelationType.ONE_TO_MANY_BI) {
                this.checkOneToManyBidirectionalRelation(mmd, clr, this.ec, changes);
                continue;
            }
            if (relationType != RelationType.MANY_TO_MANY_BI) continue;
            this.checkManyToManyBidirectionalRelation(mmd, clr, this.ec, changes);
        }
    }

    @Override
    public void process() {
        for (Map.Entry<Integer, List<RelationChange>> entry : this.fieldChanges.entrySet()) {
            ClassLoaderResolver clr;
            int fieldNumber = entry.getKey();
            List<RelationChange> changes = entry.getValue();
            AbstractMemberMetaData mmd = this.ownerSM.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            RelationType relationType = mmd.getRelationType(clr = this.ec.getClassLoaderResolver());
            if (relationType == RelationType.ONE_TO_ONE_BI) {
                this.processOneToOneBidirectionalRelation(mmd, clr, this.ec, changes);
                continue;
            }
            if (relationType == RelationType.MANY_TO_ONE_BI) {
                this.processManyToOneBidirectionalRelation(mmd, clr, this.ec, changes);
                continue;
            }
            if (relationType == RelationType.ONE_TO_MANY_BI) {
                this.processOneToManyBidirectionalRelation(mmd, clr, this.ec, changes);
                continue;
            }
            if (relationType != RelationType.MANY_TO_MANY_BI) continue;
            this.processManyToManyBidirectionalRelation(mmd, clr, this.ec, changes);
        }
    }

    protected void checkOneToOneBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec, List<RelationChange> changes) {
        for (RelationChange change : changes) {
            RelationshipManager newRelMgr;
            Object newValueFieldValue;
            Object newValue;
            if (change.type != ChangeType.CHANGE_OBJECT || (newValue = this.ownerSM.provideField(mmd.getAbsoluteFieldNumber())) == null) continue;
            AbstractMemberMetaData relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, newValue);
            DNStateManager newSM = ec.findStateManager(newValue);
            if (newSM == null || relatedMmd == null) continue;
            if (!newSM.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber())) {
                newSM.loadField(relatedMmd.getAbsoluteFieldNumber());
            }
            if ((newValueFieldValue = newSM.provideField(relatedMmd.getAbsoluteFieldNumber())) == this.pc || (newRelMgr = ec.getRelationshipManager(newSM)) == null || !newRelMgr.managesField(relatedMmd.getAbsoluteFieldNumber())) continue;
            if (newValueFieldValue == null) {
                String msg = Localiser.msg("013003", StringUtils.toJVMIDString(this.pc), mmd.getName(), StringUtils.toJVMIDString(newValue), relatedMmd.getName());
                NucleusLogger.PERSISTENCE.error(msg);
                throw new NucleusUserException(msg);
            }
            String msg = Localiser.msg("013002", StringUtils.toJVMIDString(this.pc), mmd.getName(), StringUtils.toJVMIDString(newValue), relatedMmd.getName(), StringUtils.toJVMIDString(newValueFieldValue));
            NucleusLogger.PERSISTENCE.error(msg);
            throw new NucleusUserException(msg);
        }
    }

    protected void checkOneToManyBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec, List<RelationChange> changes) {
        for (RelationChange change : changes) {
            Object newValueFieldValue;
            RelationshipManager newElementRelMgr;
            DNStateManager newElementSM;
            AbstractMemberMetaData relatedMmd;
            if (change.type == ChangeType.ADD_OBJECT) {
                if (ec.getApiAdapter().isDeleted(change.value)) {
                    throw new NucleusUserException(Localiser.msg("013008", StringUtils.toJVMIDString(this.pc), mmd.getName(), StringUtils.toJVMIDString(change.value)));
                }
                relatedMmd = mmd.getRelatedMemberMetaData(clr)[0];
                newElementSM = ec.findStateManager(change.value);
                if (newElementSM == null || !newElementSM.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber()) || (newElementRelMgr = ec.getRelationshipManager(newElementSM)) == null || !newElementRelMgr.managesField(relatedMmd.getAbsoluteFieldNumber()) || (newValueFieldValue = newElementSM.provideField(relatedMmd.getAbsoluteFieldNumber())) == this.pc || newValueFieldValue == null) continue;
                ApiAdapter api = ec.getApiAdapter();
                Object id1 = api.getIdForObject(this.pc);
                Object id2 = api.getIdForObject(newValueFieldValue);
                if (id1 != null && id2 != null && id1.equals(id2)) continue;
                throw new NucleusUserException(Localiser.msg("013009", StringUtils.toJVMIDString(this.pc), mmd.getName(), StringUtils.toJVMIDString(change.value), StringUtils.toJVMIDString(newValueFieldValue)));
            }
            if (change.type != ChangeType.REMOVE_OBJECT || ec.getApiAdapter().isDeleted(change.value)) continue;
            relatedMmd = mmd.getRelatedMemberMetaData(clr)[0];
            newElementSM = ec.findStateManager(change.value);
            if (newElementSM == null || !newElementSM.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber()) || (newElementRelMgr = ec.getRelationshipManager(newElementSM)) == null || !newElementRelMgr.managesField(relatedMmd.getAbsoluteFieldNumber()) || (newValueFieldValue = newElementSM.provideField(relatedMmd.getAbsoluteFieldNumber())) != this.pc) continue;
            throw new NucleusUserException(Localiser.msg("013010", StringUtils.toJVMIDString(this.pc), mmd.getName(), StringUtils.toJVMIDString(change.value)));
        }
    }

    protected void checkManyToOneBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec, List<RelationChange> changes) {
    }

    protected void checkManyToManyBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec, List<RelationChange> changes) {
    }

    protected void processOneToOneBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec, List<RelationChange> changes) {
        for (RelationChange change : changes) {
            Object replaceValue;
            AbstractMemberMetaData relatedMmd;
            if (change.type != ChangeType.CHANGE_OBJECT) continue;
            Object oldValue = change.oldValue;
            Object newValue = this.ownerSM.provideField(mmd.getAbsoluteFieldNumber());
            Object object = oldValue = mmd.isSingleCollection() ? SCOUtils.singleCollectionValue(ec.getTypeManager(), oldValue) : oldValue;
            if (oldValue != null) {
                boolean oldIsDeleted;
                relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, oldValue);
                DNStateManager oldSM = ec.findStateManager(oldValue);
                if (oldSM != null && !(oldIsDeleted = ec.getApiAdapter().isDeleted(oldSM.getObject()))) {
                    if (!oldSM.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber())) {
                        oldSM.loadField(relatedMmd.getAbsoluteFieldNumber());
                    }
                    Object oldValueFieldValue = oldSM.provideField(relatedMmd.getAbsoluteFieldNumber());
                    Object object2 = oldValueFieldValue = mmd.isSingleCollection() ? SCOUtils.singleCollectionValue(ec.getTypeManager(), oldValueFieldValue) : oldValueFieldValue;
                    if (oldValueFieldValue != null && oldValueFieldValue == this.pc) {
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug(Localiser.msg("013004", StringUtils.toJVMIDString(oldValue), relatedMmd.getFullFieldName(), StringUtils.toJVMIDString(this.pc), StringUtils.toJVMIDString(newValue)));
                        }
                        replaceValue = null;
                        if (relatedMmd.isSingleCollection()) {
                            replaceValue = ec.getTypeManager().getContainerHandler(relatedMmd.getType()).newContainer(mmd);
                        }
                        oldSM.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), replaceValue);
                    }
                }
            }
            if ((newValue = mmd.isSingleCollection() ? SCOUtils.singleCollectionValue(ec.getTypeManager(), newValue) : newValue) == null) continue;
            relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, newValue);
            DNStateManager newSM = ec.findStateManager(newValue, true);
            if (newSM == null || relatedMmd == null) continue;
            if (!newSM.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber())) {
                newSM.loadField(relatedMmd.getAbsoluteFieldNumber());
            }
            Object newValueFieldValue = newSM.provideField(relatedMmd.getAbsoluteFieldNumber());
            if (relatedMmd.isSingleCollection()) {
                newValueFieldValue = SCOUtils.singleCollectionValue(ec.getTypeManager(), newValueFieldValue);
            }
            if (newValueFieldValue == null) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("013005", StringUtils.toJVMIDString(newValue), relatedMmd.getFullFieldName(), StringUtils.toJVMIDString(this.pc)));
                }
                Object replaceValue2 = this.pc;
                if (relatedMmd.isSingleCollection()) {
                    ElementContainerHandler containerHandler = (ElementContainerHandler)ec.getTypeManager().getContainerHandler(relatedMmd.getType());
                    replaceValue2 = containerHandler.newContainer(null, this.pc);
                }
                newSM.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), replaceValue2);
                continue;
            }
            if (newValueFieldValue == this.pc) continue;
            DNStateManager newValueFieldSM = ec.findStateManager(newValueFieldValue);
            if (newValueFieldSM != null) {
                if (!newValueFieldSM.isFieldLoaded(mmd.getAbsoluteFieldNumber())) {
                    newValueFieldSM.loadField(mmd.getAbsoluteFieldNumber());
                }
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("013004", StringUtils.toJVMIDString(newValueFieldValue), mmd.getFullFieldName(), StringUtils.toJVMIDString(newValue), StringUtils.toJVMIDString(this.pc)));
                }
                newValueFieldSM.replaceFieldValue(mmd.getAbsoluteFieldNumber(), null);
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("013005", StringUtils.toJVMIDString(newValue), relatedMmd.getFullFieldName(), StringUtils.toJVMIDString(this.pc)));
            }
            replaceValue = this.pc;
            if (relatedMmd.isSingleCollection()) {
                ElementContainerHandler containerHandler = (ElementContainerHandler)ec.getTypeManager().getContainerHandler(relatedMmd.getType());
                replaceValue = containerHandler.newContainer(null, this.pc);
            }
            newSM.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), replaceValue);
        }
    }

    protected void processOneToManyBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec, List<RelationChange> changes) {
        for (RelationChange change : changes) {
            Object currentVal;
            AbstractMemberMetaData relatedMmd;
            Object attached;
            if (change.type != ChangeType.ADD_OBJECT && change.type != ChangeType.REMOVE_OBJECT) continue;
            DNStateManager sm = ec.findStateManager(change.value);
            if (sm == null && ec.getApiAdapter().isDetached(change.value) && (attached = ec.getAttachedObjectForId(ec.getApiAdapter().getIdForObject(change.value))) != null) {
                sm = ec.findStateManager(attached);
            }
            if (sm == null) continue;
            if (change.type == ChangeType.ADD_OBJECT) {
                relatedMmd = mmd.getRelatedMemberMetaData(clr)[0];
                if (sm.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber())) {
                    currentVal = sm.provideField(relatedMmd.getAbsoluteFieldNumber());
                    if (currentVal == this.ownerSM.getObject()) continue;
                    sm.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), this.ownerSM.getObject());
                    continue;
                }
                ec.removeObjectFromLevel2Cache(sm.getInternalObjectId());
                continue;
            }
            if (change.type != ChangeType.REMOVE_OBJECT) continue;
            relatedMmd = mmd.getRelatedMemberMetaData(clr)[0];
            if (sm.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber())) {
                currentVal = sm.provideField(relatedMmd.getAbsoluteFieldNumber());
                if (currentVal != this.ownerSM.getObject()) continue;
                sm.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), null);
                continue;
            }
            ec.removeObjectFromLevel2Cache(sm.getInternalObjectId());
        }
    }

    protected void processManyToOneBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec, List<RelationChange> changes) {
        for (RelationChange change : changes) {
            AbstractMemberMetaData relatedMmd;
            if (change.type != ChangeType.CHANGE_OBJECT) continue;
            Object oldValue = change.oldValue;
            Object newValue = this.ownerSM.provideField(mmd.getAbsoluteFieldNumber());
            if (oldValue != null) {
                relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, oldValue);
                DNStateManager oldSM = ec.findStateManager(oldValue);
                if (oldSM != null && relatedMmd != null && oldSM.getLoadedFields()[relatedMmd.getAbsoluteFieldNumber()]) {
                    Collection oldColl;
                    Object oldContainerValue;
                    if (oldSM.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber()) && (oldContainerValue = oldSM.provideField(relatedMmd.getAbsoluteFieldNumber())) instanceof Collection && (oldColl = (Collection)oldContainerValue).contains(this.pc)) {
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug(Localiser.msg("013006", StringUtils.toJVMIDString(this.pc), mmd.getFullFieldName(), relatedMmd.getFullFieldName(), StringUtils.toJVMIDString(oldValue)));
                        }
                        if (oldColl instanceof SCOCollection) {
                            ((SCOCollection)((Object)oldColl)).remove(this.pc, false);
                        } else {
                            oldColl.remove(this.pc);
                        }
                    }
                } else if (oldSM != null) {
                    ec.removeObjectFromLevel2Cache(oldSM.getInternalObjectId());
                }
            }
            if (newValue == null) continue;
            relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, newValue);
            DNStateManager newSM = ec.findStateManager(newValue);
            if (newSM != null && relatedMmd != null && newSM.getLoadedFields()[relatedMmd.getAbsoluteFieldNumber()]) {
                Collection newColl;
                Object newContainerValue = newSM.provideField(relatedMmd.getAbsoluteFieldNumber());
                if (!(newContainerValue instanceof Collection) || (newColl = (Collection)newContainerValue).contains(this.pc)) continue;
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("013007", StringUtils.toJVMIDString(this.pc), mmd.getFullFieldName(), relatedMmd.getFullFieldName(), StringUtils.toJVMIDString(newValue)));
                }
                newColl.add(this.pc);
                continue;
            }
            ec.removeObjectFromLevel2Cache(ec.getApiAdapter().getIdForObject(newValue));
        }
    }

    protected void processManyToManyBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec, List<RelationChange> changes) {
        for (RelationChange change : changes) {
            Collection currentVal;
            AbstractMemberMetaData relatedMmd;
            Object attached;
            if (change.type != ChangeType.ADD_OBJECT && change.type != ChangeType.REMOVE_OBJECT) continue;
            DNStateManager sm = ec.findStateManager(change.value);
            if (sm == null && ec.getApiAdapter().isDetached(change.value) && (attached = ec.getAttachedObjectForId(ec.getApiAdapter().getIdForObject(change.value))) != null) {
                sm = ec.findStateManager(attached);
            }
            if (sm == null) continue;
            if (change.type == ChangeType.ADD_OBJECT) {
                relatedMmd = mmd.getRelatedMemberMetaData(clr)[0];
                ec.removeObjectFromLevel2Cache(sm.getInternalObjectId());
                ec.removeObjectFromLevel2Cache(this.ownerSM.getInternalObjectId());
                if (this.ownerSM.isFieldLoaded(mmd.getAbsoluteFieldNumber()) && !this.ownerSM.getLifecycleState().isDeleted && (currentVal = (Collection)this.ownerSM.provideField(mmd.getAbsoluteFieldNumber())) != null && !currentVal.contains(sm.getObject())) {
                    currentVal.add(sm.getObject());
                }
                if (!sm.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber()) || (currentVal = (Collection)sm.provideField(relatedMmd.getAbsoluteFieldNumber())) == null || currentVal.contains(this.ownerSM.getObject())) continue;
                currentVal.add(this.ownerSM.getObject());
                continue;
            }
            if (change.type != ChangeType.REMOVE_OBJECT) continue;
            relatedMmd = mmd.getRelatedMemberMetaData(clr)[0];
            ec.removeObjectFromLevel2Cache(sm.getInternalObjectId());
            ec.removeObjectFromLevel2Cache(this.ownerSM.getInternalObjectId());
            if (this.ownerSM.isFieldLoaded(mmd.getAbsoluteFieldNumber()) && !this.ownerSM.getLifecycleState().isDeleted) {
                currentVal = (Collection)this.ownerSM.provideField(mmd.getAbsoluteFieldNumber());
                if (!sm.getLifecycleState().isDeleted && currentVal != null && currentVal.contains(sm.getObject())) {
                    currentVal.remove(sm.getObject());
                } else {
                    this.ownerSM.unloadField(mmd.getName());
                }
            }
            if (!sm.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber()) || sm.getLifecycleState().isDeleted || (currentVal = (Collection)sm.provideField(relatedMmd.getAbsoluteFieldNumber())) == null || !currentVal.contains(this.ownerSM.getObject())) continue;
            currentVal.remove(this.ownerSM.getObject());
        }
    }

    private static class RelationChange {
        ChangeType type;
        Object value;
        Object oldValue;

        public RelationChange(ChangeType type, Object val) {
            this.type = type;
            this.value = val;
        }

        public RelationChange(ChangeType type, Object newVal, Object oldVal) {
            this.type = type;
            this.value = newVal;
            this.oldValue = oldVal;
        }

        public String toString() {
            if (this.oldValue != null) {
                return "RelationChange type=" + this.type + " value=" + StringUtils.toJVMIDString(this.oldValue) + " -> " + StringUtils.toJVMIDString(this.value);
            }
            return "RelationChange type=" + this.type + " value=" + StringUtils.toJVMIDString(this.value);
        }
    }

    private static enum ChangeType {
        ADD_OBJECT,
        REMOVE_OBJECT,
        CHANGE_OBJECT;

    }
}

