/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.datanucleus.BeanValidationHandler;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.Configuration;
import org.datanucleus.DetachState;
import org.datanucleus.ExecutionContext;
import org.datanucleus.ExecutionContextListener;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchGroupManager;
import org.datanucleus.FetchPlan;
import org.datanucleus.FetchPlanState;
import org.datanucleus.ManagedRelationsHandler;
import org.datanucleus.PersistableObjectType;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.ReachabilityAtCommitHandler;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CacheUniqueKey;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.L2CachePopulateFieldManager;
import org.datanucleus.cache.Level1Cache;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.cache.SoftRefCache;
import org.datanucleus.cache.StrongRefCache;
import org.datanucleus.cache.WeakRefCache;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancer.ImplementationCreator;
import org.datanucleus.exceptions.ClassNotDetachableException;
import org.datanucleus.exceptions.ClassNotPersistableException;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.CommitStateTransitionException;
import org.datanucleus.exceptions.NoPersistenceInformationException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusFatalUserException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.ObjectDetachedException;
import org.datanucleus.exceptions.RollbackStateTransitionException;
import org.datanucleus.exceptions.TransactionActiveOnCloseException;
import org.datanucleus.exceptions.TransactionNotActiveException;
import org.datanucleus.flush.FlushMode;
import org.datanucleus.flush.FlushProcess;
import org.datanucleus.flush.Operation;
import org.datanucleus.flush.OperationQueue;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.identity.DatastoreUniqueLongId;
import org.datanucleus.identity.IdentityKeyTranslator;
import org.datanucleus.identity.IdentityReference;
import org.datanucleus.identity.IdentityStringTranslator;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.SCOID;
import org.datanucleus.management.ManagerStatistics;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.properties.BasePropertyStore;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.LockManager;
import org.datanucleus.state.LockManagerImpl;
import org.datanucleus.state.LockMode;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.query.Extent;
import org.datanucleus.store.types.converters.TypeConversionHelper;
import org.datanucleus.store.types.scostore.Store;
import org.datanucleus.transaction.Transaction;
import org.datanucleus.transaction.TransactionEventListener;
import org.datanucleus.transaction.TransactionImpl;
import org.datanucleus.transaction.jta.JTAJCATransactionImpl;
import org.datanucleus.transaction.jta.JTATransactionImpl;
import org.datanucleus.util.ConcurrentReferenceHashMap;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ExecutionContextImpl
implements ExecutionContext,
TransactionEventListener {
    PersistenceNucleusContext nucCtx;
    private Object owner;
    private boolean closing = false;
    private boolean closed;
    private FetchPlan fetchPlan;
    private ClassLoaderResolver clr = null;
    private CallbackHandler callbackHandler;
    protected Level1Cache cache;
    private final BasePropertyStore properties = new BasePropertyStore();
    private Transaction tx;
    private FlushMode flushMode = null;
    private final Map<Object, DNStateManager> enlistedSMCache = new ConcurrentReferenceHashMap<Object, DNStateManager>(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);
    private final Collection<DNStateManager> dirtySMs = new LinkedHashSet<DNStateManager>();
    private final Collection<DNStateManager> indirectDirtySMs = new LinkedHashSet<DNStateManager>();
    private OperationQueue operationQueue = null;
    private Set<DNStateManager> nontxProcessedSMs = null;
    private boolean l2CacheEnabled = false;
    private Map<Object, BitSet> l2CacheTxFieldsToUpdateById = null;
    private Set l2CacheTxIds = null;
    private List<Object> l2CacheObjectsToEvictUponRollback = null;
    private int flushing = 0;
    private FetchGroupManager fetchGrpMgr;
    private LockManager lockMgr = null;
    private Map<DNStateManager, Object> smAttachDetachObjectReferenceMap = null;
    private Map<DNStateManager, List<ExecutionContext.EmbeddedOwnerRelation>> smEmbeddedInfoByOwner = null;
    private Map<DNStateManager, ExecutionContext.EmbeddedOwnerRelation> smEmbeddedInfoByEmbedded = null;
    protected Map<DNStateManager, Map<?, ?>> stateManagerAssociatedValuesMap = null;
    private ManagedRelationsHandler managedRelationsHandler = null;
    private ReachabilityAtCommitHandler pbrAtCommitHandler = null;
    private boolean runningDetachAllOnTxnEnd = false;
    private DNStateManager[] detachAllOnTxnEndSMs = null;
    private ManagerStatistics statistics = null;
    private Set<ExecutionContextListener> ecListeners = null;
    private ThreadLocal contextInfoThreadLocal;

    public ExecutionContextImpl(PersistenceNucleusContext ctx, Object owner, Map<String, Object> options) {
        this.nucCtx = ctx;
        this.initialise(owner, options);
        this.initialiseLevel1Cache();
    }

    @Override
    public void initialise(Object owner, Map<String, Object> options) {
        this.owner = owner;
        this.closed = false;
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        this.clr = this.nucCtx.getClassLoaderResolver(contextLoader);
        try {
            ImplementationCreator ic = this.nucCtx.getImplementationCreator();
            if (ic != null) {
                this.clr.setRuntimeClassLoader(ic.getClassLoader());
            }
        }
        catch (Exception ic) {
            // empty catch block
        }
        Configuration conf = this.nucCtx.getConfiguration();
        for (Map.Entry<String, Object> entry : conf.getManagerOverrideableProperties().entrySet()) {
            this.properties.setProperty(entry.getKey().toLowerCase(Locale.ENGLISH), entry.getValue());
        }
        this.properties.getFrequentProperties().setDefaults(conf.getFrequentProperties());
        this.fetchPlan = new FetchPlan(this, this.clr).setMaxFetchDepth(conf.getIntProperty("datanucleus.maxFetchDepth"));
        if (TransactionType.JTA.toString().equalsIgnoreCase(conf.getStringProperty("datanucleus.transaction.type"))) {
            if (this.getNucleusContext().isJcaMode()) {
                this.tx = new JTAJCATransactionImpl(this, this.properties);
            } else {
                boolean autoJoin = true;
                if (options != null && options.containsKey("jta_autojoin")) {
                    autoJoin = Boolean.valueOf((String)options.get("jta_autojoin"));
                }
                this.tx = new JTATransactionImpl(this, autoJoin, this.properties);
            }
        } else {
            this.tx = new TransactionImpl(this, this.properties);
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("010000", this, this.nucCtx.getStoreManager(), this.tx));
        }
        if (this.nucCtx.statisticsEnabled()) {
            this.statistics = new ManagerStatistics(this.nucCtx.getJMXManager(), this.nucCtx.getStatistics());
        }
        this.contextInfoThreadLocal = new ThreadLocal(){

            protected Object initialValue() {
                return new ThreadContextInfo();
            }
        };
        if (this.properties.getBooleanProperty("datanucleus.manageRelationships")) {
            this.managedRelationsHandler = new ManagedRelationsHandler(this.properties.getBooleanProperty("datanucleus.manageRelationshipsChecks"));
        }
        if (this.properties.getFrequentProperties().getReachabilityAtCommit().booleanValue()) {
            this.pbrAtCommitHandler = new ReachabilityAtCommitHandler(this);
        }
        this.lockMgr = new LockManagerImpl(this);
        this.l2CacheObjectsToEvictUponRollback = null;
        this.setLevel2Cache(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        String closeActionTxAction;
        if (this.closed) {
            throw new NucleusUserException(Localiser.msg("010002"));
        }
        if (this.tx.getIsActive() && (closeActionTxAction = this.nucCtx.getConfiguration().getStringProperty("datanucleus.executionContext.closeActiveTxAction")) != null) {
            if (closeActionTxAction.equalsIgnoreCase("exception")) {
                throw new TransactionActiveOnCloseException(this);
            }
            if (closeActionTxAction.equalsIgnoreCase("rollback")) {
                NucleusLogger.GENERAL.warn("ExecutionContext closed with active transaction, so rolling back the active transaction");
                this.tx.rollback();
            }
        }
        if (!this.dirtySMs.isEmpty() && this.tx.getNontransactionalWrite()) {
            if (this.isNonTxAtomic()) {
                this.processNontransactionalUpdate();
            } else {
                try {
                    this.tx.begin();
                    this.tx.commit();
                }
                finally {
                    if (this.tx.isActive()) {
                        this.tx.rollback();
                    }
                }
            }
        }
        if (this.properties.getFrequentProperties().getDetachOnClose().booleanValue() && this.cache != null && !this.cache.isEmpty()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("010011"));
            LinkedHashSet toDetach = new LinkedHashSet(this.cache.values());
            try {
                if (!this.tx.getNontransactionalRead()) {
                    this.tx.begin();
                }
                for (DNStateManager sm : toDetach) {
                    if (sm == null || sm.getObject() == null || sm.getExecutionContext().getApiAdapter().isDeleted(sm.getObject()) || sm.getExternalObjectId() == null) continue;
                    try {
                        sm.detach(new DetachState(this.getApiAdapter()));
                    }
                    catch (NucleusObjectNotFoundException nucleusObjectNotFoundException) {}
                }
                if (!this.tx.getNontransactionalRead()) {
                    this.tx.commit();
                }
            }
            finally {
                if (!this.tx.getNontransactionalRead() && this.tx.isActive()) {
                    this.tx.rollback();
                }
            }
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("010012"));
        }
        ExecutionContext.LifecycleListener[] listener = this.nucCtx.getExecutionContextListeners();
        for (int i = 0; i < listener.length; ++i) {
            listener[i].preClose(this);
        }
        this.closing = true;
        if (this.cache != null && !this.cache.isEmpty()) {
            HashSet cachedSMsClone = new HashSet(this.cache.values());
            for (DNStateManager sm : cachedSMsClone) {
                if (sm == null) continue;
                sm.disconnect();
            }
            this.cache.clear();
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(Localiser.msg("003011"));
            }
        }
        this.closeCallbackHandler();
        if (this.ecListeners != null) {
            HashSet<ExecutionContextListener> listeners = new HashSet<ExecutionContextListener>(this.ecListeners);
            for (ExecutionContextListener lstr : listeners) {
                lstr.executionContextClosing(this);
            }
            this.ecListeners.clear();
            this.ecListeners = null;
        }
        this.fetchPlan.clearGroups().addGroup("default");
        if (this.statistics != null) {
            this.statistics.close();
            this.statistics = null;
        }
        this.enlistedSMCache.clear();
        this.dirtySMs.clear();
        this.indirectDirtySMs.clear();
        if (this.nontxProcessedSMs != null) {
            this.nontxProcessedSMs.clear();
            this.nontxProcessedSMs = null;
        }
        if (this.managedRelationsHandler != null) {
            this.managedRelationsHandler.clear();
        }
        if (this.l2CacheTxIds != null) {
            this.l2CacheTxIds.clear();
        }
        if (this.l2CacheTxFieldsToUpdateById != null) {
            this.l2CacheTxFieldsToUpdateById.clear();
        }
        if (this.pbrAtCommitHandler != null) {
            this.pbrAtCommitHandler.clear();
        }
        if (this.smEmbeddedInfoByOwner != null) {
            this.smEmbeddedInfoByOwner.clear();
            this.smEmbeddedInfoByOwner = null;
        }
        if (this.smEmbeddedInfoByEmbedded != null) {
            this.smEmbeddedInfoByEmbedded.clear();
            this.smEmbeddedInfoByEmbedded = null;
        }
        if (this.stateManagerAssociatedValuesMap != null) {
            this.stateManagerAssociatedValuesMap.clear();
            this.stateManagerAssociatedValuesMap = null;
        }
        this.l2CacheObjectsToEvictUponRollback = null;
        this.closing = false;
        this.closed = true;
        this.tx.close();
        this.tx = null;
        this.owner = null;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("010001", this));
        }
        this.nucCtx.getExecutionContextPool().checkIn(this);
    }

    @Override
    public void registerExecutionContextListener(ExecutionContextListener listener) {
        if (this.ecListeners == null) {
            this.ecListeners = new HashSet<ExecutionContextListener>();
        }
        this.ecListeners.add(listener);
    }

    @Override
    public void deregisterExecutionContextListener(ExecutionContextListener listener) {
        if (this.ecListeners != null) {
            this.ecListeners.remove(listener);
        }
    }

    protected void setLevel2Cache(boolean flag) {
        if (flag && this.nucCtx.hasLevel2Cache() && !this.l2CacheEnabled) {
            this.l2CacheTxIds = new HashSet();
            this.l2CacheTxFieldsToUpdateById = new HashMap<Object, BitSet>();
            this.l2CacheEnabled = true;
        } else if (!flag && this.l2CacheEnabled) {
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug("Disabling L2 caching for " + this);
            }
            this.l2CacheTxIds.clear();
            this.l2CacheTxIds = null;
            this.l2CacheTxFieldsToUpdateById.clear();
            this.l2CacheTxFieldsToUpdateById = null;
            this.l2CacheEnabled = false;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected ThreadContextInfo acquireThreadContextInfo() {
        ThreadContextInfo threadInfo = (ThreadContextInfo)this.contextInfoThreadLocal.get();
        ++threadInfo.referenceCounter;
        return threadInfo;
    }

    protected ThreadContextInfo getThreadContextInfo() {
        return (ThreadContextInfo)this.contextInfoThreadLocal.get();
    }

    protected void releaseThreadContextInfo() {
        ThreadContextInfo threadInfo = (ThreadContextInfo)this.contextInfoThreadLocal.get();
        if (--threadInfo.referenceCounter <= 0) {
            threadInfo.referenceCounter = 0;
            if (threadInfo.attachedOwnerByObject != null) {
                threadInfo.attachedOwnerByObject.clear();
            }
            threadInfo.attachedOwnerByObject = null;
            if (threadInfo.attachedPCById != null) {
                threadInfo.attachedPCById.clear();
            }
            threadInfo.attachedPCById = null;
            this.contextInfoThreadLocal.remove();
        }
    }

    @Override
    public void transactionStarted() {
        this.getStoreManager().transactionStarted(this);
        this.postBegin();
    }

    @Override
    public void transactionPreFlush() {
    }

    @Override
    public void transactionFlushed() {
    }

    @Override
    public void transactionPreCommit() {
        this.preCommit();
    }

    @Override
    public void transactionCommitted() {
        this.getStoreManager().transactionCommitted(this);
        this.postCommit();
    }

    @Override
    public void transactionPreRollBack() {
        this.preRollback();
    }

    @Override
    public void transactionRolledBack() {
        this.getStoreManager().transactionRolledBack(this);
        this.postRollback();
    }

    @Override
    public void transactionEnded() {
    }

    @Override
    public void transactionSetSavepoint(String name) {
    }

    @Override
    public void transactionReleaseSavepoint(String name) {
    }

    @Override
    public void transactionRollbackToSavepoint(String name) {
    }

    @Override
    public ManagerStatistics getStatistics() {
        return this.statistics;
    }

    protected void initialiseLevel1Cache() {
        String level1Type = this.getStringProperty("datanucleus.cache.level1.type");
        if (level1Type == null) {
            level1Type = this.nucCtx.getConfiguration().getStringProperty("datanucleus.cache.level1.type");
        }
        if ("none".equalsIgnoreCase(level1Type)) {
            return;
        }
        if ("soft".equalsIgnoreCase(level1Type)) {
            this.cache = new SoftRefCache();
        } else if ("weak".equalsIgnoreCase(level1Type)) {
            this.cache = new WeakRefCache();
        } else if ("strong".equalsIgnoreCase(level1Type)) {
            this.cache = new StrongRefCache();
        } else {
            String level1ClassName = this.getNucleusContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_level1", "name", level1Type, "class-name");
            if (level1ClassName == null) {
                throw new NucleusUserException(Localiser.msg("003001", level1Type)).setFatal();
            }
            try {
                this.cache = (Level1Cache)this.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.cache_level1", "name", level1Type, "class-name", null, null);
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("003003", level1Type));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(Localiser.msg("003002", level1Type, level1ClassName), e).setFatal();
            }
        }
    }

    @Override
    public Level1Cache getLevel1Cache() {
        return this.cache;
    }

    @Override
    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    @Override
    public LockManager getLockManager() {
        return this.lockMgr;
    }

    @Override
    public FetchPlan getFetchPlan() {
        this.assertIsOpen();
        return this.fetchPlan;
    }

    @Override
    public PersistenceNucleusContext getNucleusContext() {
        return this.nucCtx;
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        if (props == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setProperty(String name, Object value) {
        String intName;
        if (name.equalsIgnoreCase("datanucleus.manageRelationships")) {
            if ("false".equalsIgnoreCase((String)value)) {
                this.managedRelationsHandler = null;
            } else if ("true".equalsIgnoreCase((String)value)) {
                this.managedRelationsHandler = new ManagedRelationsHandler(this.properties.getBooleanProperty("datanucleus.manageRelationshipsChecks"));
            }
        } else if (name.equalsIgnoreCase("datanucleus.manageRelationshipsChecks")) {
            if (this.managedRelationsHandler != null) {
                Boolean checks = Boolean.valueOf((String)value);
                if (checks == Boolean.TRUE) {
                    this.managedRelationsHandler.setPerformChecks(true);
                } else if (checks == Boolean.FALSE) {
                    this.managedRelationsHandler.setPerformChecks(false);
                }
            }
        } else if (name.equalsIgnoreCase("datanucleus.persistenceByReachabilityAtCommit")) {
            if (this.pbrAtCommitHandler != null) {
                if ("false".equalsIgnoreCase((String)value)) {
                    this.pbrAtCommitHandler = null;
                } else if ("true".equalsIgnoreCase((String)value)) {
                    this.pbrAtCommitHandler = new ReachabilityAtCommitHandler(this);
                }
            }
        } else {
            if (name.equalsIgnoreCase("datanucleus.flush.mode")) {
                this.flushMode = FlushMode.getFlushModeForString((String)value);
                return;
            }
            if (name.equalsIgnoreCase("datanucleus.cache.level2.type")) {
                if ("none".equalsIgnoreCase((String)value)) {
                    this.setLevel2Cache(false);
                } else {
                    NucleusLogger.PERSISTENCE.warn("Only support disabling L2 cache via property on PM/EM. Ignored");
                }
                return;
            }
            if (name.equalsIgnoreCase("datanucleus.cache.level1.type")) {
                if ("none".equalsIgnoreCase((String)value)) {
                    if (this.cache != null) {
                        if (!this.cache.isEmpty()) {
                            NucleusLogger.PERSISTENCE.warn("Can only disable L1 cache when it is empty. Ignored");
                            return;
                        }
                        this.cache.clear();
                        this.cache = null;
                    }
                } else {
                    NucleusLogger.PERSISTENCE.warn("Only support disabling L1 cache via property on PM/EM. Ignored");
                }
                return;
            }
        }
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            intName = this.getNucleusContext().getConfiguration().getInternalNameForProperty(name);
            this.getNucleusContext().getConfiguration().validatePropertyValue(intName, value);
            this.properties.setProperty(intName.toLowerCase(Locale.ENGLISH), value);
        } else {
            intName = this.getNucleusContext().getConfiguration().getInternalNameForProperty(name);
            if (intName != null && !intName.equalsIgnoreCase(name)) {
                this.getNucleusContext().getConfiguration().validatePropertyValue(intName, value);
                this.properties.setProperty(intName.toLowerCase(Locale.ENGLISH), value);
            } else {
                NucleusLogger.PERSISTENCE.warn("Attempt to set property \"" + name + "\" on PM/EM yet this is not supported. Ignored");
            }
        }
        if (name.equalsIgnoreCase("datanucleus.SerializeRead")) {
            this.tx.setSerializeRead(this.getBooleanProperty("datanucleus.SerializeRead"));
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.properties.getProperties().entrySet()) {
            props.put(this.nucCtx.getConfiguration().getCaseSensitiveNameForPropertyName(entry.getKey()), entry.getValue());
        }
        return props;
    }

    @Override
    public Boolean getBooleanProperty(String name) {
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            this.assertIsOpen();
            return this.properties.getBooleanProperty(this.getNucleusContext().getConfiguration().getInternalNameForProperty(name));
        }
        return null;
    }

    @Override
    public Integer getIntProperty(String name) {
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            this.assertIsOpen();
            return this.properties.getIntProperty(this.getNucleusContext().getConfiguration().getInternalNameForProperty(name));
        }
        return null;
    }

    @Override
    public String getStringProperty(String name) {
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            this.assertIsOpen();
            return this.properties.getStringProperty(this.getNucleusContext().getConfiguration().getInternalNameForProperty(name));
        }
        return null;
    }

    @Override
    public Object getProperty(String name) {
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            this.assertIsOpen();
            return this.properties.getProperty(this.getNucleusContext().getConfiguration().getInternalNameForProperty(name).toLowerCase(Locale.ENGLISH));
        }
        return null;
    }

    @Override
    public Set<String> getSupportedProperties() {
        return this.nucCtx.getConfiguration().getManagedOverrideablePropertyNames();
    }

    @Override
    public boolean getMultithreaded() {
        return false;
    }

    @Override
    public FlushMode getFlushMode() {
        return this.flushMode;
    }

    @Override
    public boolean isDelayDatastoreOperationsEnabled() {
        if (!this.tx.isActive()) {
            if (this.isFlushing()) {
                return false;
            }
            return !this.isNonTxAtomic();
        }
        if (this.isFlushing() || this.tx.isCommitting()) {
            return false;
        }
        if (this.flushMode == FlushMode.AUTO) {
            return false;
        }
        if (this.flushMode == FlushMode.MANUAL || this.flushMode == FlushMode.QUERY) {
            return true;
        }
        return this.tx.getOptimistic();
    }

    @Override
    public String getTenantId() {
        return this.nucCtx.getTenantId(this);
    }

    @Override
    public String getCurrentUser() {
        return this.nucCtx.getCurrentUser(this);
    }

    @Override
    public boolean isInserting(Object pc) {
        DNStateManager sm = this.findStateManager(pc);
        if (sm == null) {
            return false;
        }
        return sm.isInserting();
    }

    @Override
    public Transaction getTransaction() {
        this.assertIsOpen();
        return this.tx;
    }

    @Override
    public void enlistInTransaction(DNStateManager sm) {
        this.assertActiveTransaction();
        if (this.pbrAtCommitHandler != null && this.tx.isActive()) {
            if (this.getApiAdapter().isNew(sm.getObject())) {
                this.pbrAtCommitHandler.addFlushedNewObject(sm.getInternalObjectId());
            } else if (this.getApiAdapter().isPersistent(sm.getObject()) && !this.getApiAdapter().isDeleted(sm.getObject()) && !this.pbrAtCommitHandler.isObjectFlushedNew(sm.getInternalObjectId())) {
                this.pbrAtCommitHandler.addPersistedObject(sm.getInternalObjectId());
            }
            if (!this.pbrAtCommitHandler.isExecuting()) {
                this.pbrAtCommitHandler.addEnlistedObject(sm.getInternalObjectId());
            }
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(Localiser.msg("015017", IdentityUtils.getPersistableIdentityForId(sm.getInternalObjectId())));
        }
        this.enlistedSMCache.put(sm.getInternalObjectId(), sm);
    }

    @Override
    public void evictFromTransaction(DNStateManager sm) {
        if (this.enlistedSMCache.remove(sm.getInternalObjectId()) != null && NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(Localiser.msg("015019", IdentityUtils.getPersistableIdentityForId(sm.getInternalObjectId())));
        }
    }

    @Override
    public boolean isEnlistedInTransaction(Object id) {
        if (this.pbrAtCommitHandler == null || !this.tx.isActive()) {
            return false;
        }
        if (id == null) {
            return false;
        }
        return this.pbrAtCommitHandler.isObjectEnlisted(id);
    }

    @Override
    public void addStateManagerToCache(DNStateManager sm) {
        this.putObjectIntoLevel1Cache(sm);
    }

    @Override
    public void removeStateManagerFromCache(DNStateManager sm) {
        List<ExecutionContext.EmbeddedOwnerRelation> embRels;
        ExecutionContext.EmbeddedOwnerRelation embRel;
        if (this.closing) {
            return;
        }
        this.removeObjectFromLevel1Cache(sm.getInternalObjectId());
        this.enlistedSMCache.remove(sm.getInternalObjectId());
        if (this.smEmbeddedInfoByEmbedded != null && (embRel = this.smEmbeddedInfoByEmbedded.get(sm)) != null) {
            if (this.smEmbeddedInfoByOwner != null) {
                this.smEmbeddedInfoByOwner.remove(embRel.getOwnerSM());
            }
            this.smEmbeddedInfoByEmbedded.remove(sm);
        }
        if (this.smEmbeddedInfoByOwner != null && (embRels = this.smEmbeddedInfoByOwner.get(sm)) != null) {
            if (this.smEmbeddedInfoByEmbedded != null) {
                for (ExecutionContext.EmbeddedOwnerRelation rel : embRels) {
                    this.smEmbeddedInfoByEmbedded.remove(rel.getEmbeddedSM());
                }
            }
            this.smEmbeddedInfoByOwner.remove(sm);
        }
        if (this.stateManagerAssociatedValuesMap != null) {
            this.stateManagerAssociatedValuesMap.remove(sm);
        }
        this.setAttachDetachReferencedObject(sm, null);
    }

    @Override
    public DNStateManager findStateManager(Object pc) {
        ExecutionContext ec;
        DNStateManager sm = (DNStateManager)this.getApiAdapter().getStateManager(pc);
        if (sm != null && (ec = sm.getExecutionContext()) != null && this != ec) {
            throw new NucleusUserException(Localiser.msg("010007", this.getApiAdapter().getIdForObject(pc)));
        }
        return sm;
    }

    @Override
    public DNStateManager findStateManager(Object pc, boolean persist) {
        DNStateManager sm = this.findStateManager(pc);
        if (sm == null && persist) {
            return this.findStateManager(this.persistObjectInternal(pc, null, null, -1, PersistableObjectType.PC));
        }
        return sm;
    }

    @Override
    public DNStateManager findStateManagerForEmbedded(Object value, DNStateManager ownerSM, AbstractMemberMetaData mmd, PersistableObjectType objectType) {
        AbstractMemberMetaData ownerMmd = ownerSM.getClassMetaData().getMetaDataForMember(mmd.getName());
        DNStateManager<Object> embeddedSM = this.findStateManager(value);
        if (embeddedSM == null) {
            embeddedSM = this.nucCtx.getStateManagerFactory().newForEmbedded(this, value, false, ownerSM, ownerMmd.getAbsoluteFieldNumber(), objectType);
        } else if (!embeddedSM.isEmbedded()) {
            NucleusLogger.PERSISTENCE.warn("Object " + StringUtils.toJVMIDString(value) + " is already registered with " + embeddedSM + " as NOT EMBEDDED but needs to be embedded into " + ownerSM + ". Please correct this. An object can be either embedded or not but not both");
        }
        return embeddedSM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DNStateManager findStateManagerOfOwnerForAttachingObject(Object pc) {
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (threadInfo.attachedOwnerByObject == null) {
                DNStateManager dNStateManager = null;
                return dNStateManager;
            }
            DNStateManager dNStateManager = threadInfo.attachedOwnerByObject.get(pc);
            return dNStateManager;
        }
        finally {
            this.releaseThreadContextInfo();
        }
    }

    private boolean isNonTxAtomic() {
        return this.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.transaction.nontx.atomic");
    }

    @Override
    public void processNontransactionalUpdate() {
        if (this.tx.isActive() || !this.tx.getNontransactionalWrite() || !this.tx.getNontransactionalWriteAutoCommit()) {
            return;
        }
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (threadInfo.nontxPersistDelete) {
                return;
            }
            this.processNontransactionalAtomicChanges();
        }
        finally {
            this.releaseThreadContextInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNontransactionalAtomicChanges() {
        if (this.tx.isActive() || !this.tx.getNontransactionalWrite() || !this.tx.getNontransactionalWriteAutoCommit()) {
            return;
        }
        if (!this.dirtySMs.isEmpty()) {
            for (DNStateManager sm : this.dirtySMs) {
                if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                    NucleusLogger.TRANSACTION.debug(Localiser.msg("015017", IdentityUtils.getPersistableIdentityForId(sm.getInternalObjectId())));
                }
                this.enlistedSMCache.put(sm.getInternalObjectId(), sm);
            }
            this.flushInternal(true);
            if (this.l2CacheEnabled) {
                this.performLevel2CacheUpdateAtCommit();
            }
            if (this.properties.getFrequentProperties().getDetachAllOnCommit().booleanValue()) {
                this.performDetachAllOnTxnEndPreparation();
                this.performDetachAllOnTxnEnd();
            }
            ArrayList<RuntimeException> failures = null;
            try {
                ApiAdapter api = this.getApiAdapter();
                DNStateManager[] sms = this.enlistedSMCache.values().toArray(new DNStateManager[this.enlistedSMCache.size()]);
                for (int i = 0; i < sms.length; ++i) {
                    try {
                        if (sms[i] != null && sms[i].getObject() != null && api.isPersistent(sms[i].getObject()) && api.isDirty(sms[i].getObject())) {
                            sms[i].postCommit(this.getTransaction());
                            continue;
                        }
                        NucleusLogger.PERSISTENCE.debug(">> Atomic nontransactional processing : Not performing postCommit on " + sms[i]);
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (failures == null) {
                            failures = new ArrayList<RuntimeException>();
                        }
                        failures.add(e);
                    }
                }
            }
            finally {
                this.resetTransactionalVariables();
            }
            if (failures != null && !failures.isEmpty()) {
                throw new CommitStateTransitionException(failures.toArray(new Exception[failures.size()]));
            }
        }
        if (this.nontxProcessedSMs != null && !this.nontxProcessedSMs.isEmpty()) {
            for (DNStateManager sm : this.nontxProcessedSMs) {
                if (sm == null || sm.getLifecycleState() == null || !sm.getLifecycleState().isDeleted()) continue;
                this.removeObjectFromLevel1Cache(sm.getInternalObjectId());
                this.removeObjectFromLevel2Cache(sm.getInternalObjectId());
            }
            this.nontxProcessedSMs.clear();
        }
    }

    @Override
    public void evictObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            DNStateManager sm = this.findStateManager(obj);
            if (sm == null) {
                throw new NucleusUserException(Localiser.msg("010048", StringUtils.toJVMIDString(obj), this.getApiAdapter().getIdForObject(obj), "evict"));
            }
            sm.evict();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public void evictObjects(Class cls, boolean subclasses) {
        if (this.cache != null && !this.cache.isEmpty()) {
            HashSet smsToEvict = new HashSet(this.cache.values());
            for (DNStateManager sm : smsToEvict) {
                Object pc = sm.getObject();
                boolean evict = false;
                if (!subclasses && pc.getClass() == cls) {
                    evict = true;
                } else if (subclasses && cls.isAssignableFrom(pc.getClass())) {
                    evict = true;
                }
                if (!evict) continue;
                sm.evict();
                this.removeObjectFromLevel1Cache(this.getApiAdapter().getIdForObject(pc));
            }
        }
    }

    @Override
    public void evictAllObjects() {
        if (this.cache != null && !this.cache.isEmpty()) {
            HashSet smsToEvict = new HashSet(this.cache.values());
            for (DNStateManager sm : smsToEvict) {
                if (sm == null) continue;
                sm.evict();
            }
            this.cache.clear();
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(Localiser.msg("003011"));
            }
        }
    }

    @Override
    public void refreshObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            DNStateManager sm = this.findStateManager(obj);
            if (sm == null) {
                throw new NucleusUserException(Localiser.msg("010048", StringUtils.toJVMIDString(obj), this.getApiAdapter().getIdForObject(obj), "refresh"));
            }
            if (this.getApiAdapter().isPersistent(obj) && sm.isWaitingToBeFlushedToDatastore()) {
                return;
            }
            sm.refresh();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public void refreshAllObjects() {
        HashSet<DNStateManager<Object>> toRefresh = new HashSet<DNStateManager<Object>>();
        toRefresh.addAll(this.enlistedSMCache.values());
        toRefresh.addAll(this.dirtySMs);
        toRefresh.addAll(this.indirectDirtySMs);
        if (!this.tx.isActive() && this.cache != null && !this.cache.isEmpty()) {
            toRefresh.addAll(this.cache.values());
        }
        ArrayList<RuntimeException> failures = null;
        for (DNStateManager dNStateManager : toRefresh) {
            try {
                dNStateManager.refresh();
            }
            catch (RuntimeException e) {
                if (failures == null) {
                    failures = new ArrayList<RuntimeException>();
                }
                failures.add(e);
            }
        }
        if (failures != null && !failures.isEmpty()) {
            throw new NucleusUserException(Localiser.msg("010037"), failures.toArray(new Exception[failures.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retrieveObjects(boolean useFetchPlan, Object ... pcs) {
        if (pcs == null || pcs.length == 0) {
            return;
        }
        ArrayList<RuntimeException> failures = null;
        for (Object pc : pcs) {
            if (pc == null) continue;
            try {
                this.clr.setPrimary(pc.getClass().getClassLoader());
                this.assertClassPersistable(pc.getClass());
                this.assertNotDetached(pc);
                DNStateManager sm = this.findStateManager(pc);
                if (sm == null) {
                    throw new NucleusUserException(Localiser.msg("010048", StringUtils.toJVMIDString(pc), this.getApiAdapter().getIdForObject(pc), "retrieve"));
                }
                sm.retrieve(useFetchPlan);
            }
            catch (RuntimeException e) {
                if (failures == null) {
                    failures = new ArrayList<RuntimeException>();
                }
                failures.add(e);
            }
            finally {
                this.clr.unsetPrimary();
            }
        }
        if (failures != null && !failures.isEmpty()) {
            throw new NucleusUserException(Localiser.msg("010037"), failures.toArray(new Exception[failures.size()]));
        }
    }

    /*
     * Loose catch block
     */
    public Object persistObject(Object obj, boolean merging) {
        if (obj == null) {
            return null;
        }
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            boolean allowMergeOfTransient = this.nucCtx.getConfiguration().getBooleanProperty("datanucleus.allowAttachOfTransient", false);
            if (this.getBooleanProperty("datanucleus.allowAttachOfTransient") != null) {
                allowMergeOfTransient = this.getBooleanProperty("datanucleus.allowAttachOfTransient");
            }
            if (merging && allowMergeOfTransient) {
                threadInfo.merging = true;
            }
            if (threadInfo.attachedOwnerByObject == null) {
                threadInfo.attachedOwnerByObject = new HashMap<Persistable, DNStateManager>();
            }
            if (threadInfo.attachedPCById == null) {
                threadInfo.attachedPCById = new HashMap<Object, Persistable>();
            }
            if (this.tx.isActive()) {
                Object object = this.persistObjectWork(obj);
                return object;
            }
            threadInfo.nontxPersistDelete = true;
            boolean success = true;
            HashSet cachedIds = this.cache != null && !this.cache.isEmpty() ? new HashSet(this.cache.keySet()) : null;
            try {
                Object object = this.persistObjectWork(obj);
                return object;
            }
            catch (RuntimeException re) {
                success = false;
                if (this.cache != null) {
                    Iterator cacheIter = this.cache.keySet().iterator();
                    while (cacheIter.hasNext()) {
                        Object id = cacheIter.next();
                        if (cachedIds != null && cachedIds.contains(id)) continue;
                        cacheIter.remove();
                    }
                }
                throw re;
            }
            finally {
                threadInfo.nontxPersistDelete = false;
                if (success) {
                    this.processNontransactionalAtomicChanges();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.releaseThreadContextInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] persistObjects(Object ... objs) {
        if (objs == null) {
            return null;
        }
        Object[] persistedObjs = new Object[objs.length];
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (threadInfo.attachedOwnerByObject == null) {
                threadInfo.attachedOwnerByObject = new HashMap<Persistable, DNStateManager>();
            }
            if (threadInfo.attachedPCById == null) {
                threadInfo.attachedPCById = new HashMap<Object, Persistable>();
            }
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = true;
            }
            try {
                this.getStoreManager().getPersistenceHandler().batchStart(this, StorePersistenceHandler.PersistenceBatchType.PERSIST);
                ArrayList<RuntimeException> failures = null;
                for (int i = 0; i < objs.length; ++i) {
                    try {
                        if (objs[i] == null) continue;
                        persistedObjs[i] = this.persistObjectWork(objs[i]);
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (failures == null) {
                            failures = new ArrayList<RuntimeException>();
                        }
                        failures.add(e);
                    }
                }
                if (failures != null && !failures.isEmpty()) {
                    RuntimeException e = (RuntimeException)failures.get(0);
                    if (e instanceof NucleusException && ((NucleusException)e).isFatal()) {
                        throw new NucleusFatalUserException(Localiser.msg("010039"), failures.toArray(new Exception[failures.size()]));
                    }
                    throw new NucleusUserException(Localiser.msg("010039"), failures.toArray(new Exception[failures.size()]));
                }
            }
            finally {
                this.getStoreManager().getPersistenceHandler().batchEnd(this, StorePersistenceHandler.PersistenceBatchType.PERSIST);
                if (!this.tx.isActive()) {
                    threadInfo.nontxPersistDelete = false;
                    this.processNontransactionalAtomicChanges();
                }
            }
        }
        finally {
            this.releaseThreadContextInfo();
        }
        return persistedObjs;
    }

    private Object persistObjectWork(Object obj) {
        boolean detached = this.getApiAdapter().isDetached(obj);
        Object persistedPc = this.persistObjectInternal(obj, null, null, -1, PersistableObjectType.PC);
        DNStateManager sm = this.findStateManager(persistedPc);
        if (sm != null && !sm.isEmbedded()) {
            if (this.indirectDirtySMs.contains(sm)) {
                this.dirtySMs.add(sm);
                this.indirectDirtySMs.remove(sm);
            } else if (!this.dirtySMs.contains(sm)) {
                this.dirtySMs.add(sm);
                if (this.l2CacheTxIds != null && this.nucCtx.isClassCacheable(sm.getClassMetaData())) {
                    this.l2CacheTxIds.add(sm.getInternalObjectId());
                }
            }
            if (this.pbrAtCommitHandler != null && this.tx.isActive() && (detached || this.getApiAdapter().isNew(persistedPc))) {
                this.pbrAtCommitHandler.addPersistedObject(sm.getInternalObjectId());
            }
        }
        return persistedPc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T persistObjectInternal(T obj, FieldValues preInsertChanges, DNStateManager ownerSM, int ownerFieldNum, PersistableObjectType objectType) {
        if (obj == null) {
            return null;
        }
        ApiAdapter api = this.getApiAdapter();
        Object id = null;
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            ExecutionContext ec = api.getExecutionContext(obj);
            if (ec != null && ec != this) {
                throw new NucleusUserException(Localiser.msg("010007", obj));
            }
            boolean cacheable = false;
            Object persistedPc = obj;
            if (api.isDetached(obj)) {
                this.assertDetachable(obj);
                if (this.getBooleanProperty("datanucleus.CopyOnAttach").booleanValue()) {
                    persistedPc = this.attachObjectCopy(ownerSM, obj, api.getIdForObject(obj) == null);
                } else {
                    this.attachObject(ownerSM, obj, api.getIdForObject(obj) == null);
                    persistedPc = obj;
                }
            } else if (api.isTransactional(obj) && !api.isPersistent(obj)) {
                DNStateManager sm;
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("010015", StringUtils.toJVMIDString(obj)));
                }
                if ((sm = this.findStateManager(obj)) == null) {
                    throw new NucleusUserException(Localiser.msg("010007", this.getApiAdapter().getIdForObject(obj)));
                }
                sm.makePersistentTransactionalTransient();
            } else if (!api.isPersistent(obj)) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("010015", StringUtils.toJVMIDString(obj)));
                }
                boolean merged = false;
                ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
                try {
                    if (threadInfo.merging) {
                        Object transientId;
                        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(obj.getClass(), this.clr);
                        if (cmd.getIdentityType() == IdentityType.APPLICATION && (transientId = this.nucCtx.getIdentityManager().getApplicationId(obj, cmd)) != null) {
                            Persistable existingObj = this.findObject(transientId, true, true, cmd.getFullClassName());
                            this.findStateManager(existingObj).attach(obj);
                            id = transientId;
                            merged = true;
                            persistedPc = existingObj;
                        }
                        cacheable = this.nucCtx.isClassCacheable(cmd);
                    }
                }
                catch (NucleusObjectNotFoundException cmd) {
                }
                finally {
                    this.releaseThreadContextInfo();
                }
                if (!merged) {
                    DNStateManager<T> sm = this.findStateManager(obj);
                    if (sm == null) {
                        if ((objectType == PersistableObjectType.EMBEDDED_COLLECTION_ELEMENT_PC || objectType == PersistableObjectType.EMBEDDED_MAP_KEY_PC || objectType == PersistableObjectType.EMBEDDED_MAP_VALUE_PC || objectType == PersistableObjectType.EMBEDDED_PC) && ownerSM != null) {
                            sm = this.nucCtx.getStateManagerFactory().newForEmbedded(this, obj, false, ownerSM, ownerFieldNum, objectType);
                            sm.makePersistent();
                            id = sm.getInternalObjectId();
                        } else {
                            sm = this.nucCtx.getStateManagerFactory().newForPersistentNew(this, obj, preInsertChanges);
                            sm.makePersistent();
                            id = sm.getInternalObjectId();
                        }
                    } else if (sm.getReferencedPC() == null) {
                        sm.makePersistent();
                        id = sm.getInternalObjectId();
                    } else {
                        persistedPc = sm.getReferencedPC();
                    }
                    if (sm != null) {
                        cacheable = this.nucCtx.isClassCacheable(sm.getClassMetaData());
                    }
                }
            } else if (api.isPersistent(obj) && api.getIdForObject(obj) == null) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("010015", StringUtils.toJVMIDString(obj)));
                }
                DNStateManager sm = this.findStateManager(obj);
                sm.makePersistent();
                id = sm.getInternalObjectId();
                cacheable = this.nucCtx.isClassCacheable(sm.getClassMetaData());
            } else if (api.isDeleted(obj)) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("010015", StringUtils.toJVMIDString(obj)));
                }
                DNStateManager sm = this.findStateManager(obj);
                sm.makePersistent();
                id = sm.getInternalObjectId();
                cacheable = this.nucCtx.isClassCacheable(sm.getClassMetaData());
            } else if (api.isPersistent(obj) && api.isTransactional(obj) && api.isDirty(obj) && this.isDelayDatastoreOperationsEnabled()) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("010015", StringUtils.toJVMIDString(obj)));
                }
                DNStateManager sm = this.findStateManager(obj);
                sm.makePersistent();
                id = sm.getInternalObjectId();
                cacheable = this.nucCtx.isClassCacheable(sm.getClassMetaData());
            }
            if (id != null && this.l2CacheTxIds != null && cacheable) {
                this.l2CacheTxIds.add(id);
            }
            T t = persistedPc;
            return t;
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public <T> T persistObjectInternal(T pc, DNStateManager ownerSM, int ownerFieldNum, PersistableObjectType objectType) {
        if (ownerSM != null) {
            DNStateManager sm = this.findStateManager(ownerSM.getObject());
            return this.persistObjectInternal(pc, null, sm, ownerFieldNum, objectType);
        }
        return this.persistObjectInternal(pc, null, null, ownerFieldNum, objectType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObjects(Object ... objs) {
        if (objs == null) {
            return;
        }
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = true;
            }
            this.getStoreManager().getPersistenceHandler().batchStart(this, StorePersistenceHandler.PersistenceBatchType.DELETE);
            ArrayList<RuntimeException> failures = null;
            for (int i = 0; i < objs.length; ++i) {
                try {
                    if (objs[i] == null) continue;
                    this.deleteObjectWork(objs[i]);
                    continue;
                }
                catch (RuntimeException e) {
                    if (failures == null) {
                        failures = new ArrayList<RuntimeException>();
                    }
                    failures.add(e);
                }
            }
            if (failures != null && !failures.isEmpty()) {
                RuntimeException e = (RuntimeException)failures.get(0);
                if (e instanceof NucleusException && ((NucleusException)e).isFatal()) {
                    throw new NucleusFatalUserException(Localiser.msg("010040"), failures.toArray(new Exception[failures.size()]));
                }
                throw new NucleusUserException(Localiser.msg("010040"), failures.toArray(new Exception[failures.size()]));
            }
        }
        finally {
            this.getStoreManager().getPersistenceHandler().batchEnd(this, StorePersistenceHandler.PersistenceBatchType.DELETE);
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = false;
                this.processNontransactionalAtomicChanges();
            }
            this.releaseThreadContextInfo();
        }
    }

    @Override
    public void deleteObject(Object obj) {
        if (obj == null) {
            return;
        }
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = true;
            }
            this.deleteObjectWork(obj);
        }
        finally {
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = false;
                this.processNontransactionalAtomicChanges();
            }
            this.releaseThreadContextInfo();
        }
    }

    void deleteObjectWork(Object obj) {
        DNStateManager sm = this.findStateManager(obj);
        if (sm == null && this.getApiAdapter().isDetached(obj)) {
            Persistable attachedObj = this.findObject(this.getApiAdapter().getIdForObject(obj), true, false, obj.getClass().getName());
            sm = this.findStateManager(attachedObj);
        }
        if (sm != null && !sm.isEmbedded()) {
            if (this.indirectDirtySMs.contains(sm)) {
                this.indirectDirtySMs.remove(sm);
                this.dirtySMs.add(sm);
            } else if (!this.dirtySMs.contains(sm)) {
                this.dirtySMs.add(sm);
                if (this.l2CacheTxIds != null && this.nucCtx.isClassCacheable(sm.getClassMetaData())) {
                    this.l2CacheTxIds.add(sm.getInternalObjectId());
                }
            }
        }
        this.deleteObjectInternal(obj);
        if (this.pbrAtCommitHandler != null && this.tx.isActive() && sm != null && this.getApiAdapter().isDeleted(obj)) {
            this.pbrAtCommitHandler.addDeletedObject(sm.getInternalObjectId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObjectInternal(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            DNStateManager<Object> sm;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            Object pc = obj;
            if (this.getApiAdapter().isDetached(obj)) {
                pc = this.findObject(this.getApiAdapter().getIdForObject(obj), true, true, null);
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("010019", StringUtils.toJVMIDString(pc)));
            }
            if (this.getApiAdapter().getName().equals("JDO")) {
                if (!this.getApiAdapter().isPersistent(pc) && !this.getApiAdapter().isTransactional(pc)) {
                    throw new NucleusUserException(Localiser.msg("010020"));
                }
                if (!this.getApiAdapter().isPersistent(pc) && this.getApiAdapter().isTransactional(pc)) {
                    throw new NucleusUserException(Localiser.msg("010021", this.getApiAdapter().getIdForObject(obj)));
                }
            }
            if ((sm = this.findStateManager(pc)) == null) {
                if (!this.getApiAdapter().allowDeleteOfNonPersistentObject()) {
                    throw new NucleusUserException(Localiser.msg("010007", this.getApiAdapter().getIdForObject(pc)));
                }
                sm = this.nucCtx.getStateManagerFactory().newForPNewToBeDeleted(this, pc);
            }
            if (this.l2CacheTxIds != null && this.nucCtx.isClassCacheable(sm.getClassMetaData())) {
                this.l2CacheTxIds.add(sm.getInternalObjectId());
            }
            sm.deletePersistent();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeObjectTransient(Object obj, FetchPlanState state) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("010022", StringUtils.toJVMIDString(obj)));
            }
            if (this.getApiAdapter().isPersistent(obj)) {
                DNStateManager sm = this.findStateManager(obj);
                sm.makeTransient(state);
            }
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public void makeObjectTransactional(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            DNStateManager<Object> sm;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            if (this.getApiAdapter().isPersistent(obj)) {
                this.assertActiveTransaction();
            }
            if ((sm = this.findStateManager(obj)) == null) {
                sm = this.nucCtx.getStateManagerFactory().newForTransactionalTransient(this, obj);
            }
            sm.makeTransactional();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public void makeObjectNontransactional(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            if (!this.getApiAdapter().isPersistent(obj) && this.getApiAdapter().isTransactional(obj) && this.getApiAdapter().isDirty(obj)) {
                throw new NucleusUserException(Localiser.msg("010024"));
            }
            DNStateManager sm = this.findStateManager(obj);
            sm.makeNontransactional();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public void attachObject(DNStateManager ownerSM, Object pc, boolean sco) {
        ApiAdapter api;
        Object id;
        this.assertClassPersistable(pc.getClass());
        Map<Persistable, DNStateManager> attachedOwnerByObject = this.getThreadContextInfo().attachedOwnerByObject;
        if (attachedOwnerByObject != null) {
            attachedOwnerByObject.put((Persistable)pc, ownerSM);
        }
        if ((id = (api = this.getApiAdapter()).getIdForObject(pc)) != null && this.isInserting(pc)) {
            return;
        }
        if (id == null && !sco) {
            this.persistObjectInternal(pc, null, null, -1, PersistableObjectType.PC);
            return;
        }
        if (api.isDetached(pc)) {
            DNStateManager l1CachedSM;
            DNStateManager dNStateManager = l1CachedSM = this.cache != null ? (DNStateManager)this.cache.get(id) : null;
            if (l1CachedSM != null && l1CachedSM.getObject() != pc) {
                throw new NucleusUserException(Localiser.msg("010017", IdentityUtils.getPersistableIdentityForId(id)));
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("010016", IdentityUtils.getPersistableIdentityForId(id)));
            }
        } else {
            return;
        }
        this.nucCtx.getStateManagerFactory().newForDetached(this, pc, id, api.getVersionForObject(pc)).attach(sco);
    }

    @Override
    public <T> T attachObjectCopy(DNStateManager ownerSM, T pc, boolean sco) {
        ApiAdapter api;
        Object id;
        this.assertClassPersistable(pc.getClass());
        this.assertDetachable(pc);
        Map<Persistable, DNStateManager> attachedOwnerByObject = this.getThreadContextInfo().attachedOwnerByObject;
        if (attachedOwnerByObject != null) {
            attachedOwnerByObject.put((Persistable)pc, ownerSM);
        }
        if ((id = (api = this.getApiAdapter()).getIdForObject(pc)) != null && this.isInserting(pc)) {
            return pc;
        }
        if (id == null && !sco) {
            return this.persistObjectInternal(pc, null, null, -1, PersistableObjectType.PC);
        }
        if (api.isPersistent(pc)) {
            return pc;
        }
        Persistable pcTarget = null;
        if (sco) {
            boolean detached = this.getApiAdapter().isDetached(pc);
            DNStateManager<T> targetSM = this.nucCtx.getStateManagerFactory().newForEmbedded(this, pc, true, null, -1, PersistableObjectType.EMBEDDED_PC);
            pcTarget = targetSM.getObject();
            if (detached) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("010018", StringUtils.toJVMIDString(pc), StringUtils.toJVMIDString(pcTarget)));
                }
                targetSM.attachCopy(pc, sco);
            }
        } else {
            boolean detached = this.getApiAdapter().isDetached(pc);
            pcTarget = this.findObject(id, false, false, pc.getClass().getName());
            if (detached) {
                Persistable obj = null;
                Map<Object, Persistable> attachedPCById = this.getThreadContextInfo().attachedPCById;
                if (attachedPCById != null) {
                    obj = attachedPCById.get(this.getApiAdapter().getIdForObject(pc));
                }
                if (obj != null) {
                    pcTarget = obj;
                } else {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(Localiser.msg("010018", StringUtils.toJVMIDString(pc), StringUtils.toJVMIDString(pcTarget)));
                    }
                    pcTarget = this.findStateManager(pcTarget).attachCopy(pc, sco);
                    if (attachedPCById != null) {
                        attachedPCById.put(this.getApiAdapter().getIdForObject(pc), pcTarget);
                    }
                }
            }
        }
        return (T)pcTarget;
    }

    @Override
    public Object getAttachedObjectForId(Object id) {
        DNStateManager sm = this.enlistedSMCache.get(id);
        if (sm == null && this.cache != null) {
            sm = (DNStateManager)this.cache.get(id);
        }
        return sm != null ? sm.getObject() : null;
    }

    @Override
    public void detachObject(FetchPlanState state, Object obj) {
        DNStateManager sm;
        if (this.getApiAdapter().isDetached(obj)) {
            return;
        }
        if (!this.getApiAdapter().isPersistent(obj)) {
            if (this.runningDetachAllOnTxnEnd && !this.getMetaDataManager().getMetaDataForClass(obj.getClass(), this.clr).isDetachable()) {
                return;
            }
            if (this.tx.isActive()) {
                this.persistObjectInternal(obj, null, null, -1, PersistableObjectType.PC);
            }
        }
        if ((sm = this.findStateManager(obj)) == null) {
            throw new NucleusUserException(Localiser.msg("010007", this.getApiAdapter().getIdForObject(obj)));
        }
        sm.detach(state);
        if (this.dirtySMs.contains(sm) || this.indirectDirtySMs.contains(sm)) {
            NucleusLogger.GENERAL.info(Localiser.msg("010047", StringUtils.toJVMIDString(obj)));
            this.clearDirty(sm);
        }
    }

    @Override
    public void detachObjects(FetchPlanState state, Object ... pcs) {
        if (pcs == null || pcs.length == 0) {
            return;
        }
        HashSet<DNStateManager> smsToDetach = new HashSet<DNStateManager>();
        for (Object pc : pcs) {
            DNStateManager sm;
            if (this.getApiAdapter().isDetached(pc)) continue;
            if (!this.getApiAdapter().isPersistent(pc)) {
                if (this.runningDetachAllOnTxnEnd && !this.getMetaDataManager().getMetaDataForClass(pc.getClass(), this.clr).isDetachable()) continue;
                if (this.tx.isActive()) {
                    this.persistObjectInternal(pc, null, null, -1, PersistableObjectType.PC);
                }
            }
            if ((sm = this.findStateManager(pc)) == null) continue;
            smsToDetach.add(sm);
        }
        for (DNStateManager sm : smsToDetach) {
            sm.detach(state);
            if (!this.dirtySMs.contains(sm) && !this.indirectDirtySMs.contains(sm)) continue;
            NucleusLogger.GENERAL.info(Localiser.msg("010047", StringUtils.toJVMIDString(sm.getObject())));
            this.clearDirty(sm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T detachObjectCopy(FetchPlanState state, T pc) {
        Object thePC = pc;
        try {
            DNStateManager sm;
            this.clr.setPrimary(pc.getClass().getClassLoader());
            if (!this.getApiAdapter().isPersistent(pc) && !this.getApiAdapter().isDetached(pc)) {
                if (this.tx.isActive()) {
                    thePC = this.persistObjectInternal(pc, null, null, -1, PersistableObjectType.PC);
                } else {
                    throw new NucleusUserException(Localiser.msg("010014"));
                }
            }
            if (this.getApiAdapter().isDetached(thePC)) {
                thePC = this.findObject(this.getApiAdapter().getIdForObject(thePC), false, true, null);
            }
            if ((sm = this.findStateManager(thePC)) == null) {
                throw new NucleusUserException(Localiser.msg("010007", this.getApiAdapter().getIdForObject(thePC)));
            }
            Object t = sm.detachCopy(state);
            return t;
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public void detachAll() {
        HashSet<DNStateManager> smsToDetach = new HashSet<DNStateManager>(this.enlistedSMCache.values());
        if (this.cache != null && !this.cache.isEmpty()) {
            smsToDetach.addAll(this.cache.values());
        }
        FetchPlanState fps = new FetchPlanState();
        for (DNStateManager sm : smsToDetach) {
            sm.detach(fps);
        }
    }

    @Override
    public Object getAttachDetachReferencedObject(DNStateManager sm) {
        if (this.smAttachDetachObjectReferenceMap == null) {
            return null;
        }
        return this.smAttachDetachObjectReferenceMap.get(sm);
    }

    @Override
    public void setAttachDetachReferencedObject(DNStateManager sm, Object obj) {
        if (obj != null) {
            if (this.smAttachDetachObjectReferenceMap == null) {
                this.smAttachDetachObjectReferenceMap = new HashMap<DNStateManager, Object>();
            }
            this.smAttachDetachObjectReferenceMap.put(sm, obj);
        } else if (this.smAttachDetachObjectReferenceMap != null) {
            this.smAttachDetachObjectReferenceMap.remove(sm);
        }
    }

    @Override
    public <T> T newInstance(Class<T> cls) {
        if (this.getApiAdapter().isPersistable(cls) && !Modifier.isAbstract(cls.getModifiers())) {
            try {
                return cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new NucleusUserException(e.toString(), e);
            }
        }
        if (this.getNucleusContext().getImplementationCreator() == null) {
            throw new NucleusUserException(Localiser.msg("010035"));
        }
        return this.getNucleusContext().getImplementationCreator().newInstance(cls, this.clr);
    }

    @Override
    public boolean exists(Object obj) {
        if (obj == null) {
            return false;
        }
        Object id = this.getApiAdapter().getIdForObject(obj);
        if (id == null) {
            return false;
        }
        try {
            this.findObject(id, true, false, obj.getClass().getName());
        }
        catch (NucleusObjectNotFoundException onfe) {
            return false;
        }
        return true;
    }

    @Override
    public Set getManagedObjects() {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet objs = new HashSet();
        for (DNStateManager sm : this.enlistedSMCache.values()) {
            objs.add(sm.getObject());
        }
        return objs;
    }

    @Override
    public Set getManagedObjects(Class[] classes) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet objs = new HashSet();
        block0: for (DNStateManager sm : this.enlistedSMCache.values()) {
            for (int i = 0; i < classes.length; ++i) {
                if (classes[i] != sm.getObject().getClass()) continue;
                objs.add(sm.getObject());
                continue block0;
            }
        }
        return objs;
    }

    @Override
    public Set getManagedObjects(String[] states) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet objs = new HashSet();
        block0: for (DNStateManager sm : this.enlistedSMCache.values()) {
            for (int i = 0; i < states.length; ++i) {
                if (!this.getApiAdapter().getObjectState(sm.getObject()).equals(states[i])) continue;
                objs.add(sm.getObject());
                continue block0;
            }
        }
        return objs;
    }

    @Override
    public Set getManagedObjects(String[] states, Class[] classes) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet objs = new HashSet();
        block0: for (DNStateManager sm : this.enlistedSMCache.values()) {
            boolean matches = false;
            for (int i = 0; i < states.length; ++i) {
                if (this.getApiAdapter().getObjectState(sm.getObject()).equals(states[i])) {
                    for (int j = 0; j < classes.length; ++j) {
                        if (classes[j] != sm.getObject().getClass()) continue;
                        matches = true;
                        objs.add(sm.getObject());
                        break;
                    }
                }
                if (matches) continue block0;
            }
        }
        return objs;
    }

    @Override
    public <T> T findObject(Class<T> cls, Object key) {
        if (cls == null || key == null) {
            throw new NucleusUserException(Localiser.msg("010051", cls, key));
        }
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(cls, this.clr);
        if (cmd == null) {
            throw new NucleusUserException(Localiser.msg("010052", cls.getName()));
        }
        Object id = key;
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            if (!IdentityUtils.isDatastoreIdentity(key)) {
                id = this.nucCtx.getIdentityManager().getDatastoreId(cmd.getFullClassName(), key);
            }
        } else if (!cmd.getObjectidClass().equals(key.getClass().getName())) {
            try {
                id = this.newObjectId(cls, key);
            }
            catch (NucleusException ne) {
                throw new IllegalArgumentException(ne);
            }
        }
        return (T)this.findObject(id, true, true, null);
    }

    @Override
    public <T> List<T> findObjects(Class<T> cls, List keys) {
        if (cls == null || keys == null) {
            throw new NucleusUserException(Localiser.msg("010051", cls, keys));
        }
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(cls, this.clr);
        if (cmd == null) {
            throw new NucleusUserException(Localiser.msg("010052", cls.getName()));
        }
        ArrayList<Persistable> objs = new ArrayList<Persistable>();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key;
            Object id = key = iterator.next();
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                if (!IdentityUtils.isDatastoreIdentity(key)) {
                    id = this.nucCtx.getIdentityManager().getDatastoreId(cmd.getFullClassName(), key);
                }
            } else if (!cmd.getObjectidClass().equals(key.getClass().getName())) {
                try {
                    id = this.newObjectId(cls, key);
                }
                catch (NucleusException ne) {
                    throw new IllegalArgumentException(ne);
                }
            }
            objs.add(this.findObject(id, true, true, null));
        }
        return objs;
    }

    @Override
    public <T> T findObjectByUnique(Class<T> cls, String[] memberNames, Object[] memberValues) {
        DNStateManager sm;
        if (cls == null || memberNames == null || memberNames.length == 0 || memberValues == null || memberValues.length == 0) {
            throw new NucleusUserException(Localiser.msg("010053", cls, StringUtils.objectArrayToString(memberNames), StringUtils.objectArrayToString(memberValues)));
        }
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(cls, this.clr);
        if (cmd == null) {
            throw new NucleusUserException(Localiser.msg("010052", cls.getName()));
        }
        for (String memberName : memberNames) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForMember(memberName);
            if (mmd != null) continue;
            throw new NucleusUserException("Attempt to find object using unique key of class " + cmd.getFullClassName() + " but field " + memberName + " doesnt exist!");
        }
        CacheUniqueKey uniKey = new CacheUniqueKey(cls.getName(), memberNames, memberValues);
        DNStateManager dNStateManager = sm = this.cache != null ? this.cache.getUnique(uniKey) : null;
        if (sm == null && this.l2CacheEnabled) {
            Persistable pc;
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(Localiser.msg("003007", uniKey));
            }
            if ((pc = this.getObjectFromLevel2CacheForUnique(uniKey)) != null) {
                sm = this.findStateManager(pc);
            }
        }
        if (sm != null) {
            return sm.getObject();
        }
        return (T)this.getStoreManager().getPersistenceHandler().findObjectForUnique(this, cmd, memberNames, memberValues);
    }

    @Override
    public Persistable findObject(Object id, boolean validate) {
        return this.findObject(id, validate, validate, null);
    }

    @Override
    public Persistable findObject(Object id, FieldValues fv, Class cls, boolean ignoreCache, boolean checkInheritance) {
        this.assertIsOpen();
        Persistable pc = null;
        DNStateManager sm = null;
        if (!ignoreCache) {
            pc = this.getObjectFromCache(id);
        }
        if (pc == null) {
            pc = (Persistable)this.getStoreManager().getPersistenceHandler().findObject(this, id);
        }
        boolean createdHollow = false;
        if (pc == null) {
            String className;
            String string = className = cls != null ? cls.getName() : null;
            if (!(id instanceof SCOID)) {
                ClassDetailsForId details = this.getClassDetailsForId(id, className, checkInheritance);
                if (details.className != null && cls != null && !cls.getName().equals(details.className)) {
                    cls = this.clr.classForName(details.className);
                }
                className = details.className;
                id = details.id;
                if (details.pc != null) {
                    pc = details.pc;
                    sm = this.findStateManager(pc);
                }
            }
            if (pc == null) {
                if (cls == null) {
                    try {
                        cls = this.clr.classForName(className, id.getClass().getClassLoader());
                    }
                    catch (ClassNotResolvedException e) {
                        String msg = Localiser.msg("010027", IdentityUtils.getPersistableIdentityForId(id));
                        NucleusLogger.PERSISTENCE.warn(msg);
                        throw new NucleusUserException(msg, e);
                    }
                }
                createdHollow = true;
                sm = this.nucCtx.getStateManagerFactory().newForHollow(this, cls, id, fv);
                pc = (Persistable)sm.getObject();
                this.putObjectIntoLevel2Cache(sm, false);
            }
        }
        if (pc != null && fv != null && !createdHollow) {
            if (sm == null) {
                sm = this.findStateManager(pc);
            }
            if (sm != null) {
                fv.fetchNonLoadedFields(sm);
            }
        }
        return pc;
    }

    @Override
    public Persistable[] findObjectsById(Object[] identities, boolean validate) {
        Iterator<Object> pc3;
        Map<Object, Persistable> pcsById;
        if (identities == null) {
            return null;
        }
        if (identities.length == 1) {
            return new Persistable[]{this.findObject(identities[0], validate, validate, null)};
        }
        for (int i = 0; i < identities.length; ++i) {
            if (identities[i] != null) continue;
            throw new NucleusUserException(Localiser.msg("010044"));
        }
        Object[] ids = new Object[identities.length];
        for (int i = 0; i < identities.length; ++i) {
            IdentityStringTranslator idStringTranslator;
            ids[i] = identities[i] instanceof String && (idStringTranslator = this.getNucleusContext().getIdentityManager().getIdentityStringTranslator()) != null ? idStringTranslator.getIdentity(this, (String)identities[i]) : identities[i];
        }
        HashMap<Object, Persistable> pcById = new HashMap<Object, Persistable>(identities.length);
        ArrayList<Object> idsToFind = new ArrayList<Object>();
        ApiAdapter api = this.getApiAdapter();
        for (int i = 0; i < ids.length; ++i) {
            Persistable pc2 = this.getObjectFromLevel1Cache(ids[i]);
            if (pc2 != null) {
                if (ids[i] instanceof SCOID && api.isPersistent(pc2) && !api.isNew(pc2) && !api.isDeleted(pc2) && !api.isTransactional(pc2)) {
                    throw new NucleusUserException(Localiser.msg("010005"));
                }
                pcById.put(ids[i], pc2);
                continue;
            }
            idsToFind.add(ids[i]);
        }
        if (!idsToFind.isEmpty() && this.l2CacheEnabled && !(pcsById = this.getObjectsFromLevel2Cache(idsToFind)).isEmpty()) {
            for (Map.Entry<Object, Persistable> entry : pcsById.entrySet()) {
                pcById.put(entry.getKey(), entry.getValue());
                idsToFind.remove(entry.getKey());
            }
        }
        boolean performValidationWhenCached = this.nucCtx.getConfiguration().getBooleanProperty("datanucleus.findObject.validateWhenCached");
        ArrayList smsToValidate = new ArrayList();
        if (validate && performValidationWhenCached) {
            Collection pcValues = pcById.values();
            for (Iterator<Object> pc3 : pcValues) {
                if (api.isTransactional(pc3)) continue;
                smsToValidate.add(this.findStateManager(pc3));
            }
        }
        Object[] foundPcs = null;
        if (!idsToFind.isEmpty()) {
            foundPcs = this.getStoreManager().getPersistenceHandler().findObjects(this, idsToFind.toArray());
        }
        int foundPcIdx = 0;
        pc3 = idsToFind.iterator();
        while (pc3.hasNext()) {
            Object id;
            Object idOrig = id = pc3.next();
            Persistable pc4 = foundPcs != null ? (Persistable)foundPcs[foundPcIdx++] : null;
            DNStateManager sm = null;
            if (pc4 != null) {
                sm = this.findStateManager(pc4);
                this.putObjectIntoLevel1Cache(sm);
            } else {
                ClassDetailsForId details = this.getClassDetailsForId(id, null, validate);
                String className = details.className;
                id = details.id;
                if (details.pc != null) {
                    pc4 = details.pc;
                    sm = this.findStateManager(pc4);
                    if (performValidationWhenCached && validate && !api.isTransactional(pc4)) {
                        smsToValidate.add(sm);
                    }
                } else {
                    try {
                        Class pcClass = this.clr.classForName(className, id instanceof DatastoreId ? null : id.getClass().getClassLoader());
                        if (Modifier.isAbstract(pcClass.getModifiers())) {
                            throw new NucleusObjectNotFoundException(Localiser.msg("010027", IdentityUtils.getPersistableIdentityForId(id), className));
                        }
                        sm = this.nucCtx.getStateManagerFactory().newForHollow(this, pcClass, id);
                        pc4 = (Persistable)sm.getObject();
                        if (!validate) {
                            sm.markForInheritanceValidation();
                        }
                        this.putObjectIntoLevel1Cache(sm);
                    }
                    catch (ClassNotResolvedException e) {
                        NucleusLogger.PERSISTENCE.warn(Localiser.msg("010027", IdentityUtils.getPersistableIdentityForId(id)));
                        throw new NucleusUserException(Localiser.msg("010027", IdentityUtils.getPersistableIdentityForId(id)), e);
                    }
                    if (validate) {
                        smsToValidate.add(sm);
                    }
                }
            }
            pcById.put(idOrig, pc4);
        }
        if (!smsToValidate.isEmpty()) {
            try {
                this.getStoreManager().getPersistenceHandler().locateObjects(smsToValidate.toArray(new DNStateManager[smsToValidate.size()]));
            }
            catch (NucleusObjectNotFoundException nonfe) {
                NucleusObjectNotFoundException[] nonfes = (NucleusObjectNotFoundException[])nonfe.getNestedExceptions();
                if (nonfes != null) {
                    for (int i = 0; i < nonfes.length; ++i) {
                        Object missingId = nonfes[i].getFailedObject();
                        this.removeObjectFromLevel1Cache(missingId);
                    }
                }
                throw nonfe;
            }
        }
        Persistable[] objs = new Persistable[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            Object id = ids[i];
            objs[i] = (Persistable)pcById.get(id);
        }
        return objs;
    }

    @Override
    public Persistable findObject(Object id, boolean validate, boolean checkInheritance, String objectClassName) {
        if (id == null) {
            throw new NucleusUserException(Localiser.msg("010044"));
        }
        IdentityStringTranslator translator = this.getNucleusContext().getIdentityManager().getIdentityStringTranslator();
        if (translator != null && id instanceof String) {
            id = translator.getIdentity(this, (String)id);
        }
        ApiAdapter api = this.getApiAdapter();
        boolean fromCache = false;
        Persistable pc = this.getObjectFromCache(id);
        DNStateManager sm = null;
        if (pc != null) {
            fromCache = true;
            if (id instanceof SCOID && api.isPersistent(pc) && !api.isNew(pc) && !api.isDeleted(pc) && !api.isTransactional(pc)) {
                throw new NucleusUserException(Localiser.msg("010005"));
            }
            if (api.isTransactional(pc)) {
                return pc;
            }
            sm = this.findStateManager(pc);
        } else {
            pc = (Persistable)this.getStoreManager().getPersistenceHandler().findObject(this, id);
            if (pc != null) {
                sm = this.findStateManager(pc);
                this.putObjectIntoLevel1Cache(sm);
                this.putObjectIntoLevel2Cache(sm, false);
            } else {
                ClassDetailsForId details = this.getClassDetailsForId(id, objectClassName, checkInheritance);
                String className = details.className;
                id = details.id;
                if (details.pc != null) {
                    pc = details.pc;
                    sm = this.findStateManager(pc);
                    fromCache = true;
                } else {
                    try {
                        Class pcClass = this.clr.classForName(className, id instanceof DatastoreId ? null : id.getClass().getClassLoader());
                        if (Modifier.isAbstract(pcClass.getModifiers())) {
                            throw new NucleusObjectNotFoundException(Localiser.msg("010027", IdentityUtils.getPersistableIdentityForId(id), className));
                        }
                        sm = this.nucCtx.getStateManagerFactory().newForHollow(this, pcClass, id);
                        pc = (Persistable)sm.getObject();
                        if (!checkInheritance && !validate) {
                            sm.markForInheritanceValidation();
                        }
                        this.putObjectIntoLevel1Cache(sm);
                    }
                    catch (ClassNotResolvedException e) {
                        NucleusLogger.PERSISTENCE.warn(Localiser.msg("010027", IdentityUtils.getPersistableIdentityForId(id)));
                        throw new NucleusUserException(Localiser.msg("010027", IdentityUtils.getPersistableIdentityForId(id)), e);
                    }
                }
            }
        }
        boolean performValidationWhenCached = this.nucCtx.getConfiguration().getBooleanProperty("datanucleus.findObject.validateWhenCached");
        if (validate && (!fromCache || performValidationWhenCached)) {
            if (!fromCache) {
                this.putObjectIntoLevel1Cache(sm);
            }
            try {
                sm.validate();
                if (sm.getObject() != pc) {
                    fromCache = false;
                    pc = (Persistable)sm.getObject();
                    this.putObjectIntoLevel1Cache(sm);
                }
            }
            catch (NucleusObjectNotFoundException onfe) {
                this.removeObjectFromLevel1Cache(sm.getInternalObjectId());
                throw onfe;
            }
        }
        if (!fromCache) {
            this.putObjectIntoLevel2Cache(sm, false);
        }
        return pc;
    }

    private ClassDetailsForId getClassDetailsForId(Object id, String objectClassName, boolean checkInheritance) {
        String className = null;
        String originalClassName = null;
        boolean checkedClassName = false;
        if (id instanceof SCOID) {
            throw new NucleusUserException(Localiser.msg("010006"));
        }
        if (id instanceof DatastoreUniqueLongId) {
            throw new NucleusObjectNotFoundException(Localiser.msg("010026", IdentityUtils.getPersistableIdentityForId(id)), id);
        }
        originalClassName = objectClassName != null ? objectClassName : this.getStoreManager().manageClassForIdentity(id, this.clr);
        if (originalClassName == null) {
            originalClassName = this.getClassNameForObjectId(id);
            checkedClassName = true;
        }
        Persistable pc = null;
        if (checkInheritance) {
            String[] subclasses;
            String string = className = checkedClassName ? originalClassName : this.getClassNameForObjectId(id);
            if (className == null) {
                throw new NucleusObjectNotFoundException(Localiser.msg("010026", IdentityUtils.getPersistableIdentityForId(id)), id);
            }
            if (!checkedClassName && (IdentityUtils.isDatastoreIdentity(id) || IdentityUtils.isSingleFieldIdentity(id)) && (subclasses = this.getMetaDataManager().getSubclassesForClass(className, true)) != null) {
                for (int i = 0; i < subclasses.length; ++i) {
                    Object oid = null;
                    if (IdentityUtils.isDatastoreIdentity(id)) {
                        oid = this.nucCtx.getIdentityManager().getDatastoreId(subclasses[i], IdentityUtils.getTargetKeyForDatastoreIdentity(id));
                    } else if (IdentityUtils.isSingleFieldIdentity(id)) {
                        oid = this.nucCtx.getIdentityManager().getSingleFieldId(id.getClass(), this.getClassLoaderResolver().classForName(subclasses[i]), IdentityUtils.getTargetKeyForSingleFieldIdentity(id));
                    }
                    pc = this.getObjectFromCache(oid);
                    if (pc == null) continue;
                    className = subclasses[i];
                    break;
                }
            }
            if (pc == null && originalClassName != null && !originalClassName.equals(className)) {
                if (IdentityUtils.isDatastoreIdentity(id)) {
                    id = this.nucCtx.getIdentityManager().getDatastoreId(className, ((DatastoreId)id).getKeyAsObject());
                    pc = this.getObjectFromCache(id);
                } else if (IdentityUtils.isSingleFieldIdentity(id)) {
                    id = this.nucCtx.getIdentityManager().getSingleFieldId(id.getClass(), this.clr.classForName(className), IdentityUtils.getTargetKeyForSingleFieldIdentity(id));
                    pc = this.getObjectFromCache(id);
                }
            }
        } else {
            className = originalClassName;
        }
        return new ClassDetailsForId(id, className, pc);
    }

    private String getClassNameForObjectId(Object id) {
        Collection<AbstractClassMetaData> cmds;
        String className = this.getStoreManager().manageClassForIdentity(id, this.clr);
        if (className == null && (cmds = this.getMetaDataManager().getClassMetaDataWithApplicationId(id.getClass().getName())) != null && cmds.size() == 1) {
            return cmds.iterator().next().getFullClassName();
        }
        if (className != null) {
            Class rootCls;
            String[] subclasses = this.getMetaDataManager().getConcreteSubclassesForClass(className);
            int numConcrete = 0;
            String concreteClassName = null;
            if (subclasses != null && subclasses.length > 0) {
                numConcrete = subclasses.length;
                concreteClassName = subclasses[0];
            }
            if (!Modifier.isAbstract((rootCls = this.clr.classForName(className)).getModifiers())) {
                concreteClassName = className;
                ++numConcrete;
            }
            if (numConcrete == 1) {
                return concreteClassName;
            }
        }
        return this.getStoreManager().getClassNameForObjectID(id, this.clr, this);
    }

    @Override
    public Object newObjectId(Class pcClass, Object key) {
        IdentityKeyTranslator translator;
        if (pcClass == null) {
            throw new NucleusUserException(Localiser.msg("010028"));
        }
        this.assertClassPersistable(pcClass);
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(pcClass, this.clr);
        if (cmd == null) {
            throw new NoPersistenceInformationException(pcClass.getName());
        }
        if (!this.getStoreManager().managesClass(cmd.getFullClassName())) {
            this.getStoreManager().manageClasses(this.clr, cmd.getFullClassName());
        }
        if ((translator = this.getNucleusContext().getIdentityManager().getIdentityKeyTranslator()) != null) {
            key = translator.getKey(this, pcClass, key);
        }
        Object id = null;
        if (cmd.usesSingleFieldIdentityClass()) {
            Object convKey;
            AbstractMemberMetaData mmd;
            if (this.getBooleanProperty("datanucleus.findObject.typeConversion").booleanValue() && translator == null && !key.getClass().getName().equals(cmd.getObjectidClass()) && !(mmd = cmd.getMetaDataForMember(cmd.getPrimaryKeyMemberNames()[0])).getType().isAssignableFrom(key.getClass()) && (convKey = TypeConversionHelper.convertTo(key, mmd.getType())) != null) {
                key = convKey;
            }
            id = this.nucCtx.getIdentityManager().getSingleFieldId(this.clr.classForName(cmd.getObjectidClass()), pcClass, key);
        } else if (key instanceof String) {
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                if (Modifier.isAbstract(pcClass.getModifiers()) && cmd.getObjectidClass() != null) {
                    try {
                        Constructor c = this.clr.classForName(cmd.getObjectidClass()).getDeclaredConstructor(String.class);
                        id = c.newInstance((String)key);
                    }
                    catch (Exception e) {
                        String msg = Localiser.msg("010030", cmd.getObjectidClass(), cmd.getFullClassName());
                        NucleusLogger.PERSISTENCE.error(msg, e);
                        throw new NucleusUserException(msg);
                    }
                } else {
                    this.clr.classForName(pcClass.getName(), true);
                    id = this.nucCtx.getIdentityManager().getApplicationId(pcClass, key);
                }
            } else {
                id = this.nucCtx.getIdentityManager().getDatastoreId((String)key);
            }
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE && key instanceof Number) {
            id = this.nucCtx.getIdentityManager().getDatastoreId(pcClass.getName(), key);
        } else {
            throw new NucleusUserException(Localiser.msg("010029", pcClass.getName(), key.getClass().getName()));
        }
        return id;
    }

    @Override
    public Object newObjectId(String className, Object pc) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, this.clr);
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            return this.nucCtx.getIdentityManager().getDatastoreId(cmd.getFullClassName(), this.getStoreManager().getValueGenerationStrategyValue(this, cmd, null));
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            return this.nucCtx.getIdentityManager().getApplicationId(pc, cmd);
        }
        return new SCOID(className);
    }

    @Override
    public void clearDirty(DNStateManager sm) {
        this.dirtySMs.remove(sm);
        this.indirectDirtySMs.remove(sm);
    }

    @Override
    public void clearDirty() {
        this.dirtySMs.clear();
        this.indirectDirtySMs.clear();
    }

    @Override
    public void markDirty(DNStateManager sm, boolean directUpdate) {
        if (sm.isEmbedded()) {
            return;
        }
        if (this.tx.isCommitting() && !this.tx.isActive()) {
            throw new NucleusException("Cannot change objects when transaction is no longer active.");
        }
        boolean isInDirty = this.dirtySMs.contains(sm);
        boolean isInIndirectDirty = this.indirectDirtySMs.contains(sm);
        if (!(this.isDelayDatastoreOperationsEnabled() || isInDirty || isInIndirectDirty || this.dirtySMs.size() < this.getNucleusContext().getConfiguration().getIntProperty("datanucleus.flush.auto.objectLimit"))) {
            this.flushInternal(false);
        }
        if (directUpdate) {
            if (isInIndirectDirty) {
                this.indirectDirtySMs.remove(sm);
                this.dirtySMs.add(sm);
            } else if (!isInDirty) {
                this.dirtySMs.add(sm);
                if (this.l2CacheTxIds != null && this.nucCtx.isClassCacheable(sm.getClassMetaData())) {
                    this.l2CacheTxIds.add(sm.getInternalObjectId());
                }
            }
        } else if (!isInDirty && !isInIndirectDirty) {
            this.indirectDirtySMs.add(sm);
            if (this.l2CacheTxIds != null && this.nucCtx.isClassCacheable(sm.getClassMetaData())) {
                this.l2CacheTxIds.add(sm.getInternalObjectId());
            }
        }
    }

    @Override
    public boolean getManageRelations() {
        return this.managedRelationsHandler != null;
    }

    @Override
    public RelationshipManager getRelationshipManager(DNStateManager sm) {
        return this.managedRelationsHandler != null ? this.managedRelationsHandler.getRelationshipManagerForStateManager(sm) : null;
    }

    @Override
    public boolean isManagingRelations() {
        return this.managedRelationsHandler != null ? this.managedRelationsHandler.isExecuting() : false;
    }

    @Override
    public List<DNStateManager> getObjectsToBeFlushed() {
        ArrayList<DNStateManager> sms = new ArrayList<DNStateManager>();
        sms.addAll(this.dirtySMs);
        sms.addAll(this.indirectDirtySMs);
        return sms;
    }

    @Override
    public boolean isFlushing() {
        return this.flushing > 0;
    }

    @Override
    public void flush() {
        if (this.tx.isActive()) {
            if (this.managedRelationsHandler != null) {
                this.managedRelationsHandler.execute();
            }
            this.flushInternal(true);
            if (!this.dirtySMs.isEmpty() || !this.indirectDirtySMs.isEmpty()) {
                NucleusLogger.PERSISTENCE.debug("Flush pass 1 resulted in " + (this.dirtySMs.size() + this.indirectDirtySMs.size()) + " additional objects being made dirty. Performing flush pass 2");
                this.flushInternal(true);
            }
            if (this.operationQueue != null && !this.operationQueue.getOperations().isEmpty()) {
                NucleusLogger.PERSISTENCE.warn("Queue of operations after flush() is not empty! Generate a testcase and report this. See below (debug) for full details of unflushed ops");
                this.operationQueue.log();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushInternal(boolean flushToDatastore) {
        if (!flushToDatastore && this.dirtySMs.isEmpty() && this.indirectDirtySMs.isEmpty()) {
            return;
        }
        if (!this.tx.isActive()) {
            if (this.nontxProcessedSMs == null) {
                this.nontxProcessedSMs = new HashSet<DNStateManager>();
            }
            this.nontxProcessedSMs.addAll(this.dirtySMs);
            this.nontxProcessedSMs.addAll(this.indirectDirtySMs);
        }
        ++this.flushing;
        try {
            if (flushToDatastore) {
                this.tx.preFlush();
            }
            FlushProcess flusher = this.getStoreManager().getFlushProcess();
            List<NucleusOptimisticException> optimisticFailures = flusher.execute(this, this.dirtySMs, this.indirectDirtySMs, this.operationQueue);
            if (flushToDatastore) {
                this.tx.flush();
            }
            if (optimisticFailures != null) {
                throw new NucleusOptimisticException(Localiser.msg("010031"), optimisticFailures.toArray(new Throwable[optimisticFailures.size()]));
            }
        }
        finally {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("010004"));
            }
            --this.flushing;
        }
    }

    @Override
    public OperationQueue getOperationQueue() {
        return this.operationQueue;
    }

    @Override
    public void addOperationToQueue(Operation oper) {
        if (this.operationQueue == null) {
            this.operationQueue = new OperationQueue();
        }
        this.operationQueue.enqueue(oper);
    }

    @Override
    public void flushOperationsForBackingStore(Store backingStore, DNStateManager sm) {
        if (this.operationQueue != null) {
            this.operationQueue.performAll(backingStore, sm);
        }
    }

    @Override
    public boolean operationQueueIsActive() {
        return this.isDelayDatastoreOperationsEnabled() && !this.isFlushing() && this.getTransaction().isActive();
    }

    public void postBegin() {
        int i;
        DNStateManager[] sms = this.dirtySMs.toArray(new DNStateManager[this.dirtySMs.size()]);
        for (i = 0; i < sms.length; ++i) {
            sms[i].preBegin(this.tx);
        }
        sms = this.indirectDirtySMs.toArray(new DNStateManager[this.indirectDirtySMs.size()]);
        for (i = 0; i < sms.length; ++i) {
            sms[i].preBegin(this.tx);
        }
    }

    public void preCommit() {
        if (this.cache != null && !this.cache.isEmpty()) {
            HashSet cachedSMs = new HashSet(this.cache.values());
            for (DNStateManager cachedSM : cachedSMs) {
                VersionMetaData vermd;
                LockMode lockMode = this.getLockManager().getLockMode(cachedSM);
                if (cachedSM == null || !cachedSM.isFlushedToDatastore() || !cachedSM.getClassMetaData().isVersioned() || lockMode != LockMode.LOCK_OPTIMISTIC_WRITE && lockMode != LockMode.LOCK_PESSIMISTIC_WRITE || (vermd = cachedSM.getClassMetaData().getVersionMetaDataForClass()) == null) continue;
                if (vermd.getMemberName() != null) {
                    cachedSM.makeDirty((Persistable)cachedSM.getObject(), vermd.getMemberName());
                    this.dirtySMs.add(cachedSM);
                    continue;
                }
                NucleusLogger.PERSISTENCE.warn("We do not support forced version update with surrogate version columns : " + cachedSM);
            }
        }
        this.flush();
        if (this.pbrAtCommitHandler != null) {
            try {
                this.pbrAtCommitHandler.execute();
            }
            catch (Throwable t) {
                NucleusLogger.PERSISTENCE.error(t);
                if (t instanceof NucleusException) {
                    throw (NucleusException)t;
                }
                throw new NucleusException("Unexpected error during precommit", t);
            }
        }
        if (this.l2CacheEnabled) {
            this.performLevel2CacheUpdateAtCommit();
        }
        if (this.properties.getFrequentProperties().getDetachAllOnCommit().booleanValue()) {
            this.performDetachAllOnTxnEndPreparation();
        }
    }

    @Override
    public boolean isObjectModifiedInTransaction(Object id) {
        if (this.l2CacheTxIds != null) {
            return this.l2CacheTxIds.contains(id);
        }
        return false;
    }

    @Override
    public void markFieldsForUpdateInLevel2Cache(Object id, boolean[] fields) {
        if (this.l2CacheTxFieldsToUpdateById == null) {
            return;
        }
        BitSet bits = this.l2CacheTxFieldsToUpdateById.get(id);
        if (bits == null) {
            bits = new BitSet();
            this.l2CacheTxFieldsToUpdateById.put(id, bits);
        }
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i]) continue;
            bits.set(i);
        }
    }

    private void performLevel2CacheUpdateAtCommit() {
        if (this.l2CacheTxIds == null) {
            return;
        }
        String cacheStoreMode = this.getLevel2CacheStoreMode();
        if ("bypass".equalsIgnoreCase(cacheStoreMode)) {
            return;
        }
        HashSet<DNStateManager> smsToCache = null;
        HashSet<Object> idsToRemove = null;
        for (Object id : this.l2CacheTxIds) {
            DNStateManager sm = this.enlistedSMCache.get(id);
            if (sm == null) {
                if (NucleusLogger.CACHE.isDebugEnabled() && this.nucCtx.getLevel2Cache().containsOid(id)) {
                    NucleusLogger.CACHE.debug(Localiser.msg("004014", IdentityUtils.getPersistableIdentityForId(id)));
                }
                if (idsToRemove == null) {
                    idsToRemove = new HashSet<Object>();
                }
                idsToRemove.add(id);
                continue;
            }
            Object obj = sm.getObject();
            Object objID = this.getApiAdapter().getIdForObject(obj);
            if (objID == null || objID instanceof IdentityReference) continue;
            if (this.getApiAdapter().isDeleted(obj)) {
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("004007", IdentityUtils.getPersistableIdentityForId(sm.getInternalObjectId())));
                }
                if (idsToRemove == null) {
                    idsToRemove = new HashSet();
                }
                idsToRemove.add(objID);
                continue;
            }
            if (this.getApiAdapter().isDetached(obj)) continue;
            if (smsToCache == null) {
                smsToCache = new HashSet<DNStateManager>();
            }
            smsToCache.add(sm);
            if (this.l2CacheObjectsToEvictUponRollback == null) {
                this.l2CacheObjectsToEvictUponRollback = new LinkedList<Object>();
            }
            this.l2CacheObjectsToEvictUponRollback.add(id);
        }
        if (idsToRemove != null && !idsToRemove.isEmpty()) {
            this.nucCtx.getLevel2Cache().evictAll(idsToRemove);
        }
        if (smsToCache != null && !smsToCache.isEmpty()) {
            this.putObjectsIntoLevel2Cache((Set<DNStateManager>)smsToCache);
        }
        this.l2CacheTxIds.clear();
        this.l2CacheTxFieldsToUpdateById.clear();
    }

    private void performDetachAllOnTxnEndPreparation() {
        ArrayList<DNStateManager<Object>> sms = new ArrayList<DNStateManager<Object>>();
        Collection<Object> roots = this.fetchPlan.getDetachmentRoots();
        Class[] rootClasses = this.fetchPlan.getDetachmentRootClasses();
        if (roots != null && !roots.isEmpty()) {
            for (Object root : roots) {
                sms.add(this.findStateManager(root));
            }
        } else if (rootClasses != null && rootClasses.length > 0) {
            DNStateManager[] txSMs = this.enlistedSMCache.values().toArray(new DNStateManager[this.enlistedSMCache.size()]);
            block3: for (int i = 0; i < txSMs.length; ++i) {
                for (int j = 0; j < rootClasses.length; ++j) {
                    if (txSMs[i].getObject().getClass() != rootClasses[j]) continue;
                    sms.add(txSMs[i]);
                    continue block3;
                }
            }
        } else if (this.cache != null && !this.cache.isEmpty()) {
            sms.addAll(this.cache.values());
        }
        Iterator smsIter = sms.iterator();
        while (smsIter.hasNext()) {
            DNStateManager sm = (DNStateManager)smsIter.next();
            Object pc = sm != null ? sm.getObject() : null;
            if (pc == null || this.getApiAdapter().isDetached(pc) || this.getApiAdapter().isDeleted(pc)) continue;
            FetchPlanState state = new FetchPlanState();
            try {
                sm.loadFieldsInFetchPlan(state);
            }
            catch (NucleusObjectNotFoundException onfe) {
                NucleusLogger.PERSISTENCE.warn(Localiser.msg("010013", StringUtils.toJVMIDString(pc), sm.getInternalObjectId()));
                smsIter.remove();
            }
        }
        this.detachAllOnTxnEndSMs = sms.toArray(new DNStateManager[sms.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDetachAllOnTxnEnd() {
        try {
            this.runningDetachAllOnTxnEnd = true;
            if (this.detachAllOnTxnEndSMs != null) {
                DNStateManager[] smsToDetach = this.detachAllOnTxnEndSMs;
                DetachState state = new DetachState(this.getApiAdapter());
                for (int i = 0; i < smsToDetach.length; ++i) {
                    Object pc = smsToDetach[i].getObject();
                    if (pc == null) continue;
                    smsToDetach[i].detach(state);
                }
            }
        }
        finally {
            this.detachAllOnTxnEndSMs = null;
            this.runningDetachAllOnTxnEnd = false;
        }
    }

    @Override
    public boolean isRunningDetachAllOnCommit() {
        return this.runningDetachAllOnTxnEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommit() {
        if (this.properties.getFrequentProperties().getDetachAllOnCommit().booleanValue()) {
            this.performDetachAllOnTxnEnd();
        }
        ArrayList<RuntimeException> failures = null;
        try {
            ApiAdapter api = this.getApiAdapter();
            DNStateManager[] sms = this.enlistedSMCache.values().toArray(new DNStateManager[this.enlistedSMCache.size()]);
            for (int i = 0; i < sms.length; ++i) {
                try {
                    if (sms[i] == null || sms[i].getObject() == null || !api.isPersistent(sms[i].getObject()) && !api.isTransactional(sms[i].getObject())) continue;
                    sms[i].postCommit(this.getTransaction());
                    if (!this.properties.getFrequentProperties().getDetachAllOnCommit().booleanValue() || !api.isDetachable(sms[i].getObject())) continue;
                    this.removeStateManagerFromCache(sms[i]);
                    continue;
                }
                catch (RuntimeException e) {
                    if (failures == null) {
                        failures = new ArrayList<RuntimeException>();
                    }
                    failures.add(e);
                }
            }
        }
        finally {
            this.resetTransactionalVariables();
        }
        if (failures != null && !failures.isEmpty()) {
            throw new CommitStateTransitionException(failures.toArray(new Exception[failures.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRollback() {
        ArrayList<RuntimeException> failures = null;
        try {
            for (DNStateManager sm : this.enlistedSMCache.values()) {
                try {
                    sm.preRollback(this.getTransaction());
                }
                catch (RuntimeException e) {
                    if (failures == null) {
                        failures = new ArrayList<RuntimeException>();
                    }
                    failures.add(e);
                }
            }
            this.clearDirty();
        }
        finally {
            this.resetTransactionalVariables();
        }
        if (failures != null && !failures.isEmpty()) {
            throw new RollbackStateTransitionException(failures.toArray(new Exception[failures.size()]));
        }
        if (this.getBooleanProperty("datanucleus.DetachAllOnRollback").booleanValue()) {
            this.performDetachAllOnTxnEndPreparation();
        }
    }

    public void postRollback() {
        if (this.getBooleanProperty("datanucleus.DetachAllOnRollback").booleanValue()) {
            this.performDetachAllOnTxnEnd();
        }
        if (this.l2CacheObjectsToEvictUponRollback != null) {
            this.nucCtx.getLevel2Cache().evictAll(this.l2CacheObjectsToEvictUponRollback);
            this.l2CacheObjectsToEvictUponRollback = null;
        }
    }

    private void resetTransactionalVariables() {
        if (this.pbrAtCommitHandler != null) {
            this.pbrAtCommitHandler.clear();
        }
        this.enlistedSMCache.clear();
        this.dirtySMs.clear();
        this.indirectDirtySMs.clear();
        this.fetchPlan.resetDetachmentRoots();
        if (this.managedRelationsHandler != null) {
            this.managedRelationsHandler.clear();
        }
        if (this.l2CacheTxIds != null) {
            this.l2CacheTxIds.clear();
        }
        if (this.l2CacheTxFieldsToUpdateById != null) {
            this.l2CacheTxFieldsToUpdateById.clear();
        }
        if (this.operationQueue != null) {
            this.operationQueue.clear();
        }
        this.smAttachDetachObjectReferenceMap = null;
        this.lockMgr.clear();
    }

    protected String getLevel2CacheRetrieveMode() {
        return this.properties.getFrequentProperties().getLevel2CacheRetrieveMode();
    }

    protected String getLevel2CacheStoreMode() {
        return this.properties.getFrequentProperties().getLevel2CacheStoreMode();
    }

    @Override
    public void putObjectIntoLevel1Cache(DNStateManager sm) {
        if (sm.isEmbedded()) {
            NucleusLogger.PERSISTENCE.warn("Attempt to L1 cache an embedded object! How did this occur? Trying to use an object as embedded yet also independently persistable? : " + sm, new Exception());
            return;
        }
        if (this.cache != null) {
            List<UniqueMetaData> unimds;
            Object id = sm.getInternalObjectId();
            if (id == null || sm.getObject() == null) {
                NucleusLogger.CACHE.warn(Localiser.msg("003006"));
                return;
            }
            if (sm.getClassMetaData().getUniqueMetaData() != null && (unimds = sm.getClassMetaData().getUniqueMetaData()) != null && !unimds.isEmpty()) {
                for (UniqueMetaData unimd : unimds) {
                    CacheUniqueKey uniKey = this.getCacheUniqueKeyForStateManager(sm, unimd);
                    if (uniKey == null) continue;
                    this.cache.putUnique(uniKey, sm);
                }
            }
            DNStateManager oldSM = this.cache.put(id, sm);
            if (NucleusLogger.CACHE.isDebugEnabled() && oldSM == null) {
                NucleusLogger.CACHE.debug(Localiser.msg("003004", IdentityUtils.getPersistableIdentityForId(id), StringUtils.booleanArrayToString(sm.getLoadedFields())));
            }
        }
    }

    private CacheUniqueKey getCacheUniqueKeyForStateManager(DNStateManager sm, UniqueMetaData unimd) {
        boolean nonNullMembers = true;
        if (unimd.getNumberOfMembers() > 0) {
            Object[] fieldVals = new Object[unimd.getNumberOfMembers()];
            for (int i = 0; i < fieldVals.length; ++i) {
                AbstractMemberMetaData mmd = sm.getClassMetaData().getMetaDataForMember(unimd.getMemberNames()[i]);
                fieldVals[i] = sm.provideField(mmd.getAbsoluteFieldNumber());
                if (fieldVals[i] != null) continue;
                nonNullMembers = false;
                break;
            }
            if (nonNullMembers) {
                return new CacheUniqueKey(sm.getClassMetaData().getFullClassName(), unimd.getMemberNames(), fieldVals);
            }
        }
        return null;
    }

    @Override
    public void putObjectIntoLevel2Cache(DNStateManager sm, boolean updateIfPresent) {
        if (sm.getInternalObjectId() == null || !this.nucCtx.isClassCacheable(sm.getClassMetaData())) {
            return;
        }
        String storeMode = this.getLevel2CacheStoreMode();
        if (storeMode.equalsIgnoreCase("bypass")) {
            return;
        }
        if (this.l2CacheTxIds != null && !this.l2CacheTxIds.contains(sm.getInternalObjectId())) {
            this.putObjectIntoLevel2CacheInternal(sm, updateIfPresent);
        }
    }

    protected CachedPC getL2CacheableObject(DNStateManager sm, CachedPC currentCachedPC) {
        CachedPC cachedPC = null;
        int[] fieldsToUpdate = null;
        if (currentCachedPC != null) {
            BitSet fieldsToUpdateBitSet;
            cachedPC = currentCachedPC.getCopy();
            cachedPC.setVersion(sm.getTransactionalVersion());
            VersionMetaData vermd = sm.getClassMetaData().getVersionMetaDataForClass();
            int versionFieldNum = -1;
            if (vermd != null && vermd.getMemberName() != null) {
                versionFieldNum = sm.getClassMetaData().getMetaDataForMember(vermd.getMemberName()).getAbsoluteFieldNumber();
            }
            if ((fieldsToUpdateBitSet = this.l2CacheTxFieldsToUpdateById.get(sm.getInternalObjectId())) != null) {
                if (versionFieldNum >= 0 && !fieldsToUpdateBitSet.get(versionFieldNum)) {
                    fieldsToUpdateBitSet.set(versionFieldNum);
                }
                int num = 0;
                for (int i = 0; i < fieldsToUpdateBitSet.length(); ++i) {
                    if (!fieldsToUpdateBitSet.get(i)) continue;
                    ++num;
                }
                fieldsToUpdate = new int[num];
                int j = 0;
                for (int i = 0; i < fieldsToUpdateBitSet.length(); ++i) {
                    if (!fieldsToUpdateBitSet.get(i)) continue;
                    fieldsToUpdate[j++] = i;
                }
            }
            if (fieldsToUpdate == null || fieldsToUpdate.length == 0) {
                return null;
            }
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                int[] loadedFieldNums = cachedPC.getLoadedFieldNumbers();
                String fieldNames = loadedFieldNums == null || loadedFieldNums.length == 0 ? "" : StringUtils.intArrayToString(loadedFieldNums);
                NucleusLogger.CACHE.debug(Localiser.msg("004015", IdentityUtils.getPersistableIdentityForId(sm.getInternalObjectId()), fieldNames, cachedPC.getVersion(), StringUtils.intArrayToString(fieldsToUpdate)));
            }
        } else {
            int[] loadedFieldNumbers = sm.getLoadedFieldNumbers();
            if (loadedFieldNumbers == null || loadedFieldNumbers.length == 0) {
                return null;
            }
            cachedPC = new CachedPC(sm.getObject().getClass(), sm.getLoadedFields(), sm.getTransactionalVersion(), sm.getInternalObjectId());
            fieldsToUpdate = loadedFieldNumbers;
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                int[] loadedFieldNums = cachedPC.getLoadedFieldNumbers();
                String fieldNames = loadedFieldNums == null || loadedFieldNums.length == 0 ? "" : StringUtils.intArrayToString(loadedFieldNums);
                NucleusLogger.CACHE.debug(Localiser.msg("004003", IdentityUtils.getPersistableIdentityForId(sm.getInternalObjectId()), fieldNames, cachedPC.getVersion()));
            }
        }
        sm.provideFields(fieldsToUpdate, new L2CachePopulateFieldManager(sm, cachedPC));
        return cachedPC;
    }

    protected void putObjectsIntoLevel2Cache(Set<DNStateManager> sms) {
        int batchSize = this.nucCtx.getConfiguration().getIntProperty("datanucleus.cache.level2.batchSize");
        Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
        HashMap<Object, CachedPC> dataToUpdate = new HashMap<Object, CachedPC>();
        HashMap<CacheUniqueKey, CachedPC> dataUniqueToUpdate = new HashMap<CacheUniqueKey, CachedPC>();
        for (DNStateManager sm : sms) {
            List<UniqueMetaData> unimds;
            Object id = sm.getInternalObjectId();
            if (id == null || !this.nucCtx.isClassCacheable(sm.getClassMetaData())) continue;
            CachedPC currentCachedPC = l2Cache.get(id);
            CachedPC cachedPC = this.getL2CacheableObject(sm, currentCachedPC);
            if (cachedPC != null && !(id instanceof IdentityReference)) {
                dataToUpdate.put(id, cachedPC);
                if (dataToUpdate.size() == batchSize) {
                    l2Cache.putAll(dataToUpdate);
                    dataToUpdate.clear();
                }
            }
            if (sm.getClassMetaData().getUniqueMetaData() == null || (unimds = sm.getClassMetaData().getUniqueMetaData()) == null || unimds.isEmpty()) continue;
            for (UniqueMetaData unimd : unimds) {
                CacheUniqueKey uniKey = this.getCacheUniqueKeyForStateManager(sm, unimd);
                if (uniKey == null) continue;
                dataUniqueToUpdate.put(uniKey, cachedPC);
                if (dataUniqueToUpdate.size() != batchSize) continue;
                l2Cache.putUniqueAll(dataUniqueToUpdate);
                dataUniqueToUpdate.clear();
            }
        }
        if (!dataToUpdate.isEmpty()) {
            l2Cache.putAll(dataToUpdate);
            dataToUpdate.clear();
        }
        if (!dataUniqueToUpdate.isEmpty()) {
            l2Cache.putUniqueAll(dataUniqueToUpdate);
            dataUniqueToUpdate.clear();
        }
    }

    protected void putObjectIntoLevel2CacheInternal(DNStateManager sm, boolean updateIfPresent) {
        List<UniqueMetaData> unimds;
        Object id = sm.getInternalObjectId();
        if (id == null || id instanceof IdentityReference) {
            return;
        }
        Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
        if (!updateIfPresent && l2Cache.containsOid(id)) {
            return;
        }
        CachedPC currentCachedPC = l2Cache.get(id);
        CachedPC cachedPC = this.getL2CacheableObject(sm, currentCachedPC);
        if (cachedPC != null) {
            l2Cache.put(id, cachedPC);
        }
        if (sm.getClassMetaData().getUniqueMetaData() != null && (unimds = sm.getClassMetaData().getUniqueMetaData()) != null && !unimds.isEmpty()) {
            for (UniqueMetaData unimd : unimds) {
                CacheUniqueKey uniKey = this.getCacheUniqueKeyForStateManager(sm, unimd);
                if (uniKey == null) continue;
                l2Cache.putUnique(uniKey, cachedPC);
            }
        }
    }

    @Override
    public void removeObjectFromLevel1Cache(Object id) {
        Object pcRemoved;
        if (id != null && this.cache != null && (pcRemoved = this.cache.remove(id)) != null && NucleusLogger.CACHE.isDebugEnabled()) {
            NucleusLogger.CACHE.debug(Localiser.msg("003009", IdentityUtils.getPersistableIdentityForId(id)));
        }
    }

    @Override
    public void removeObjectFromLevel2Cache(Object id) {
        Level2Cache l2Cache;
        if (id != null && !(id instanceof IdentityReference) && (l2Cache = this.nucCtx.getLevel2Cache()).containsOid(id)) {
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(Localiser.msg("004016", id));
            }
            l2Cache.evict(id);
        }
    }

    @Override
    public boolean hasIdentityInCache(Object id) {
        Level2Cache l2Cache;
        if (this.cache != null && this.cache.containsKey(id)) {
            return true;
        }
        return this.l2CacheEnabled && (l2Cache = this.nucCtx.getLevel2Cache()).containsOid(id);
    }

    @Override
    public Persistable getObjectFromCache(Object id) {
        Persistable pc = this.getObjectFromLevel1Cache(id);
        if (pc != null) {
            return pc;
        }
        if (id instanceof SCOID) {
            return null;
        }
        return this.getObjectFromLevel2Cache(id);
    }

    @Override
    public Persistable[] getObjectsFromCache(Object[] ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        Persistable[] objs = new Persistable[ids.length];
        HashSet<Object> idsNotFound = new HashSet<Object>();
        for (int i = 0; i < ids.length; ++i) {
            objs[i] = this.getObjectFromLevel1Cache(ids[i]);
            if (objs[i] != null) continue;
            idsNotFound.add(ids[i]);
        }
        if (!idsNotFound.isEmpty()) {
            Map<Object, Persistable> l2ObjsById = this.getObjectsFromLevel2Cache(idsNotFound);
            for (int i = 0; i < ids.length; ++i) {
                if (objs[i] != null) continue;
                objs[i] = l2ObjsById.get(ids[i]);
            }
        }
        return objs;
    }

    protected Persistable getObjectFromLevel1Cache(Object id) {
        Persistable pc = null;
        DNStateManager sm = null;
        if (this.cache != null) {
            sm = (DNStateManager)this.cache.get(id);
            if (sm != null) {
                pc = (Persistable)sm.getObject();
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("003008", IdentityUtils.getPersistableIdentityForId(id), StringUtils.booleanArrayToString(sm.getLoadedFields())));
                }
                sm.resetDetachState();
                return pc;
            }
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(Localiser.msg("003007", IdentityUtils.getPersistableIdentityForId(id)));
            }
        }
        return null;
    }

    protected Persistable getObjectFromLevel2Cache(Object id) {
        Persistable pc = null;
        if (this.l2CacheEnabled) {
            if (!this.nucCtx.isClassWithIdentityCacheable(id)) {
                return null;
            }
            String cacheRetrieveMode = this.getLevel2CacheRetrieveMode();
            if ("bypass".equalsIgnoreCase(cacheRetrieveMode)) {
                return null;
            }
            Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
            CachedPC cachedPC = l2Cache.get(id);
            if (cachedPC != null) {
                DNStateManager sm = this.nucCtx.getStateManagerFactory().newForCachedPC(this, id, cachedPC);
                pc = (Persistable)sm.getObject();
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("004006", IdentityUtils.getPersistableIdentityForId(id), StringUtils.intArrayToString(cachedPC.getLoadedFieldNumbers()), cachedPC.getVersion(), StringUtils.toJVMIDString(pc)));
                }
                if (this.tx.isActive() && this.tx.getOptimistic()) {
                    sm.makeNontransactional();
                } else if (!this.tx.isActive() && this.getApiAdapter().isTransactional(pc)) {
                    sm.makeNontransactional();
                }
                return pc;
            }
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(Localiser.msg("004005", IdentityUtils.getPersistableIdentityForId(id)));
            }
        }
        return null;
    }

    protected Persistable getObjectFromLevel2CacheForUnique(CacheUniqueKey uniKey) {
        Persistable pc = null;
        if (this.l2CacheEnabled) {
            String cacheRetrieveMode = this.getLevel2CacheRetrieveMode();
            if ("bypass".equalsIgnoreCase(cacheRetrieveMode)) {
                return null;
            }
            Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
            CachedPC cachedPC = l2Cache.getUnique(uniKey);
            if (cachedPC != null) {
                Object id = cachedPC.getId();
                DNStateManager sm = this.nucCtx.getStateManagerFactory().newForCachedPC(this, id, cachedPC);
                pc = (Persistable)sm.getObject();
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("004006", IdentityUtils.getPersistableIdentityForId(id), StringUtils.intArrayToString(cachedPC.getLoadedFieldNumbers()), cachedPC.getVersion(), StringUtils.toJVMIDString(pc)));
                }
                if (this.tx.isActive() && this.tx.getOptimistic()) {
                    sm.makeNontransactional();
                } else if (!this.tx.isActive() && this.getApiAdapter().isTransactional(pc)) {
                    sm.makeNontransactional();
                }
                return pc;
            }
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(Localiser.msg("004005", uniKey));
            }
        }
        return null;
    }

    protected Map<Object, Persistable> getObjectsFromLevel2Cache(Collection ids) {
        if (this.l2CacheEnabled) {
            Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
            Map<Object, CachedPC> cachedPCs = l2Cache.getAll(ids);
            HashMap<Object, Persistable> pcsById = new HashMap<Object, Persistable>(cachedPCs.size());
            for (Map.Entry<Object, CachedPC> entry : cachedPCs.entrySet()) {
                Object id = entry.getKey();
                CachedPC cachedPC = entry.getValue();
                if (cachedPC != null) {
                    DNStateManager sm = this.nucCtx.getStateManagerFactory().newForCachedPC(this, id, cachedPC);
                    Persistable pc = (Persistable)sm.getObject();
                    if (NucleusLogger.CACHE.isDebugEnabled()) {
                        NucleusLogger.CACHE.debug(Localiser.msg("004006", IdentityUtils.getPersistableIdentityForId(id), StringUtils.intArrayToString(cachedPC.getLoadedFieldNumbers()), cachedPC.getVersion(), StringUtils.toJVMIDString(pc)));
                    }
                    if (this.tx.isActive() && this.tx.getOptimistic()) {
                        sm.makeNontransactional();
                    } else if (!this.tx.isActive() && this.getApiAdapter().isTransactional(pc)) {
                        sm.makeNontransactional();
                    }
                    pcsById.put(id, pc);
                    continue;
                }
                if (!NucleusLogger.CACHE.isDebugEnabled()) continue;
                NucleusLogger.CACHE.debug(Localiser.msg("004005", IdentityUtils.getPersistableIdentityForId(id)));
            }
            return pcsById;
        }
        return null;
    }

    @Override
    public void replaceObjectId(Persistable pc, Object oldID, Object newID) {
        if (pc == null || newID == null) {
            NucleusLogger.CACHE.warn(Localiser.msg("003006"));
            return;
        }
        DNStateManager sm = this.findStateManager(pc);
        if (this.cache != null) {
            Object o;
            if (oldID != null && (o = this.cache.get(oldID)) != null) {
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("003012", IdentityUtils.getPersistableIdentityForId(oldID), IdentityUtils.getPersistableIdentityForId(newID)));
                }
                this.cache.remove(oldID);
            }
            if (sm != null) {
                this.putObjectIntoLevel1Cache(sm);
            }
        }
        if (oldID != null && this.enlistedSMCache.get(oldID) != null && sm != null) {
            this.enlistedSMCache.remove(oldID);
            this.enlistedSMCache.put(newID, sm);
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(Localiser.msg("015018", IdentityUtils.getPersistableIdentityForId(oldID), IdentityUtils.getPersistableIdentityForId(newID)));
            }
        }
        if (oldID != null && this.l2CacheTxIds != null && this.l2CacheTxIds.contains(oldID)) {
            this.l2CacheTxIds.remove(oldID);
            this.l2CacheTxIds.add(newID);
        }
        if (oldID != null && this.pbrAtCommitHandler != null && this.tx.isActive()) {
            this.pbrAtCommitHandler.swapObjectId(oldID, newID);
        }
    }

    @Override
    public boolean getSerializeReadForClass(String className) {
        AbstractClassMetaData cmd;
        if (this.tx.isActive() && this.tx.getSerializeRead() != null) {
            return this.tx.getSerializeRead();
        }
        if (this.getProperty("datanucleus.SerializeRead") != null) {
            return this.properties.getBooleanProperty("datanucleus.SerializeRead");
        }
        if (className != null && (cmd = this.getMetaDataManager().getMetaDataForClass(className, this.clr)) != null) {
            return cmd.isSerializeRead();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Extent<T> getExtent(Class<T> pcClass, boolean subclasses) {
        try {
            this.clr.setPrimary(pcClass.getClassLoader());
            this.assertClassPersistable(pcClass);
            Extent<T> extent = this.getStoreManager().getExtent(this, pcClass, subclasses);
            return extent;
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        if (this.callbackHandler != null) {
            return this.callbackHandler;
        }
        if (this.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.allowCallbacks")) {
            String callbackHandlerClassName = this.getNucleusContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.callbackhandler", "name", this.getNucleusContext().getApiName(), "class-name");
            if (callbackHandlerClassName != null) {
                try {
                    this.callbackHandler = (CallbackHandler)this.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.callbackhandler", "name", this.getNucleusContext().getApiName(), "class-name", new Class[]{ClassConstants.EXECUTION_CONTEXT}, new Object[]{this});
                }
                catch (Exception e) {
                    NucleusLogger.PERSISTENCE.error(Localiser.msg("025000", callbackHandlerClassName, e));
                }
            }
        } else {
            this.callbackHandler = new NullCallbackHandler();
        }
        return this.callbackHandler;
    }

    @Override
    public void closeCallbackHandler() {
        if (this.callbackHandler != null) {
            this.callbackHandler.close();
        }
    }

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw new NucleusUserException(Localiser.msg("010002")).setFatal();
        }
    }

    @Override
    public void assertClassPersistable(Class cls) {
        if (cls == null) {
            return;
        }
        if (!this.getNucleusContext().getApiAdapter().isPersistable(cls) && !cls.isInterface()) {
            throw new ClassNotPersistableException(cls.getName());
        }
        if (!this.hasPersistenceInformationForClass(cls)) {
            throw new NoPersistenceInformationException(cls.getName());
        }
    }

    protected void assertDetachable(Object object) {
        if (object != null && !this.getApiAdapter().isDetachable(object)) {
            throw new ClassNotDetachableException(object.getClass().getName());
        }
    }

    protected void assertNotDetached(Object object) {
        if (object != null && this.getApiAdapter().isDetached(object)) {
            throw new ObjectDetachedException(object.getClass().getName());
        }
    }

    protected void assertActiveTransaction() {
        if (!this.tx.isActive()) {
            throw new TransactionNotActiveException();
        }
    }

    @Override
    public boolean hasPersistenceInformationForClass(Class cls) {
        if (cls == null) {
            return false;
        }
        if (this.getMetaDataManager().getMetaDataForClass(cls, this.clr) != null) {
            return true;
        }
        if (cls.isInterface()) {
            try {
                this.newInstance(cls);
            }
            catch (RuntimeException ex) {
                NucleusLogger.PERSISTENCE.warn(ex);
            }
            return this.getMetaDataManager().getMetaDataForClass(cls, this.clr) != null;
        }
        return false;
    }

    protected FetchGroupManager getFetchGroupManager() {
        if (this.fetchGrpMgr == null) {
            this.fetchGrpMgr = new FetchGroupManager(this.getNucleusContext());
        }
        return this.fetchGrpMgr;
    }

    @Override
    public void addInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().addFetchGroup(grp);
    }

    protected void removeInternalFetchGroup(FetchGroup grp) {
        if (this.fetchGrpMgr == null) {
            return;
        }
        this.getFetchGroupManager().removeFetchGroup(grp);
    }

    @Override
    public FetchGroup getInternalFetchGroup(Class cls, String name) {
        if (!cls.isInterface() && !this.getNucleusContext().getApiAdapter().isPersistable(cls)) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        if (cls.isInterface() && !this.getNucleusContext().getMetaDataManager().isPersistentInterface(cls.getName())) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        if (this.fetchGrpMgr == null) {
            return null;
        }
        return this.getFetchGroupManager().getFetchGroup(cls, name, true);
    }

    @Override
    public Set<FetchGroup> getFetchGroupsWithName(String name) {
        if (this.fetchGrpMgr == null) {
            return null;
        }
        return this.getFetchGroupManager().getFetchGroupsWithName(name);
    }

    @Override
    public ExecutionContext.EmbeddedOwnerRelation registerEmbeddedRelation(DNStateManager ownerSM, int ownerMemberNum, PersistableObjectType objectType, DNStateManager embSM) {
        List<ExecutionContext.EmbeddedOwnerRelation> ownerRelations;
        ExecutionContext.EmbeddedOwnerRelation relation = new ExecutionContext.EmbeddedOwnerRelation(ownerSM, ownerMemberNum, objectType, embSM);
        if (this.smEmbeddedInfoByEmbedded == null) {
            this.smEmbeddedInfoByEmbedded = new HashMap<DNStateManager, ExecutionContext.EmbeddedOwnerRelation>();
        }
        if (this.smEmbeddedInfoByEmbedded.containsKey(embSM)) {
            NucleusLogger.PERSISTENCE.warn("Attempt to register relation between embedded object " + embSM + " with owner " + ownerSM + " but already has an owner");
        }
        this.smEmbeddedInfoByEmbedded.put(embSM, relation);
        if (this.smEmbeddedInfoByOwner == null) {
            this.smEmbeddedInfoByOwner = new HashMap<DNStateManager, List<ExecutionContext.EmbeddedOwnerRelation>>();
        }
        if ((ownerRelations = this.smEmbeddedInfoByOwner.get(ownerSM)) == null) {
            ownerRelations = new ArrayList<ExecutionContext.EmbeddedOwnerRelation>();
        }
        ownerRelations.add(relation);
        this.smEmbeddedInfoByOwner.put(ownerSM, ownerRelations);
        return relation;
    }

    @Override
    public void deregisterEmbeddedRelation(ExecutionContext.EmbeddedOwnerRelation rel) {
        if (this.smEmbeddedInfoByEmbedded != null) {
            this.smEmbeddedInfoByEmbedded.remove(rel.getEmbeddedSM());
            if (this.smEmbeddedInfoByEmbedded.isEmpty()) {
                this.smEmbeddedInfoByEmbedded = null;
            }
        }
        if (this.smEmbeddedInfoByOwner != null) {
            List<ExecutionContext.EmbeddedOwnerRelation> ownerRels = this.smEmbeddedInfoByOwner.get(rel.getOwnerSM());
            ownerRels.remove(rel);
            if (ownerRels.isEmpty()) {
                this.smEmbeddedInfoByOwner.remove(rel.getOwnerSM());
                if (this.smEmbeddedInfoByOwner.isEmpty()) {
                    this.smEmbeddedInfoByOwner = null;
                }
            }
        }
    }

    @Override
    public void removeEmbeddedOwnerRelation(DNStateManager ownerSM, int ownerFieldNum, DNStateManager embSM) {
        if (this.smEmbeddedInfoByOwner != null) {
            List<ExecutionContext.EmbeddedOwnerRelation> ownerRels = this.smEmbeddedInfoByOwner.get(ownerSM);
            ExecutionContext.EmbeddedOwnerRelation rel = null;
            for (ExecutionContext.EmbeddedOwnerRelation ownerRel : ownerRels) {
                if (ownerRel.getEmbeddedSM() != embSM || ownerRel.getOwnerMemberNum() != ownerFieldNum) continue;
                rel = ownerRel;
                break;
            }
            if (rel != null) {
                this.deregisterEmbeddedRelation(rel);
            }
        }
    }

    @Override
    public DNStateManager getOwnerForEmbeddedStateManager(DNStateManager embSM) {
        if (embSM == null || !embSM.isEmbedded() || this.smEmbeddedInfoByEmbedded == null || !this.smEmbeddedInfoByEmbedded.containsKey(embSM)) {
            return null;
        }
        return this.smEmbeddedInfoByEmbedded.get(embSM).getOwnerSM();
    }

    @Override
    public ExecutionContext.EmbeddedOwnerRelation getOwnerInformationForEmbedded(DNStateManager embSM) {
        if (embSM == null || !embSM.isEmbedded() || this.smEmbeddedInfoByEmbedded == null) {
            return null;
        }
        return this.smEmbeddedInfoByEmbedded.get(embSM);
    }

    @Override
    public List<ExecutionContext.EmbeddedOwnerRelation> getEmbeddedInformationForOwner(DNStateManager ownerSM) {
        if (this.smEmbeddedInfoByOwner == null) {
            return null;
        }
        return this.smEmbeddedInfoByOwner.get(ownerSM);
    }

    @Override
    public void setStateManagerAssociatedValue(DNStateManager sm, Object key, Object value) {
        Map<?, ?> valueMap = null;
        if (this.stateManagerAssociatedValuesMap == null) {
            this.stateManagerAssociatedValuesMap = new HashMap();
            valueMap = new HashMap();
            this.stateManagerAssociatedValuesMap.put(sm, valueMap);
        } else {
            valueMap = this.stateManagerAssociatedValuesMap.get(sm);
            if (valueMap == null) {
                valueMap = new HashMap();
                this.stateManagerAssociatedValuesMap.put(sm, valueMap);
            }
        }
        valueMap.put(key, value);
    }

    @Override
    public Object getStateManagerAssociatedValue(DNStateManager sm, Object key) {
        if (this.stateManagerAssociatedValuesMap == null) {
            return null;
        }
        Map<?, ?> valueMap = this.stateManagerAssociatedValuesMap.get(sm);
        return valueMap == null ? null : valueMap.get(key);
    }

    @Override
    public void removeStateManagerAssociatedValue(DNStateManager sm, Object key) {
        Map<?, ?> valueMap;
        if (this.stateManagerAssociatedValuesMap != null && (valueMap = this.stateManagerAssociatedValuesMap.get(sm)) != null) {
            valueMap.remove(key);
        }
    }

    @Override
    public boolean containsStateManagerAssociatedValue(DNStateManager sm, Object key) {
        if (this.stateManagerAssociatedValuesMap != null && this.stateManagerAssociatedValuesMap.containsKey(sm)) {
            return this.stateManagerAssociatedValuesMap.get(sm).containsKey(key);
        }
        return false;
    }

    public static class NullCallbackHandler
    implements CallbackHandler {
        public void setBeanValidationHandler(BeanValidationHandler handler) {
        }

        @Override
        public void addListener(Object listener, Class[] classes) {
        }

        @Override
        public void removeListener(Object listener) {
        }

        @Override
        public void close() {
        }
    }

    private static class ClassDetailsForId {
        Object id;
        String className;
        Persistable pc;

        public ClassDetailsForId(Object id, String className, Persistable pc) {
            this.id = id;
            this.className = className;
            this.pc = pc;
        }
    }

    static class ThreadContextInfo {
        int referenceCounter = 0;
        Map<Persistable, DNStateManager> attachedOwnerByObject = null;
        Map<Object, Persistable> attachedPCById = null;
        boolean merging = false;
        boolean nontxPersistDelete = false;

        ThreadContextInfo() {
        }
    }
}

