/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.properties.BooleanPropertyValidator;
import org.datanucleus.properties.FrequentlyAccessedProperties;
import org.datanucleus.properties.IntegerPropertyValidator;
import org.datanucleus.properties.PropertyStore;
import org.datanucleus.properties.PropertyValidator;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.PersistenceUtils;

public class Configuration
extends PropertyStore
implements Serializable {
    private static final long serialVersionUID = 1483628590934722025L;
    private NucleusContext nucCtx;
    private Map<String, PropertyMapping> propertyMappings = new HashMap<String, PropertyMapping>();
    private Map<String, Object> defaultProperties = new HashMap<String, Object>();
    private Map<String, PropertyValidator> propertyValidators = new HashMap<String, PropertyValidator>();
    private volatile Map<String, Object> managerOverrideableProperties;
    private FrequentlyAccessedProperties defaultFrequentProperties = new FrequentlyAccessedProperties();

    public Configuration(NucleusContext nucCtx) {
        this.nucCtx = nucCtx;
        this.frequentProperties.setDefaults(this.defaultFrequentProperties);
        nucCtx.applyDefaultProperties(this);
        ConfigurationElement[] propElements = nucCtx.getPluginManager().getConfigurationElementsForExtension("org.datanucleus.persistence_properties", (String)null, (String)null);
        if (propElements != null) {
            for (int i = 0; i < propElements.length; ++i) {
                String name = propElements[i].getAttribute("name");
                String intName = propElements[i].getAttribute("internal-name");
                String value = propElements[i].getAttribute("value");
                String datastoreString = propElements[i].getAttribute("datastore");
                String validatorName = propElements[i].getAttribute("validator");
                boolean datastore = datastoreString != null && datastoreString.equalsIgnoreCase("true");
                String mgrOverrideString = propElements[i].getAttribute("manager-overrideable");
                boolean mgrOverride = mgrOverrideString != null && mgrOverrideString.equalsIgnoreCase("true");
                this.addDefaultProperty(name, intName, value, validatorName, datastore, mgrOverride);
            }
        }
    }

    public Set<String> getSupportedProperties() {
        return this.propertyMappings.keySet();
    }

    public Map<String, Object> getDatastoreProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (Map.Entry propEntry : this.properties.entrySet()) {
            String name = (String)propEntry.getKey();
            if (!this.isPropertyForDatastore(name)) continue;
            props.put(name, propEntry.getValue());
        }
        return props;
    }

    public void removeDatastoreProperties() {
        Iterator propKeyIter = this.properties.keySet().iterator();
        while (propKeyIter.hasNext()) {
            String name = (String)propKeyIter.next();
            if (!this.isPropertyForDatastore(name)) continue;
            propKeyIter.remove();
        }
    }

    private boolean isPropertyForDatastore(String name) {
        PropertyMapping mapping = this.propertyMappings.get(name.toLowerCase(Locale.ENGLISH));
        return mapping != null ? mapping.datastore : false;
    }

    public String getInternalNameForProperty(String name) {
        PropertyMapping mapping = this.propertyMappings.get(name.toLowerCase(Locale.ENGLISH));
        return mapping != null && mapping.internalName != null ? mapping.internalName : name;
    }

    public Map<String, Object> getManagerOverrideableProperties() {
        Map<String, Object> props = this.managerOverrideableProperties;
        if (props != null) {
            return props;
        }
        props = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, PropertyMapping> entry : this.propertyMappings.entrySet()) {
            PropertyMapping intMapping;
            PropertyMapping mapping = entry.getValue();
            if (mapping.managerOverride) {
                String propName = mapping.internalName != null ? mapping.internalName.toLowerCase(Locale.ENGLISH) : mapping.name.toLowerCase(Locale.ENGLISH);
                props.put(propName, this.getProperty(propName));
                continue;
            }
            if (mapping.internalName == null || (intMapping = this.propertyMappings.get(mapping.internalName.toLowerCase(Locale.ENGLISH))) == null || !intMapping.managerOverride) continue;
            props.put(mapping.name.toLowerCase(Locale.ENGLISH), this.getProperty(mapping.internalName));
        }
        this.managerOverrideableProperties = props = Collections.unmodifiableMap(props);
        return props;
    }

    public Set<String> getManagedOverrideablePropertyNames() {
        HashSet<String> propNames = new HashSet<String>();
        for (PropertyMapping mapping : this.propertyMappings.values()) {
            if (!mapping.managerOverride) continue;
            propNames.add(mapping.name);
        }
        return propNames;
    }

    public String getPropertyNameWithInternalPropertyName(String propName, String propPrefix) {
        if (propName == null) {
            return null;
        }
        for (PropertyMapping mapping : this.propertyMappings.values()) {
            if (mapping.internalName == null || !mapping.internalName.toLowerCase().equals(propName.toLowerCase()) || !mapping.name.startsWith(propPrefix)) continue;
            return mapping.name;
        }
        return null;
    }

    public String getCaseSensitiveNameForPropertyName(String propName) {
        if (propName == null) {
            return null;
        }
        for (PropertyMapping mapping : this.propertyMappings.values()) {
            if (!mapping.name.toLowerCase().equals(propName.toLowerCase())) continue;
            return mapping.name;
        }
        return propName;
    }

    public void setDefaultProperties(Map<String, Object> props) {
        if (props != null && !props.isEmpty()) {
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                PropertyMapping mapping = this.propertyMappings.get(entry.getKey().toLowerCase(Locale.ENGLISH));
                Object propValue = entry.getValue();
                if (mapping != null && mapping.validatorName != null && propValue instanceof String) {
                    propValue = this.getValueForPropertyWithValidator((String)propValue, mapping.validatorName);
                }
                this.defaultProperties.put(entry.getKey().toLowerCase(Locale.ENGLISH), propValue);
                this.defaultFrequentProperties.setProperty(entry.getKey(), propValue);
            }
        }
    }

    public void addDefaultBooleanProperty(String name, String internalName, Boolean value, boolean datastore, boolean managerOverrideable) {
        this.addDefaultProperty(name, internalName, value != null ? "" + value : null, BooleanPropertyValidator.class.getName(), datastore, managerOverrideable);
    }

    public void addDefaultIntegerProperty(String name, String internalName, Integer value, boolean datastore, boolean managerOverrideable) {
        this.addDefaultProperty(name, internalName, value != null ? "" + value : null, IntegerPropertyValidator.class.getName(), datastore, managerOverrideable);
    }

    public void addDefaultProperty(String name, String internalName, String value, String validatorName, boolean datastore, boolean managerOverrideable) {
        String storedName;
        this.managerOverrideableProperties = null;
        this.propertyMappings.put(name.toLowerCase(Locale.ENGLISH), new PropertyMapping(name, internalName, validatorName, datastore, managerOverrideable));
        String string = storedName = internalName != null ? internalName.toLowerCase(Locale.ENGLISH) : name.toLowerCase(Locale.ENGLISH);
        if (!this.defaultProperties.containsKey(storedName)) {
            Object propValue = System.getProperty(name);
            if (propValue == null) {
                propValue = value;
            }
            if (propValue != null) {
                if (validatorName != null) {
                    propValue = this.getValueForPropertyWithValidator(value, validatorName);
                }
                this.defaultProperties.put(storedName, propValue);
                this.defaultFrequentProperties.setProperty(storedName, propValue);
            }
        }
    }

    protected Object getValueForPropertyWithValidator(String value, String validatorName) {
        if (validatorName.equals(BooleanPropertyValidator.class.getName())) {
            return Boolean.valueOf(value);
        }
        if (validatorName.equals(IntegerPropertyValidator.class.getName())) {
            return Integer.valueOf(value);
        }
        return value;
    }

    @Override
    public boolean hasProperty(String name) {
        if (this.properties.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return true;
        }
        return this.defaultProperties.containsKey(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public Object getProperty(String name) {
        if (this.properties.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return super.getProperty(name);
        }
        return this.defaultProperties.get(name.toLowerCase(Locale.ENGLISH));
    }

    public synchronized void setPropertiesUsingFile(String filename) {
        if (filename == null) {
            return;
        }
        HashMap<String, Object> props = null;
        try {
            Properties propsFromFile = PersistenceUtils.setPropertiesUsingFile(filename);
            props = new HashMap<String, Object>();
            for (String key : propsFromFile.stringPropertyNames()) {
                props.put(key, propsFromFile.getProperty(key));
            }
            this.setPropertyInternal("datanucleus.propertiesFile", filename);
        }
        catch (NucleusUserException nue) {
            this.properties.remove("datanucleus.propertiesFile");
            throw nue;
        }
        if (props != null && !props.isEmpty()) {
            this.setPersistenceProperties(props);
        }
    }

    public Map<String, Object> getPersistencePropertiesDefaults() {
        return Collections.unmodifiableMap(this.defaultProperties);
    }

    public Map<String, Object> getPersistenceProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Set<String> getPropertyNamesWithPrefix(String prefix) {
        HashSet<String> propNames = null;
        for (String name : this.properties.keySet()) {
            if (!name.startsWith(prefix.toLowerCase(Locale.ENGLISH))) continue;
            if (propNames == null) {
                propNames = new HashSet<String>();
            }
            propNames.add(name);
        }
        return propNames;
    }

    public void setPersistenceProperties(Map<String, Object> props) {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public void setProperty(String name, Object value) {
        if (name != null) {
            String propertyName = name.trim();
            PropertyMapping mapping = this.propertyMappings.get(propertyName.toLowerCase(Locale.ENGLISH));
            if (mapping != null) {
                if (mapping.validatorName != null) {
                    this.validatePropertyValue(mapping.internalName != null ? mapping.internalName : propertyName, value, mapping.validatorName);
                    if (value != null && value instanceof String) {
                        value = this.getValueForPropertyWithValidator((String)value, mapping.validatorName);
                    }
                }
                this.setPropertyInternal(mapping.internalName != null ? mapping.internalName : mapping.name, value);
                if (propertyName.equals("datanucleus.propertiesFile")) {
                    this.setPropertiesUsingFile((String)value);
                }
            } else {
                this.setPropertyInternal(propertyName, value);
                if (!this.propertyMappings.isEmpty()) {
                    NucleusLogger.PERSISTENCE.info(Localiser.msg("008015", propertyName));
                }
            }
        }
    }

    public void validatePropertyValue(String name, Object value) {
        String validatorName = null;
        PropertyMapping mapping = this.propertyMappings.get(name.toLowerCase(Locale.ENGLISH));
        if (mapping != null && (validatorName = mapping.validatorName) != null) {
            this.validatePropertyValue(name, value, validatorName);
        }
    }

    private void validatePropertyValue(String name, Object value, String validatorName) {
        if (validatorName == null) {
            return;
        }
        PropertyValidator validator = this.propertyValidators.get(validatorName);
        if (validator == null) {
            try {
                validator = (PropertyValidator)this.nucCtx.getPluginManager().createExecutableExtension("org.datanucleus.persistence_properties", "name", name, "validator", null, null);
                if (validator == null) {
                    Class validatorCls = this.nucCtx.getClassLoaderResolver(this.getClass().getClassLoader()).classForName(validatorName);
                    validator = (PropertyValidator)validatorCls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if (validator != null) {
                    this.propertyValidators.put(validatorName, validator);
                }
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.warn("Error creating validator of type " + validatorName, e);
            }
        }
        if (validator != null && !validator.validate(name, value)) {
            throw new IllegalArgumentException(Localiser.msg("008012", name, value));
        }
    }

    public synchronized boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Configuration)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Configuration config = (Configuration)obj;
        if (this.properties == null ? config.properties != null : !this.properties.equals(config.properties)) {
            return false;
        }
        return !(this.defaultProperties == null ? config.defaultProperties != null : !this.defaultProperties.equals(config.defaultProperties));
    }

    public int hashCode() {
        return (this.properties != null ? this.properties.hashCode() : 0) ^ (this.defaultProperties != null ? this.defaultProperties.hashCode() : 0);
    }

    static class PropertyMapping
    implements Serializable {
        private static final long serialVersionUID = 9004376979051886506L;
        String name;
        String internalName;
        String validatorName;
        boolean datastore;
        boolean managerOverride;

        public PropertyMapping(String name, String intName, String validator, boolean datastore, boolean managerOverride) {
            this.name = name;
            this.internalName = intName;
            this.validatorName = validator;
            this.datastore = datastore;
            this.managerOverride = managerOverride;
        }
    }
}

