/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.lang.reflect.Method;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class EnumConversionHelper {
    public static Object getEnumForStoredValue(AbstractMemberMetaData mmd, FieldRole role, Object value, ClassLoaderResolver clr) {
        Class enumType = mmd.getType();
        String valueGetterMethodName = null;
        String getEnumStatisMethodName = null;
        if (role == FieldRole.ROLE_FIELD && mmd.hasExtension("enum-value-getter")) {
            valueGetterMethodName = mmd.getValueForExtension("enum-value-getter");
            getEnumStatisMethodName = mmd.getValueForExtension("enum-getter-by-value");
        } else if (role == FieldRole.ROLE_COLLECTION_ELEMENT) {
            enumType = clr.classForName(mmd.getCollection().getElementType());
            if (mmd.getElementMetaData() != null && mmd.getElementMetaData().hasExtension("enum-value-getter")) {
                valueGetterMethodName = mmd.getElementMetaData().getValueForExtension("enum-value-getter");
                getEnumStatisMethodName = mmd.getElementMetaData().getValueForExtension("enum-getter-by-value");
            }
        } else if (role == FieldRole.ROLE_ARRAY_ELEMENT) {
            enumType = clr.classForName(mmd.getArray().getElementType());
            if (mmd.getElementMetaData() != null && mmd.getElementMetaData().hasExtension("enum-value-getter")) {
                valueGetterMethodName = mmd.getElementMetaData().getValueForExtension("enum-value-getter");
                getEnumStatisMethodName = mmd.getElementMetaData().getValueForExtension("enum-getter-by-value");
            }
        } else if (role == FieldRole.ROLE_MAP_KEY) {
            enumType = clr.classForName(mmd.getMap().getKeyType());
            if (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().hasExtension("enum-value-getter")) {
                valueGetterMethodName = mmd.getKeyMetaData().getValueForExtension("enum-value-getter");
                getEnumStatisMethodName = mmd.getKeyMetaData().getValueForExtension("enum-getter-by-value");
            }
        } else if (role == FieldRole.ROLE_MAP_VALUE) {
            enumType = clr.classForName(mmd.getMap().getValueType());
            if (mmd.getValueMetaData() != null && mmd.getValueMetaData().hasExtension("enum-value-getter")) {
                valueGetterMethodName = mmd.getValueMetaData().getValueForExtension("enum-value-getter");
                getEnumStatisMethodName = mmd.getValueMetaData().getValueForExtension("enum-getter-by-value");
            }
        }
        if (valueGetterMethodName != null) {
            T[] enumConstants = enumType.getEnumConstants();
            Method valueGetterMethod = ClassUtils.getMethodForClass(enumType, valueGetterMethodName, null);
            if (valueGetterMethod != null) {
                for (int i = 0; i < enumConstants.length; ++i) {
                    try {
                        Object enumValue = valueGetterMethod.invoke(enumConstants[i], new Object[0]);
                        if (!(enumValue.getClass() == value.getClass() ? enumValue.equals(value) : enumValue instanceof Number && value instanceof Number && ((Number)enumValue).intValue() == ((Number)value).intValue())) continue;
                        return enumConstants[i];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            } else if (getEnumStatisMethodName != null) {
                try {
                    Method getterMethod = ClassUtils.getMethodForClass(enumType, getEnumStatisMethodName, new Class[]{Integer.TYPE});
                    if (getterMethod != null) {
                        return getterMethod.invoke(null, ((Number)value).intValue());
                    }
                    getterMethod = ClassUtils.getMethodForClass(enumType, getEnumStatisMethodName, new Class[]{Short.TYPE});
                    if (getterMethod != null) {
                        return getterMethod.invoke(null, ((Number)value).shortValue());
                    }
                    getterMethod = ClassUtils.getMethodForClass(enumType, getEnumStatisMethodName, new Class[]{String.class});
                    if (getterMethod != null) {
                        return getterMethod.invoke(null, (String)value);
                    }
                }
                catch (Exception e) {
                    NucleusLogger.PERSISTENCE.warn("Specified enum getter-by-value for field " + mmd.getFullFieldName() + " gave an error on extracting the enum so just using the ordinal : " + e.getMessage());
                }
            }
        }
        return value instanceof String ? Enum.valueOf(enumType, (String)value) : enumType.getEnumConstants()[(Integer)value];
    }

    public static Object getStoredValueFromEnum(AbstractMemberMetaData mmd, FieldRole role, Enum myEnum) {
        String methodName = null;
        boolean numeric = false;
        if (mmd != null) {
            ColumnMetaData[] colmds = null;
            if (role == FieldRole.ROLE_FIELD) {
                if (mmd.hasExtension("enum-value-getter")) {
                    methodName = mmd.getValueForExtension("enum-value-getter");
                }
                colmds = mmd.getColumnMetaData();
            } else if (role == FieldRole.ROLE_COLLECTION_ELEMENT || role == FieldRole.ROLE_ARRAY_ELEMENT) {
                if (mmd.getElementMetaData() != null) {
                    if (mmd.getElementMetaData().hasExtension("enum-value-getter")) {
                        methodName = mmd.getElementMetaData().getValueForExtension("enum-value-getter");
                    }
                    colmds = mmd.getElementMetaData().getColumnMetaData();
                }
            } else if (role == FieldRole.ROLE_MAP_KEY) {
                if (mmd.getKeyMetaData() != null) {
                    if (mmd.getKeyMetaData().hasExtension("enum-value-getter")) {
                        methodName = mmd.getKeyMetaData().getValueForExtension("enum-value-getter");
                    }
                    colmds = mmd.getKeyMetaData().getColumnMetaData();
                }
            } else if (role == FieldRole.ROLE_MAP_VALUE && mmd.getValueMetaData() != null) {
                if (mmd.getValueMetaData().hasExtension("enum-value-getter")) {
                    methodName = mmd.getValueMetaData().getValueForExtension("enum-value-getter");
                }
                colmds = mmd.getValueMetaData().getColumnMetaData();
            }
            if (methodName == null && colmds != null && colmds.length == 1) {
                if (MetaDataUtils.isJdbcTypeNumeric(colmds[0].getJdbcType())) {
                    numeric = true;
                } else if (MetaDataUtils.isJdbcTypeString(colmds[0].getJdbcType())) {
                    numeric = false;
                }
            }
        }
        if (methodName != null) {
            try {
                Method getterMethod = ClassUtils.getMethodForClass(myEnum.getClass(), methodName, null);
                return getterMethod.invoke((Object)myEnum, new Object[0]);
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.warn("Specified enum value-getter for method " + methodName + " on field " + mmd.getFullFieldName() + " gave an error on extracting the value", e);
            }
        }
        return numeric ? Integer.valueOf(myEnum.ordinal()) : myEnum.name();
    }
}

