/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.InvalidClassMetaDataException;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class InterfaceMetaData
extends AbstractClassMetaData {
    private static final long serialVersionUID = -7719837155678222822L;

    public InterfaceMetaData(PackageMetaData parent, String name) {
        super(parent, name);
    }

    @Override
    public synchronized void populate(ClassLoaderResolver clr, ClassLoader primary, MetaDataManager mgr) {
        if (this.isInitialised() || this.isPopulated()) {
            NucleusLogger.METADATA.error(Localiser.msg("044068", this.name));
            throw new NucleusException(Localiser.msg("044068", this.fullName)).setFatal();
        }
        if (this.populating) {
            return;
        }
        this.mmgr = mgr;
        try {
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(Localiser.msg("044075", this.fullName));
            }
            this.populating = true;
            Class cls = this.loadClass(clr, primary);
            if (!this.isMetaDataComplete()) {
                this.mmgr.addAnnotationsDataToClass(cls, this, clr);
            }
            this.mmgr.addORMDataToClass(cls, clr);
            if (ClassUtils.isInnerClass(this.fullName) && !Modifier.isStatic(cls.getModifiers()) && this.persistenceModifier == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                throw new InvalidClassMetaDataException("044063", new Object[]{this.fullName});
            }
            this.determineSuperClassName(clr, cls);
            this.inheritIdentity();
            this.determineIdentity();
            this.validateUserInputForIdentity();
            this.addMetaDataForMembersNotInMetaData(cls);
            this.validateUserInputForInheritanceMetaData(false);
            this.determineInheritanceMetaData();
            this.applyDefaultDiscriminatorValueWhenNotSpecified();
            if (this.objectidClass == null) {
                this.populatePropertyMetaData(clr, cls, true, primary);
                this.determineObjectIdClass();
                this.populatePropertyMetaData(clr, cls, false, primary);
            } else {
                this.populatePropertyMetaData(clr, cls, true, primary);
                this.populatePropertyMetaData(clr, cls, false, primary);
                this.determineObjectIdClass();
            }
            this.setPopulated();
        }
        catch (RuntimeException e) {
            NucleusLogger.METADATA.debug(e);
            throw e;
        }
        finally {
            this.populating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void initialise(ClassLoaderResolver clr) {
        if (this.initialising || this.isInitialised()) {
            return;
        }
        this.checkPopulated();
        try {
            this.initialising = true;
            if (this.pcSuperclassMetaData != null && !this.pcSuperclassMetaData.isInitialised()) {
                this.pcSuperclassMetaData.initialise(clr);
            }
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(Localiser.msg("044076", this.fullName));
            }
            this.validateObjectIdClass(clr);
            Iterator fields_iter = this.members.iterator();
            int no_of_managed_fields = 0;
            int no_of_overridden_fields = 0;
            while (fields_iter.hasNext()) {
                AbstractMemberMetaData fmd = (AbstractMemberMetaData)fields_iter.next();
                fmd.initialise(clr);
                if (!fmd.isFieldToBePersisted()) continue;
                if (fmd.fieldBelongsToClass()) {
                    ++no_of_managed_fields;
                    continue;
                }
                ++no_of_overridden_fields;
            }
            this.managedMembers = new AbstractMemberMetaData[no_of_managed_fields];
            this.overriddenMembers = new AbstractMemberMetaData[no_of_overridden_fields];
            fields_iter = this.members.iterator();
            int field_id = 0;
            int overridden_field_id = 0;
            this.memberPositionsByName = new HashMap();
            while (fields_iter.hasNext()) {
                AbstractMemberMetaData fmd = (AbstractMemberMetaData)fields_iter.next();
                if (!fmd.isFieldToBePersisted()) continue;
                if (fmd.fieldBelongsToClass()) {
                    fmd.setFieldId(field_id);
                    this.managedMembers[field_id] = fmd;
                    this.memberPositionsByName.put(fmd.getName(), field_id);
                    ++field_id;
                    continue;
                }
                this.overriddenMembers[overridden_field_id++] = fmd;
            }
            if (this.pcSuperclassMetaData != null) {
                if (!this.pcSuperclassMetaData.isInitialised()) {
                    this.pcSuperclassMetaData.initialise(clr);
                }
                this.noOfInheritedManagedMembers = this.pcSuperclassMetaData.getNoOfInheritedManagedMembers() + this.pcSuperclassMetaData.getNoOfManagedMembers();
            }
            this.initialiseMemberPositionInformation();
            if (this.joins != null) {
                for (JoinMetaData joinmd : this.joins) {
                    joinmd.initialise(clr);
                }
            }
            if (this.foreignKeys != null) {
                for (ForeignKeyMetaData fkmd : this.foreignKeys) {
                    fkmd.initialise(clr);
                }
            }
            if (this.indexes != null) {
                for (IndexMetaData idxmd : this.indexes) {
                    idxmd.initialise(clr);
                }
            }
            if (this.uniqueConstraints != null) {
                for (UniqueMetaData unimd : this.uniqueConstraints) {
                    unimd.initialise(clr);
                }
            }
            if (this.fetchGroups != null) {
                this.fetchGroupMetaDataByName = new HashMap();
                for (FetchGroupMetaData fgmd : this.fetchGroups) {
                    fgmd.initialise(clr);
                    this.fetchGroupMetaDataByName.put(fgmd.getName(), fgmd);
                }
            }
            if (this.identityType == IdentityType.DATASTORE && this.identityMetaData == null) {
                if (this.pcSuperclassMetaData != null) {
                    IdentityMetaData superImd = this.pcSuperclassMetaData.getIdentityMetaData();
                    this.identityMetaData = new IdentityMetaData();
                    this.identityMetaData.setColumnName(superImd.getColumnName());
                    this.identityMetaData.setValueStrategy(superImd.getValueStrategy());
                    this.identityMetaData.setSequence(superImd.getSequence());
                } else {
                    this.identityMetaData = new IdentityMetaData();
                }
            }
            if (this.versionMetaData != null) {
                this.versionMetaData.initialise(clr);
            }
            if (this.identityMetaData != null) {
                this.identityMetaData.initialise(clr);
            }
            if (this.inheritanceMetaData != null) {
                this.inheritanceMetaData.initialise(clr);
            }
            if (this.identityType == IdentityType.APPLICATION) {
                this.usesSingleFieldIdentityClass = IdentityUtils.isSingleFieldIdentityClass(this.getObjectidClass());
            }
            this.setInitialised();
        }
        finally {
            this.initialising = false;
            this.mmgr.abstractClassMetaDataInitialised(this);
        }
    }

    @Override
    protected AbstractMemberMetaData newDefaultedProperty(String name) {
        return new PropertyMetaData((MetaData)this, name);
    }

    protected void populatePropertyMetaData(ClassLoaderResolver clr, Class cls, boolean pkFields, ClassLoader primary) {
        Collections.sort(this.members);
        for (AbstractMemberMetaData fmd : this.members) {
            if (pkFields != fmd.isPrimaryKey()) continue;
            Class fieldCls = cls;
            if (!fmd.fieldBelongsToClass()) {
                try {
                    fieldCls = clr.classForName(fmd.getClassName(), primary);
                }
                catch (ClassNotResolvedException cnre) {
                    String fieldClassName = this.getPackageName() + "." + fmd.getClassName();
                    try {
                        fieldCls = clr.classForName(fieldClassName, primary);
                        fmd.setClassName(fieldClassName);
                    }
                    catch (ClassNotResolvedException cnre2) {
                        NucleusLogger.METADATA.error(Localiser.msg("044080", fieldClassName));
                        throw new InvalidClassMetaDataException("044080", this.fullName, fieldClassName);
                    }
                }
            }
            Method cls_method = null;
            try {
                cls_method = fieldCls.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(fmd.getName(), true), new Class[0]);
            }
            catch (Exception e) {
                try {
                    cls_method = fieldCls.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(fmd.getName(), false), new Class[0]);
                }
                catch (Exception e2) {
                    throw new InvalidClassMetaDataException("044072", this.fullName, fmd.getFullFieldName());
                }
            }
            fmd.populate(clr, null, cls_method, primary, this.mmgr);
        }
    }

    protected void addMetaDataForMembersNotInMetaData(Class cls) {
        HashSet<String> memberNames = new HashSet<String>();
        for (AbstractMemberMetaData mmd : this.members) {
            memberNames.add(mmd.getName());
        }
        Collections.sort(this.members);
        try {
            Method[] clsMethods = cls.getDeclaredMethods();
            block3: for (int i = 0; i < clsMethods.length; ++i) {
                String memberName;
                if (!clsMethods[i].getDeclaringClass().getName().equals(this.fullName) || !clsMethods[i].getName().startsWith("get") && !clsMethods[i].getName().startsWith("is") || ClassUtils.isInnerClass(clsMethods[i].getName()) || clsMethods[i].isBridge() || Modifier.isStatic(clsMethods[i].getModifiers()) || memberNames.contains(memberName = ClassUtils.getFieldNameForJavaBeanGetter(clsMethods[i].getName()))) continue;
                String setterName = ClassUtils.getJavaBeanSetterName(memberName);
                for (int j = 0; j < clsMethods.length; ++j) {
                    if (!clsMethods[j].getName().equals(setterName)) continue;
                    NucleusLogger.METADATA.debug(Localiser.msg("044060", this.fullName, memberName));
                    AbstractMemberMetaData mmd = this.newDefaultedProperty(memberName);
                    this.members.add(mmd);
                    memberNames.add(mmd.getName());
                    Collections.sort(this.members);
                    continue block3;
                }
            }
        }
        catch (Exception e) {
            NucleusLogger.METADATA.error(e.getMessage(), e);
            throw new NucleusUserException(e.getMessage());
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder(super.toString()).append(" [").append(this.getFullClassName()).append("]");
        if (this.identityType != null) {
            str.append(" identity=").append(this.identityType.toString());
            if (this.identityType == IdentityType.APPLICATION) {
                str.append("(").append(this.getNoOfPrimaryKeyMembers()).append(" pkFields, id=").append(this.objectidClass).append(")");
            }
        }
        str.append(", modifier=" + this.persistenceModifier);
        if (this.inheritanceMetaData != null && this.inheritanceMetaData.getStrategy() != null) {
            str.append(", inheritance=").append(this.inheritanceMetaData.getStrategy().toString());
        }
        if (this.isInitialised()) {
            int i;
            str.append(", managedMembers.size=").append(this.managedMembers.length);
            str.append(", overriddenMembers.size=").append(this.overriddenMembers.length);
            str.append("\n");
            str.append("    managed=[");
            for (i = 0; i < this.managedMembers.length; ++i) {
                if (i != 0) {
                    str.append(",");
                }
                str.append(this.managedMembers[i] instanceof PropertyMetaData ? "Property(" : "Field(").append(this.managedMembers[i].getFullFieldName()).append(")");
            }
            str.append("]");
            str.append("\n");
            str.append("    overridden=[");
            for (i = 0; i < this.overriddenMembers.length; ++i) {
                if (i != 0) {
                    str.append(",");
                }
                str.append(this.overriddenMembers[i] instanceof PropertyMetaData ? "Property(" : "Field(").append(this.overriddenMembers[i].getFullFieldName()).append(")");
            }
            str.append("]");
        } else {
            str.append(", members.size=").append(this.members.size());
        }
        return str.toString();
    }
}

