/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.datanucleus.ExecutionContextImpl;
import org.datanucleus.FetchPlanState;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.query.Extent;

public class ExecutionContextThreadedImpl
extends ExecutionContextImpl {
    protected Lock lock = new ReentrantLock();

    public ExecutionContextThreadedImpl(PersistenceNucleusContext ctx, Object owner, Map<String, Object> options) {
        super(ctx, owner, options);
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    @Override
    public boolean getMultithreaded() {
        return true;
    }

    @Override
    public void processNontransactionalUpdate() {
        try {
            this.lock.lock();
            super.processNontransactionalUpdate();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void enlistInTransaction(ObjectProvider sm) {
        try {
            this.lock.lock();
            super.enlistInTransaction(sm);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void evictFromTransaction(ObjectProvider sm) {
        try {
            this.lock.lock();
            super.evictFromTransaction(sm);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addObjectProviderToCache(ObjectProvider op) {
        try {
            this.lock.lock();
            super.addObjectProviderToCache(op);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeObjectProviderFromCache(ObjectProvider op) {
        try {
            this.lock.lock();
            super.removeObjectProviderFromCache(op);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ObjectProvider findObjectProvider(Object pc) {
        try {
            this.lock.lock();
            ObjectProvider objectProvider = super.findObjectProvider(pc);
            return objectProvider;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.lock.lock();
            super.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void evictObject(Object obj) {
        try {
            this.lock.lock();
            super.evictObject(obj);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void refreshObject(Object obj) {
        try {
            this.lock.lock();
            super.refreshObject(obj);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void retrieveObject(Object obj, boolean fgOnly) {
        try {
            this.lock.lock();
            super.retrieveObject(obj, fgOnly);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object persistObject(Object obj, boolean merging) {
        try {
            this.lock.lock();
            Object object = super.persistObject(obj, merging);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object[] persistObjects(Object ... objs) {
        try {
            this.lock.lock();
            Object[] objectArray = super.persistObjects(objs);
            return objectArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void deleteObject(Object obj) {
        try {
            this.lock.lock();
            super.deleteObject(obj);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void deleteObjects(Object ... objs) {
        try {
            this.lock.lock();
            super.deleteObjects(objs);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void makeObjectTransient(Object obj, FetchPlanState state) {
        try {
            this.lock.lock();
            super.makeObjectTransient(obj, state);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void makeObjectTransactional(Object obj) {
        try {
            this.lock.lock();
            super.makeObjectTransactional(obj);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachObject(ObjectProvider ownerOP, Object pc, boolean sco) {
        try {
            this.lock.lock();
            super.attachObject(ownerOP, pc, sco);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object attachObjectCopy(ObjectProvider ownerOP, Object pc, boolean sco) {
        try {
            this.lock.lock();
            Object object = super.attachObjectCopy(ownerOP, pc, sco);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void detachObject(FetchPlanState state, Object obj) {
        try {
            this.lock.lock();
            super.detachObject(state, obj);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void detachObjects(FetchPlanState state, Object ... objs) {
        try {
            this.lock.lock();
            super.detachObjects(state, objs);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object detachObjectCopy(Object pc, FetchPlanState state) {
        try {
            this.lock.lock();
            Object object = super.detachObjectCopy(state, pc);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clearDirty(ObjectProvider op) {
        try {
            this.lock.lock();
            super.clearDirty(op);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clearDirty() {
        try {
            this.lock.lock();
            super.clearDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void evictAllObjects() {
        this.assertIsOpen();
        try {
            this.lock.lock();
            super.evictAllObjects();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void markDirty(ObjectProvider op, boolean directUpdate) {
        try {
            this.lock.lock();
            super.markDirty(op, directUpdate);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void flush() {
        try {
            this.lock.lock();
            super.flush();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void flushInternal(boolean flushToDatastore) {
        try {
            this.lock.lock();
            super.flushInternal(flushToDatastore);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceObjectId(Persistable pc, Object oldID, Object newID) {
        try {
            this.lock.lock();
            super.replaceObjectId(pc, oldID, newID);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extent getExtent(Class pcClass, boolean subclasses) {
        try {
            this.lock.lock();
            Extent extent = super.getExtent(pcClass, subclasses);
            return extent;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void evictObjects(Class cls, boolean subclasses) {
        try {
            this.lock.lock();
            super.evictObjects(cls, subclasses);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void refreshAllObjects() {
        try {
            this.lock.lock();
            super.refreshAllObjects();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<ObjectProvider> getObjectsToBeFlushed() {
        try {
            this.lock.lock();
            List<ObjectProvider> list = super.getObjectsToBeFlushed();
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void postBegin() {
        try {
            this.lock.lock();
            super.postBegin();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void preCommit() {
        try {
            this.lock.lock();
            super.preCommit();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void postCommit() {
        try {
            this.lock.lock();
            super.postCommit();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void preRollback() {
        try {
            this.lock.lock();
            super.preRollback();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void postRollback() {
        try {
            this.lock.lock();
            super.postRollback();
        }
        finally {
            this.lock.unlock();
        }
    }
}

