/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.lang.annotation.ElementType;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.Configuration;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.util.StringUtils;

public class BeanValidationHandler {
    Validator validator;
    ClassLoaderResolver clr;
    Configuration conf;

    public BeanValidationHandler(ExecutionContext ec, Object validatorFactory) {
        this.conf = ec.getNucleusContext().getConfiguration();
        this.clr = ec.getClassLoaderResolver();
        this.validator = ((ValidatorFactory)validatorFactory).usingContext().traversableResolver((TraversableResolver)new PersistenceTraversalResolver(ec)).getValidator();
    }

    public void close() {
    }

    public void validate(Object pc, String callbackName, Class<?>[] groups) {
        if (this.validator == null) {
            return;
        }
        Set violations = this.validator.validate(pc, (Class[])groups);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException("Validation failed for " + StringUtils.toJVMIDString(pc) + " during " + callbackName + " for groups " + StringUtils.objectArrayToString(groups) + " - exceptions are attached", violations);
        }
    }

    public void preDelete(Object pc) {
        Class<?>[] groups = this.getGroups(this.conf.getStringProperty("datanucleus.validation.group.pre-remove"), "pre-remove");
        if (groups != null) {
            this.validate(pc, "pre-remove", groups);
        }
    }

    public void preStore(Object pc) {
        Class<?>[] groups = this.getGroups(this.conf.getStringProperty("datanucleus.validation.group.pre-update"), "pre-update");
        if (groups != null) {
            this.validate(pc, "pre-update", groups);
        }
    }

    public void prePersist(Object pc) {
        Class<?>[] groups = this.getGroups(this.conf.getStringProperty("datanucleus.validation.group.pre-persist"), "pre-persist");
        if (groups != null) {
            this.validate(pc, "pre-persist", groups);
        }
    }

    private Class<?>[] getGroups(String property, String eventName) {
        if (property == null || property.trim().length() == 0) {
            if (eventName.equals("pre-persist") || eventName.equals("pre-update")) {
                return new Class[]{Default.class};
            }
            return null;
        }
        String[] classNames = property.trim().split(",");
        Class[] groups = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            groups[i] = this.clr.classForName(classNames[i].trim());
        }
        return groups;
    }

    static class PersistenceTraversalResolver
    implements TraversableResolver {
        ExecutionContext ec;

        PersistenceTraversalResolver(ExecutionContext ec) {
            this.ec = ec;
        }

        public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return false;
        }

        public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            AbstractClassMetaData acmd = this.ec.getMetaDataManager().getMetaDataForClass(traversableObject.getClass(), this.ec.getClassLoaderResolver());
            if (acmd == null) {
                return false;
            }
            AbstractMemberMetaData mmd = acmd.getMetaDataForMember(traversableProperty.getName());
            if (mmd.getPersistenceModifier() == FieldPersistenceModifier.NONE) {
                return true;
            }
            ObjectProvider op = this.ec.findObjectProvider(traversableObject);
            return op.isFieldLoaded(mmd.getAbsoluteFieldNumber());
        }
    }
}

