/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.query.compiler.CompilationOptimiser;
import org.datanucleus.store.query.compiler.QueryCompilation;
import org.datanucleus.store.query.expression.DyadicExpression;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.query.expression.InvokeExpression;
import org.datanucleus.store.query.expression.PrimaryExpression;
import org.datanucleus.store.query.expression.VariableExpression;
import org.datanucleus.util.NucleusLogger;

public class VarThisCompilationOptimiser
implements CompilationOptimiser {
    QueryCompilation compilation;

    public VarThisCompilationOptimiser(QueryCompilation compilation, MetaDataManager unused, ClassLoaderResolver clr) {
        this.compilation = compilation;
    }

    @Override
    public void optimise() {
        if (this.compilation == null) {
            return;
        }
        if (this.compilation.getExprFilter() != null) {
            HashSet<String> redundantVariables = new HashSet<String>();
            this.findRedundantFilterVariables(this.compilation.getExprFilter(), redundantVariables);
            if (!redundantVariables.isEmpty()) {
                for (String var : redundantVariables) {
                    Expression[] exprGrouping;
                    if (NucleusLogger.QUERY.isDebugEnabled()) {
                        NucleusLogger.QUERY.debug("JDOQL Optimiser : Query was defined with variable " + var + " yet this was redundant, so has been replaced by the candidate");
                    }
                    this.compilation.setExprFilter(this.replaceVariableWithCandidateInExpression(var, this.compilation.getExprFilter()));
                    this.compilation.setExprHaving(this.replaceVariableWithCandidateInExpression(var, this.compilation.getExprHaving()));
                    Expression[] exprResult = this.compilation.getExprResult();
                    if (exprResult != null) {
                        for (int i = 0; i < exprResult.length; ++i) {
                            exprResult[i] = this.replaceVariableWithCandidateInExpression(var, exprResult[i]);
                        }
                    }
                    if ((exprGrouping = this.compilation.getExprGrouping()) != null) {
                        for (int i = 0; i < exprGrouping.length; ++i) {
                            exprGrouping[i] = this.replaceVariableWithCandidateInExpression(var, exprGrouping[i]);
                        }
                    }
                    this.compilation.getSymbolTable().removeSymbol(this.compilation.getSymbolTable().getSymbol(var));
                }
            }
        }
    }

    private Expression replaceVariableWithCandidateInExpression(String varName, Expression expr) {
        InvokeExpression invokeExpr;
        if (expr == null) {
            return null;
        }
        if (expr instanceof VariableExpression && ((VariableExpression)expr).getId().equals(varName)) {
            ArrayList<String> tuples = new ArrayList<String>();
            tuples.add(this.compilation.getCandidateAlias());
            PrimaryExpression replExpr = new PrimaryExpression(tuples);
            ((Expression)replExpr).bind(this.compilation.getSymbolTable());
            return replExpr;
        }
        if (expr instanceof DyadicExpression) {
            DyadicExpression dyExpr = (DyadicExpression)expr;
            if (dyExpr.getLeft() != null) {
                dyExpr.setLeft(this.replaceVariableWithCandidateInExpression(varName, dyExpr.getLeft()));
            }
            if (dyExpr.getRight() != null) {
                dyExpr.setRight(this.replaceVariableWithCandidateInExpression(varName, dyExpr.getRight()));
            }
        } else if (expr instanceof PrimaryExpression) {
            if (expr.getLeft() != null) {
                if (expr.getLeft() instanceof VariableExpression && ((VariableExpression)expr.getLeft()).getId().equals(varName)) {
                    expr.setLeft(null);
                } else {
                    expr.setLeft(this.replaceVariableWithCandidateInExpression(varName, expr.getLeft()));
                }
            }
        } else if (expr instanceof InvokeExpression && (invokeExpr = (InvokeExpression)expr).getLeft() != null) {
            invokeExpr.setLeft(this.replaceVariableWithCandidateInExpression(varName, invokeExpr.getLeft()));
        }
        return expr;
    }

    private void findRedundantFilterVariables(Expression filterExpr, Set<String> varNames) {
        if (filterExpr instanceof DyadicExpression) {
            DyadicExpression dyExpr = (DyadicExpression)filterExpr;
            if (dyExpr.getOperator() == Expression.OP_EQ) {
                PrimaryExpression leftExpr;
                if (dyExpr.getLeft() instanceof VariableExpression) {
                    PrimaryExpression rightExpr;
                    if (dyExpr.getRight() instanceof PrimaryExpression && (rightExpr = (PrimaryExpression)dyExpr.getRight()).getId().equals(this.compilation.getCandidateAlias())) {
                        varNames.add(((VariableExpression)dyExpr.getLeft()).getId());
                    }
                } else if (dyExpr.getRight() instanceof VariableExpression && dyExpr.getLeft() instanceof PrimaryExpression && (leftExpr = (PrimaryExpression)dyExpr.getLeft()).getId().equals(this.compilation.getCandidateAlias())) {
                    varNames.add(((VariableExpression)dyExpr.getRight()).getId());
                }
            } else if (dyExpr.getOperator() == Expression.OP_AND) {
                this.findRedundantFilterVariables(dyExpr.getLeft(), varNames);
                this.findRedundantFilterVariables(dyExpr.getRight(), varNames);
            } else if (dyExpr.getOperator() == Expression.OP_OR) {
                this.findRedundantFilterVariables(dyExpr.getLeft(), varNames);
                this.findRedundantFilterVariables(dyExpr.getRight(), varNames);
            }
        }
    }
}

