/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.Period;
import java.time.YearMonth;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.query.cache.JavaxCacheQueryCompilationCache;
import org.datanucleus.store.query.cache.JavaxCacheQueryDatastoreCompilationCache;
import org.datanucleus.store.query.cache.JavaxCacheQueryResultCache;
import org.datanucleus.store.query.cache.QueryCompilationCache;
import org.datanucleus.store.query.cache.QueryDatastoreCompilationCache;
import org.datanucleus.store.query.cache.QueryResultsCache;
import org.datanucleus.store.query.cache.SoftQueryCompilationCache;
import org.datanucleus.store.query.cache.SoftQueryDatastoreCompilationCache;
import org.datanucleus.store.query.cache.SoftQueryResultsCache;
import org.datanucleus.store.query.cache.StrongQueryCompilationCache;
import org.datanucleus.store.query.cache.StrongQueryDatastoreCompilationCache;
import org.datanucleus.store.query.cache.StrongQueryResultsCache;
import org.datanucleus.store.query.cache.WeakQueryCompilationCache;
import org.datanucleus.store.query.cache.WeakQueryDatastoreCompilationCache;
import org.datanucleus.store.query.cache.WeakQueryResultsCache;
import org.datanucleus.store.query.compiler.QueryCompilation;
import org.datanucleus.store.query.inmemory.InvocationEvaluator;
import org.datanucleus.store.query.inmemory.method.AbsFunction;
import org.datanucleus.store.query.inmemory.method.ArcCosineFunction;
import org.datanucleus.store.query.inmemory.method.ArcSineFunction;
import org.datanucleus.store.query.inmemory.method.ArcTangentFunction;
import org.datanucleus.store.query.inmemory.method.ArrayContainsMethod;
import org.datanucleus.store.query.inmemory.method.ArraySizeMethod;
import org.datanucleus.store.query.inmemory.method.CeilFunction;
import org.datanucleus.store.query.inmemory.method.CoalesceFunction;
import org.datanucleus.store.query.inmemory.method.CollectionContainsMethod;
import org.datanucleus.store.query.inmemory.method.ConcatFunction;
import org.datanucleus.store.query.inmemory.method.ContainerIsEmptyMethod;
import org.datanucleus.store.query.inmemory.method.ContainerSizeMethod;
import org.datanucleus.store.query.inmemory.method.CosineFunction;
import org.datanucleus.store.query.inmemory.method.CurrentDateFunction;
import org.datanucleus.store.query.inmemory.method.CurrentTimeFunction;
import org.datanucleus.store.query.inmemory.method.CurrentTimestampFunction;
import org.datanucleus.store.query.inmemory.method.DateGetDayMethod;
import org.datanucleus.store.query.inmemory.method.DateGetDayOfWeekMethod;
import org.datanucleus.store.query.inmemory.method.DateGetHoursMethod;
import org.datanucleus.store.query.inmemory.method.DateGetMinutesMethod;
import org.datanucleus.store.query.inmemory.method.DateGetMonthMethod;
import org.datanucleus.store.query.inmemory.method.DateGetSecondsMethod;
import org.datanucleus.store.query.inmemory.method.DateGetTimeMethod;
import org.datanucleus.store.query.inmemory.method.DateGetYearMethod;
import org.datanucleus.store.query.inmemory.method.DegreesFunction;
import org.datanucleus.store.query.inmemory.method.EnumMatchesMethod;
import org.datanucleus.store.query.inmemory.method.EnumOrdinalMethod;
import org.datanucleus.store.query.inmemory.method.EnumToStringMethod;
import org.datanucleus.store.query.inmemory.method.ExpFunction;
import org.datanucleus.store.query.inmemory.method.FloorFunction;
import org.datanucleus.store.query.inmemory.method.LengthFunction;
import org.datanucleus.store.query.inmemory.method.ListGetMethod;
import org.datanucleus.store.query.inmemory.method.ListIndexOfMethod;
import org.datanucleus.store.query.inmemory.method.LocalDateGetDayOfMonth;
import org.datanucleus.store.query.inmemory.method.LocalDateGetDayOfWeek;
import org.datanucleus.store.query.inmemory.method.LocalDateGetMonthValue;
import org.datanucleus.store.query.inmemory.method.LocalDateGetYear;
import org.datanucleus.store.query.inmemory.method.LocalDateTimeGetDayOfMonth;
import org.datanucleus.store.query.inmemory.method.LocalDateTimeGetDayOfWeek;
import org.datanucleus.store.query.inmemory.method.LocalDateTimeGetHour;
import org.datanucleus.store.query.inmemory.method.LocalDateTimeGetMinute;
import org.datanucleus.store.query.inmemory.method.LocalDateTimeGetMonthValue;
import org.datanucleus.store.query.inmemory.method.LocalDateTimeGetSecond;
import org.datanucleus.store.query.inmemory.method.LocalDateTimeGetYear;
import org.datanucleus.store.query.inmemory.method.LocalTimeGetHour;
import org.datanucleus.store.query.inmemory.method.LocalTimeGetMinute;
import org.datanucleus.store.query.inmemory.method.LocalTimeGetSecond;
import org.datanucleus.store.query.inmemory.method.LocateFunction;
import org.datanucleus.store.query.inmemory.method.LogFunction;
import org.datanucleus.store.query.inmemory.method.LowerFunction;
import org.datanucleus.store.query.inmemory.method.MapContainsEntryMethod;
import org.datanucleus.store.query.inmemory.method.MapContainsKeyMethod;
import org.datanucleus.store.query.inmemory.method.MapContainsValueMethod;
import org.datanucleus.store.query.inmemory.method.MapGetMethod;
import org.datanucleus.store.query.inmemory.method.ModFunction;
import org.datanucleus.store.query.inmemory.method.MonthDayGetDayOfMonth;
import org.datanucleus.store.query.inmemory.method.MonthDayGetMonthValue;
import org.datanucleus.store.query.inmemory.method.NullIfFunction;
import org.datanucleus.store.query.inmemory.method.ObjectGetClassMethod;
import org.datanucleus.store.query.inmemory.method.OptionalGetMethod;
import org.datanucleus.store.query.inmemory.method.OptionalIsPresentMethod;
import org.datanucleus.store.query.inmemory.method.OptionalOrElseMethod;
import org.datanucleus.store.query.inmemory.method.PeriodGetDays;
import org.datanucleus.store.query.inmemory.method.PeriodGetMonths;
import org.datanucleus.store.query.inmemory.method.PeriodGetYears;
import org.datanucleus.store.query.inmemory.method.RadiansFunction;
import org.datanucleus.store.query.inmemory.method.SineFunction;
import org.datanucleus.store.query.inmemory.method.SizeFunction;
import org.datanucleus.store.query.inmemory.method.SqrtFunction;
import org.datanucleus.store.query.inmemory.method.StringCharAtMethod;
import org.datanucleus.store.query.inmemory.method.StringConcatMethod;
import org.datanucleus.store.query.inmemory.method.StringEndsWithMethod;
import org.datanucleus.store.query.inmemory.method.StringEqualsIgnoreCaseMethod;
import org.datanucleus.store.query.inmemory.method.StringEqualsMethod;
import org.datanucleus.store.query.inmemory.method.StringIndexOfMethod;
import org.datanucleus.store.query.inmemory.method.StringLengthMethod;
import org.datanucleus.store.query.inmemory.method.StringMatchesMethod;
import org.datanucleus.store.query.inmemory.method.StringStartsWithMethod;
import org.datanucleus.store.query.inmemory.method.StringSubstringMethod;
import org.datanucleus.store.query.inmemory.method.StringToLowerCaseMethod;
import org.datanucleus.store.query.inmemory.method.StringToUpperCaseMethod;
import org.datanucleus.store.query.inmemory.method.StringTrimLeftMethod;
import org.datanucleus.store.query.inmemory.method.StringTrimMethod;
import org.datanucleus.store.query.inmemory.method.StringTrimRightMethod;
import org.datanucleus.store.query.inmemory.method.SubstringFunction;
import org.datanucleus.store.query.inmemory.method.TangentFunction;
import org.datanucleus.store.query.inmemory.method.TemporalDayMethod;
import org.datanucleus.store.query.inmemory.method.TemporalHourMethod;
import org.datanucleus.store.query.inmemory.method.TemporalMinuteMethod;
import org.datanucleus.store.query.inmemory.method.TemporalMonthJavaMethod;
import org.datanucleus.store.query.inmemory.method.TemporalMonthMethod;
import org.datanucleus.store.query.inmemory.method.TemporalSecondMethod;
import org.datanucleus.store.query.inmemory.method.TemporalYearMethod;
import org.datanucleus.store.query.inmemory.method.TrimFunction;
import org.datanucleus.store.query.inmemory.method.UpperFunction;
import org.datanucleus.store.query.inmemory.method.YearMonthGetMonthValue;
import org.datanucleus.store.query.inmemory.method.YearMonthGetYear;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class QueryManagerImpl
implements QueryManager {
    protected NucleusContext nucleusCtx;
    protected StoreManager storeMgr;
    protected final QueryCompilationCache queryCompilationCache;
    protected final QueryDatastoreCompilationCache queryCompilationCacheDatastore;
    protected final QueryResultsCache queryResultsCache;
    protected Map<String, InvocationEvaluator> inmemoryQueryMethodEvaluatorByName = new ConcurrentHashMap<String, InvocationEvaluator>();
    protected Map<String, String> queryMethodAliasByPrefix = null;

    public QueryManagerImpl(NucleusContext nucleusContext, StoreManager storeMgr) {
        String cacheClassName;
        this.nucleusCtx = nucleusContext;
        this.storeMgr = storeMgr;
        Configuration conf = this.nucleusCtx.getConfiguration();
        String cacheType = conf.getStringProperty("datanucleus.cache.queryCompilation.type");
        if (cacheType == null) {
            cacheType = "soft";
        }
        if ("soft".equalsIgnoreCase(cacheType)) {
            this.queryCompilationCache = new SoftQueryCompilationCache(nucleusContext);
        } else if ("weak".equalsIgnoreCase(cacheType)) {
            this.queryCompilationCache = new WeakQueryCompilationCache(this.nucleusCtx);
        } else if ("strong".equalsIgnoreCase(cacheType)) {
            this.queryCompilationCache = new StrongQueryCompilationCache(this.nucleusCtx);
        } else if ("javax.cache".equalsIgnoreCase(cacheType)) {
            this.queryCompilationCache = new JavaxCacheQueryCompilationCache(this.nucleusCtx);
        } else {
            cacheClassName = this.nucleusCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_query_compilation", "name", cacheType, "class-name");
            if (cacheClassName == null) {
                throw new NucleusUserException(Localiser.msg("021500", cacheType)).setFatal();
            }
            try {
                this.queryCompilationCache = (QueryCompilationCache)this.nucleusCtx.getPluginManager().createExecutableExtension("org.datanucleus.cache_query_compilation", "name", cacheType, "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.nucleusCtx});
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("021502", cacheClassName));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(Localiser.msg("021501", cacheType, cacheClassName), e).setFatal();
            }
        }
        cacheType = conf.getStringProperty("datanucleus.cache.queryCompilationDatastore.type");
        if (cacheType == null) {
            cacheType = "soft";
        }
        if ("soft".equalsIgnoreCase(cacheType)) {
            this.queryCompilationCacheDatastore = new SoftQueryDatastoreCompilationCache(nucleusContext);
        } else if ("weak".equalsIgnoreCase(cacheType)) {
            this.queryCompilationCacheDatastore = new WeakQueryDatastoreCompilationCache(this.nucleusCtx);
        } else if ("strong".equalsIgnoreCase(cacheType)) {
            this.queryCompilationCacheDatastore = new StrongQueryDatastoreCompilationCache(this.nucleusCtx);
        } else if ("javax.cache".equalsIgnoreCase(cacheType)) {
            this.queryCompilationCacheDatastore = new JavaxCacheQueryDatastoreCompilationCache(this.nucleusCtx);
        } else {
            cacheClassName = this.nucleusCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_query_compilation_store", "name", cacheType, "class-name");
            if (cacheClassName == null) {
                throw new NucleusUserException(Localiser.msg("021500", cacheType)).setFatal();
            }
            try {
                this.queryCompilationCacheDatastore = (QueryDatastoreCompilationCache)this.nucleusCtx.getPluginManager().createExecutableExtension("org.datanucleus.cache_query_compilation_store", "name", cacheType, "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.nucleusCtx});
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("021502", cacheClassName));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(Localiser.msg("021501", cacheType, cacheClassName), e).setFatal();
            }
        }
        cacheType = conf.getStringProperty("datanucleus.cache.queryResults.type");
        if (cacheType == null) {
            cacheType = "soft";
        }
        if ("soft".equalsIgnoreCase(cacheType)) {
            this.queryResultsCache = new SoftQueryResultsCache(nucleusContext);
        } else if ("weak".equalsIgnoreCase(cacheType)) {
            this.queryResultsCache = new WeakQueryResultsCache(this.nucleusCtx);
        } else if ("strong".equalsIgnoreCase(cacheType)) {
            this.queryResultsCache = new StrongQueryResultsCache(this.nucleusCtx);
        } else if ("javax.cache".equalsIgnoreCase(cacheType)) {
            this.queryResultsCache = new JavaxCacheQueryResultCache(this.nucleusCtx);
        } else {
            cacheClassName = this.nucleusCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_query_result", "name", cacheType, "class-name");
            if (cacheClassName == null) {
                throw new NucleusUserException(Localiser.msg("021500", cacheType)).setFatal();
            }
            try {
                this.queryResultsCache = (QueryResultsCache)this.nucleusCtx.getPluginManager().createExecutableExtension("org.datanucleus.cache_query_result", "name", cacheType, "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.nucleusCtx});
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("021502", cacheClassName));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(Localiser.msg("021501", cacheType, cacheClassName), e).setFatal();
            }
        }
        this.queryMethodAliasByPrefix = new HashMap<String, String>();
        this.queryMethodAliasByPrefix.put("JDOHelper", "JDOHelper");
        this.queryMethodAliasByPrefix.put("javax.jdo.JDOHelper", "JDOHelper");
        this.queryMethodAliasByPrefix.put("Math", "Math");
        this.queryMethodAliasByPrefix.put("java.lang.Math", "Math");
        ConfigurationElement[] queryMethodAliases = this.nucleusCtx.getPluginManager().getConfigurationElementsForExtension("org.datanucleus.query_method_prefix", (String)null, (String)null);
        if (queryMethodAliases != null && queryMethodAliases.length > 0) {
            for (int i = 0; i < queryMethodAliases.length; ++i) {
                this.queryMethodAliasByPrefix.put(queryMethodAliases[i].getAttribute("prefix"), queryMethodAliases[i].getAttribute("alias"));
            }
        }
    }

    @Override
    public void close() {
        if (this.queryCompilationCache != null) {
            this.queryCompilationCache.close();
        }
        if (this.queryCompilationCacheDatastore != null) {
            this.queryCompilationCacheDatastore.close();
        }
        if (this.queryResultsCache != null) {
            this.queryResultsCache.close();
        }
        this.inmemoryQueryMethodEvaluatorByName.clear();
        this.inmemoryQueryMethodEvaluatorByName = null;
    }

    @Override
    public Map<String, String> getQueryMethodAliasesByPrefix() {
        return this.queryMethodAliasByPrefix;
    }

    @Override
    public QueryCompilationCache getQueryCompilationCache() {
        return this.queryCompilationCache;
    }

    @Override
    public void addQueryCompilation(String language, String query, QueryCompilation compilation) {
        if (this.queryCompilationCache != null) {
            this.queryCompilationCache.put(language + ":" + query, compilation);
        }
    }

    @Override
    public void removeQueryCompilation(String language, String query) {
        if (this.queryCompilationCache != null) {
            this.queryCompilationCache.evict(language + ":" + query);
        }
    }

    @Override
    public QueryCompilation getQueryCompilationForQuery(String language, String query) {
        String queryKey;
        QueryCompilation compilation;
        if (this.queryCompilationCache != null && (compilation = this.queryCompilationCache.get(queryKey = language + ":" + query)) != null) {
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(Localiser.msg("021079", query, language));
            }
            return compilation;
        }
        return null;
    }

    @Override
    public QueryDatastoreCompilationCache getQueryDatastoreCompilationCache() {
        return this.queryCompilationCacheDatastore;
    }

    @Override
    public void addDatastoreQueryCompilation(String datastore, String language, String query, Object compilation) {
        if (this.queryCompilationCacheDatastore != null) {
            String queryKey = language + ":" + query;
            this.queryCompilationCacheDatastore.put(queryKey, compilation);
        }
    }

    @Override
    public void removeDatastoreQueryCompilation(String datastore, String language, String query) {
        if (this.queryCompilationCacheDatastore != null) {
            String queryKey = language + ":" + query;
            this.queryCompilationCacheDatastore.evict(queryKey);
        }
    }

    @Override
    public Object getDatastoreQueryCompilation(String datastore, String language, String query) {
        String queryKey;
        Object compilation;
        if (this.queryCompilationCacheDatastore != null && (compilation = this.queryCompilationCacheDatastore.get(queryKey = language + ":" + query)) != null) {
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(Localiser.msg("021080", query, language, datastore));
            }
            return compilation;
        }
        return null;
    }

    @Override
    public QueryResultsCache getQueryResultsCache() {
        return this.queryResultsCache;
    }

    @Override
    public void evictQueryResultsForType(Class cls) {
        if (this.queryResultsCache != null) {
            this.queryResultsCache.evict(cls);
        }
    }

    @Override
    public void addQueryResult(Query query, Map params, List<Object> results) {
        if (this.queryResultsCache != null) {
            String queryKey = QueryUtils.getKeyForQueryResultsCache(query, params);
            this.queryResultsCache.put(queryKey, results);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(Localiser.msg("021081", query, results.size()));
            }
        }
    }

    @Override
    public List<Object> getQueryResult(Query query, Map params) {
        if (this.queryResultsCache != null) {
            String queryKey = QueryUtils.getKeyForQueryResultsCache(query, params);
            List<Object> results = this.queryResultsCache.get(queryKey);
            if (results != null && NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(Localiser.msg("021082", query, results.size()));
            }
            return results;
        }
        return null;
    }

    @Override
    public InvocationEvaluator getInMemoryEvaluatorForMethod(Class type, String methodName) {
        PluginManager pluginMgr;
        ConfigurationElement[] elems;
        InvocationEvaluator eval;
        Object lookupName;
        Object object = lookupName = type != null ? type.getName() + ":" + methodName : methodName;
        if (type != null && type.isArray()) {
            lookupName = "ARRAY:" + methodName;
        }
        if ((eval = this.inmemoryQueryMethodEvaluatorByName.get(lookupName)) != null) {
            return eval;
        }
        ClassLoaderResolver clr = this.nucleusCtx.getClassLoaderResolver(type != null ? type.getClassLoader() : null);
        if (type == null) {
            if ("Math.abs".equals(methodName)) {
                eval = new AbsFunction();
            }
            if ("Math.sqrt".equals(methodName)) {
                eval = new SqrtFunction();
            }
            if ("Math.acos".equals(methodName)) {
                eval = new ArcCosineFunction();
            }
            if ("Math.asin".equals(methodName)) {
                eval = new ArcSineFunction();
            }
            if ("Math.atan".equals(methodName)) {
                eval = new ArcTangentFunction();
            }
            if ("Math.cos".equals(methodName)) {
                eval = new CosineFunction();
            }
            if ("Math.sin".equals(methodName)) {
                eval = new SineFunction();
            }
            if ("Math.tan".equals(methodName)) {
                eval = new TangentFunction();
            }
            if ("Math.log".equals(methodName)) {
                eval = new LogFunction();
            }
            if ("Math.exp".equals(methodName)) {
                eval = new ExpFunction();
            }
            if ("Math.floor".equals(methodName)) {
                eval = new FloorFunction();
            }
            if ("Math.ceil".equals(methodName)) {
                eval = new CeilFunction();
            }
            if ("Math.toDegrees".equals(methodName)) {
                eval = new DegreesFunction();
            }
            if ("Math.toRadians".equals(methodName)) {
                eval = new RadiansFunction();
            }
            if ("CURRENT_DATE".equals(methodName)) {
                eval = new CurrentDateFunction();
            }
            if ("CURRENT_TIME".equals(methodName)) {
                eval = new CurrentTimeFunction();
            }
            if ("CURRENT_TIMESTAMP".equals(methodName)) {
                eval = new CurrentTimestampFunction();
            }
            if ("ABS".equals(methodName)) {
                eval = new AbsFunction();
            }
            if ("SQRT".equals(methodName)) {
                eval = new SqrtFunction();
            }
            if ("MOD".equals(methodName)) {
                eval = new ModFunction();
            }
            if ("COALESCE".equals(methodName)) {
                eval = new CoalesceFunction();
            }
            if ("COS".equals(methodName)) {
                eval = new CosineFunction();
            }
            if ("SIN".equals(methodName)) {
                eval = new SineFunction();
            }
            if ("TAN".equals(methodName)) {
                eval = new TangentFunction();
            }
            if ("ACOS".equals(methodName)) {
                eval = new ArcCosineFunction();
            }
            if ("ASIN".equals(methodName)) {
                eval = new ArcSineFunction();
            }
            if ("ATAN".equals(methodName)) {
                eval = new ArcTangentFunction();
            }
            if ("CEIL".equals(methodName)) {
                eval = new CeilFunction();
            }
            if ("FLOOR".equals(methodName)) {
                eval = new FloorFunction();
            }
            if ("LOG".equals(methodName)) {
                eval = new LogFunction();
            }
            if ("EXP".equals(methodName)) {
                eval = new ExpFunction();
            }
            if ("NULLIF".equals(methodName)) {
                eval = new NullIfFunction();
            }
            if ("SIZE".equals(methodName)) {
                eval = new SizeFunction();
            }
            if ("UPPER".equals(methodName)) {
                eval = new UpperFunction();
            }
            if ("LOWER".equals(methodName)) {
                eval = new LowerFunction();
            }
            if ("LENGTH".equals(methodName)) {
                eval = new LengthFunction();
            }
            if ("CONCAT".equals(methodName)) {
                eval = new ConcatFunction();
            }
            if ("SUBSTRING".equals(methodName)) {
                eval = new SubstringFunction();
            }
            if ("LOCATE".equals(methodName)) {
                eval = new LocateFunction();
            }
            if ("TRIM".equals(methodName)) {
                eval = new TrimFunction();
            }
            if ("TRIM_LEADING".equals(methodName)) {
                eval = new TrimFunction();
            }
            if ("TRIM_TRAILING".equals(methodName)) {
                eval = new TrimFunction();
            }
            if ("DEGREES".equals(methodName)) {
                eval = new DegreesFunction();
            }
            if ("RADIANS".equals(methodName)) {
                eval = new RadiansFunction();
            }
            if ("YEAR".equals(methodName)) {
                eval = new TemporalYearMethod();
            }
            if ("MONTH".equals(methodName)) {
                eval = new TemporalMonthMethod();
            }
            if ("MONTH_JAVA".equals(methodName)) {
                eval = new TemporalMonthJavaMethod();
            }
            if ("DAY".equals(methodName)) {
                eval = new TemporalDayMethod();
            }
            if ("HOUR".equals(methodName)) {
                eval = new TemporalHourMethod();
            }
            if ("MINUTE".equals(methodName)) {
                eval = new TemporalMinuteMethod();
            }
            if ("SECOND".equals(methodName)) {
                eval = new TemporalSecondMethod();
            }
            if (eval != null) {
                this.inmemoryQueryMethodEvaluatorByName.put((String)lookupName, eval);
                return eval;
            }
        } else {
            if (type.isArray()) {
                if ("size".equals(methodName)) {
                    eval = new ArraySizeMethod();
                }
                if ("length".equals(methodName)) {
                    eval = new ArraySizeMethod();
                }
                if ("contains".equals(methodName)) {
                    eval = new ArrayContainsMethod();
                }
            } else if (type.isEnum()) {
                if ("matches".equals(methodName)) {
                    eval = new EnumMatchesMethod();
                }
                if ("toString".equals(methodName)) {
                    eval = new EnumToStringMethod();
                }
                if ("ordinal".equals(methodName)) {
                    eval = new EnumOrdinalMethod();
                }
            } else if ("java.lang.String".equals(type.getName())) {
                if ("charAt".equals(methodName)) {
                    eval = new StringCharAtMethod();
                }
                if ("concat".equals(methodName)) {
                    eval = new StringConcatMethod();
                }
                if ("endsWith".equals(methodName)) {
                    eval = new StringEndsWithMethod();
                }
                if ("equals".equals(methodName)) {
                    eval = new StringEqualsMethod();
                }
                if ("equalsIgnoreCase".equals(methodName)) {
                    eval = new StringEqualsIgnoreCaseMethod();
                }
                if ("indexOf".equals(methodName)) {
                    eval = new StringIndexOfMethod();
                }
                if ("length".equals(methodName)) {
                    eval = new StringLengthMethod();
                }
                if ("matches".equals(methodName)) {
                    eval = new StringMatchesMethod();
                }
                if ("startsWith".equals(methodName)) {
                    eval = new StringStartsWithMethod();
                }
                if ("substring".equals(methodName)) {
                    eval = new StringSubstringMethod();
                }
                if ("toUpperCase".equals(methodName)) {
                    eval = new StringToUpperCaseMethod();
                }
                if ("toLowerCase".equals(methodName)) {
                    eval = new StringToLowerCaseMethod();
                }
                if ("trim".equals(methodName)) {
                    eval = new StringTrimMethod();
                }
                if ("trimLeft".equals(methodName)) {
                    eval = new StringTrimLeftMethod();
                }
                if ("trimRight".equals(methodName)) {
                    eval = new StringTrimRightMethod();
                }
            } else if (Collection.class.isAssignableFrom(type)) {
                if ("size".equals(methodName)) {
                    eval = new ContainerSizeMethod();
                }
                if ("isEmpty".equals(methodName)) {
                    eval = new ContainerIsEmptyMethod();
                }
                if ("contains".equals(methodName)) {
                    eval = new CollectionContainsMethod();
                }
                if ("get".equals(methodName)) {
                    eval = new ListGetMethod();
                }
                if ("indexOf".equals(methodName)) {
                    eval = new ListIndexOfMethod();
                }
            } else if (Map.class.isAssignableFrom(type)) {
                if ("size".equals(methodName)) {
                    eval = new ContainerSizeMethod();
                }
                if ("isEmpty".equals(methodName)) {
                    eval = new ContainerIsEmptyMethod();
                }
                if ("containsKey".equals(methodName)) {
                    eval = new MapContainsKeyMethod();
                }
                if ("containsValue".equals(methodName)) {
                    eval = new MapContainsValueMethod();
                }
                if ("containsEntry".equals(methodName)) {
                    eval = new MapContainsEntryMethod();
                }
                if ("get".equals(methodName)) {
                    eval = new MapGetMethod();
                }
            } else if (Optional.class.isAssignableFrom(type)) {
                if ("isPresent".equals(methodName)) {
                    eval = new OptionalIsPresentMethod();
                }
                if ("get".equals(methodName)) {
                    eval = new OptionalGetMethod();
                }
                if ("orElse".equals(methodName)) {
                    eval = new OptionalOrElseMethod();
                }
            } else if (Date.class.isAssignableFrom(type)) {
                if ("getTime".equals(methodName)) {
                    eval = new DateGetTimeMethod();
                }
                if ("getDay".equals(methodName)) {
                    eval = new DateGetDayMethod();
                }
                if ("getDate".equals(methodName)) {
                    eval = new DateGetDayMethod();
                }
                if ("getDayOfWeek".equals(methodName)) {
                    eval = new DateGetDayOfWeekMethod();
                }
                if ("getMonth".equals(methodName)) {
                    eval = new DateGetMonthMethod();
                }
                if ("getYear".equals(methodName)) {
                    eval = new DateGetYearMethod();
                }
                if ("getHour".equals(methodName)) {
                    eval = new DateGetHoursMethod();
                }
                if ("getMinute".equals(methodName)) {
                    eval = new DateGetMinutesMethod();
                }
                if ("getSecond".equals(methodName)) {
                    eval = new DateGetSecondsMethod();
                }
            } else if (LocalDate.class.isAssignableFrom(type)) {
                if ("getDayOfMonth".equals(methodName)) {
                    eval = new LocalDateGetDayOfMonth();
                }
                if ("getDayOfWeek".equals(methodName)) {
                    eval = new LocalDateGetDayOfWeek();
                }
                if ("getMonthValue".equals(methodName)) {
                    eval = new LocalDateGetMonthValue();
                }
                if ("getYear".equals(methodName)) {
                    eval = new LocalDateGetYear();
                }
            } else if (LocalTime.class.isAssignableFrom(type)) {
                if ("getHour".equals(methodName)) {
                    eval = new LocalTimeGetHour();
                }
                if ("getMinute".equals(methodName)) {
                    eval = new LocalTimeGetMinute();
                }
                if ("getSecond".equals(methodName)) {
                    eval = new LocalTimeGetSecond();
                }
            } else if (LocalDateTime.class.isAssignableFrom(type)) {
                if ("getDayOfMonth".equals(methodName)) {
                    eval = new LocalDateTimeGetDayOfMonth();
                }
                if ("getDayOfWeek".equals(methodName)) {
                    eval = new LocalDateTimeGetDayOfWeek();
                }
                if ("getMonthValue".equals(methodName)) {
                    eval = new LocalDateTimeGetMonthValue();
                }
                if ("getYear".equals(methodName)) {
                    eval = new LocalDateTimeGetYear();
                }
                if ("getHour".equals(methodName)) {
                    eval = new LocalDateTimeGetHour();
                }
                if ("getMinute".equals(methodName)) {
                    eval = new LocalDateTimeGetMinute();
                }
                if ("getSecond".equals(methodName)) {
                    eval = new LocalDateTimeGetSecond();
                }
            } else if (MonthDay.class.isAssignableFrom(type)) {
                if ("getDayOfMonth".equals(methodName)) {
                    eval = new MonthDayGetDayOfMonth();
                }
                if ("getMonthValue".equals(methodName)) {
                    eval = new MonthDayGetMonthValue();
                }
            } else if (Period.class.isAssignableFrom(type)) {
                if ("getDays".equals(methodName)) {
                    eval = new PeriodGetDays();
                }
                if ("getMonths".equals(methodName)) {
                    eval = new PeriodGetMonths();
                }
                if ("getYears".equals(methodName)) {
                    eval = new PeriodGetYears();
                }
            } else if (YearMonth.class.isAssignableFrom(type)) {
                if ("getYear".equals(methodName)) {
                    eval = new YearMonthGetYear();
                }
                if ("getMonthValue".equals(methodName)) {
                    eval = new YearMonthGetMonthValue();
                }
            }
            if (eval == null && Object.class.isAssignableFrom(type) && "getClass".equals(methodName)) {
                eval = new ObjectGetClassMethod();
            }
            if (eval != null) {
                this.inmemoryQueryMethodEvaluatorByName.put((String)lookupName, eval);
                return eval;
            }
        }
        if ((elems = (pluginMgr = this.nucleusCtx.getPluginManager()).getConfigurationElementsForExtension("org.datanucleus.query_method_evaluators", "method", methodName)) == null) {
            return null;
        }
        InvocationEvaluator requiredEvaluator = null;
        for (int i = 0; i < elems.length; ++i) {
            try {
                String evalName = elems[i].getAttribute("evaluator");
                eval = (InvocationEvaluator)pluginMgr.createExecutableExtension("org.datanucleus.query_method_evaluators", new String[]{"method", "evaluator"}, new String[]{methodName, evalName}, "evaluator", null, null);
                String elemClsName = elems[i].getAttribute("class");
                if (elemClsName != null && StringUtils.isWhitespace(elemClsName)) {
                    elemClsName = null;
                }
                if (elemClsName == null) {
                    if (type == null) {
                        requiredEvaluator = eval;
                    }
                    this.inmemoryQueryMethodEvaluatorByName.put((String)lookupName, eval);
                    continue;
                }
                Class elemCls = clr.classForName(elemClsName);
                if (elemCls.isAssignableFrom(type)) {
                    requiredEvaluator = eval;
                }
                this.inmemoryQueryMethodEvaluatorByName.put((String)lookupName, eval);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return requiredEvaluator;
    }
}

