/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import org.datanucleus.store.types.converters.TypeConverter;

public class LocalTimeDateConverter
implements TypeConverter<LocalTime, Date> {
    private static final long serialVersionUID = -2093237215554953399L;

    @Override
    public LocalTime toMemberType(Date date) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault()).toLocalTime();
    }

    @Override
    public Date toDatastoreType(LocalTime time) {
        if (time == null) {
            return null;
        }
        return Date.from(time.atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant());
    }
}

