/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.nio.ByteBuffer;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.TypeConversionHelper;

public class CharArrayByteBufferConverter
implements TypeConverter<char[], ByteBuffer> {
    private static final long serialVersionUID = 2306306360514101678L;

    @Override
    public ByteBuffer toDatastoreType(char[] memberValue) {
        if (memberValue == null) {
            return null;
        }
        byte[] bytes = TypeConversionHelper.getByteArrayFromCharArray(memberValue);
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public char[] toMemberType(ByteBuffer datastoreValue) {
        if (datastoreValue == null) {
            return null;
        }
        return TypeConversionHelper.getCharArrayFromByteArray(datastoreValue.array());
    }
}

