/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.nio.ByteBuffer;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.TypeConversionHelper;

public class FloatArrayByteBufferConverter
implements TypeConverter<float[], ByteBuffer> {
    private static final long serialVersionUID = -8328547369768394603L;

    @Override
    public ByteBuffer toDatastoreType(float[] memberValue) {
        if (memberValue == null) {
            return null;
        }
        byte[] bytes = TypeConversionHelper.getByteArrayFromFloatArray(memberValue);
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public float[] toMemberType(ByteBuffer datastoreValue) {
        if (datastoreValue == null) {
            return null;
        }
        return TypeConversionHelper.getFloatArrayFromByteArray(datastoreValue.array());
    }
}

