/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.expression;

import org.datanucleus.query.compiler.PropertySymbol;
import org.datanucleus.query.compiler.Symbol;
import org.datanucleus.query.compiler.SymbolTable;
import org.datanucleus.query.expression.Expression;

public class ParameterExpression
extends Expression {
    private static final long serialVersionUID = -2170413163550042263L;
    private String name;
    private int position;
    private Class type;

    public ParameterExpression(String name, int position) {
        this.name = name;
        this.position = position;
    }

    public ParameterExpression(String name, Class type) {
        this.name = name;
        this.type = type;
        this.position = -1;
    }

    public String getId() {
        return this.name;
    }

    public int getPosition() {
        return this.position;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public Class getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Symbol bind(SymbolTable symtbl) {
        if (symtbl.hasSymbol(this.getId())) {
            this.symbol = symtbl.getSymbol(this.getId());
        } else {
            this.symbol = new PropertySymbol(this.getId());
            this.symbol.setType(1);
            if (this.type != null) {
                this.symbol.setValueType(this.type);
            }
            symtbl.addSymbol(this.symbol);
        }
        return this.symbol;
    }

    public String toString() {
        return "ParameterExpression{" + this.name + "}";
    }
}

