/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.cache.CacheUniqueKey;
import org.datanucleus.cache.CachedPC;

public interface Level2Cache
extends Serializable {
    public void close();

    public void evict(Object var1);

    public void evictAll();

    public void evictAll(Object[] var1);

    public void evictAll(Collection var1);

    public void evictAll(Class var1, boolean var2);

    default public int getSize() {
        return 0;
    }

    public <T> CachedPC<T> get(Object var1);

    default public Map<Object, CachedPC> getAll(Collection oids) {
        if (oids == null) {
            return null;
        }
        HashMap<Object, CachedPC> objs = new HashMap<Object, CachedPC>();
        for (Object id : oids) {
            CachedPC value = this.get(id);
            objs.put(id, value);
        }
        return objs;
    }

    public <T> CachedPC<T> put(Object var1, CachedPC<T> var2);

    default public void putAll(Map<Object, CachedPC> objs) {
        if (objs == null) {
            return;
        }
        for (Map.Entry<Object, CachedPC> entry : objs.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    default public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public boolean containsOid(Object var1);

    default public CachedPC getUnique(CacheUniqueKey key) {
        return null;
    }

    default public CachedPC putUnique(CacheUniqueKey key, CachedPC pc) {
        return null;
    }

    default public void putUniqueAll(Map<CacheUniqueKey, CachedPC> objs) {
        if (objs == null) {
            return;
        }
        for (Map.Entry<CacheUniqueKey, CachedPC> entry : objs.entrySet()) {
            this.putUnique(entry.getKey(), entry.getValue());
        }
    }

    default public void removeUnique(CacheUniqueKey key) {
    }

    default public void pin(Object oid) {
    }

    default public void pinAll(Collection oids) {
    }

    default public void pinAll(Object[] oids) {
    }

    default public void pinAll(Class pcClass, boolean subclasses) {
    }

    default public void unpin(Object oid) {
    }

    default public void unpinAll(Collection oids) {
    }

    default public void unpinAll(Object[] oids) {
    }

    default public void unpinAll(Class pcClass, boolean subclasses) {
    }

    default public int getNumberOfPinnedObjects() {
        return 0;
    }

    default public int getNumberOfUnpinnedObjects() {
        return 0;
    }
}

