/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.cache;

import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.store.query.cache.QueryResultsCache;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractQueryResultsCache
implements QueryResultsCache {
    private static final long serialVersionUID = 5815194081248492071L;
    protected NucleusContext nucleusCtx;
    protected int maxSize = -1;
    protected boolean clearAtClose = true;
    protected long expiryMillis = -1L;
    protected String cacheName;

    public AbstractQueryResultsCache(NucleusContext nucleusCtx) {
        this.nucleusCtx = nucleusCtx;
        Configuration conf = nucleusCtx.getConfiguration();
        this.maxSize = conf.getIntProperty("datanucleus.cache.queryResults.maxSize");
        this.clearAtClose = conf.getBooleanProperty("datanucleus.cache.queryResults.clearAtClose", true);
        if (conf.hasProperty("datanucleus.cache.queryResults.expiryMillis")) {
            this.expiryMillis = conf.getIntProperty("datanucleus.cache.queryResults.expiryMillis");
        }
        this.cacheName = conf.getStringProperty("datanucleus.cache.queryResults.cacheName");
        if (this.cacheName == null) {
            NucleusLogger.CACHE.warn("No property datanucleus.cache.queryResults.cacheName specified so using name of 'DataNucleus-Query'");
            this.cacheName = "DataNucleus-Query";
        }
    }
}

