/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NoExtentException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.flush.FlushNonReferential;
import org.datanucleus.flush.FlushProcess;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.metadata.ValueGenerationStrategy;
import org.datanucleus.properties.PropertyStore;
import org.datanucleus.state.StateManagerImpl;
import org.datanucleus.store.ConnectionEncryptionProvider;
import org.datanucleus.store.DefaultCandidateExtent;
import org.datanucleus.store.Extent;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.NucleusConnectionImpl;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreDataManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.autostart.AutoStartMechanism;
import org.datanucleus.store.connection.ConnectionManager;
import org.datanucleus.store.connection.ConnectionManagerImpl;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.query.QueryManagerImpl;
import org.datanucleus.store.schema.DefaultStoreSchemaHandler;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.store.schema.naming.DN2NamingFactory;
import org.datanucleus.store.schema.naming.JPANamingFactory;
import org.datanucleus.store.schema.naming.NamingCase;
import org.datanucleus.store.schema.naming.NamingFactory;
import org.datanucleus.store.valuegenerator.AbstractConnectedGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationConnectionProvider;
import org.datanucleus.store.valuegenerator.ValueGenerationManager;
import org.datanucleus.store.valuegenerator.ValueGenerationManagerImpl;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.TypeConversionHelper;

public abstract class AbstractStoreManager
extends PropertyStore
implements StoreManager {
    protected final String storeManagerKey;
    protected PersistenceNucleusContext nucleusContext;
    protected ValueGenerationManager valueGenerationMgr = new ValueGenerationManagerImpl(this);
    protected StoreDataManager storeDataMgr = new StoreDataManager();
    protected StorePersistenceHandler persistenceHandler = null;
    protected FlushProcess flushProcess = null;
    protected QueryManager queryMgr = null;
    protected StoreSchemaHandler schemaHandler = null;
    protected NamingFactory namingFactory = null;
    protected ConnectionManager connectionMgr;

    protected AbstractStoreManager(String key, ClassLoaderResolver clr, PersistenceNucleusContext nucleusContext, Map<String, Object> props) {
        this.storeManagerKey = key;
        this.nucleusContext = nucleusContext;
        if (props != null) {
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                this.setPropertyInternal(entry.getKey(), entry.getValue());
            }
        }
        this.registerConnectionMgr();
        nucleusContext.addExecutionContextListener(new ExecutionContext.LifecycleListener(){

            @Override
            public void preClose(ExecutionContext ec) {
                AbstractStoreManager.this.connectionMgr.closeAllConnections(ec);
            }
        });
    }

    protected void registerConnectionMgr() {
        this.connectionMgr = new ConnectionManagerImpl(this);
    }

    @Override
    public synchronized void close() {
        this.connectionMgr.close();
        this.connectionMgr = null;
        this.valueGenerationMgr.clear();
        this.valueGenerationMgr = null;
        this.storeDataMgr.clear();
        this.storeDataMgr = null;
        if (this.persistenceHandler != null) {
            this.persistenceHandler.close();
            this.persistenceHandler = null;
        }
        if (this.schemaHandler != null) {
            this.schemaHandler = null;
        }
        if (this.queryMgr != null) {
            this.queryMgr.close();
            this.queryMgr = null;
        }
        this.nucleusContext = null;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionMgr;
    }

    @Override
    public String getConnectionPassword() {
        String decrypterName;
        String password = this.getStringProperty("datanucleus.ConnectionPassword");
        if (password != null && (decrypterName = this.getStringProperty("datanucleus.ConnectionPasswordDecrypter")) != null) {
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
            try {
                Class decrypterCls = clr.classForName(decrypterName);
                ConnectionEncryptionProvider decrypter = (ConnectionEncryptionProvider)decrypterCls.newInstance();
                password = decrypter.decrypt(password);
            }
            catch (Exception e) {
                NucleusLogger.DATASTORE.warn("Error invoking decrypter class " + decrypterName, e);
            }
        }
        return password;
    }

    @Override
    public boolean isJdbcStore() {
        return false;
    }

    @Override
    public StorePersistenceHandler getPersistenceHandler() {
        return this.persistenceHandler;
    }

    @Override
    public FlushProcess getFlushProcess() {
        if (this.flushProcess == null) {
            this.flushProcess = new FlushNonReferential();
        }
        return this.flushProcess;
    }

    @Override
    public QueryManager getQueryManager() {
        if (this.queryMgr == null) {
            this.queryMgr = new QueryManagerImpl(this.nucleusContext, this);
        }
        return this.queryMgr;
    }

    @Override
    public StoreSchemaHandler getSchemaHandler() {
        if (this.schemaHandler == null) {
            this.schemaHandler = new DefaultStoreSchemaHandler(this);
        }
        return this.schemaHandler;
    }

    @Override
    public NamingFactory getNamingFactory() {
        if (this.namingFactory == null) {
            String namingFactoryName = this.getStringProperty("datanucleus.identifier.namingFactory");
            if ("datanucleus2".equalsIgnoreCase(namingFactoryName)) {
                this.namingFactory = new DN2NamingFactory(this.nucleusContext);
            } else if ("jpa".equalsIgnoreCase(namingFactoryName)) {
                this.namingFactory = new JPANamingFactory(this.nucleusContext);
            } else {
                String namingFactoryClassName = this.nucleusContext.getPluginManager().getAttributeValueForExtension("org.datanucleus.identifier_namingfactory", "name", namingFactoryName, "class-name");
                if (namingFactoryClassName == null) {
                    throw new NucleusUserException("Error in specified NamingFactory " + namingFactoryName + " not found");
                }
                try {
                    Class[] argTypes = new Class[]{ClassConstants.NUCLEUS_CONTEXT};
                    Object[] args = new Object[]{this.nucleusContext};
                    this.namingFactory = (NamingFactory)this.nucleusContext.getPluginManager().createExecutableExtension("org.datanucleus.identifier_namingfactory", "name", namingFactoryName, "class-name", argTypes, args);
                }
                catch (Throwable thr) {
                    throw new NucleusUserException("Exception creating NamingFactory for datastore : " + thr.getMessage(), thr);
                }
            }
            String identifierCase = this.getStringProperty("datanucleus.identifier.case");
            if (identifierCase != null) {
                if (identifierCase.equalsIgnoreCase("lowercase")) {
                    this.namingFactory.setNamingCase(NamingCase.LOWER_CASE);
                } else if (identifierCase.equalsIgnoreCase("UPPERCASE")) {
                    this.namingFactory.setNamingCase(NamingCase.UPPER_CASE);
                } else {
                    this.namingFactory.setNamingCase(NamingCase.MIXED_CASE);
                }
            }
        }
        return this.namingFactory;
    }

    @Override
    public NucleusConnection getNucleusConnection(final ExecutionContext ec) {
        final ManagedConnection mc = this.connectionMgr.getConnection(ec.getTransaction().isActive(), ec, ec.getTransaction());
        mc.lock();
        Runnable closeRunnable = new Runnable(){

            @Override
            public void run() {
                mc.unlock();
                if (!ec.getTransaction().isActive()) {
                    mc.release();
                }
            }
        };
        return new NucleusConnectionImpl(mc.getConnection(), closeRunnable);
    }

    @Override
    public ValueGenerationManager getValueGenerationManager() {
        return this.valueGenerationMgr;
    }

    @Override
    public ApiAdapter getApiAdapter() {
        return this.nucleusContext.getApiAdapter();
    }

    @Override
    public String getStoreManagerKey() {
        return this.storeManagerKey;
    }

    @Override
    public PersistenceNucleusContext getNucleusContext() {
        return this.nucleusContext;
    }

    @Override
    public MetaDataManager getMetaDataManager() {
        return this.nucleusContext.getMetaDataManager();
    }

    @Override
    public StoreData getStoreDataForClass(String className) {
        return this.storeDataMgr.get(className);
    }

    protected void registerStoreData(StoreData data) {
        this.storeDataMgr.registerStoreData(data);
        if (this.nucleusContext.getAutoStartMechanism() != null) {
            this.nucleusContext.getAutoStartMechanism().addClass(data);
        }
    }

    protected void deregisterAllStoreData() {
        this.storeDataMgr.clear();
        AutoStartMechanism starter = this.nucleusContext.getAutoStartMechanism();
        if (starter != null) {
            try {
                if (!starter.isOpen()) {
                    starter.open();
                }
                starter.deleteAllClasses();
            }
            finally {
                if (starter.isOpen()) {
                    starter.close();
                }
            }
        }
    }

    protected void logConfiguration() {
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            NucleusLogger.DATASTORE.debug("======================= Datastore =========================");
            NucleusLogger.DATASTORE.debug("StoreManager : \"" + this.storeManagerKey + "\" (" + this.getClass().getName() + ")");
            NucleusLogger.DATASTORE.debug("Datastore : " + (this.getBooleanProperty("datanucleus.readOnlyDatastore") ? "read-only" : "read-write") + (this.getBooleanProperty("datanucleus.SerializeRead") ? ", useLocking" : ""));
            StringBuilder autoCreateOptions = null;
            if (this.getSchemaHandler().isAutoCreateTables() || this.getSchemaHandler().isAutoCreateColumns() || this.getSchemaHandler().isAutoCreateConstraints()) {
                autoCreateOptions = new StringBuilder();
                boolean first = true;
                if (this.getSchemaHandler().isAutoCreateTables()) {
                    if (!first) {
                        autoCreateOptions.append(",");
                    }
                    autoCreateOptions.append("Tables");
                    first = false;
                }
                if (this.getSchemaHandler().isAutoCreateColumns()) {
                    if (!first) {
                        autoCreateOptions.append(",");
                    }
                    autoCreateOptions.append("Columns");
                    first = false;
                }
                if (this.getSchemaHandler().isAutoCreateConstraints()) {
                    if (!first) {
                        autoCreateOptions.append(",");
                    }
                    autoCreateOptions.append("Constraints");
                    first = false;
                }
            }
            StringBuilder validateOptions = null;
            if (this.getSchemaHandler().isValidateTables() || this.getSchemaHandler().isValidateColumns() || this.getSchemaHandler().isValidateConstraints()) {
                validateOptions = new StringBuilder();
                boolean first = true;
                if (this.getSchemaHandler().isValidateTables()) {
                    validateOptions.append("Tables");
                    first = false;
                }
                if (this.getSchemaHandler().isValidateColumns()) {
                    if (!first) {
                        validateOptions.append(",");
                    }
                    validateOptions.append("Columns");
                    first = false;
                }
                if (this.getSchemaHandler().isValidateConstraints()) {
                    if (!first) {
                        validateOptions.append(",");
                    }
                    validateOptions.append("Constraints");
                    first = false;
                }
            }
            NucleusLogger.DATASTORE.debug("Schema Control : AutoCreate(" + (autoCreateOptions != null ? autoCreateOptions.toString() : "None") + "), Validate(" + (validateOptions != null ? validateOptions.toString() : "None") + ")");
            String namingFactoryName = this.getStringProperty("datanucleus.identifier.namingFactory");
            String namingCase = this.getStringProperty("datanucleus.identifier.case");
            NucleusLogger.DATASTORE.debug("Schema : NamingFactory=" + namingFactoryName + " identifierCase=" + namingCase);
            NucleusLogger.DATASTORE.debug("Query Languages : " + StringUtils.collectionToString(this.getSupportedQueryLanguages()));
            NucleusLogger.DATASTORE.debug("Queries : Timeout=" + this.getIntProperty("datanucleus.datastoreReadTimeout"));
            NucleusLogger.DATASTORE.debug("===========================================================");
        }
    }

    @Override
    public void printInformation(String category, PrintStream ps) throws Exception {
        if (category.equalsIgnoreCase("DATASTORE")) {
            ps.println(Localiser.msg("032020", this.storeManagerKey, this.getConnectionURL(), this.getBooleanProperty("datanucleus.readOnlyDatastore") ? "read-only" : "read-write"));
        }
    }

    @Override
    public boolean managesClass(String className) {
        return this.storeDataMgr.managesClass(className);
    }

    @Override
    public void manageClasses(ClassLoaderResolver clr, String ... classNames) {
        if (classNames == null) {
            return;
        }
        String[] filteredClassNames = this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        for (AbstractClassMetaData cmd : this.getMetaDataManager().getReferencedClasses(filteredClassNames, clr)) {
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || this.storeDataMgr.managesClass(cmd.getFullClassName())) continue;
            this.registerStoreData(this.newStoreData((ClassMetaData)cmd, clr));
        }
    }

    protected StoreData newStoreData(ClassMetaData cmd, ClassLoaderResolver clr) {
        return new StoreData(cmd.getFullClassName(), cmd, StoreData.Type.FCO, null);
    }

    @Override
    public void unmanageAllClasses(ClassLoaderResolver clr) {
    }

    @Override
    public void unmanageClass(ClassLoaderResolver clr, String className, boolean removeFromDatastore) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
        if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            if (removeFromDatastore) {
                // empty if block
            }
            this.storeDataMgr.deregisterClass(className);
        }
    }

    @Override
    public String manageClassForIdentity(Object id, ClassLoaderResolver clr) {
        if (this.nucleusContext.getTypeManager().isSupportedSecondClassType(id.getClass().getName())) {
            return null;
        }
        String className = IdentityUtils.getTargetClassNameForIdentity(id);
        if (className == null) {
            return null;
        }
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
        if (IdentityUtils.isDatastoreIdentity(id) && cmd.getIdentityType() != IdentityType.DATASTORE) {
            throw new NucleusUserException(Localiser.msg("038001", id, cmd.getFullClassName()));
        }
        if (IdentityUtils.isSingleFieldIdentity(id) && (cmd.getIdentityType() != IdentityType.APPLICATION || !cmd.getObjectidClass().equals(id.getClass().getName()))) {
            throw new NucleusUserException(Localiser.msg("038001", id, cmd.getFullClassName()));
        }
        if (!this.managesClass(className)) {
            this.manageClasses(clr, className);
        }
        return className;
    }

    @Override
    public <T> Extent<T> getExtent(ExecutionContext ec, Class<T> c, boolean subclasses) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(c, ec.getClassLoaderResolver());
        if (!cmd.isRequiresExtent()) {
            throw new NoExtentException(c.getName());
        }
        if (!this.managesClass(c.getName())) {
            this.manageClasses(ec.getClassLoaderResolver(), c.getName());
        }
        return new DefaultCandidateExtent<T>(ec, c, subclasses, cmd);
    }

    @Override
    public Collection<String> getSupportedQueryLanguages() {
        HashSet<String> languages = new HashSet<String>();
        languages.add("JDOQL");
        languages.add("JPQL");
        return languages;
    }

    @Override
    public boolean supportsQueryLanguage(String language) {
        return language != null && (language.equalsIgnoreCase("JDOQL") || language.equalsIgnoreCase("JPQL"));
    }

    @Override
    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        if (id == null) {
            return null;
        }
        if (id instanceof SCOID) {
            return ((SCOID)id).getSCOClass();
        }
        String className = IdentityUtils.getTargetClassNameForIdentity(id);
        if (className != null) {
            return className;
        }
        Collection<AbstractClassMetaData> cmds = this.getMetaDataManager().getClassMetaDataWithApplicationId(id.getClass().getName());
        if (cmds != null && !cmds.isEmpty()) {
            return cmds.iterator().next().getFullClassName();
        }
        return null;
    }

    @Override
    public boolean supportsValueGenerationStrategy(String strategy) {
        return this.valueGenerationMgr.supportsStrategy(strategy);
    }

    @Override
    public boolean isValueGenerationStrategyDatastoreAttributed(AbstractClassMetaData cmd, int absFieldNumber) {
        if (absFieldNumber < 0) {
            if (cmd.isEmbeddedOnly()) {
                return false;
            }
            IdentityMetaData idmd = cmd.getBaseIdentityMetaData();
            if (idmd == null) {
                String strategy = this.getValueGenerationStrategyForNative(cmd, absFieldNumber);
                if (strategy.equalsIgnoreCase(ValueGenerationStrategy.IDENTITY.toString())) {
                    return true;
                }
            } else {
                String strategy;
                ValueGenerationStrategy idStrategy = idmd.getValueStrategy();
                if (idStrategy == ValueGenerationStrategy.IDENTITY) {
                    return true;
                }
                if (idStrategy == ValueGenerationStrategy.NATIVE && (strategy = this.getValueGenerationStrategyForNative(cmd, absFieldNumber)).equalsIgnoreCase(ValueGenerationStrategy.IDENTITY.toString())) {
                    return true;
                }
            }
        } else {
            String strategy;
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absFieldNumber);
            if (mmd.getValueStrategy() == null) {
                return false;
            }
            if (mmd.getValueStrategy() == ValueGenerationStrategy.IDENTITY) {
                return true;
            }
            if (mmd.getValueStrategy() == ValueGenerationStrategy.NATIVE && (strategy = this.getValueGenerationStrategyForNative(cmd, absFieldNumber)).equalsIgnoreCase(ValueGenerationStrategy.IDENTITY.toString())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueGenerationStrategyValue(ExecutionContext ec, AbstractClassMetaData cmd, int absoluteFieldNumber) {
        ValueGenerator generator = this.getValueGeneratorForMember(ec.getClassLoaderResolver(), cmd, absoluteFieldNumber);
        Object oid = this.getNextValueForValueGenerator(generator, ec);
        AbstractMemberMetaData mmd = null;
        String fieldName = null;
        ValueGenerationStrategy strategy = null;
        if (absoluteFieldNumber >= 0) {
            mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
            fieldName = mmd.getFullFieldName();
            strategy = mmd.getValueStrategy();
        } else {
            fieldName = cmd.getFullClassName() + " (datastore id)";
            strategy = cmd.getIdentityMetaData().getValueStrategy();
        }
        if (mmd != null) {
            try {
                Object convertedValue = TypeConversionHelper.convertTo(oid, mmd.getType());
                if (convertedValue == null) {
                    throw new NucleusException(Localiser.msg("038003", mmd.getFullFieldName(), oid)).setFatal();
                }
                oid = convertedValue;
            }
            catch (NumberFormatException nfe) {
                throw new NucleusUserException("Value strategy created value=" + oid + " type=" + oid.getClass().getName() + " but field is of type " + mmd.getTypeName() + ". Use a different strategy or change the type of the field " + mmd.getFullFieldName());
            }
        }
        if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
            NucleusLogger.VALUEGENERATION.debug(Localiser.msg("038002", fieldName, strategy, generator.getClass().getName(), oid));
        }
        return oid;
    }

    protected synchronized ValueGenerator getValueGeneratorForMember(ClassLoaderResolver clr, AbstractClassMetaData cmd, int absoluteFieldNumber) {
        String memberKey = this.valueGenerationMgr.getMemberKey(cmd, absoluteFieldNumber);
        ValueGenerator generator = this.valueGenerationMgr.getValueGeneratorForMemberKey(memberKey);
        if (generator != null) {
            return generator;
        }
        String fieldName = null;
        ValueGenerationStrategy strategy = null;
        String sequence = null;
        String valueGeneratorName = null;
        if (absoluteFieldNumber >= 0) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
            fieldName = mmd.getFullFieldName();
            strategy = mmd.getValueStrategy();
            sequence = mmd.getSequence();
            valueGeneratorName = mmd.getValueGeneratorName();
        } else {
            fieldName = cmd.getFullClassName() + " (datastore id)";
            strategy = cmd.getIdentityMetaData().getValueStrategy();
            sequence = cmd.getIdentityMetaData().getSequence();
            valueGeneratorName = cmd.getIdentityMetaData().getValueGeneratorName();
        }
        String strategyName = strategy.toString();
        if (strategy.equals(ValueGenerationStrategy.CUSTOM)) {
            strategyName = strategy.getCustomName();
        } else if (strategy.equals(ValueGenerationStrategy.NATIVE)) {
            strategyName = this.getValueGenerationStrategyForNative(cmd, absoluteFieldNumber);
            strategy = ValueGenerationStrategy.getIdentityStrategy(strategyName);
        }
        generator = this.valueGenerationMgr.getUniqueValueGeneratorByName(strategyName);
        if (generator != null) {
            this.valueGenerationMgr.registerValueGeneratorForMemberKey(memberKey, generator);
            return generator;
        }
        if (!strategy.toString().equalsIgnoreCase("custom") && !this.supportsValueGenerationStrategy(strategy.toString())) {
            throw new NucleusUserException("Attempt to use strategy=" + strategy.toString() + " but this is not supported for this datastore");
        }
        TableGeneratorMetaData tableGeneratorMetaData = null;
        SequenceMetaData sequenceMetaData = null;
        if (valueGeneratorName != null) {
            if (strategy == ValueGenerationStrategy.INCREMENT) {
                tableGeneratorMetaData = this.getMetaDataManager().getMetaDataForTableGenerator(clr, valueGeneratorName);
                if (tableGeneratorMetaData == null) {
                    throw new NucleusUserException(Localiser.msg("038005", fieldName, valueGeneratorName));
                }
            } else if (strategy == ValueGenerationStrategy.SEQUENCE && (sequenceMetaData = this.getMetaDataManager().getMetaDataForSequence(clr, valueGeneratorName)) == null) {
                throw new NucleusUserException(Localiser.msg("038006", fieldName, valueGeneratorName));
            }
        } else if (strategy == ValueGenerationStrategy.SEQUENCE && sequence != null && (sequenceMetaData = this.getMetaDataManager().getMetaDataForSequence(clr, sequence)) == null) {
            NucleusLogger.VALUEGENERATION.info("Member " + fieldName + " has been specified to use sequence '" + sequence + "' but there is no <sequence> specified in the MetaData. Falling back to use a sequence in the datastore with this name directly.");
        }
        Properties props = this.getPropertiesForValueGenerator(cmd, absoluteFieldNumber, clr, sequenceMetaData, tableGeneratorMetaData);
        return this.valueGenerationMgr.createAndRegisterValueGenerator(memberKey, strategyName, props);
    }

    @Override
    public String getValueGenerationStrategyForNative(AbstractClassMetaData cmd, int absFieldNumber) {
        if (absFieldNumber >= 0) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absFieldNumber);
            Class type = mmd.getType();
            if (String.class.isAssignableFrom(type)) {
                return ValueGenerationStrategy.UUIDHEX.toString();
            }
            if (type == Long.class || type == Integer.class || type == Short.class || type == Long.TYPE || type == Integer.TYPE || type == Short.TYPE || type == BigInteger.class) {
                if (this.supportsValueGenerationStrategy(ValueGenerationStrategy.IDENTITY.toString())) {
                    return ValueGenerationStrategy.IDENTITY.toString();
                }
                if (this.supportsValueGenerationStrategy(ValueGenerationStrategy.SEQUENCE.toString()) && mmd.getSequence() != null) {
                    return ValueGenerationStrategy.SEQUENCE.toString();
                }
                if (this.supportsValueGenerationStrategy(ValueGenerationStrategy.INCREMENT.toString())) {
                    return ValueGenerationStrategy.INCREMENT.toString();
                }
                throw new NucleusUserException("This datastore provider doesn't support numeric native strategy for member " + mmd.getFullFieldName());
            }
            throw new NucleusUserException("This datastore provider doesn't support native strategy for field of type " + type.getName());
        }
        IdentityMetaData idmd = cmd.getBaseIdentityMetaData();
        if (idmd != null && idmd.getColumnMetaData() != null && MetaDataUtils.isJdbcTypeString(idmd.getColumnMetaData().getJdbcType())) {
            return ValueGenerationStrategy.UUIDHEX.toString();
        }
        if (this.supportsValueGenerationStrategy(ValueGenerationStrategy.IDENTITY.toString())) {
            return ValueGenerationStrategy.IDENTITY.toString();
        }
        if (this.supportsValueGenerationStrategy(ValueGenerationStrategy.SEQUENCE.toString()) && idmd != null && idmd.getSequence() != null) {
            return ValueGenerationStrategy.SEQUENCE.toString();
        }
        if (this.supportsValueGenerationStrategy(ValueGenerationStrategy.INCREMENT.toString())) {
            return ValueGenerationStrategy.INCREMENT.toString();
        }
        throw new NucleusUserException("This datastore provider doesn't support numeric native strategy for class " + cmd.getFullClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getNextValueForValueGenerator(ValueGenerator generator, final ExecutionContext ec) {
        Object oid = null;
        ValueGenerator valueGenerator = generator;
        synchronized (valueGenerator) {
            if (generator instanceof AbstractConnectedGenerator) {
                ValueGenerationConnectionProvider connProvider = new ValueGenerationConnectionProvider(){
                    ManagedConnection mconn;

                    @Override
                    public ManagedConnection retrieveConnection() {
                        this.mconn = AbstractStoreManager.this.connectionMgr.getConnection(ec);
                        return this.mconn;
                    }

                    @Override
                    public void releaseConnection() {
                        this.mconn.release();
                        this.mconn = null;
                    }
                };
                ((AbstractConnectedGenerator)generator).setConnectionProvider(connProvider);
            }
            oid = generator.next();
        }
        return oid;
    }

    protected Properties getPropertiesForValueGenerator(AbstractClassMetaData cmd, int absoluteFieldNumber, ClassLoaderResolver clr, SequenceMetaData seqmd, TableGeneratorMetaData tablegenmd) {
        Properties properties = new Properties();
        AbstractMemberMetaData mmd = null;
        ValueGenerationStrategy strategy = null;
        String sequence = null;
        Map<String, String> extensions = null;
        if (absoluteFieldNumber >= 0) {
            mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
            strategy = mmd.getValueStrategy();
            sequence = mmd.getSequence();
            extensions = mmd.getExtensions();
        } else {
            IdentityMetaData idmd = cmd.getBaseIdentityMetaData();
            strategy = idmd.getValueStrategy();
            sequence = idmd.getSequence();
            extensions = idmd.getExtensions();
        }
        properties.setProperty("class-name", cmd.getFullClassName());
        properties.put("root-class-name", cmd.getBaseAbstractClassMetaData().getFullClassName());
        if (mmd != null) {
            properties.setProperty("field-name", mmd.getFullFieldName());
        }
        if (sequence != null) {
            properties.setProperty("sequence-name", sequence);
        }
        if (extensions != null) {
            properties.putAll(extensions);
        }
        if (strategy.equals(ValueGenerationStrategy.NATIVE)) {
            String realStrategyName = this.getValueGenerationStrategyForNative(cmd, absoluteFieldNumber);
            strategy = ValueGenerationStrategy.getIdentityStrategy(realStrategyName);
        }
        if (strategy == ValueGenerationStrategy.INCREMENT && tablegenmd != null) {
            properties.put("key-initial-value", "" + tablegenmd.getInitialValue());
            properties.put("key-cache-size", "" + tablegenmd.getAllocationSize());
            if (tablegenmd.getTableName() != null) {
                properties.put("sequence-table-name", tablegenmd.getTableName());
            }
            if (tablegenmd.getCatalogName() != null) {
                properties.put("sequence-catalog-name", tablegenmd.getCatalogName());
            }
            if (tablegenmd.getSchemaName() != null) {
                properties.put("sequence-schema-name", tablegenmd.getSchemaName());
            }
            if (tablegenmd.getPKColumnName() != null) {
                properties.put("sequence-name-column-name", tablegenmd.getPKColumnName());
            }
            if (tablegenmd.getPKColumnName() != null) {
                properties.put("sequence-nextval-column-name", tablegenmd.getValueColumnName());
            }
            if (tablegenmd.getPKColumnValue() != null) {
                properties.put("sequence-name", tablegenmd.getPKColumnValue());
            }
        } else if (strategy == ValueGenerationStrategy.INCREMENT && tablegenmd == null) {
            if (!properties.containsKey("key-cache-size")) {
                properties.put("key-cache-size", "" + this.getIntProperty("datanucleus.valuegeneration.increment.allocationSize"));
            }
        } else if (strategy == ValueGenerationStrategy.SEQUENCE && seqmd != null && seqmd.getDatastoreSequence() != null) {
            if (seqmd.getInitialValue() >= 0) {
                properties.put("key-initial-value", "" + seqmd.getInitialValue());
            }
            if (seqmd.getAllocationSize() > 0) {
                properties.put("key-cache-size", "" + seqmd.getAllocationSize());
            } else {
                properties.put("key-cache-size", "" + this.getIntProperty("datanucleus.valuegeneration.sequence.allocationSize"));
            }
            properties.put("sequence-name", "" + seqmd.getDatastoreSequence());
            Map<String, String> seqExtensions = seqmd.getExtensions();
            if (seqExtensions != null) {
                properties.putAll(seqExtensions);
            }
        }
        return properties;
    }

    @Override
    public Collection<String> getSubClassesForClass(String className, boolean includeDescendents, ClassLoaderResolver clr) {
        HashSet<String> subclasses = new HashSet<String>();
        String[] subclassNames = this.getMetaDataManager().getSubclassesForClass(className, includeDescendents);
        if (subclassNames != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                if (!this.storeDataMgr.managesClass(subclassNames[i])) {
                    this.manageClasses(clr, subclassNames[i]);
                }
                subclasses.add(subclassNames[i]);
            }
        }
        return subclasses;
    }

    @Override
    public Collection<String> getSupportedOptions() {
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean hasProperty(String name) {
        if (this.properties.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return true;
        }
        return this.nucleusContext.getConfiguration().hasProperty(name);
    }

    @Override
    public Object getProperty(String name) {
        if (this.properties.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return super.getProperty(name);
        }
        return this.nucleusContext.getConfiguration().getProperty(name);
    }

    @Override
    public int getIntProperty(String name) {
        if (this.properties.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return super.getIntProperty(name);
        }
        return this.nucleusContext.getConfiguration().getIntProperty(name);
    }

    @Override
    public String getStringProperty(String name) {
        if (this.properties.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return super.getStringProperty(name);
        }
        return this.nucleusContext.getConfiguration().getStringProperty(name);
    }

    @Override
    public boolean getBooleanProperty(String name) {
        if (this.properties.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return super.getBooleanProperty(name);
        }
        return this.nucleusContext.getConfiguration().getBooleanProperty(name);
    }

    @Override
    public boolean getBooleanProperty(String name, boolean resultIfNotSet) {
        if (this.properties.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return super.getBooleanProperty(name, resultIfNotSet);
        }
        return this.nucleusContext.getConfiguration().getBooleanProperty(name, resultIfNotSet);
    }

    @Override
    public Boolean getBooleanObjectProperty(String name) {
        if (this.properties.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return super.getBooleanObjectProperty(name);
        }
        return this.nucleusContext.getConfiguration().getBooleanObjectProperty(name);
    }

    @Override
    public boolean useBackedSCOWrapperForMember(AbstractMemberMetaData mmd, ExecutionContext ec) {
        return this.usesBackedSCOWrappers();
    }

    @Override
    public String getDefaultObjectProviderClassName() {
        return StateManagerImpl.class.getName();
    }
}

