/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.annotations.AnnotatedMember;
import org.datanucleus.metadata.annotations.AnnotationManager;
import org.datanucleus.metadata.annotations.AnnotationObject;
import org.datanucleus.metadata.annotations.AnnotationReader;
import org.datanucleus.metadata.annotations.ClassAnnotationHandler;
import org.datanucleus.metadata.annotations.Member;
import org.datanucleus.metadata.annotations.MemberAnnotationHandler;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractAnnotationReader
implements AnnotationReader {
    protected MetaDataManager mmgr;
    protected String[] supportedPackages;
    protected Set<String> supportedDuplicateAnnotations = new HashSet<String>();

    public AbstractAnnotationReader(MetaDataManager mgr) {
        this.mmgr = mgr;
    }

    @Override
    public boolean isPersistenceContext() {
        return this.mmgr.getNucleusContext() instanceof PersistenceNucleusContext;
    }

    @Override
    public String[] getSupportedAnnotationPackages() {
        return this.supportedPackages;
    }

    protected void setSupportedAnnotationPackages(String[] packages) {
        this.supportedPackages = packages;
    }

    protected void addSupportedDuplicateAnnotations(String annot) {
        this.supportedDuplicateAnnotations.add(annot);
    }

    protected boolean isSupportedAnnotation(String annotationClassName) {
        if (this.supportedPackages == null) {
            return false;
        }
        for (String supportedPackage : this.supportedPackages) {
            if (!annotationClassName.startsWith(supportedPackage)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AbstractClassMetaData getMetaDataForClass(Class cls, PackageMetaData pmd, ClassLoaderResolver clr) {
        AnnotationObject[] classAnnotations = this.getClassAnnotationsForClass(cls);
        if (classAnnotations == null || classAnnotations.length == 0) {
            return null;
        }
        AbstractClassMetaData cmd = this.processClassAnnotations(pmd, cls, classAnnotations, clr);
        if (cmd != null) {
            AnnotationManager annMgr = this.mmgr.getAnnotationManager();
            for (AnnotationObject annotationObject : classAnnotations) {
                String annName = annotationObject.getName();
                ClassAnnotationHandler handler = annMgr.getHandlerForClassAnnotation(annName);
                if (handler == null) continue;
                handler.processClassAnnotation(annotationObject, cmd, clr);
            }
            if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                Method[] methodArray;
                MemberAnnotationHandler handler;
                String annName;
                AbstractMemberMetaData mmd;
                AnnotationObject[] annotations;
                Collection<AnnotatedMember> annotatedFields = this.getFieldAnnotationsForClass(cls);
                Collection<AnnotatedMember> annotatedGetterMethods = this.getJavaBeanAccessorAnnotationsForClass(cls);
                block1: for (AnnotatedMember annotatedMember : annotatedFields) {
                    Iterator<AnnotatedMember> methodIter = annotatedGetterMethods.iterator();
                    while (methodIter.hasNext()) {
                        AnnotatedMember method = methodIter.next();
                        if (!annotatedMember.getName().equals(method.getName())) continue;
                        NucleusLogger.METADATA.info("Processable annotations specified on both field and getter for " + cls.getName() + "." + annotatedMember.getName() + " so using as FIELD");
                        annotatedMember.addAnnotations(method.getAnnotations());
                        methodIter.remove();
                        continue block1;
                    }
                }
                boolean propertyAccessor = false;
                if (cmd.getAccessViaField() != null) {
                    if (cmd.getAccessViaField() == Boolean.FALSE) {
                        propertyAccessor = true;
                    }
                } else {
                    for (AnnotatedMember method : annotatedGetterMethods) {
                        if (method.getAnnotations().length <= 0) continue;
                        propertyAccessor = true;
                    }
                }
                for (AnnotatedMember method : annotatedGetterMethods) {
                    annotations = method.getAnnotations();
                    if ((annotations == null || annotations.length == 0) && method.getMember().isProperty() && !propertyAccessor) continue;
                    mmd = this.processMemberAnnotations(cmd, method.getMember(), annotations);
                    if (annotations == null || annotations.length <= 0) continue;
                    for (AnnotationObject annotation : annotations) {
                        annName = annotation.getName();
                        handler = annMgr.getHandlerForMemberAnnotation(annName);
                        if (handler == null) continue;
                        if (mmd == null) {
                            mmd = new PropertyMetaData((MetaData)cmd, method.getMember().getName());
                            cmd.addMember(mmd);
                        }
                        handler.processMemberAnnotation(annotation, mmd, clr);
                    }
                }
                for (AnnotatedMember field : annotatedFields) {
                    annotations = field.getAnnotations();
                    if ((annotations == null || annotations.length == 0) && !field.getMember().isProperty() && propertyAccessor) continue;
                    mmd = this.processMemberAnnotations(cmd, field.getMember(), annotations);
                    if (annotations == null || annotations.length <= 0) continue;
                    for (AnnotationObject annotation : annotations) {
                        annName = annotation.getName();
                        handler = annMgr.getHandlerForMemberAnnotation(annName);
                        if (handler == null) continue;
                        if (mmd == null) {
                            mmd = new FieldMetaData((MetaData)cmd, field.getMember().getName());
                            cmd.addMember(mmd);
                        }
                        handler.processMemberAnnotation(annotation, mmd, clr);
                    }
                }
                for (Method method : methodArray = cls.getDeclaredMethods()) {
                    this.processMethodAnnotations(cmd, method);
                }
            }
        }
        return cmd;
    }

    protected abstract AbstractClassMetaData processClassAnnotations(PackageMetaData var1, Class var2, AnnotationObject[] var3, ClassLoaderResolver var4);

    protected abstract AbstractMemberMetaData processMemberAnnotations(AbstractClassMetaData var1, Member var2, AnnotationObject[] var3);

    protected abstract void processMethodAnnotations(AbstractClassMetaData var1, Method var2);

    protected AnnotationObject[] getClassAnnotationsForClass(Class cls) {
        Annotation[] annotations = cls.getAnnotations();
        HashSet<String> annotNames = new HashSet<String>();
        ArrayList<Annotation> supportedAnnots = new ArrayList<Annotation>();
        if (annotations != null && annotations.length > 0) {
            AnnotationManager annMgr = this.mmgr.getAnnotationManager();
            for (Annotation annotation : annotations) {
                Annotation[] subAnnotations;
                String annName = annotation.annotationType().getName();
                if (this.isSupportedAnnotation(annName) || annMgr.getClassAnnotationHasHandler(annName)) {
                    if (annotNames.contains(annName) && !this.supportedDuplicateAnnotations.contains(annName)) {
                        NucleusLogger.METADATA.warn("Annotation " + annName + " on class=" + cls.getName() + " is DUPLICATED : " + annotation + " - only the first will be used!");
                    }
                    supportedAnnots.add(annotation);
                    annotNames.add(annName);
                    continue;
                }
                for (Annotation subAnnotation : subAnnotations = annotation.annotationType().getAnnotations()) {
                    annName = subAnnotation.annotationType().getName();
                    if (!this.isSupportedAnnotation(annName) && !annMgr.getClassAnnotationHasHandler(annName)) continue;
                    if (annotNames.contains(annName) && !this.supportedDuplicateAnnotations.contains(annName)) {
                        NucleusLogger.METADATA.warn("Annotation " + annName + " on class=" + cls.getName() + " is DUPLICATED : for sub of " + annotation + " - only the first will be used!");
                    }
                    supportedAnnots.add(subAnnotation);
                    annotNames.add(annName);
                }
            }
        }
        return this.getAnnotationObjectsForAnnotations(cls.getName(), supportedAnnots.toArray(new Annotation[supportedAnnots.size()]));
    }

    protected Collection<AnnotatedMember> getJavaBeanAccessorAnnotationsForClass(Class cls) {
        HashSet<AnnotatedMember> annotatedMethods = new HashSet<AnnotatedMember>();
        Method[] methods = cls.getDeclaredMethods();
        int numberOfMethods = methods.length;
        for (int i = 0; i < numberOfMethods; ++i) {
            Annotation[] annotations;
            HashSet<String> annotNames = new HashSet<String>();
            String methodName = methods[i].getName();
            if (methods[i].isBridge() || (!methodName.startsWith("get") || methodName.length() <= 3) && (!methodName.startsWith("is") || methodName.length() <= 2) || (annotations = methods[i].getAnnotations()) == null || annotations.length <= 0) continue;
            ArrayList<Annotation> supportedAnnots = new ArrayList<Annotation>();
            AnnotationManager annMgr = this.mmgr.getAnnotationManager();
            for (Annotation annotation : annotations) {
                Annotation[] subAnnotations;
                String annName = annotation.annotationType().getName();
                if (this.isSupportedAnnotation(annName) || annMgr.getMemberAnnotationHasHandler(annName)) {
                    if (annotNames.contains(annName) && !this.supportedDuplicateAnnotations.contains(annName)) {
                        NucleusLogger.METADATA.warn("Annotation " + annName + " on class=" + cls.getName() + " is DUPLICATED : " + annotation + " - only the first will be used!");
                    }
                    supportedAnnots.add(annotation);
                    annotNames.add(annName);
                    continue;
                }
                for (Annotation subAnnotation : subAnnotations = annotation.annotationType().getAnnotations()) {
                    annName = subAnnotation.annotationType().getName();
                    if (!this.isSupportedAnnotation(annName) && !annMgr.getMemberAnnotationHasHandler(annName)) continue;
                    if (annotNames.contains(annName) && !this.supportedDuplicateAnnotations.contains(annName)) {
                        NucleusLogger.METADATA.warn("Annotation " + annName + " on class=" + cls.getName() + " is DUPLICATED : for sub of " + annotation + " - only the first will be used!");
                    }
                    supportedAnnots.add(subAnnotation);
                    annotNames.add(annName);
                }
            }
            if (supportedAnnots.isEmpty()) continue;
            AnnotationObject[] annotObjects = this.getAnnotationObjectsForAnnotations(cls.getName(), supportedAnnots.toArray(new Annotation[supportedAnnots.size()]));
            annotatedMethods.add(new AnnotatedMember(new Member(methods[i]), annotObjects));
        }
        return annotatedMethods;
    }

    protected Collection<AnnotatedMember> getFieldAnnotationsForClass(Class cls) {
        HashSet<AnnotatedMember> annotatedFields = new HashSet<AnnotatedMember>();
        Field[] fields = cls.getDeclaredFields();
        int numberOfFields = fields.length;
        for (int i = 0; i < numberOfFields; ++i) {
            HashSet<String> annotNames = new HashSet<String>();
            Annotation[] annotations = fields[i].getAnnotations();
            ArrayList<Annotation> supportedAnnots = new ArrayList<Annotation>();
            if (annotations != null && annotations.length > 0) {
                AnnotationManager annMgr = this.mmgr.getAnnotationManager();
                for (Annotation annotation : annotations) {
                    Annotation[] subAnnotations;
                    String annName = annotation.annotationType().getName();
                    if (this.isSupportedAnnotation(annName) || annMgr.getMemberAnnotationHasHandler(annName)) {
                        if (annotNames.contains(annName) && !this.supportedDuplicateAnnotations.contains(annName)) {
                            NucleusLogger.METADATA.warn("Annotation " + annName + " on class=" + cls.getName() + " is DUPLICATED : " + annotation + " - only the first will be used!");
                        }
                        supportedAnnots.add(annotation);
                        annotNames.add(annName);
                        continue;
                    }
                    for (Annotation subAnnotation : subAnnotations = annotation.annotationType().getAnnotations()) {
                        annName = subAnnotation.annotationType().getName();
                        if (!this.isSupportedAnnotation(annName) && !annMgr.getMemberAnnotationHasHandler(annName)) continue;
                        if (annotNames.contains(annName) && !this.supportedDuplicateAnnotations.contains(annName)) {
                            NucleusLogger.METADATA.warn("Annotation " + annName + " on class=" + cls.getName() + " is DUPLICATED : for sub of " + annotation + " - only the first will be used!");
                        }
                        supportedAnnots.add(subAnnotation);
                        annotNames.add(annName);
                    }
                }
            }
            if (supportedAnnots.isEmpty()) continue;
            AnnotationObject[] objects = this.getAnnotationObjectsForAnnotations(cls.getName(), supportedAnnots.toArray(new Annotation[supportedAnnots.size()]));
            annotatedFields.add(new AnnotatedMember(new Member(fields[i]), objects));
        }
        return annotatedFields;
    }

    protected AnnotationObject[] getAnnotationObjectsForAnnotations(String clsName, Annotation[] annotations) {
        if (annotations == null) {
            return null;
        }
        AnnotationObject[] objects = new AnnotationObject[annotations.length];
        int numberOfAnns = annotations.length;
        for (int i = 0; i < numberOfAnns; ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Method[] annMethods = annotations[i].annotationType().getDeclaredMethods();
            int numberOfAnnotateMethods = annMethods.length;
            for (int j = 0; j < numberOfAnnotateMethods; ++j) {
                try {
                    map.put(annMethods[j].getName(), annMethods[j].invoke((Object)annotations[i], new Object[0]));
                    continue;
                }
                catch (Exception ex) {
                    NucleusLogger.METADATA.warn(Localiser.msg("044201", clsName, annotations[i].annotationType().getName(), annMethods[j].getName()));
                }
            }
            objects[i] = new AnnotationObject(annotations[i].annotationType().getName(), map);
        }
        return objects;
    }
}

