/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CacheUniqueKey;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.util.ConcurrentReferenceHashMap;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class WeakLevel2Cache
implements Level2Cache {
    private static final long serialVersionUID = -4521848285620167823L;
    protected Collection<PinnedClass> pinnedClasses;
    protected Collection pinnedIds;
    protected Map<Object, CachedPC> pinnedCache;
    protected transient Map<Object, CachedPC> unpinnedCache;
    protected transient Map<CacheUniqueKey, CachedPC> uniqueKeyCache;
    protected ApiAdapter apiAdapter;
    private int maxSize = -1;

    protected WeakLevel2Cache() {
    }

    public WeakLevel2Cache(NucleusContext nucleusCtx) {
        this.apiAdapter = nucleusCtx.getApiAdapter();
        this.pinnedCache = new HashMap<Object, CachedPC>();
        this.unpinnedCache = new ConcurrentReferenceHashMap<Object, CachedPC>(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);
        this.uniqueKeyCache = new ConcurrentReferenceHashMap<CacheUniqueKey, CachedPC>(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);
        this.maxSize = nucleusCtx.getConfiguration().getIntProperty("datanucleus.cache.level2.maxSize");
    }

    @Override
    public void close() {
        this.evictAll();
        this.pinnedCache = null;
        this.unpinnedCache = null;
        this.uniqueKeyCache = null;
    }

    @Override
    public void evict(Object oid) {
        if (oid == null) {
            return;
        }
        this.unpinnedCache.remove(oid);
        this.pinnedCache.remove(oid);
    }

    @Override
    public void evictAll() {
        this.unpinnedCache.clear();
        this.pinnedCache.clear();
        this.uniqueKeyCache.clear();
    }

    @Override
    public void evictAll(Class pcClass, boolean subclasses) {
        if (pcClass == null) {
            return;
        }
        HashSet oidsToEvict = new HashSet();
        Set<Map.Entry<Object, CachedPC>> pinnedObjects = this.pinnedCache.entrySet();
        for (Map.Entry entry : pinnedObjects) {
            CachedPC pc = (CachedPC)entry.getValue();
            if (!pcClass.getName().equals(pc.getObjectClass().getName()) && (!subclasses || !pcClass.isAssignableFrom(pc.getObjectClass()))) continue;
            oidsToEvict.add(entry.getKey());
        }
        Set<Map.Entry<Object, CachedPC>> set = this.unpinnedCache.entrySet();
        for (Map.Entry entry : set) {
            CachedPC pc = (CachedPC)entry.getValue();
            if (pc == null || !pcClass.getName().equals(pc.getObjectClass().getName()) && (!subclasses || !pcClass.isAssignableFrom(pc.getObjectClass()))) continue;
            oidsToEvict.add(entry.getKey());
        }
        if (!oidsToEvict.isEmpty()) {
            this.evictAll(oidsToEvict);
        }
    }

    @Override
    public void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    @Override
    public void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    public CachedPC get(Object oid) {
        if (oid == null) {
            return null;
        }
        CachedPC pc = this.pinnedCache.get(oid);
        if (pc != null) {
            return pc;
        }
        return this.unpinnedCache.get(oid);
    }

    @Override
    public Map<Object, CachedPC> getAll(Collection oids) {
        if (oids == null) {
            return null;
        }
        HashMap<Object, CachedPC> objs = new HashMap<Object, CachedPC>();
        for (Object oid : oids) {
            CachedPC obj = this.get(oid);
            if (obj == null) continue;
            objs.put(oid, obj);
        }
        return objs;
    }

    @Override
    public int getNumberOfPinnedObjects() {
        return this.pinnedCache.size();
    }

    @Override
    public int getNumberOfUnpinnedObjects() {
        return this.unpinnedCache.size();
    }

    @Override
    public int getSize() {
        return this.getNumberOfPinnedObjects() + this.getNumberOfUnpinnedObjects();
    }

    @Override
    public void putAll(Map<Object, CachedPC> objs) {
        if (objs == null) {
            return;
        }
        for (Map.Entry<Object, CachedPC> entry : objs.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            NucleusLogger.CACHE.warn(Localiser.msg("004011"));
            return null;
        }
        if (this.maxSize >= 0 && this.getSize() == this.maxSize) {
            return null;
        }
        boolean toBePinned = false;
        if (this.pinnedClasses != null) {
            for (PinnedClass pinCls : this.pinnedClasses) {
                if (!pinCls.cls.getName().equals(pc.getObjectClass().getName()) && (!pinCls.subclasses || !pinCls.cls.isAssignableFrom(pc.getObjectClass()))) continue;
                toBePinned = true;
                break;
            }
        }
        if (this.pinnedIds != null && this.pinnedIds.contains(oid)) {
            toBePinned = true;
        }
        CachedPC obj = null;
        if (this.pinnedCache.get(oid) != null) {
            obj = this.pinnedCache.put(oid, pc);
            if (obj != null) {
                return obj;
            }
        } else if (toBePinned) {
            this.pinnedCache.put(oid, pc);
            this.unpinnedCache.remove(oid);
        } else {
            obj = this.unpinnedCache.put(oid, pc);
            if (obj != null) {
                return obj;
            }
        }
        return null;
    }

    @Override
    public boolean containsOid(Object oid) {
        return this.pinnedCache.containsKey(oid) || this.unpinnedCache.containsKey(oid);
    }

    @Override
    public boolean isEmpty() {
        return this.pinnedCache.isEmpty() && this.unpinnedCache.isEmpty();
    }

    @Override
    public CachedPC getUnique(CacheUniqueKey key) {
        return this.uniqueKeyCache.get(key);
    }

    @Override
    public CachedPC putUnique(CacheUniqueKey key, CachedPC pc) {
        return this.uniqueKeyCache.put(key, pc);
    }

    @Override
    public void putUniqueAll(Map<CacheUniqueKey, CachedPC> objs) {
        this.uniqueKeyCache.putAll(objs);
    }

    @Override
    public void removeUnique(CacheUniqueKey key) {
        this.uniqueKeyCache.remove(key);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.unpinnedCache = new ConcurrentReferenceHashMap<Object, CachedPC>(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);
        this.uniqueKeyCache = new ConcurrentReferenceHashMap<CacheUniqueKey, CachedPC>(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);
    }

    @Override
    public void pin(Object oid) {
        if (oid == null) {
            return;
        }
        if (this.pinnedIds == null) {
            this.pinnedIds = new HashSet();
        } else if (!this.pinnedIds.contains(oid)) {
            this.pinnedIds.add(oid);
        }
        CachedPC pc = this.unpinnedCache.get(oid);
        if (pc != null) {
            this.pinnedCache.put(oid, pc);
            this.unpinnedCache.remove(oid);
        }
    }

    @Override
    public void pinAll(Class cls, boolean subs) {
        PinnedClass pinnedCls;
        if (cls == null) {
            return;
        }
        if (this.pinnedClasses == null) {
            this.pinnedClasses = new HashSet<PinnedClass>();
        }
        if (this.pinnedClasses.contains(pinnedCls = new PinnedClass(cls, subs))) {
            return;
        }
        this.pinnedClasses.add(pinnedCls);
        Collection<CachedPC> unpinnedObjects = this.unpinnedCache.values();
        for (CachedPC obj : unpinnedObjects) {
            if ((!subs || !cls.isInstance(obj.getObjectClass())) && !cls.getName().equals(obj.getObjectClass().getName())) continue;
            this.pin(obj);
        }
    }

    @Override
    public void pinAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.pin(iter.next());
        }
    }

    @Override
    public void pinAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.pin(oids[i]);
        }
    }

    @Override
    public void unpin(Object oid) {
        if (oid == null) {
            return;
        }
        CachedPC pc = this.pinnedCache.get(oid);
        if (pc != null) {
            this.unpinnedCache.put(oid, pc);
            this.pinnedCache.remove(oid);
        }
        if (this.pinnedIds != null && this.pinnedIds.contains(oid)) {
            this.pinnedIds.remove(oid);
        }
    }

    @Override
    public void unpinAll(Class cls, boolean subs) {
        if (cls == null) {
            return;
        }
        if (this.pinnedClasses != null) {
            PinnedClass pinnedCls = new PinnedClass(cls, subs);
            this.pinnedClasses.remove(pinnedCls);
        }
        Collection<CachedPC> pinnedObjects = this.pinnedCache.values();
        for (CachedPC obj : pinnedObjects) {
            if ((!subs || !cls.isInstance(obj.getObjectClass())) && !cls.getName().equals(obj.getObjectClass().getName())) continue;
            this.unpin(obj);
        }
    }

    @Override
    public void unpinAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.unpin(iter.next());
        }
    }

    @Override
    public void unpinAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.unpin(oids[i]);
        }
    }

    class PinnedClass {
        Class cls;
        boolean subclasses;

        public PinnedClass(Class cls, boolean subclasses) {
            this.cls = cls;
            this.subclasses = subclasses;
        }

        public int hashCode() {
            return this.cls.hashCode() ^ (this.subclasses ? 0 : 1);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PinnedClass)) {
                return false;
            }
            PinnedClass other = (PinnedClass)obj;
            return other.cls.getName().equals(this.cls.getName()) && other.subclasses == this.subclasses;
        }
    }
}

