/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers.backed;

import java.io.ObjectStreamException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.flush.MapClearOperation;
import org.datanucleus.flush.MapPutOperation;
import org.datanucleus.flush.MapRemoveOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.BackedSCOStoreManager;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.scostore.MapStore;
import org.datanucleus.store.types.scostore.Store;
import org.datanucleus.store.types.wrappers.backed.BackedSCO;
import org.datanucleus.store.types.wrappers.backed.Collection;
import org.datanucleus.store.types.wrappers.backed.Set;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class SortedMap<K, V>
extends org.datanucleus.store.types.wrappers.SortedMap<K, V>
implements BackedSCO {
    protected transient MapStore<K, V> backingStore;
    protected transient boolean allowNulls = false;
    protected transient boolean useCache = true;
    protected transient boolean isCacheLoaded = false;

    public SortedMap(ObjectProvider op, AbstractMemberMetaData mmd) {
        super(op, mmd);
        ClassLoaderResolver clr = this.ownerOP.getExecutionContext().getClassLoaderResolver();
        Comparator comparator = SCOUtils.getComparator(mmd, clr);
        this.delegate = comparator != null ? new TreeMap(comparator) : new TreeMap();
        this.allowNulls = SCOUtils.allowNullsInContainer(this.allowNulls, mmd);
        this.useCache = SCOUtils.useContainerCache(this.ownerOP, mmd);
        if (!SCOUtils.mapHasSerialisedKeysAndValues(mmd) && mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            this.backingStore = (MapStore)((BackedSCOStoreManager)((Object)this.ownerOP.getStoreManager())).getBackingStoreForField(clr, mmd, java.util.SortedMap.class);
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(op, this.ownerMmd.getName(), this, this.useCache, this.allowNulls, SCOUtils.useCachedLazyLoading(op, this.ownerMmd)));
        }
    }

    @Override
    public void initialise(java.util.SortedMap newValue, Object oldValue) {
        if (newValue != null) {
            if (SCOUtils.mapHasSerialisedKeysAndValues(this.ownerMmd) && (this.ownerMmd.getMap().keyIsPersistent() || this.ownerMmd.getMap().valueIsPersistent())) {
                ExecutionContext ec = this.ownerOP.getExecutionContext();
                for (Map.Entry entry : newValue.entrySet()) {
                    ObjectProvider<Object> objSM;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (this.ownerMmd.getMap().keyIsPersistent() && (objSM = ec.findObjectProvider(key)) == null) {
                        objSM = ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(ec, key, false, this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber());
                    }
                    if (!this.ownerMmd.getMap().valueIsPersistent() || (objSM = ec.findObjectProvider(value)) != null) continue;
                    objSM = ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(ec, value, false, this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber());
                }
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023008", this.ownerOP.getObjectAsPrintable(), this.ownerMmd.getName(), "" + newValue.size()));
            }
            if (this.useCache) {
                Map oldMap = (Map)oldValue;
                if (oldMap != null) {
                    this.delegate.putAll(oldMap);
                }
                this.isCacheLoaded = true;
                SCOUtils.updateMapWithMapKeysValues(this.ownerOP.getExecutionContext().getApiAdapter(), this, newValue);
            } else {
                if (this.backingStore != null) {
                    if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                        if (this.ownerOP.isFlushedToDatastore() || !this.ownerOP.getLifecycleState().isNew()) {
                            this.ownerOP.getExecutionContext().addOperationToQueue(new MapClearOperation(this.ownerOP, this.backingStore));
                            for (Map.Entry entry : newValue.entrySet()) {
                                this.ownerOP.getExecutionContext().addOperationToQueue(new MapPutOperation(this.ownerOP, this.backingStore, entry.getKey(), entry.getValue()));
                            }
                        }
                    } else {
                        this.backingStore.clear(this.ownerOP);
                        this.backingStore.putAll(this.ownerOP, newValue);
                    }
                }
                this.delegate.putAll(newValue);
                this.isCacheLoaded = true;
                this.makeDirty();
            }
        }
    }

    @Override
    public void initialise(java.util.SortedMap m) {
        if (m != null) {
            if (SCOUtils.mapHasSerialisedKeysAndValues(this.ownerMmd) && (this.ownerMmd.getMap().keyIsPersistent() || this.ownerMmd.getMap().valueIsPersistent())) {
                ExecutionContext ec = this.ownerOP.getExecutionContext();
                for (Map.Entry entry : m.entrySet()) {
                    ObjectProvider<Object> objSM;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (this.ownerMmd.getMap().keyIsPersistent() && (objSM = ec.findObjectProvider(key)) == null) {
                        objSM = ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(ec, key, false, this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber());
                    }
                    if (!this.ownerMmd.getMap().valueIsPersistent() || (objSM = ec.findObjectProvider(value)) != null) continue;
                    objSM = ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(ec, value, false, this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber());
                }
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023007", this.ownerOP.getObjectAsPrintable(), this.ownerMmd.getName(), "" + m.size()));
            }
            this.delegate.putAll(m);
            this.isCacheLoaded = true;
        }
    }

    @Override
    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerOP, this.ownerMmd)) {
            this.loadFromStore();
        }
    }

    @Override
    public java.util.SortedMap getValue() {
        this.loadFromStore();
        return super.getValue();
    }

    @Override
    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    @Override
    public boolean isLoaded() {
        return this.useCache ? this.isCacheLoaded : false;
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023006", this.ownerOP.getObjectAsPrintable(), this.ownerMmd.getName()));
            }
            this.delegate.clear();
            SCOUtils.populateMapDelegateWithStoreData(this.delegate, this.backingStore, this.ownerOP);
            this.isCacheLoaded = true;
        }
    }

    @Override
    public Store getBackingStore() {
        return this.backingStore;
    }

    @Override
    public void updateEmbeddedKey(K key, int fieldNumber, Object newValue, boolean makeDirty) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedKey(this.ownerOP, key, fieldNumber, newValue);
        }
    }

    @Override
    public void updateEmbeddedValue(V value, int fieldNumber, Object newValue, boolean makeDirty) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedValue(this.ownerOP, value, fieldNumber, newValue);
        }
    }

    @Override
    public void unsetOwner() {
        super.unsetOwner();
        if (this.backingStore != null) {
            this.backingStore = null;
        }
    }

    @Override
    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return ((TreeMap)this.delegate).clone();
    }

    @Override
    public Comparator comparator() {
        return this.delegate.comparator();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsKey(key);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsKey(this.ownerOP, key);
        }
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsValue(value);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsValue(this.ownerOP, value);
        }
        return this.delegate.containsValue(value);
    }

    @Override
    public java.util.Set entrySet() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerOP, this.ownerMmd, false, this.backingStore.entrySetStore());
        }
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        return this.entrySet().equals(m.entrySet());
    }

    @Override
    public K firstKey() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.firstKey();
        }
        if (!this.useCache) {
            java.util.Set keys = this.keySet();
            Iterator keysIter = keys.iterator();
            return (K)keysIter.next();
        }
        this.loadFromStore();
        return this.delegate.firstKey();
    }

    @Override
    public K lastKey() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.lastKey();
        }
        if (!this.useCache) {
            java.util.Set keys = this.keySet();
            Iterator keysIter = keys.iterator();
            K last = null;
            while (keysIter.hasNext()) {
                last = (K)keysIter.next();
            }
            return last;
        }
        this.loadFromStore();
        return this.delegate.lastKey();
    }

    @Override
    public java.util.SortedMap headMap(K toKey) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.headMap(toKey);
        }
        if (!this.useCache) {
            throw new NucleusUserException("Don't currently support SortedMap.headMap() when not using cached containers");
        }
        this.loadFromStore();
        return this.delegate.headMap(toKey);
    }

    @Override
    public java.util.SortedMap subMap(K fromKey, K toKey) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.subMap(fromKey, toKey);
        }
        if (!this.useCache) {
            throw new NucleusUserException("Don't currently support SortedMap.subMap() when not using cached container");
        }
        this.loadFromStore();
        return this.delegate.subMap(fromKey, toKey);
    }

    @Override
    public java.util.SortedMap tailMap(K fromKey) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.headMap(fromKey);
        }
        if (!this.useCache) {
            throw new NucleusUserException("Don't currently support SortedMap.tailMap() when not using cached containers");
        }
        this.loadFromStore();
        return this.delegate.headMap(fromKey);
    }

    @Override
    public V get(Object key) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.get(this.ownerOP, key);
        }
        return this.delegate.get(key);
    }

    @Override
    public int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            int h = 0;
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                h += i.next().hashCode();
            }
            return h;
        }
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public java.util.Set keySet() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerOP, this.ownerMmd, false, this.backingStore.keySetStore());
        }
        return this.delegate.keySet();
    }

    @Override
    public int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.entrySetStore().size(this.ownerOP);
        }
        return this.delegate.size();
    }

    @Override
    public java.util.Collection values() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Collection(this.ownerOP, this.ownerMmd, true, this.backingStore.valueCollectionStore());
        }
        return this.delegate.values();
    }

    @Override
    public void clear() {
        this.makeDirty();
        this.delegate.clear();
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new MapClearOperation(this.ownerOP, this.backingStore));
            } else {
                this.backingStore.clear(this.ownerOP);
            }
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public V put(K key, V value) {
        if (!this.allowNulls) {
            if (value == null) {
                throw new NullPointerException("Nulls not allowed for map at field " + this.ownerMmd.getName() + " but value is null");
            }
            if (key == null) {
                throw new NullPointerException("Nulls not allowed for map at field " + this.ownerMmd.getName() + " but key is null");
            }
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        this.makeDirty();
        V oldValue = null;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new MapPutOperation(this.ownerOP, this.backingStore, key, value));
            } else {
                oldValue = this.backingStore.put(this.ownerOP, key, value);
            }
        }
        V delegateOldValue = this.delegate.put(key, value);
        if (this.backingStore == null) {
            oldValue = delegateOldValue;
        } else if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
            oldValue = delegateOldValue;
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return oldValue;
    }

    @Override
    public void putAll(Map m) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                for (Map.Entry entry : m.entrySet()) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new MapPutOperation(this.ownerOP, this.backingStore, entry.getKey(), entry.getValue()));
                }
            } else {
                this.backingStore.putAll(this.ownerOP, m);
            }
        }
        this.delegate.putAll(m);
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public V remove(Object key) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        V removed = null;
        Object delegateRemoved = this.delegate.remove(key);
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new MapRemoveOperation(this.ownerOP, this.backingStore, key, delegateRemoved));
                removed = delegateRemoved;
            } else {
                removed = this.backingStore.remove(this.ownerOP, key);
            }
        } else {
            removed = delegateRemoved;
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return removed;
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new TreeMap(this.delegate);
        }
        return new TreeMap(this.delegate);
    }
}

