/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.expression;

import org.datanucleus.query.compiler.Symbol;
import org.datanucleus.query.compiler.SymbolTable;
import org.datanucleus.query.expression.Expression;

public class JoinExpression
extends Expression {
    private static final long serialVersionUID = -3758088504354624725L;
    JoinType type;
    Expression joinedExpr;
    Expression onExpr;

    public JoinExpression(Expression expr, String alias, JoinType type) {
        this.joinedExpr = expr;
        this.alias = alias;
        this.type = type;
    }

    public void setJoinExpression(JoinExpression expr) {
        this.right = expr;
    }

    public void setOnExpression(Expression expr) {
        this.onExpr = expr;
    }

    public Expression getJoinedExpression() {
        return this.joinedExpr;
    }

    public Expression getOnExpression() {
        return this.onExpr;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public JoinType getType() {
        return this.type;
    }

    @Override
    public Symbol bind(SymbolTable symtbl) {
        return null;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("JoinExpression{").append((Object)this.type).append(" ").append(this.joinedExpr).append(" alias=").append(this.alias);
        if (this.right != null) {
            str.append(" join=").append(this.right);
        }
        if (this.onExpr != null) {
            str.append(" on=").append(this.onExpr);
        }
        str.append("}");
        return str.toString();
    }

    public static enum JoinType {
        JOIN_INNER,
        JOIN_LEFT_OUTER,
        JOIN_RIGHT_OUTER,
        JOIN_INNER_FETCH,
        JOIN_LEFT_OUTER_FETCH,
        JOIN_RIGHT_OUTER_FETCH;


        public static boolean isFetch(JoinType type) {
            return type == JOIN_INNER_FETCH || type == JOIN_LEFT_OUTER_FETCH || type == JOIN_RIGHT_OUTER_FETCH;
        }
    }
}

