/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.ContainerHandler;
import org.datanucleus.store.types.ElementContainerAdapter;
import org.datanucleus.store.types.MapContainerAdapter;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class L2CacheRetrieveFieldManager
extends AbstractFieldManager {
    ObjectProvider op;
    ExecutionContext ec;
    CachedPC cachedPC;
    List<Integer> fieldsNotLoaded = null;

    public L2CacheRetrieveFieldManager(ObjectProvider op, CachedPC cachedpc) {
        this.op = op;
        this.ec = op.getExecutionContext();
        this.cachedPC = cachedpc;
    }

    public int[] getFieldsNotLoaded() {
        if (this.fieldsNotLoaded == null) {
            return null;
        }
        int[] flds = new int[this.fieldsNotLoaded.size()];
        int i = 0;
        for (Integer fldNum : this.fieldsNotLoaded) {
            flds[i++] = fldNum;
        }
        return flds;
    }

    @Override
    public boolean fetchBooleanField(int fieldNumber) {
        return (Boolean)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public byte fetchByteField(int fieldNumber) {
        return (Byte)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public char fetchCharField(int fieldNumber) {
        return ((Character)this.cachedPC.getFieldValue(fieldNumber)).charValue();
    }

    @Override
    public double fetchDoubleField(int fieldNumber) {
        return (Double)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public float fetchFloatField(int fieldNumber) {
        return ((Float)this.cachedPC.getFieldValue(fieldNumber)).floatValue();
    }

    @Override
    public int fetchIntField(int fieldNumber) {
        return (Integer)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public long fetchLongField(int fieldNumber) {
        return (Long)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public short fetchShortField(int fieldNumber) {
        return (Short)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public String fetchStringField(int fieldNumber) {
        return (String)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public Object fetchObjectField(int fieldNumber) {
        Object value = this.cachedPC.getFieldValue(fieldNumber);
        if (value == null) {
            return null;
        }
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        return mmd.hasContainer() ? this.processContainerField(fieldNumber, value, mmd) : this.processField(fieldNumber, value, mmd);
    }

    private Object processContainerField(int fieldNumber, Object container, AbstractMemberMetaData mmd) {
        Object containerHandler = this.op.getExecutionContext().getTypeManager().getContainerHandler(mmd.getType());
        return mmd.hasMap() ? this.processMapContainer(fieldNumber, container, mmd, (ContainerHandler<Object, MapContainerAdapter<Object>>)containerHandler) : this.processElementContainer(fieldNumber, container, mmd, (ContainerHandler<Object, ElementContainerAdapter<Object>>)containerHandler);
    }

    private Object processMapContainer(int fieldNumber, Object cachedMapContainer, AbstractMemberMetaData mmd, ContainerHandler<Object, MapContainerAdapter<Object>> containerHandler) {
        try {
            MapContainerAdapter<Object> cachedMapContainerAdapter = containerHandler.getAdapter(cachedMapContainer);
            Object newContainer = L2CacheRetrieveFieldManager.newContainer(cachedMapContainer, mmd, containerHandler);
            MapContainerAdapter<Object> fieldMapContainerAdapter = containerHandler.getAdapter(newContainer);
            for (Map.Entry<Object, Object> entry : cachedMapContainerAdapter.entries()) {
                Object mapKey = null;
                mapKey = mmd.getMap().keyIsPersistent() ? this.getObjectFromCachedId(entry.getKey()) : entry.getKey();
                Object mapValue = null;
                Object mapValueId = entry.getValue();
                if (mapValueId != null) {
                    mapValue = mmd.getMap().valueIsPersistent() ? this.getObjectFromCachedId(entry.getValue()) : entry.getValue();
                }
                fieldMapContainerAdapter.put(mapKey, mapValue);
            }
            return SCOUtils.wrapSCOField(this.op, fieldNumber, fieldMapContainerAdapter.getContainer(), true);
        }
        catch (Exception e) {
            if (this.fieldsNotLoaded == null) {
                this.fieldsNotLoaded = new ArrayList<Integer>();
            }
            this.fieldsNotLoaded.add(fieldNumber);
            NucleusLogger.CACHE.error("Exception thrown creating value for field " + mmd.getFullFieldName() + " of type " + cachedMapContainer.getClass().getName(), e);
            return null;
        }
    }

    private Object processElementContainer(int fieldNumber, Object cachedContainer, AbstractMemberMetaData mmd, ContainerHandler<Object, ElementContainerAdapter<Object>> containerHandler) {
        try {
            Object newContainer = mmd.hasArray() ? containerHandler.newContainer(mmd) : L2CacheRetrieveFieldManager.newContainer(cachedContainer, mmd, containerHandler);
            ElementContainerAdapter<Object> fieldContainerAdapter = containerHandler.getAdapter(newContainer);
            RelationType relType = mmd.getRelationType(this.ec.getClassLoaderResolver());
            ElementContainerAdapter<Object> cachedContainerAdapter = containerHandler.getAdapter(cachedContainer);
            if (relType == RelationType.NONE) {
                String elementType = mmd.hasCollection() ? mmd.getCollection().getElementType() : mmd.getArray().getElementType();
                boolean bl = this.ec.getTypeManager().isSecondClassMutableType(elementType);
                if (bl) {
                    for (Object t : cachedContainerAdapter) {
                        fieldContainerAdapter.add(SCOUtils.copyValue(t));
                    }
                } else {
                    for (Object t : cachedContainerAdapter) {
                        fieldContainerAdapter.add(t);
                    }
                }
            } else {
                for (Object t : cachedContainerAdapter) {
                    Object element = t == null ? null : this.getObjectFromCachedId(t);
                    fieldContainerAdapter.add(element);
                }
            }
            return SCOUtils.wrapSCOField(this.op, fieldNumber, fieldContainerAdapter.getContainer(), true);
        }
        catch (Exception e) {
            if (this.fieldsNotLoaded == null) {
                this.fieldsNotLoaded = new ArrayList<Integer>();
            }
            this.fieldsNotLoaded.add(fieldNumber);
            NucleusLogger.CACHE.error("Exception thrown creating value for field " + mmd.getFullFieldName() + " of type " + cachedContainer.getClass().getName(), e);
            return null;
        }
    }

    private Object processField(int fieldNumber, Object value, AbstractMemberMetaData mmd) {
        RelationType relType = mmd.getRelationType(this.ec.getClassLoaderResolver());
        if (relType == RelationType.NONE) {
            return SCOUtils.wrapSCOField(this.op, fieldNumber, SCOUtils.copyValue(value), true);
        }
        if ((mmd.isSerialized() || MetaDataUtils.isMemberEmbedded(mmd, relType, this.ec.getClassLoaderResolver(), this.ec.getMetaDataManager())) && this.ec.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.cache.level2.cacheEmbedded") && value instanceof CachedPC) {
            CachedPC valueCachedPC = (CachedPC)value;
            AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(valueCachedPC.getObjectClass(), this.ec.getClassLoaderResolver());
            int[] fieldsToLoad = ClassUtils.getFlagsSetTo(valueCachedPC.getLoadedFields(), cmd.getAllMemberPositions(), true);
            ObjectProvider valueOP = this.ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(this.ec, cmd, this.op, mmd.getAbsoluteFieldNumber());
            if (fieldsToLoad != null && fieldsToLoad.length > 0) {
                valueOP.replaceFields(fieldsToLoad, new L2CacheRetrieveFieldManager(valueOP, valueCachedPC));
            }
            return valueOP.getObject();
        }
        try {
            return this.getObjectFromCachedId(value);
        }
        catch (NucleusObjectNotFoundException nonfe) {
            if (this.fieldsNotLoaded == null) {
                this.fieldsNotLoaded = new ArrayList<Integer>();
            }
            this.fieldsNotLoaded.add(fieldNumber);
            return null;
        }
    }

    private Object getObjectFromCachedId(Object cachedId) {
        Object pcId = null;
        String pcClassName = null;
        if (cachedId instanceof CachedPC.CachedId) {
            CachedPC.CachedId cId = (CachedPC.CachedId)cachedId;
            pcId = cId.getId();
            pcClassName = cId.getClassName();
        } else {
            pcId = cachedId;
            pcClassName = IdentityUtils.getTargetClassNameForIdentity(pcId);
        }
        Class pcCls = this.ec.getClassLoaderResolver().classForName(pcClassName);
        return this.ec.findObject(pcId, null, pcCls, false, false);
    }

    static <T> T newContainer(Object container, AbstractMemberMetaData mmd, ContainerHandler containerHandler) {
        Object newContainer;
        try {
            newContainer = container.getClass().newInstance();
        }
        catch (Exception e) {
            newContainer = containerHandler.newContainer(mmd);
        }
        return (T)newContainer;
    }
}

