/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.Configuration;
import org.datanucleus.DetachState;
import org.datanucleus.ExecutionContext;
import org.datanucleus.ExecutionContextListener;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchGroupManager;
import org.datanucleus.FetchPlan;
import org.datanucleus.FetchPlanState;
import org.datanucleus.ImplementationCreator;
import org.datanucleus.JTAJCATransactionImpl;
import org.datanucleus.JTATransactionImpl;
import org.datanucleus.ManagedRelationsHandler;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.ReachabilityAtCommitHandler;
import org.datanucleus.Transaction;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.TransactionImpl;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CacheUniqueKey;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.L2CachePopulateFieldManager;
import org.datanucleus.cache.Level1Cache;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.cache.SoftRefCache;
import org.datanucleus.cache.StrongRefCache;
import org.datanucleus.cache.WeakRefCache;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.exceptions.ClassNotDetachableException;
import org.datanucleus.exceptions.ClassNotPersistableException;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.CommitStateTransitionException;
import org.datanucleus.exceptions.NoPersistenceInformationException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusFatalUserException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.ObjectDetachedException;
import org.datanucleus.exceptions.RollbackStateTransitionException;
import org.datanucleus.exceptions.TransactionActiveOnCloseException;
import org.datanucleus.exceptions.TransactionNotActiveException;
import org.datanucleus.flush.FlushMode;
import org.datanucleus.flush.FlushProcess;
import org.datanucleus.flush.Operation;
import org.datanucleus.flush.OperationQueue;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.identity.DatastoreUniqueLongId;
import org.datanucleus.identity.IdentityKeyTranslator;
import org.datanucleus.identity.IdentityReference;
import org.datanucleus.identity.IdentityStringTranslator;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.SCOID;
import org.datanucleus.management.ManagerStatistics;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.properties.BasePropertyStore;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.LockManager;
import org.datanucleus.state.LockManagerImpl;
import org.datanucleus.state.LockMode;
import org.datanucleus.state.NullCallbackHandler;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.Extent;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.types.scostore.Store;
import org.datanucleus.util.ConcurrentReferenceHashMap;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.TypeConversionHelper;

public class ExecutionContextImpl
implements ExecutionContext,
TransactionEventListener {
    PersistenceNucleusContext nucCtx;
    private Object owner;
    private boolean closing = false;
    private boolean closed;
    private FetchPlan fetchPlan;
    private ClassLoaderResolver clr = null;
    private CallbackHandler callbackHandler;
    protected Level1Cache cache;
    private final BasePropertyStore properties = new BasePropertyStore();
    private Transaction tx;
    private FlushMode flushMode = null;
    private final Map<Object, ObjectProvider> enlistedOPCache = new ConcurrentReferenceHashMap<Object, ObjectProvider>(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);
    private final List<ObjectProvider> dirtyOPs = new ArrayList<ObjectProvider>();
    private final List<ObjectProvider> indirectDirtyOPs = new ArrayList<ObjectProvider>();
    private OperationQueue operationQueue = null;
    private Set<ObjectProvider> nontxProcessedOPs = null;
    private boolean l2CacheEnabled = false;
    private Map<Object, BitSet> l2CacheTxFieldsToUpdateById = null;
    private Set l2CacheTxIds = null;
    private List<Object> l2CacheObjectsToEvictUponRollback = null;
    private int flushing = 0;
    private FetchGroupManager fetchGrpMgr;
    private LockManager lockMgr = null;
    private Map<ObjectProvider, Object> opAttachDetachObjectReferenceMap = null;
    private Map<ObjectProvider, List<ExecutionContext.EmbeddedOwnerRelation>> opEmbeddedInfoByOwner = null;
    private Map<ObjectProvider, List<ExecutionContext.EmbeddedOwnerRelation>> opEmbeddedInfoByEmbedded = null;
    protected Map<ObjectProvider, Map<?, ?>> opAssociatedValuesMapByOP = null;
    private ManagedRelationsHandler managedRelationsHandler = null;
    private ReachabilityAtCommitHandler pbrAtCommitHandler = null;
    private boolean runningDetachAllOnTxnEnd = false;
    private ObjectProvider[] detachAllOnTxnEndOPs = null;
    private ManagerStatistics statistics = null;
    private Set<ExecutionContextListener> ecListeners = null;
    private ThreadLocal contextInfoThreadLocal;

    public ExecutionContextImpl(PersistenceNucleusContext ctx, Object owner, Map<String, Object> options) {
        this.nucCtx = ctx;
        this.initialise(owner, options);
        this.initialiseLevel1Cache();
    }

    @Override
    public void initialise(Object owner, Map<String, Object> options) {
        this.owner = owner;
        this.closed = false;
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        this.clr = this.nucCtx.getClassLoaderResolver(contextLoader);
        try {
            ImplementationCreator ic = this.nucCtx.getImplementationCreator();
            if (ic != null) {
                this.clr.setRuntimeClassLoader(ic.getClassLoader());
            }
        }
        catch (Exception ic) {
            // empty catch block
        }
        Configuration conf = this.nucCtx.getConfiguration();
        for (Map.Entry<String, Object> entry : conf.getManagerOverrideableProperties().entrySet()) {
            this.properties.setProperty(entry.getKey().toLowerCase(Locale.ENGLISH), entry.getValue());
        }
        this.properties.getFrequentProperties().setDefaults(conf.getFrequentProperties());
        this.fetchPlan = new FetchPlan(this, this.clr).setMaxFetchDepth(conf.getIntProperty("datanucleus.maxFetchDepth"));
        if (TransactionType.JTA.toString().equalsIgnoreCase(conf.getStringProperty("datanucleus.transaction.type"))) {
            if (this.getNucleusContext().isJcaMode()) {
                this.tx = new JTAJCATransactionImpl(this, this.properties);
            } else {
                boolean autoJoin = true;
                if (options != null && options.containsKey("jta_autojoin")) {
                    autoJoin = Boolean.valueOf((String)options.get("jta_autojoin"));
                }
                this.tx = new JTATransactionImpl(this, autoJoin, this.properties);
            }
        } else {
            this.tx = new TransactionImpl(this, this.properties);
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("010000", this, this.nucCtx.getStoreManager(), this.tx));
        }
        if (this.nucCtx.statisticsEnabled()) {
            this.statistics = new ManagerStatistics(this.nucCtx.getJMXManager(), this.nucCtx.getStatistics());
        }
        this.contextInfoThreadLocal = new ThreadLocal(){

            protected Object initialValue() {
                return new ThreadContextInfo();
            }
        };
        if (this.properties.getBooleanProperty("datanucleus.manageRelationships")) {
            this.managedRelationsHandler = new ManagedRelationsHandler(this.properties.getBooleanProperty("datanucleus.manageRelationshipsChecks"));
        }
        if (this.properties.getFrequentProperties().getReachabilityAtCommit().booleanValue()) {
            this.pbrAtCommitHandler = new ReachabilityAtCommitHandler(this);
        }
        this.lockMgr = new LockManagerImpl(this);
        this.l2CacheObjectsToEvictUponRollback = null;
        this.setLevel2Cache(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        String closeActionTxAction;
        if (this.closed) {
            throw new NucleusUserException(Localiser.msg("010002"));
        }
        if (this.tx.getIsActive() && (closeActionTxAction = this.nucCtx.getConfiguration().getStringProperty("datanucleus.executionContext.closeActiveTxAction")) != null) {
            if (closeActionTxAction.equalsIgnoreCase("exception")) {
                throw new TransactionActiveOnCloseException(this);
            }
            if (closeActionTxAction.equalsIgnoreCase("rollback")) {
                NucleusLogger.GENERAL.warn("ExecutionContext closed with active transaction, so rolling back the active transaction");
                this.tx.rollback();
            }
        }
        if (!this.dirtyOPs.isEmpty() && this.tx.getNontransactionalWrite()) {
            if (this.isNonTxAtomic()) {
                this.processNontransactionalUpdate();
            } else {
                try {
                    this.tx.begin();
                    this.tx.commit();
                }
                finally {
                    if (this.tx.isActive()) {
                        this.tx.rollback();
                    }
                }
            }
        }
        if (this.properties.getFrequentProperties().getDetachOnClose().booleanValue() && this.cache != null && !this.cache.isEmpty()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("010011"));
            ArrayList toDetach = new ArrayList(this.cache.values());
            try {
                if (!this.tx.getNontransactionalRead()) {
                    this.tx.begin();
                }
                for (ObjectProvider op : toDetach) {
                    if (op == null || op.getObject() == null || op.getExecutionContext().getApiAdapter().isDeleted(op.getObject()) || op.getExternalObjectId() == null) continue;
                    try {
                        op.detach(new DetachState(this.getApiAdapter()));
                    }
                    catch (NucleusObjectNotFoundException nucleusObjectNotFoundException) {}
                }
                if (!this.tx.getNontransactionalRead()) {
                    this.tx.commit();
                }
            }
            finally {
                if (!this.tx.getNontransactionalRead() && this.tx.isActive()) {
                    this.tx.rollback();
                }
            }
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("010012"));
        }
        ExecutionContext.LifecycleListener[] listener = this.nucCtx.getExecutionContextListeners();
        for (int i = 0; i < listener.length; ++i) {
            listener[i].preClose(this);
        }
        this.closing = true;
        if (this.cache != null && !this.cache.isEmpty()) {
            HashSet cachedOPsClone = new HashSet(this.cache.values());
            for (ObjectProvider op : cachedOPsClone) {
                if (op != null) {
                    op.disconnect();
                    continue;
                }
                NucleusLogger.CACHE.error(">> EC.close L1Cache op IS NULL!");
            }
            this.cache.clear();
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(Localiser.msg("003011"));
            }
        }
        this.closeCallbackHandler();
        if (this.ecListeners != null) {
            HashSet<ExecutionContextListener> listeners = new HashSet<ExecutionContextListener>(this.ecListeners);
            for (ExecutionContextListener lstr : listeners) {
                lstr.executionContextClosing(this);
            }
            this.ecListeners.clear();
            this.ecListeners = null;
        }
        this.fetchPlan.clearGroups().addGroup("default");
        if (this.statistics != null) {
            this.statistics.close();
            this.statistics = null;
        }
        this.enlistedOPCache.clear();
        this.dirtyOPs.clear();
        this.indirectDirtyOPs.clear();
        if (this.nontxProcessedOPs != null) {
            this.nontxProcessedOPs.clear();
            this.nontxProcessedOPs = null;
        }
        if (this.managedRelationsHandler != null) {
            this.managedRelationsHandler.clear();
        }
        if (this.l2CacheTxIds != null) {
            this.l2CacheTxIds.clear();
        }
        if (this.l2CacheTxFieldsToUpdateById != null) {
            this.l2CacheTxFieldsToUpdateById.clear();
        }
        if (this.pbrAtCommitHandler != null) {
            this.pbrAtCommitHandler.clear();
        }
        if (this.opEmbeddedInfoByOwner != null) {
            this.opEmbeddedInfoByOwner.clear();
            this.opEmbeddedInfoByOwner = null;
        }
        if (this.opEmbeddedInfoByEmbedded != null) {
            this.opEmbeddedInfoByEmbedded.clear();
            this.opEmbeddedInfoByEmbedded = null;
        }
        if (this.opAssociatedValuesMapByOP != null) {
            this.opAssociatedValuesMapByOP.clear();
            this.opAssociatedValuesMapByOP = null;
        }
        this.l2CacheObjectsToEvictUponRollback = null;
        this.closing = false;
        this.closed = true;
        this.tx.close();
        this.tx = null;
        this.owner = null;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("010001", this));
        }
        this.nucCtx.getExecutionContextPool().checkIn(this);
    }

    @Override
    public void registerExecutionContextListener(ExecutionContextListener listener) {
        if (this.ecListeners == null) {
            this.ecListeners = new HashSet<ExecutionContextListener>();
        }
        this.ecListeners.add(listener);
    }

    @Override
    public void deregisterExecutionContextListener(ExecutionContextListener listener) {
        if (this.ecListeners != null) {
            this.ecListeners.remove(listener);
        }
    }

    protected void setLevel2Cache(boolean flag) {
        if (flag && this.nucCtx.hasLevel2Cache() && !this.l2CacheEnabled) {
            this.l2CacheTxIds = new HashSet();
            this.l2CacheTxFieldsToUpdateById = new HashMap<Object, BitSet>();
            this.l2CacheEnabled = true;
        } else if (!flag && this.l2CacheEnabled) {
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug("Disabling L2 caching for " + this);
            }
            this.l2CacheTxIds.clear();
            this.l2CacheTxIds = null;
            this.l2CacheTxFieldsToUpdateById.clear();
            this.l2CacheTxFieldsToUpdateById = null;
            this.l2CacheEnabled = false;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected ThreadContextInfo acquireThreadContextInfo() {
        ThreadContextInfo threadInfo = (ThreadContextInfo)this.contextInfoThreadLocal.get();
        ++threadInfo.referenceCounter;
        return threadInfo;
    }

    protected ThreadContextInfo getThreadContextInfo() {
        return (ThreadContextInfo)this.contextInfoThreadLocal.get();
    }

    protected void releaseThreadContextInfo() {
        ThreadContextInfo threadInfo = (ThreadContextInfo)this.contextInfoThreadLocal.get();
        if (--threadInfo.referenceCounter <= 0) {
            threadInfo.referenceCounter = 0;
            if (threadInfo.attachedOwnerByObject != null) {
                threadInfo.attachedOwnerByObject.clear();
            }
            threadInfo.attachedOwnerByObject = null;
            if (threadInfo.attachedPCById != null) {
                threadInfo.attachedPCById.clear();
            }
            threadInfo.attachedPCById = null;
            this.contextInfoThreadLocal.remove();
        }
    }

    @Override
    public void transactionStarted() {
        this.getStoreManager().transactionStarted(this);
        this.postBegin();
    }

    @Override
    public void transactionPreFlush() {
    }

    @Override
    public void transactionFlushed() {
    }

    @Override
    public void transactionPreCommit() {
        this.preCommit();
    }

    @Override
    public void transactionCommitted() {
        this.getStoreManager().transactionCommitted(this);
        this.postCommit();
    }

    @Override
    public void transactionPreRollBack() {
        this.preRollback();
    }

    @Override
    public void transactionRolledBack() {
        this.getStoreManager().transactionRolledBack(this);
        this.postRollback();
    }

    @Override
    public void transactionEnded() {
    }

    @Override
    public void transactionSetSavepoint(String name) {
    }

    @Override
    public void transactionReleaseSavepoint(String name) {
    }

    @Override
    public void transactionRollbackToSavepoint(String name) {
    }

    @Override
    public ManagerStatistics getStatistics() {
        return this.statistics;
    }

    protected void initialiseLevel1Cache() {
        String level1Type = this.nucCtx.getConfiguration().getStringProperty("datanucleus.cache.level1.type");
        if ("none".equalsIgnoreCase(level1Type)) {
            return;
        }
        if ("soft".equalsIgnoreCase(level1Type)) {
            this.cache = new SoftRefCache();
        } else if ("weak".equalsIgnoreCase(level1Type)) {
            this.cache = new WeakRefCache();
        } else if ("strong".equalsIgnoreCase(level1Type)) {
            this.cache = new StrongRefCache();
        } else {
            String level1ClassName = this.getNucleusContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_level1", "name", level1Type, "class-name");
            if (level1ClassName == null) {
                throw new NucleusUserException(Localiser.msg("003001", level1Type)).setFatal();
            }
            try {
                this.cache = (Level1Cache)this.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.cache_level1", "name", level1Type, "class-name", null, null);
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("003003", level1Type));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(Localiser.msg("003002", level1Type, level1ClassName), e).setFatal();
            }
        }
    }

    @Override
    public Level1Cache getLevel1Cache() {
        return this.cache;
    }

    @Override
    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    @Override
    public LockManager getLockManager() {
        return this.lockMgr;
    }

    @Override
    public FetchPlan getFetchPlan() {
        this.assertIsOpen();
        return this.fetchPlan;
    }

    @Override
    public PersistenceNucleusContext getNucleusContext() {
        return this.nucCtx;
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public void setProperties(Map props) {
        if (props == null) {
            return;
        }
        for (Map.Entry entry : props.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            this.setProperty((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setProperty(String name, Object value) {
        String intName;
        if (name.equalsIgnoreCase("datanucleus.manageRelationships")) {
            if ("false".equalsIgnoreCase((String)value)) {
                this.managedRelationsHandler = null;
            } else if ("true".equalsIgnoreCase((String)value)) {
                this.managedRelationsHandler = new ManagedRelationsHandler(this.properties.getBooleanProperty("datanucleus.manageRelationshipsChecks"));
            }
        } else if (name.equalsIgnoreCase("datanucleus.manageRelationshipsChecks")) {
            if (this.managedRelationsHandler != null) {
                Boolean checks = Boolean.valueOf((String)value);
                if (checks == Boolean.TRUE) {
                    this.managedRelationsHandler.setPerformChecks(true);
                } else if (checks == Boolean.FALSE) {
                    this.managedRelationsHandler.setPerformChecks(false);
                }
            }
        } else if (name.equalsIgnoreCase("datanucleus.persistenceByReachabilityAtCommit")) {
            if (this.pbrAtCommitHandler != null) {
                if ("false".equalsIgnoreCase((String)value)) {
                    this.pbrAtCommitHandler = null;
                } else if ("true".equalsIgnoreCase((String)value)) {
                    this.pbrAtCommitHandler = new ReachabilityAtCommitHandler(this);
                }
            }
        } else if (name.equalsIgnoreCase("datanucleus.flush.mode")) {
            this.flushMode = FlushMode.getFlushModeForString((String)value);
            return;
        }
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            intName = this.getNucleusContext().getConfiguration().getInternalNameForProperty(name);
            this.getNucleusContext().getConfiguration().validatePropertyValue(intName, value);
            this.properties.setProperty(intName.toLowerCase(Locale.ENGLISH), value);
        } else if (name.equalsIgnoreCase("datanucleus.cache.level2.type")) {
            if ("none".equalsIgnoreCase((String)value)) {
                this.setLevel2Cache(false);
            }
        } else {
            intName = this.getNucleusContext().getConfiguration().getInternalNameForProperty(name);
            if (intName != null && !intName.equalsIgnoreCase(name)) {
                this.getNucleusContext().getConfiguration().validatePropertyValue(intName, value);
                this.properties.setProperty(intName.toLowerCase(Locale.ENGLISH), value);
            } else {
                NucleusLogger.PERSISTENCE.warn("Attempt to set property \"" + name + "\" on PM/EM yet this is not supported. Ignored");
            }
        }
        if (name.equalsIgnoreCase("datanucleus.SerializeRead")) {
            this.tx.setSerializeRead(this.getBooleanProperty("datanucleus.SerializeRead"));
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.properties.getProperties().entrySet()) {
            props.put(this.nucCtx.getConfiguration().getCaseSensitiveNameForPropertyName(entry.getKey()), entry.getValue());
        }
        return props;
    }

    @Override
    public Boolean getBooleanProperty(String name) {
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            this.assertIsOpen();
            return this.properties.getBooleanProperty(this.getNucleusContext().getConfiguration().getInternalNameForProperty(name));
        }
        return null;
    }

    @Override
    public Integer getIntProperty(String name) {
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            this.assertIsOpen();
            return this.properties.getIntProperty(this.getNucleusContext().getConfiguration().getInternalNameForProperty(name));
        }
        return null;
    }

    @Override
    public String getStringProperty(String name) {
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            this.assertIsOpen();
            return this.properties.getStringProperty(this.getNucleusContext().getConfiguration().getInternalNameForProperty(name));
        }
        return null;
    }

    @Override
    public Object getProperty(String name) {
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            this.assertIsOpen();
            return this.properties.getProperty(this.getNucleusContext().getConfiguration().getInternalNameForProperty(name).toLowerCase(Locale.ENGLISH));
        }
        return null;
    }

    @Override
    public Set<String> getSupportedProperties() {
        return this.nucCtx.getConfiguration().getManagedOverrideablePropertyNames();
    }

    @Override
    public boolean getMultithreaded() {
        return false;
    }

    @Override
    public FlushMode getFlushMode() {
        return this.flushMode;
    }

    @Override
    public boolean isDelayDatastoreOperationsEnabled() {
        if (!this.tx.isActive()) {
            if (this.isFlushing()) {
                return false;
            }
            return !this.isNonTxAtomic();
        }
        if (this.isFlushing() || this.tx.isCommitting()) {
            return false;
        }
        if (this.flushMode == FlushMode.AUTO) {
            return false;
        }
        if (this.flushMode == FlushMode.MANUAL || this.flushMode == FlushMode.QUERY) {
            return true;
        }
        return this.tx.getOptimistic();
    }

    @Override
    public boolean isInserting(Object pc) {
        ObjectProvider op = this.findObjectProvider(pc);
        if (op == null) {
            return false;
        }
        return op.isInserting();
    }

    @Override
    public Transaction getTransaction() {
        this.assertIsOpen();
        return this.tx;
    }

    @Override
    public void enlistInTransaction(ObjectProvider op) {
        this.assertActiveTransaction();
        if (this.pbrAtCommitHandler != null && this.tx.isActive()) {
            if (this.getApiAdapter().isNew(op.getObject())) {
                this.pbrAtCommitHandler.addFlushedNewObject(op.getInternalObjectId());
            } else if (this.getApiAdapter().isPersistent(op.getObject()) && !this.getApiAdapter().isDeleted(op.getObject()) && !this.pbrAtCommitHandler.isObjectFlushedNew(op.getInternalObjectId())) {
                this.pbrAtCommitHandler.addPersistedObject(op.getInternalObjectId());
            }
            if (!this.pbrAtCommitHandler.isExecuting()) {
                this.pbrAtCommitHandler.addEnlistedObject(op.getInternalObjectId());
            }
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(Localiser.msg("015017", StringUtils.toJVMIDString(op.getObject()), op.getInternalObjectId().toString()));
        }
        this.enlistedOPCache.put(op.getInternalObjectId(), op);
    }

    @Override
    public void evictFromTransaction(ObjectProvider op) {
        if (this.enlistedOPCache.remove(op.getInternalObjectId()) != null && NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(Localiser.msg("015019", StringUtils.toJVMIDString(op.getObject()), IdentityUtils.getPersistableIdentityForId(op.getInternalObjectId())));
        }
    }

    @Override
    public boolean isEnlistedInTransaction(Object id) {
        if (this.pbrAtCommitHandler == null || !this.tx.isActive()) {
            return false;
        }
        if (id == null) {
            return false;
        }
        return this.pbrAtCommitHandler.isObjectEnlisted(id);
    }

    @Override
    public Object getAttachedObjectForId(Object id) {
        ObjectProvider op = this.enlistedOPCache.get(id);
        if (op != null) {
            return op.getObject();
        }
        if (this.cache != null && (op = (ObjectProvider)this.cache.get(id)) != null) {
            return op.getObject();
        }
        return null;
    }

    @Override
    public void addObjectProviderToCache(ObjectProvider op) {
        this.putObjectIntoLevel1Cache(op);
    }

    @Override
    public void removeObjectProviderFromCache(ObjectProvider op) {
        List<ExecutionContext.EmbeddedOwnerRelation> embRels;
        if (this.closing) {
            return;
        }
        this.removeObjectFromLevel1Cache(op.getInternalObjectId());
        this.enlistedOPCache.remove(op.getInternalObjectId());
        if (this.opEmbeddedInfoByEmbedded != null && (embRels = this.opEmbeddedInfoByEmbedded.get(op)) != null) {
            for (ExecutionContext.EmbeddedOwnerRelation rel : embRels) {
                this.opEmbeddedInfoByOwner.remove(rel.getOwnerOP());
            }
            this.opEmbeddedInfoByEmbedded.remove(op);
        }
        if (this.opEmbeddedInfoByOwner != null && (embRels = this.opEmbeddedInfoByOwner.get(op)) != null) {
            for (ExecutionContext.EmbeddedOwnerRelation rel : embRels) {
                this.opEmbeddedInfoByEmbedded.remove(rel.getEmbeddedOP());
            }
            this.opEmbeddedInfoByOwner.remove(op);
        }
        if (this.opAssociatedValuesMapByOP != null) {
            this.opAssociatedValuesMapByOP.remove(op);
        }
        this.setAttachDetachReferencedObject(op, null);
    }

    @Override
    public ObjectProvider findObjectProvider(Object pc) {
        ExecutionContext ec;
        ObjectProvider op = (ObjectProvider)this.getApiAdapter().getStateManager(pc);
        if (op != null && (ec = op.getExecutionContext()) != null && this != ec) {
            throw new NucleusUserException(Localiser.msg("010007", this.getApiAdapter().getIdForObject(pc)));
        }
        return op;
    }

    @Override
    public ObjectProvider findObjectProvider(Object pc, boolean persist) {
        ObjectProvider op = this.findObjectProvider(pc);
        if (op == null && persist) {
            int objectType = 0;
            Object object2 = this.persistObjectInternal(pc, null, null, -1, objectType);
            op = this.findObjectProvider(object2);
        } else if (op == null) {
            return null;
        }
        return op;
    }

    @Override
    public ObjectProvider findObjectProviderForEmbedded(Object value, ObjectProvider owner, AbstractMemberMetaData mmd) {
        ObjectProvider[] embOwnerOPs;
        ObjectProvider<Object> embeddedOP = this.findObjectProvider(value);
        if (embeddedOP == null) {
            embeddedOP = this.nucCtx.getObjectProviderFactory().newForEmbedded(this, value, false, owner, owner.getClassMetaData().getMetaDataForMember(mmd.getName()).getAbsoluteFieldNumber());
        }
        if ((embOwnerOPs = this.getOwnersForEmbeddedObjectProvider(embeddedOP)) == null || embOwnerOPs.length == 0) {
            int absoluteFieldNumber = owner.getClassMetaData().getMetaDataForMember(mmd.getName()).getAbsoluteFieldNumber();
            this.registerEmbeddedRelation(owner, absoluteFieldNumber, embeddedOP);
            embeddedOP.setPcObjectType((short)1);
        }
        return embeddedOP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectProvider findObjectProviderOfOwnerForAttachingObject(Object pc) {
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (threadInfo.attachedOwnerByObject == null) {
                ObjectProvider objectProvider = null;
                return objectProvider;
            }
            ObjectProvider objectProvider = threadInfo.attachedOwnerByObject.get(pc);
            return objectProvider;
        }
        finally {
            this.releaseThreadContextInfo();
        }
    }

    private boolean isNonTxAtomic() {
        return this.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.transaction.nontx.atomic");
    }

    @Override
    public void processNontransactionalUpdate() {
        if (this.tx.isActive() || !this.tx.getNontransactionalWrite() || !this.tx.getNontransactionalWriteAutoCommit()) {
            return;
        }
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (threadInfo.nontxPersistDelete) {
                return;
            }
            this.processNontransactionalAtomicChanges();
        }
        finally {
            this.releaseThreadContextInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNontransactionalAtomicChanges() {
        if (this.tx.isActive() || !this.tx.getNontransactionalWrite() || !this.tx.getNontransactionalWriteAutoCommit()) {
            return;
        }
        if (!this.dirtyOPs.isEmpty()) {
            for (ObjectProvider op : this.dirtyOPs) {
                if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                    NucleusLogger.TRANSACTION.debug(Localiser.msg("015017", StringUtils.toJVMIDString(op.getObject()), op.getInternalObjectId().toString()));
                }
                this.enlistedOPCache.put(op.getInternalObjectId(), op);
            }
            this.flushInternal(true);
            if (this.l2CacheEnabled) {
                this.performLevel2CacheUpdateAtCommit();
            }
            if (this.properties.getFrequentProperties().getDetachAllOnCommit().booleanValue()) {
                this.performDetachAllOnTxnEndPreparation();
                this.performDetachAllOnTxnEnd();
            }
            ArrayList<RuntimeException> failures = null;
            try {
                ApiAdapter api = this.getApiAdapter();
                ObjectProvider[] ops = this.enlistedOPCache.values().toArray(new ObjectProvider[this.enlistedOPCache.size()]);
                for (int i = 0; i < ops.length; ++i) {
                    try {
                        if (ops[i] != null && ops[i].getObject() != null && api.isPersistent(ops[i].getObject()) && api.isDirty(ops[i].getObject())) {
                            ops[i].postCommit(this.getTransaction());
                            continue;
                        }
                        NucleusLogger.PERSISTENCE.debug(">> Atomic nontransactional processing : Not performing postCommit on " + ops[i]);
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (failures == null) {
                            failures = new ArrayList<RuntimeException>();
                        }
                        failures.add(e);
                    }
                }
            }
            finally {
                this.resetTransactionalVariables();
            }
            if (failures != null && !failures.isEmpty()) {
                throw new CommitStateTransitionException(failures.toArray(new Exception[failures.size()]));
            }
        }
        if (this.nontxProcessedOPs != null && !this.nontxProcessedOPs.isEmpty()) {
            for (ObjectProvider op : this.nontxProcessedOPs) {
                if (op == null || op.getLifecycleState() == null || !op.getLifecycleState().isDeleted()) continue;
                this.removeObjectFromLevel1Cache(op.getInternalObjectId());
                this.removeObjectFromLevel2Cache(op.getInternalObjectId());
            }
            this.nontxProcessedOPs.clear();
        }
    }

    @Override
    public void evictObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            ObjectProvider op = this.findObjectProvider(obj);
            if (op == null) {
                throw new NucleusUserException(Localiser.msg("010048", StringUtils.toJVMIDString(obj), this.getApiAdapter().getIdForObject(obj), "evict"));
            }
            op.evict();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public void evictObjects(Class cls, boolean subclasses) {
        if (this.cache != null) {
            HashSet opsToEvict = new HashSet(this.cache.values());
            for (ObjectProvider op : opsToEvict) {
                Object pc = op.getObject();
                boolean evict = false;
                if (!subclasses && pc.getClass() == cls) {
                    evict = true;
                } else if (subclasses && cls.isAssignableFrom(pc.getClass())) {
                    evict = true;
                }
                if (!evict) continue;
                op.evict();
                this.removeObjectFromLevel1Cache(this.getApiAdapter().getIdForObject(pc));
            }
        }
    }

    @Override
    public void evictAllObjects() {
        if (this.cache != null && !this.cache.isEmpty()) {
            HashSet opsToEvict = new HashSet(this.cache.values());
            for (ObjectProvider op : opsToEvict) {
                if (op != null) {
                    op.evict();
                    continue;
                }
                NucleusLogger.CACHE.error(">> EC.evictAllObjects L1Cache op IS NULL!");
            }
            this.cache.clear();
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(Localiser.msg("003011"));
            }
        }
    }

    @Override
    public void refreshObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            ObjectProvider op = this.findObjectProvider(obj);
            if (op == null) {
                throw new NucleusUserException(Localiser.msg("010048", StringUtils.toJVMIDString(obj), this.getApiAdapter().getIdForObject(obj), "refresh"));
            }
            if (this.getApiAdapter().isPersistent(obj) && op.isWaitingToBeFlushedToDatastore()) {
                return;
            }
            op.refresh();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public void refreshAllObjects() {
        HashSet<ObjectProvider<Object>> toRefresh = new HashSet<ObjectProvider<Object>>();
        toRefresh.addAll(this.enlistedOPCache.values());
        toRefresh.addAll(this.dirtyOPs);
        toRefresh.addAll(this.indirectDirtyOPs);
        if (!this.tx.isActive() && this.cache != null && !this.cache.isEmpty()) {
            toRefresh.addAll(this.cache.values());
        }
        ArrayList<RuntimeException> failures = null;
        for (ObjectProvider objectProvider : toRefresh) {
            try {
                objectProvider.refresh();
            }
            catch (RuntimeException e) {
                if (failures == null) {
                    failures = new ArrayList<RuntimeException>();
                }
                failures.add(e);
            }
        }
        if (failures != null && !failures.isEmpty()) {
            throw new NucleusUserException(Localiser.msg("010037"), failures.toArray(new Exception[failures.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retrieveObject(Object obj, boolean fgOnly) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            ObjectProvider op = this.findObjectProvider(obj);
            if (op == null) {
                throw new NucleusUserException(Localiser.msg("010048", StringUtils.toJVMIDString(obj), this.getApiAdapter().getIdForObject(obj), "retrieve"));
            }
            op.retrieve(fgOnly);
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    /*
     * Loose catch block
     */
    public Object persistObject(Object obj, boolean merging) {
        if (obj == null) {
            return null;
        }
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            boolean allowMergeOfTransient = this.nucCtx.getConfiguration().getBooleanProperty("datanucleus.allowAttachOfTransient", false);
            if (this.getBooleanProperty("datanucleus.allowAttachOfTransient") != null) {
                allowMergeOfTransient = this.getBooleanProperty("datanucleus.allowAttachOfTransient");
            }
            if (merging && allowMergeOfTransient) {
                threadInfo.merging = true;
            }
            if (threadInfo.attachedOwnerByObject == null) {
                threadInfo.attachedOwnerByObject = new HashMap<Object, ObjectProvider>();
            }
            if (threadInfo.attachedPCById == null) {
                threadInfo.attachedPCById = new HashMap();
            }
            if (this.tx.isActive()) {
                Object object = this.persistObjectWork(obj);
                return object;
            }
            threadInfo.nontxPersistDelete = true;
            boolean success = true;
            HashSet cachedIds = this.cache != null && !this.cache.isEmpty() ? new HashSet(this.cache.keySet()) : null;
            try {
                Object object = this.persistObjectWork(obj);
                return object;
            }
            catch (RuntimeException re) {
                success = false;
                if (this.cache != null) {
                    Iterator cacheIter = this.cache.keySet().iterator();
                    while (cacheIter.hasNext()) {
                        Object id = cacheIter.next();
                        if (cachedIds != null && cachedIds.contains(id)) continue;
                        cacheIter.remove();
                    }
                }
                throw re;
            }
            finally {
                threadInfo.nontxPersistDelete = false;
                if (success) {
                    this.processNontransactionalAtomicChanges();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.releaseThreadContextInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] persistObjects(Object ... objs) {
        if (objs == null) {
            return null;
        }
        Object[] persistedObjs = new Object[objs.length];
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (threadInfo.attachedOwnerByObject == null) {
                threadInfo.attachedOwnerByObject = new HashMap<Object, ObjectProvider>();
            }
            if (threadInfo.attachedPCById == null) {
                threadInfo.attachedPCById = new HashMap();
            }
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = true;
            }
            try {
                this.getStoreManager().getPersistenceHandler().batchStart(this, StorePersistenceHandler.PersistenceBatchType.PERSIST);
                ArrayList<RuntimeException> failures = null;
                for (int i = 0; i < objs.length; ++i) {
                    try {
                        if (objs[i] == null) continue;
                        persistedObjs[i] = this.persistObjectWork(objs[i]);
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (failures == null) {
                            failures = new ArrayList<RuntimeException>();
                        }
                        failures.add(e);
                    }
                }
                if (failures != null && !failures.isEmpty()) {
                    RuntimeException e = (RuntimeException)failures.get(0);
                    if (e instanceof NucleusException && ((NucleusException)e).isFatal()) {
                        throw new NucleusFatalUserException(Localiser.msg("010039"), failures.toArray(new Exception[failures.size()]));
                    }
                    throw new NucleusUserException(Localiser.msg("010039"), failures.toArray(new Exception[failures.size()]));
                }
            }
            finally {
                this.getStoreManager().getPersistenceHandler().batchEnd(this, StorePersistenceHandler.PersistenceBatchType.PERSIST);
                if (!this.tx.isActive()) {
                    threadInfo.nontxPersistDelete = false;
                    this.processNontransactionalAtomicChanges();
                }
            }
        }
        finally {
            this.releaseThreadContextInfo();
        }
        return persistedObjs;
    }

    private Object persistObjectWork(Object obj) {
        boolean detached = this.getApiAdapter().isDetached(obj);
        Object persistedPc = this.persistObjectInternal(obj, null, null, -1, 0);
        ObjectProvider op = this.findObjectProvider(persistedPc);
        if (op != null) {
            if (this.indirectDirtyOPs.contains(op)) {
                this.dirtyOPs.add(op);
                this.indirectDirtyOPs.remove(op);
            } else if (!this.dirtyOPs.contains(op)) {
                this.dirtyOPs.add(op);
                if (this.l2CacheTxIds != null && this.nucCtx.isClassCacheable(op.getClassMetaData())) {
                    this.l2CacheTxIds.add(op.getInternalObjectId());
                }
            }
            if (this.pbrAtCommitHandler != null && this.tx.isActive() && (detached || this.getApiAdapter().isNew(persistedPc))) {
                this.pbrAtCommitHandler.addPersistedObject(op.getInternalObjectId());
            }
        }
        return persistedPc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T persistObjectInternal(T obj, FieldValues preInsertChanges, ObjectProvider ownerOP, int ownerFieldNum, int objectType) {
        if (obj == null) {
            return null;
        }
        ApiAdapter api = this.getApiAdapter();
        Object id = null;
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            ExecutionContext ec = api.getExecutionContext(obj);
            if (ec != null && ec != this) {
                throw new NucleusUserException(Localiser.msg("010007", obj));
            }
            boolean cacheable = false;
            Object persistedPc = obj;
            if (api.isDetached(obj)) {
                this.assertDetachable(obj);
                if (this.getBooleanProperty("datanucleus.CopyOnAttach").booleanValue()) {
                    persistedPc = this.attachObjectCopy(ownerOP, obj, api.getIdForObject(obj) == null);
                } else {
                    this.attachObject(ownerOP, obj, api.getIdForObject(obj) == null);
                    persistedPc = obj;
                }
            } else if (api.isTransactional(obj) && !api.isPersistent(obj)) {
                ObjectProvider op;
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("010015", StringUtils.toJVMIDString(obj)));
                }
                if ((op = this.findObjectProvider(obj)) == null) {
                    throw new NucleusUserException(Localiser.msg("010007", this.getApiAdapter().getIdForObject(obj)));
                }
                op.makePersistentTransactionalTransient();
            } else if (!api.isPersistent(obj)) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("010015", StringUtils.toJVMIDString(obj)));
                }
                boolean merged = false;
                ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
                try {
                    if (threadInfo.merging) {
                        Object transientId;
                        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(obj.getClass(), this.clr);
                        if (cmd.getIdentityType() == IdentityType.APPLICATION && (transientId = this.nucCtx.getIdentityManager().getApplicationId(obj, cmd)) != null) {
                            Object existingObj = this.findObject(transientId, true, true, cmd.getFullClassName());
                            ObjectProvider existingOP = this.findObjectProvider(existingObj);
                            existingOP.attach(obj);
                            id = transientId;
                            merged = true;
                            persistedPc = existingObj;
                        }
                        cacheable = this.nucCtx.isClassCacheable(cmd);
                    }
                }
                catch (NucleusObjectNotFoundException cmd) {
                }
                finally {
                    this.releaseThreadContextInfo();
                }
                if (!merged) {
                    ObjectProvider<T> op = this.findObjectProvider(obj);
                    if (op == null) {
                        if ((objectType == 2 || objectType == 3 || objectType == 4 || objectType == 1) && ownerOP != null) {
                            op = this.nucCtx.getObjectProviderFactory().newForEmbedded(this, obj, false, ownerOP, ownerFieldNum);
                            op.setPcObjectType((short)objectType);
                            op.makePersistent();
                            id = op.getInternalObjectId();
                        } else {
                            op = this.nucCtx.getObjectProviderFactory().newForPersistentNew(this, obj, preInsertChanges);
                            op.makePersistent();
                            id = op.getInternalObjectId();
                        }
                    } else if (op.getReferencedPC() == null) {
                        op.makePersistent();
                        id = op.getInternalObjectId();
                    } else {
                        persistedPc = op.getReferencedPC();
                    }
                    if (op != null) {
                        cacheable = this.nucCtx.isClassCacheable(op.getClassMetaData());
                    }
                }
            } else if (api.isPersistent(obj) && api.getIdForObject(obj) == null) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("010015", StringUtils.toJVMIDString(obj)));
                }
                ObjectProvider op = this.findObjectProvider(obj);
                op.makePersistent();
                id = op.getInternalObjectId();
                cacheable = this.nucCtx.isClassCacheable(op.getClassMetaData());
            } else if (api.isDeleted(obj)) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("010015", StringUtils.toJVMIDString(obj)));
                }
                ObjectProvider op = this.findObjectProvider(obj);
                op.makePersistent();
                id = op.getInternalObjectId();
                cacheable = this.nucCtx.isClassCacheable(op.getClassMetaData());
            } else if (api.isPersistent(obj) && api.isTransactional(obj) && api.isDirty(obj) && this.isDelayDatastoreOperationsEnabled()) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("010015", StringUtils.toJVMIDString(obj)));
                }
                ObjectProvider op = this.findObjectProvider(obj);
                op.makePersistent();
                id = op.getInternalObjectId();
                cacheable = this.nucCtx.isClassCacheable(op.getClassMetaData());
            }
            if (id != null && this.l2CacheTxIds != null && cacheable) {
                this.l2CacheTxIds.add(id);
            }
            T t = persistedPc;
            return t;
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public <T> T persistObjectInternal(T pc, ObjectProvider ownerOP, int ownerFieldNum, int objectType) {
        if (ownerOP != null) {
            ObjectProvider op = this.findObjectProvider(ownerOP.getObject());
            return this.persistObjectInternal(pc, null, op, ownerFieldNum, objectType);
        }
        return this.persistObjectInternal(pc, null, null, ownerFieldNum, objectType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObjects(Object ... objs) {
        if (objs == null) {
            return;
        }
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = true;
            }
            this.getStoreManager().getPersistenceHandler().batchStart(this, StorePersistenceHandler.PersistenceBatchType.DELETE);
            ArrayList<RuntimeException> failures = null;
            for (int i = 0; i < objs.length; ++i) {
                try {
                    if (objs[i] == null) continue;
                    this.deleteObjectWork(objs[i]);
                    continue;
                }
                catch (RuntimeException e) {
                    if (failures == null) {
                        failures = new ArrayList<RuntimeException>();
                    }
                    failures.add(e);
                }
            }
            if (failures != null && !failures.isEmpty()) {
                RuntimeException e = (RuntimeException)failures.get(0);
                if (e instanceof NucleusException && ((NucleusException)e).isFatal()) {
                    throw new NucleusFatalUserException(Localiser.msg("010040"), failures.toArray(new Exception[failures.size()]));
                }
                throw new NucleusUserException(Localiser.msg("010040"), failures.toArray(new Exception[failures.size()]));
            }
        }
        finally {
            this.getStoreManager().getPersistenceHandler().batchEnd(this, StorePersistenceHandler.PersistenceBatchType.DELETE);
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = false;
                this.processNontransactionalAtomicChanges();
            }
            this.releaseThreadContextInfo();
        }
    }

    @Override
    public void deleteObject(Object obj) {
        if (obj == null) {
            return;
        }
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = true;
            }
            this.deleteObjectWork(obj);
        }
        finally {
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = false;
                this.processNontransactionalAtomicChanges();
            }
            this.releaseThreadContextInfo();
        }
    }

    void deleteObjectWork(Object obj) {
        ObjectProvider op = this.findObjectProvider(obj);
        if (op == null && this.getApiAdapter().isDetached(obj)) {
            Object attachedObj = this.findObject(this.getApiAdapter().getIdForObject(obj), true, false, obj.getClass().getName());
            op = this.findObjectProvider(attachedObj);
        }
        if (op != null) {
            if (this.indirectDirtyOPs.contains(op)) {
                this.indirectDirtyOPs.remove(op);
                this.dirtyOPs.add(op);
            } else if (!this.dirtyOPs.contains(op)) {
                this.dirtyOPs.add(op);
                if (this.l2CacheTxIds != null && this.nucCtx.isClassCacheable(op.getClassMetaData())) {
                    this.l2CacheTxIds.add(op.getInternalObjectId());
                }
            }
        }
        this.deleteObjectInternal(obj);
        if (this.pbrAtCommitHandler != null && this.tx.isActive() && op != null && this.getApiAdapter().isDeleted(obj)) {
            this.pbrAtCommitHandler.addDeletedObject(op.getInternalObjectId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObjectInternal(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            ObjectProvider<Object> op;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            Object pc = obj;
            if (this.getApiAdapter().isDetached(obj)) {
                pc = this.findObject(this.getApiAdapter().getIdForObject(obj), true, true, null);
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("010019", StringUtils.toJVMIDString(pc)));
            }
            if (this.getApiAdapter().getName().equals("JDO")) {
                if (!this.getApiAdapter().isPersistent(pc) && !this.getApiAdapter().isTransactional(pc)) {
                    throw new NucleusUserException(Localiser.msg("010020"));
                }
                if (!this.getApiAdapter().isPersistent(pc) && this.getApiAdapter().isTransactional(pc)) {
                    throw new NucleusUserException(Localiser.msg("010021", this.getApiAdapter().getIdForObject(obj)));
                }
            }
            if ((op = this.findObjectProvider(pc)) == null) {
                if (!this.getApiAdapter().allowDeleteOfNonPersistentObject()) {
                    throw new NucleusUserException(Localiser.msg("010007", this.getApiAdapter().getIdForObject(pc)));
                }
                op = this.nucCtx.getObjectProviderFactory().newForPNewToBeDeleted(this, pc);
            }
            if (this.l2CacheTxIds != null && this.nucCtx.isClassCacheable(op.getClassMetaData())) {
                this.l2CacheTxIds.add(op.getInternalObjectId());
            }
            op.deletePersistent();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeObjectTransient(Object obj, FetchPlanState state) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("010022", StringUtils.toJVMIDString(obj)));
            }
            if (this.getApiAdapter().isPersistent(obj)) {
                ObjectProvider op = this.findObjectProvider(obj);
                op.makeTransient(state);
            }
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public void makeObjectTransactional(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            ObjectProvider<Object> op;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            if (this.getApiAdapter().isPersistent(obj)) {
                this.assertActiveTransaction();
            }
            if ((op = this.findObjectProvider(obj)) == null) {
                op = this.nucCtx.getObjectProviderFactory().newForTransactionalTransient(this, obj);
            }
            op.makeTransactional();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public void makeObjectNontransactional(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            if (!this.getApiAdapter().isPersistent(obj) && this.getApiAdapter().isTransactional(obj) && this.getApiAdapter().isDirty(obj)) {
                throw new NucleusUserException(Localiser.msg("010024"));
            }
            ObjectProvider op = this.findObjectProvider(obj);
            op.makeNontransactional();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public void attachObject(ObjectProvider ownerOP, Object pc, boolean sco) {
        ApiAdapter api;
        Object id;
        this.assertClassPersistable(pc.getClass());
        Map<Object, ObjectProvider> attachedOwnerByObject = this.getThreadContextInfo().attachedOwnerByObject;
        if (attachedOwnerByObject != null) {
            attachedOwnerByObject.put(pc, ownerOP);
        }
        if ((id = (api = this.getApiAdapter()).getIdForObject(pc)) != null && this.isInserting(pc)) {
            return;
        }
        if (id == null && !sco) {
            this.persistObjectInternal(pc, null, null, -1, 0);
            return;
        }
        if (api.isDetached(pc)) {
            ObjectProvider l1CachedOP;
            if (this.cache != null && (l1CachedOP = (ObjectProvider)this.cache.get(id)) != null && l1CachedOP.getObject() != pc) {
                throw new NucleusUserException(Localiser.msg("010017", StringUtils.toJVMIDString(pc)));
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("010016", StringUtils.toJVMIDString(pc)));
            }
        } else {
            return;
        }
        ObjectProvider<Object> op = this.nucCtx.getObjectProviderFactory().newForDetached(this, pc, id, api.getVersionForObject(pc));
        op.attach(sco);
    }

    @Override
    public <T> T attachObjectCopy(ObjectProvider ownerOP, T pc, boolean sco) {
        ApiAdapter api;
        Object id;
        this.assertClassPersistable(pc.getClass());
        this.assertDetachable(pc);
        Map<Object, ObjectProvider> attachedOwnerByObject = this.getThreadContextInfo().attachedOwnerByObject;
        if (attachedOwnerByObject != null) {
            attachedOwnerByObject.put(pc, ownerOP);
        }
        if ((id = (api = this.getApiAdapter()).getIdForObject(pc)) != null && this.isInserting(pc)) {
            return pc;
        }
        if (id == null && !sco) {
            return this.persistObjectInternal(pc, null, null, -1, 0);
        }
        if (api.isPersistent(pc)) {
            return pc;
        }
        Object pcTarget = null;
        if (sco) {
            boolean detached = this.getApiAdapter().isDetached(pc);
            ObjectProvider<T> targetOP = this.nucCtx.getObjectProviderFactory().newForEmbedded(this, pc, true, null, -1);
            pcTarget = targetOP.getObject();
            if (detached) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("010018", StringUtils.toJVMIDString(pc), StringUtils.toJVMIDString(pcTarget)));
                }
                targetOP.attachCopy(pc, sco);
            }
        } else {
            boolean detached = this.getApiAdapter().isDetached(pc);
            pcTarget = this.findObject(id, false, false, pc.getClass().getName());
            if (detached) {
                Object obj = null;
                Map attachedPCById = this.getThreadContextInfo().attachedPCById;
                if (attachedPCById != null) {
                    obj = attachedPCById.get(this.getApiAdapter().getIdForObject(pc));
                }
                if (obj != null) {
                    pcTarget = obj;
                } else {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(Localiser.msg("010018", StringUtils.toJVMIDString(pc), StringUtils.toJVMIDString(pcTarget)));
                    }
                    pcTarget = this.findObjectProvider(pcTarget).attachCopy(pc, sco);
                    if (attachedPCById != null) {
                        attachedPCById.put(this.getApiAdapter().getIdForObject(pc), pcTarget);
                    }
                }
            }
        }
        return (T)pcTarget;
    }

    @Override
    public void detachObject(FetchPlanState state, Object obj) {
        ObjectProvider op;
        if (this.getApiAdapter().isDetached(obj)) {
            return;
        }
        if (!this.getApiAdapter().isPersistent(obj)) {
            if (this.runningDetachAllOnTxnEnd && !this.getMetaDataManager().getMetaDataForClass(obj.getClass(), this.clr).isDetachable()) {
                return;
            }
            if (this.tx.isActive()) {
                this.persistObjectInternal(obj, null, null, -1, 0);
            }
        }
        if ((op = this.findObjectProvider(obj)) == null) {
            throw new NucleusUserException(Localiser.msg("010007", this.getApiAdapter().getIdForObject(obj)));
        }
        op.detach(state);
        if (this.dirtyOPs.contains(op) || this.indirectDirtyOPs.contains(op)) {
            NucleusLogger.GENERAL.info(Localiser.msg("010047", StringUtils.toJVMIDString(obj)));
            this.clearDirty(op);
        }
    }

    @Override
    public void detachObjects(FetchPlanState state, Object ... pcs) {
        if (pcs == null || pcs.length == 0) {
            return;
        }
        HashSet<ObjectProvider> opsToDetach = new HashSet<ObjectProvider>();
        for (Object pc : pcs) {
            ObjectProvider op;
            if (this.getApiAdapter().isDetached(pc)) continue;
            if (!this.getApiAdapter().isPersistent(pc)) {
                if (this.runningDetachAllOnTxnEnd && !this.getMetaDataManager().getMetaDataForClass(pc.getClass(), this.clr).isDetachable()) continue;
                if (this.tx.isActive()) {
                    this.persistObjectInternal(pc, null, null, -1, 0);
                }
            }
            if ((op = this.findObjectProvider(pc)) == null) continue;
            opsToDetach.add(op);
        }
        for (ObjectProvider op : opsToDetach) {
            op.detach(state);
            if (!this.dirtyOPs.contains(op) && !this.indirectDirtyOPs.contains(op)) continue;
            NucleusLogger.GENERAL.info(Localiser.msg("010047", StringUtils.toJVMIDString(op.getObject())));
            this.clearDirty(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T detachObjectCopy(FetchPlanState state, T pc) {
        Object thePC = pc;
        try {
            ObjectProvider op;
            this.clr.setPrimary(pc.getClass().getClassLoader());
            if (!this.getApiAdapter().isPersistent(pc) && !this.getApiAdapter().isDetached(pc)) {
                if (this.tx.isActive()) {
                    thePC = this.persistObjectInternal(pc, null, null, -1, 0);
                } else {
                    throw new NucleusUserException(Localiser.msg("010014"));
                }
            }
            if (this.getApiAdapter().isDetached(thePC)) {
                thePC = this.findObject(this.getApiAdapter().getIdForObject(thePC), false, true, null);
            }
            if ((op = this.findObjectProvider(thePC)) == null) {
                throw new NucleusUserException(Localiser.msg("010007", this.getApiAdapter().getIdForObject(thePC)));
            }
            Object t = op.detachCopy(state);
            return t;
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public void detachAll() {
        HashSet<ObjectProvider> opsToDetach = new HashSet<ObjectProvider>(this.enlistedOPCache.values());
        if (this.cache != null && !this.cache.isEmpty()) {
            opsToDetach.addAll(this.cache.values());
        }
        FetchPlanState fps = new FetchPlanState();
        for (ObjectProvider op : opsToDetach) {
            op.detach(fps);
        }
    }

    @Override
    public Object getAttachDetachReferencedObject(ObjectProvider op) {
        if (this.opAttachDetachObjectReferenceMap == null) {
            return null;
        }
        return this.opAttachDetachObjectReferenceMap.get(op);
    }

    @Override
    public void setAttachDetachReferencedObject(ObjectProvider op, Object obj) {
        if (obj != null) {
            if (this.opAttachDetachObjectReferenceMap == null) {
                this.opAttachDetachObjectReferenceMap = new HashMap<ObjectProvider, Object>();
            }
            this.opAttachDetachObjectReferenceMap.put(op, obj);
        } else if (this.opAttachDetachObjectReferenceMap != null) {
            this.opAttachDetachObjectReferenceMap.remove(op);
        }
    }

    @Override
    public <T> T newInstance(Class<T> cls) {
        if (this.getApiAdapter().isPersistable(cls) && !Modifier.isAbstract(cls.getModifiers())) {
            try {
                return cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new NucleusUserException(e.toString(), e);
            }
        }
        this.assertHasImplementationCreator();
        return this.getNucleusContext().getImplementationCreator().newInstance(cls, this.clr);
    }

    @Override
    public boolean exists(Object obj) {
        if (obj == null) {
            return false;
        }
        Object id = this.getApiAdapter().getIdForObject(obj);
        if (id == null) {
            return false;
        }
        try {
            this.findObject(id, true, false, obj.getClass().getName());
        }
        catch (NucleusObjectNotFoundException onfe) {
            return false;
        }
        return true;
    }

    @Override
    public Set getManagedObjects() {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet objs = new HashSet();
        for (ObjectProvider op : this.enlistedOPCache.values()) {
            objs.add(op.getObject());
        }
        return objs;
    }

    @Override
    public Set getManagedObjects(Class[] classes) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet objs = new HashSet();
        block0: for (ObjectProvider op : this.enlistedOPCache.values()) {
            for (int i = 0; i < classes.length; ++i) {
                if (classes[i] != op.getObject().getClass()) continue;
                objs.add(op.getObject());
                continue block0;
            }
        }
        return objs;
    }

    @Override
    public Set getManagedObjects(String[] states) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet objs = new HashSet();
        block0: for (ObjectProvider op : this.enlistedOPCache.values()) {
            for (int i = 0; i < states.length; ++i) {
                if (!this.getApiAdapter().getObjectState(op.getObject()).equals(states[i])) continue;
                objs.add(op.getObject());
                continue block0;
            }
        }
        return objs;
    }

    @Override
    public Set getManagedObjects(String[] states, Class[] classes) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet objs = new HashSet();
        block0: for (ObjectProvider op : this.enlistedOPCache.values()) {
            boolean matches = false;
            for (int i = 0; i < states.length; ++i) {
                if (this.getApiAdapter().getObjectState(op.getObject()).equals(states[i])) {
                    for (int j = 0; j < classes.length; ++j) {
                        if (classes[j] != op.getObject().getClass()) continue;
                        matches = true;
                        objs.add(op.getObject());
                        break;
                    }
                }
                if (matches) continue block0;
            }
        }
        return objs;
    }

    @Override
    public <T> T findObject(Class<T> cls, Object key) {
        if (cls == null || key == null) {
            throw new NucleusUserException(Localiser.msg("010051", cls, key));
        }
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(cls, this.clr);
        if (cmd == null) {
            throw new NucleusUserException(Localiser.msg("010052", cls.getName()));
        }
        Object id = key;
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            if (!IdentityUtils.isDatastoreIdentity(key)) {
                id = this.nucCtx.getIdentityManager().getDatastoreId(cmd.getFullClassName(), key);
            }
        } else if (!cmd.getObjectidClass().equals(key.getClass().getName())) {
            try {
                id = this.newObjectId(cls, key);
            }
            catch (NucleusException ne) {
                throw new IllegalArgumentException(ne);
            }
        }
        return (T)this.findObject(id, true, true, null);
    }

    @Override
    public <T> List<T> findObjects(Class<T> cls, List keys) {
        if (cls == null || keys == null) {
            throw new NucleusUserException(Localiser.msg("010051", cls, keys));
        }
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(cls, this.clr);
        if (cmd == null) {
            throw new NucleusUserException(Localiser.msg("010052", cls.getName()));
        }
        ArrayList<Object> objs = new ArrayList<Object>();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key;
            Object id = key = iterator.next();
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                if (!IdentityUtils.isDatastoreIdentity(key)) {
                    id = this.nucCtx.getIdentityManager().getDatastoreId(cmd.getFullClassName(), key);
                }
            } else if (!cmd.getObjectidClass().equals(key.getClass().getName())) {
                try {
                    id = this.newObjectId(cls, key);
                }
                catch (NucleusException ne) {
                    throw new IllegalArgumentException(ne);
                }
            }
            objs.add(this.findObject(id, true, true, null));
        }
        return objs;
    }

    @Override
    public <T> T findObjectByUnique(Class<T> cls, String[] memberNames, Object[] memberValues) {
        if (cls == null || memberNames == null || memberNames.length == 0 || memberValues == null || memberValues.length == 0) {
            throw new NucleusUserException(Localiser.msg("010053", cls, StringUtils.objectArrayToString(memberNames), StringUtils.objectArrayToString(memberValues)));
        }
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(cls, this.clr);
        if (cmd == null) {
            throw new NucleusUserException(Localiser.msg("010052", cls.getName()));
        }
        for (String memberName : memberNames) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForMember(memberName);
            if (mmd != null) continue;
            throw new NucleusUserException("Attempt to find object using unique key of class " + cmd.getFullClassName() + " but field " + memberName + " doesnt exist!");
        }
        CacheUniqueKey uniKey = new CacheUniqueKey(cls.getName(), memberNames, memberValues);
        ObjectProvider op = this.cache.getUnique(uniKey);
        if (op == null && this.l2CacheEnabled) {
            Object pc;
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(Localiser.msg("003007", uniKey));
            }
            if ((pc = this.getObjectFromLevel2CacheForUnique(uniKey)) != null) {
                op = this.findObjectProvider(pc);
            }
        }
        if (op != null) {
            return op.getObject();
        }
        return (T)this.getStoreManager().getPersistenceHandler().findObjectForUnique(this, cmd, memberNames, memberValues);
    }

    @Override
    public Object findObject(Object id, boolean validate) {
        return this.findObject(id, validate, validate, null);
    }

    @Override
    public Object findObject(Object id, FieldValues fv, Class cls, boolean ignoreCache, boolean checkInheritance) {
        this.assertIsOpen();
        Object pc = null;
        ObjectProvider op = null;
        if (!ignoreCache) {
            pc = this.getObjectFromCache(id);
        }
        if (pc == null) {
            pc = this.getStoreManager().getPersistenceHandler().findObject(this, id);
        }
        boolean createdHollow = false;
        if (pc == null) {
            String className;
            String string = className = cls != null ? cls.getName() : null;
            if (!(id instanceof SCOID)) {
                ClassDetailsForId details = this.getClassDetailsForId(id, className, checkInheritance);
                if (details.className != null && cls != null && !cls.getName().equals(details.className)) {
                    cls = this.clr.classForName(details.className);
                }
                className = details.className;
                id = details.id;
                if (details.pc != null) {
                    pc = details.pc;
                    op = this.findObjectProvider(pc);
                }
            }
            if (pc == null) {
                if (cls == null) {
                    try {
                        cls = this.clr.classForName(className, id.getClass().getClassLoader());
                    }
                    catch (ClassNotResolvedException e) {
                        String msg = Localiser.msg("010027", IdentityUtils.getPersistableIdentityForId(id));
                        NucleusLogger.PERSISTENCE.warn(msg);
                        throw new NucleusUserException(msg, e);
                    }
                }
                createdHollow = true;
                op = this.nucCtx.getObjectProviderFactory().newForHollow(this, cls, id, fv);
                pc = op.getObject();
                this.putObjectIntoLevel2Cache(op, false);
            }
        }
        if (pc != null && fv != null && !createdHollow) {
            if (op == null) {
                op = this.findObjectProvider(pc);
            }
            if (op != null) {
                fv.fetchNonLoadedFields(op);
            }
        }
        return pc;
    }

    @Override
    public Object[] findObjectsById(Object[] identities, boolean validate) {
        Iterator<Object> pc3;
        Map pcsById;
        if (identities == null) {
            return null;
        }
        if (identities.length == 1) {
            return new Object[]{this.findObject(identities[0], validate, validate, null)};
        }
        for (int i = 0; i < identities.length; ++i) {
            if (identities[i] != null) continue;
            throw new NucleusUserException(Localiser.msg("010044"));
        }
        Object[] ids = new Object[identities.length];
        for (int i = 0; i < identities.length; ++i) {
            IdentityStringTranslator idStringTranslator;
            ids[i] = identities[i] instanceof String && (idStringTranslator = this.getNucleusContext().getIdentityManager().getIdentityStringTranslator()) != null ? idStringTranslator.getIdentity(this, (String)identities[i]) : identities[i];
        }
        HashMap<Object, Object> pcById = new HashMap<Object, Object>(identities.length);
        ArrayList<Object> idsToFind = new ArrayList<Object>();
        ApiAdapter api = this.getApiAdapter();
        for (int i = 0; i < ids.length; ++i) {
            Object pc2 = this.getObjectFromLevel1Cache(ids[i]);
            if (pc2 != null) {
                if (ids[i] instanceof SCOID && api.isPersistent(pc2) && !api.isNew(pc2) && !api.isDeleted(pc2) && !api.isTransactional(pc2)) {
                    throw new NucleusUserException(Localiser.msg("010005"));
                }
                pcById.put(ids[i], pc2);
                continue;
            }
            idsToFind.add(ids[i]);
        }
        if (!idsToFind.isEmpty() && this.l2CacheEnabled && !(pcsById = this.getObjectsFromLevel2Cache(idsToFind)).isEmpty()) {
            for (Map.Entry entry : pcsById.entrySet()) {
                pcById.put(entry.getKey(), entry.getValue());
                idsToFind.remove(entry.getKey());
            }
        }
        boolean performValidationWhenCached = this.nucCtx.getConfiguration().getBooleanProperty("datanucleus.findObject.validateWhenCached");
        ArrayList opsToValidate = new ArrayList();
        if (validate && performValidationWhenCached) {
            Collection pcValues = pcById.values();
            for (Iterator<Object> pc3 : pcValues) {
                if (api.isTransactional(pc3)) continue;
                ObjectProvider op = this.findObjectProvider(pc3);
                opsToValidate.add(op);
            }
        }
        Object[] foundPcs = null;
        if (!idsToFind.isEmpty()) {
            foundPcs = this.getStoreManager().getPersistenceHandler().findObjects(this, idsToFind.toArray());
        }
        int foundPcIdx = 0;
        pc3 = idsToFind.iterator();
        while (pc3.hasNext()) {
            Object id;
            Object idOrig = id = pc3.next();
            Object pc4 = foundPcs != null ? foundPcs[foundPcIdx++] : null;
            ObjectProvider op = null;
            if (pc4 != null) {
                op = this.findObjectProvider(pc4);
                this.putObjectIntoLevel1Cache(op);
            } else {
                ClassDetailsForId details = this.getClassDetailsForId(id, null, validate);
                String className = details.className;
                id = details.id;
                if (details.pc != null) {
                    pc4 = details.pc;
                    op = this.findObjectProvider(pc4);
                    if (performValidationWhenCached && validate && !api.isTransactional(pc4)) {
                        opsToValidate.add(op);
                    }
                } else {
                    try {
                        Class pcClass = this.clr.classForName(className, id instanceof DatastoreId ? null : id.getClass().getClassLoader());
                        if (Modifier.isAbstract(pcClass.getModifiers())) {
                            throw new NucleusObjectNotFoundException(Localiser.msg("010027", IdentityUtils.getPersistableIdentityForId(id), className));
                        }
                        op = this.nucCtx.getObjectProviderFactory().newForHollow(this, pcClass, id);
                        pc4 = op.getObject();
                        if (!validate) {
                            op.markForInheritanceValidation();
                        }
                        this.putObjectIntoLevel1Cache(op);
                    }
                    catch (ClassNotResolvedException e) {
                        NucleusLogger.PERSISTENCE.warn(Localiser.msg("010027", IdentityUtils.getPersistableIdentityForId(id)));
                        throw new NucleusUserException(Localiser.msg("010027", IdentityUtils.getPersistableIdentityForId(id)), e);
                    }
                    if (validate) {
                        opsToValidate.add(op);
                    }
                }
            }
            pcById.put(idOrig, pc4);
        }
        if (!opsToValidate.isEmpty()) {
            try {
                this.getStoreManager().getPersistenceHandler().locateObjects(opsToValidate.toArray(new ObjectProvider[opsToValidate.size()]));
            }
            catch (NucleusObjectNotFoundException nonfe) {
                NucleusObjectNotFoundException[] nonfes = (NucleusObjectNotFoundException[])nonfe.getNestedExceptions();
                if (nonfes != null) {
                    for (int i = 0; i < nonfes.length; ++i) {
                        Object missingId = nonfes[i].getFailedObject();
                        this.removeObjectFromLevel1Cache(missingId);
                    }
                }
                throw nonfe;
            }
        }
        Object[] objs = new Object[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            Object id = ids[i];
            objs[i] = pcById.get(id);
        }
        return objs;
    }

    @Override
    public Object findObject(Object id, boolean validate, boolean checkInheritance, String objectClassName) {
        if (id == null) {
            throw new NucleusUserException(Localiser.msg("010044"));
        }
        IdentityStringTranslator translator = this.getNucleusContext().getIdentityManager().getIdentityStringTranslator();
        if (translator != null && id instanceof String) {
            id = translator.getIdentity(this, (String)id);
        }
        ApiAdapter api = this.getApiAdapter();
        boolean fromCache = false;
        Object pc = this.getObjectFromCache(id);
        ObjectProvider op = null;
        if (pc != null) {
            fromCache = true;
            if (id instanceof SCOID && api.isPersistent(pc) && !api.isNew(pc) && !api.isDeleted(pc) && !api.isTransactional(pc)) {
                throw new NucleusUserException(Localiser.msg("010005"));
            }
            if (api.isTransactional(pc)) {
                return pc;
            }
            op = this.findObjectProvider(pc);
        } else {
            pc = this.getStoreManager().getPersistenceHandler().findObject(this, id);
            if (pc != null) {
                op = this.findObjectProvider(pc);
                this.putObjectIntoLevel1Cache(op);
                this.putObjectIntoLevel2Cache(op, false);
            } else {
                ClassDetailsForId details = this.getClassDetailsForId(id, objectClassName, checkInheritance);
                String className = details.className;
                id = details.id;
                if (details.pc != null) {
                    pc = details.pc;
                    op = this.findObjectProvider(pc);
                    fromCache = true;
                } else {
                    try {
                        Class pcClass = this.clr.classForName(className, id instanceof DatastoreId ? null : id.getClass().getClassLoader());
                        if (Modifier.isAbstract(pcClass.getModifiers())) {
                            throw new NucleusObjectNotFoundException(Localiser.msg("010027", IdentityUtils.getPersistableIdentityForId(id), className));
                        }
                        op = this.nucCtx.getObjectProviderFactory().newForHollow(this, pcClass, id);
                        pc = op.getObject();
                        if (!checkInheritance && !validate) {
                            op.markForInheritanceValidation();
                        }
                        this.putObjectIntoLevel1Cache(op);
                    }
                    catch (ClassNotResolvedException e) {
                        NucleusLogger.PERSISTENCE.warn(Localiser.msg("010027", IdentityUtils.getPersistableIdentityForId(id)));
                        throw new NucleusUserException(Localiser.msg("010027", IdentityUtils.getPersistableIdentityForId(id)), e);
                    }
                }
            }
        }
        boolean performValidationWhenCached = this.nucCtx.getConfiguration().getBooleanProperty("datanucleus.findObject.validateWhenCached");
        if (validate && (!fromCache || performValidationWhenCached)) {
            if (!fromCache) {
                this.putObjectIntoLevel1Cache(op);
            }
            try {
                op.validate();
                if (op.getObject() != pc) {
                    fromCache = false;
                    pc = op.getObject();
                    this.putObjectIntoLevel1Cache(op);
                }
            }
            catch (NucleusObjectNotFoundException onfe) {
                this.removeObjectFromLevel1Cache(op.getInternalObjectId());
                throw onfe;
            }
        }
        if (!fromCache) {
            this.putObjectIntoLevel2Cache(op, false);
        }
        return pc;
    }

    private ClassDetailsForId getClassDetailsForId(Object id, String objectClassName, boolean checkInheritance) {
        String className = null;
        String originalClassName = null;
        boolean checkedClassName = false;
        if (id instanceof SCOID) {
            throw new NucleusUserException(Localiser.msg("010006"));
        }
        if (id instanceof DatastoreUniqueLongId) {
            throw new NucleusObjectNotFoundException(Localiser.msg("010026"), id);
        }
        originalClassName = objectClassName != null ? objectClassName : this.getStoreManager().manageClassForIdentity(id, this.clr);
        if (originalClassName == null) {
            originalClassName = this.getClassNameForObjectId(id);
            checkedClassName = true;
        }
        Object pc = null;
        if (checkInheritance) {
            String[] subclasses;
            String string = className = checkedClassName ? originalClassName : this.getClassNameForObjectId(id);
            if (className == null) {
                throw new NucleusObjectNotFoundException(Localiser.msg("010026"), id);
            }
            if (!checkedClassName && (IdentityUtils.isDatastoreIdentity(id) || IdentityUtils.isSingleFieldIdentity(id)) && (subclasses = this.getMetaDataManager().getSubclassesForClass(className, true)) != null) {
                for (int i = 0; i < subclasses.length; ++i) {
                    Object oid = null;
                    if (IdentityUtils.isDatastoreIdentity(id)) {
                        oid = this.nucCtx.getIdentityManager().getDatastoreId(subclasses[i], IdentityUtils.getTargetKeyForDatastoreIdentity(id));
                    } else if (IdentityUtils.isSingleFieldIdentity(id)) {
                        oid = this.nucCtx.getIdentityManager().getSingleFieldId(id.getClass(), this.getClassLoaderResolver().classForName(subclasses[i]), IdentityUtils.getTargetKeyForSingleFieldIdentity(id));
                    }
                    pc = this.getObjectFromCache(oid);
                    if (pc == null) continue;
                    className = subclasses[i];
                    break;
                }
            }
            if (pc == null && originalClassName != null && !originalClassName.equals(className)) {
                if (IdentityUtils.isDatastoreIdentity(id)) {
                    id = this.nucCtx.getIdentityManager().getDatastoreId(className, ((DatastoreId)id).getKeyAsObject());
                    pc = this.getObjectFromCache(id);
                } else if (IdentityUtils.isSingleFieldIdentity(id)) {
                    id = this.nucCtx.getIdentityManager().getSingleFieldId(id.getClass(), this.clr.classForName(className), IdentityUtils.getTargetKeyForSingleFieldIdentity(id));
                    pc = this.getObjectFromCache(id);
                }
            }
        } else {
            className = originalClassName;
        }
        return new ClassDetailsForId(id, className, pc);
    }

    private String getClassNameForObjectId(Object id) {
        Collection<AbstractClassMetaData> cmds;
        String className = this.getStoreManager().manageClassForIdentity(id, this.clr);
        if (className == null && (cmds = this.getMetaDataManager().getClassMetaDataWithApplicationId(id.getClass().getName())) != null && cmds.size() == 1) {
            return cmds.iterator().next().getFullClassName();
        }
        if (className != null) {
            Class rootCls;
            String[] subclasses = this.getMetaDataManager().getConcreteSubclassesForClass(className);
            int numConcrete = 0;
            String concreteClassName = null;
            if (subclasses != null && subclasses.length > 0) {
                numConcrete = subclasses.length;
                concreteClassName = subclasses[0];
            }
            if (!Modifier.isAbstract((rootCls = this.clr.classForName(className)).getModifiers())) {
                concreteClassName = className;
                ++numConcrete;
            }
            if (numConcrete == 1) {
                return concreteClassName;
            }
        }
        return this.getStoreManager().getClassNameForObjectID(id, this.clr, this);
    }

    @Override
    public Object newObjectId(Class pcClass, Object key) {
        IdentityKeyTranslator translator;
        if (pcClass == null) {
            throw new NucleusUserException(Localiser.msg("010028"));
        }
        this.assertClassPersistable(pcClass);
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(pcClass, this.clr);
        if (cmd == null) {
            throw new NoPersistenceInformationException(pcClass.getName());
        }
        if (!this.getStoreManager().managesClass(cmd.getFullClassName())) {
            this.getStoreManager().manageClasses(this.clr, cmd.getFullClassName());
        }
        if ((translator = this.getNucleusContext().getIdentityManager().getIdentityKeyTranslator()) != null) {
            key = translator.getKey(this, pcClass, key);
        }
        Object id = null;
        if (cmd.usesSingleFieldIdentityClass()) {
            Object convKey;
            AbstractMemberMetaData mmd;
            if (this.getBooleanProperty("datanucleus.findObject.typeConversion").booleanValue() && translator == null && !key.getClass().getName().equals(cmd.getObjectidClass()) && !(mmd = cmd.getMetaDataForMember(cmd.getPrimaryKeyMemberNames()[0])).getType().isAssignableFrom(key.getClass()) && (convKey = TypeConversionHelper.convertTo(key, mmd.getType())) != null) {
                key = convKey;
            }
            id = this.nucCtx.getIdentityManager().getSingleFieldId(this.clr.classForName(cmd.getObjectidClass()), pcClass, key);
        } else if (key instanceof String) {
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                if (Modifier.isAbstract(pcClass.getModifiers()) && cmd.getObjectidClass() != null) {
                    try {
                        Constructor c = this.clr.classForName(cmd.getObjectidClass()).getDeclaredConstructor(String.class);
                        id = c.newInstance((String)key);
                    }
                    catch (Exception e) {
                        String msg = Localiser.msg("010030", cmd.getObjectidClass(), cmd.getFullClassName());
                        NucleusLogger.PERSISTENCE.error(msg, e);
                        throw new NucleusUserException(msg);
                    }
                } else {
                    this.clr.classForName(pcClass.getName(), true);
                    id = this.nucCtx.getIdentityManager().getApplicationId(pcClass, key);
                }
            } else {
                id = this.nucCtx.getIdentityManager().getDatastoreId((String)key);
            }
        } else {
            throw new NucleusUserException(Localiser.msg("010029", pcClass.getName(), key.getClass().getName()));
        }
        return id;
    }

    @Override
    public Object newObjectId(String className, Object pc) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, this.clr);
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            return this.nucCtx.getIdentityManager().getDatastoreId(cmd.getFullClassName(), this.getStoreManager().getValueGenerationStrategyValue(this, cmd, -1));
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            return this.nucCtx.getIdentityManager().getApplicationId(pc, cmd);
        }
        return new SCOID(className);
    }

    @Override
    public void clearDirty(ObjectProvider op) {
        this.dirtyOPs.remove(op);
        this.indirectDirtyOPs.remove(op);
    }

    @Override
    public void clearDirty() {
        this.dirtyOPs.clear();
        this.indirectDirtyOPs.clear();
    }

    @Override
    public void markDirty(ObjectProvider op, boolean directUpdate) {
        if (this.tx.isCommitting() && !this.tx.isActive()) {
            throw new NucleusException("Cannot change objects when transaction is no longer active.");
        }
        boolean isInDirty = this.dirtyOPs.contains(op);
        boolean isInIndirectDirty = this.indirectDirtyOPs.contains(op);
        if (!(this.isDelayDatastoreOperationsEnabled() || isInDirty || isInIndirectDirty || this.dirtyOPs.size() < this.getNucleusContext().getConfiguration().getIntProperty("datanucleus.flush.auto.objectLimit"))) {
            this.flushInternal(false);
        }
        if (directUpdate) {
            if (isInIndirectDirty) {
                this.indirectDirtyOPs.remove(op);
                this.dirtyOPs.add(op);
            } else if (!isInDirty) {
                this.dirtyOPs.add(op);
                if (this.l2CacheTxIds != null && this.nucCtx.isClassCacheable(op.getClassMetaData())) {
                    this.l2CacheTxIds.add(op.getInternalObjectId());
                }
            }
        } else if (!isInDirty && !isInIndirectDirty) {
            this.indirectDirtyOPs.add(op);
            if (this.l2CacheTxIds != null && this.nucCtx.isClassCacheable(op.getClassMetaData())) {
                this.l2CacheTxIds.add(op.getInternalObjectId());
            }
        }
    }

    @Override
    public boolean getManageRelations() {
        return this.managedRelationsHandler != null;
    }

    @Override
    public RelationshipManager getRelationshipManager(ObjectProvider op) {
        return this.managedRelationsHandler != null ? this.managedRelationsHandler.getRelationshipManagerForObjectProvider(op) : null;
    }

    @Override
    public boolean isManagingRelations() {
        return this.managedRelationsHandler != null ? this.managedRelationsHandler.isExecuting() : false;
    }

    @Override
    public List<ObjectProvider> getObjectsToBeFlushed() {
        ArrayList<ObjectProvider> ops = new ArrayList<ObjectProvider>();
        ops.addAll(this.dirtyOPs);
        ops.addAll(this.indirectDirtyOPs);
        return ops;
    }

    @Override
    public boolean isFlushing() {
        return this.flushing > 0;
    }

    @Override
    public void flush() {
        if (this.tx.isActive()) {
            if (this.managedRelationsHandler != null) {
                this.managedRelationsHandler.execute();
            }
            this.flushInternal(true);
            if (!this.dirtyOPs.isEmpty() || !this.indirectDirtyOPs.isEmpty()) {
                NucleusLogger.PERSISTENCE.debug("Flush pass 1 resulted in " + (this.dirtyOPs.size() + this.indirectDirtyOPs.size()) + " additional objects being made dirty. Performing flush pass 2");
                this.flushInternal(true);
            }
            if (this.operationQueue != null && !this.operationQueue.getOperations().isEmpty()) {
                NucleusLogger.PERSISTENCE.warn("Queue of operations after flush() is not empty! Generate a testcase and report this. See below (debug) for full details of unflushed ops");
                this.operationQueue.log();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushInternal(boolean flushToDatastore) {
        if (!flushToDatastore && this.dirtyOPs.isEmpty() && this.indirectDirtyOPs.isEmpty()) {
            return;
        }
        if (!this.tx.isActive()) {
            if (this.nontxProcessedOPs == null) {
                this.nontxProcessedOPs = new HashSet<ObjectProvider>();
            }
            this.nontxProcessedOPs.addAll(this.dirtyOPs);
            this.nontxProcessedOPs.addAll(this.indirectDirtyOPs);
        }
        ++this.flushing;
        try {
            if (flushToDatastore) {
                this.tx.preFlush();
            }
            FlushProcess flusher = this.getStoreManager().getFlushProcess();
            List<NucleusOptimisticException> optimisticFailures = flusher.execute(this, this.dirtyOPs, this.indirectDirtyOPs, this.operationQueue);
            if (flushToDatastore) {
                this.tx.flush();
            }
            if (optimisticFailures != null) {
                throw new NucleusOptimisticException(Localiser.msg("010031"), optimisticFailures.toArray(new Throwable[optimisticFailures.size()]));
            }
        }
        finally {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("010004"));
            }
            --this.flushing;
        }
    }

    @Override
    public OperationQueue getOperationQueue() {
        return this.operationQueue;
    }

    @Override
    public void addOperationToQueue(Operation oper) {
        if (this.operationQueue == null) {
            this.operationQueue = new OperationQueue();
        }
        this.operationQueue.enqueue(oper);
    }

    @Override
    public void flushOperationsForBackingStore(Store backingStore, ObjectProvider op) {
        if (this.operationQueue != null) {
            this.operationQueue.performAll(backingStore, op);
        }
    }

    @Override
    public boolean operationQueueIsActive() {
        return this.isDelayDatastoreOperationsEnabled() && !this.isFlushing() && this.getTransaction().isActive();
    }

    public void postBegin() {
        int i;
        ObjectProvider[] ops = this.dirtyOPs.toArray(new ObjectProvider[this.dirtyOPs.size()]);
        for (i = 0; i < ops.length; ++i) {
            ops[i].preBegin(this.tx);
        }
        ops = this.indirectDirtyOPs.toArray(new ObjectProvider[this.indirectDirtyOPs.size()]);
        for (i = 0; i < ops.length; ++i) {
            ops[i].preBegin(this.tx);
        }
    }

    public void preCommit() {
        if (this.cache != null && !this.cache.isEmpty()) {
            HashSet cachedOPs = new HashSet(this.cache.values());
            for (ObjectProvider cachedOP : cachedOPs) {
                LockMode lockMode = this.getLockManager().getLockMode(cachedOP);
                if (cachedOP != null && cachedOP.isFlushedToDatastore() && cachedOP.getClassMetaData().isVersioned() && (lockMode == LockMode.LOCK_OPTIMISTIC_WRITE || lockMode == LockMode.LOCK_PESSIMISTIC_WRITE)) {
                    VersionMetaData vermd = cachedOP.getClassMetaData().getVersionMetaDataForClass();
                    if (vermd == null) continue;
                    if (vermd.getFieldName() != null) {
                        cachedOP.makeDirty((Persistable)cachedOP.getObject(), vermd.getFieldName());
                        this.dirtyOPs.add(cachedOP);
                        continue;
                    }
                    NucleusLogger.PERSISTENCE.warn("We do not support forced version update with surrogate version columns : " + cachedOP);
                    continue;
                }
                if (cachedOP != null) continue;
                NucleusLogger.CACHE.error(">> EC.preCommit L1Cache op IS NULL!");
            }
        }
        this.flush();
        if (this.pbrAtCommitHandler != null) {
            try {
                this.pbrAtCommitHandler.execute();
            }
            catch (Throwable t) {
                NucleusLogger.PERSISTENCE.error(t);
                if (t instanceof NucleusException) {
                    throw (NucleusException)t;
                }
                throw new NucleusException("Unexpected error during precommit", t);
            }
        }
        if (this.l2CacheEnabled) {
            this.performLevel2CacheUpdateAtCommit();
        }
        if (this.properties.getFrequentProperties().getDetachAllOnCommit().booleanValue()) {
            this.performDetachAllOnTxnEndPreparation();
        }
    }

    @Override
    public boolean isObjectModifiedInTransaction(Object id) {
        if (this.l2CacheTxIds != null) {
            return this.l2CacheTxIds.contains(id);
        }
        return false;
    }

    @Override
    public void markFieldsForUpdateInLevel2Cache(Object id, boolean[] fields) {
        if (this.l2CacheTxFieldsToUpdateById == null) {
            return;
        }
        BitSet bits = this.l2CacheTxFieldsToUpdateById.get(id);
        if (bits == null) {
            bits = new BitSet();
            this.l2CacheTxFieldsToUpdateById.put(id, bits);
        }
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i]) continue;
            bits.set(i);
        }
    }

    private void performLevel2CacheUpdateAtCommit() {
        if (this.l2CacheTxIds == null) {
            return;
        }
        String cacheStoreMode = this.getLevel2CacheStoreMode();
        if ("bypass".equalsIgnoreCase(cacheStoreMode)) {
            return;
        }
        HashSet<ObjectProvider> opsToCache = null;
        HashSet<Object> idsToRemove = null;
        for (Object id : this.l2CacheTxIds) {
            ObjectProvider op = this.enlistedOPCache.get(id);
            if (op == null) {
                if (NucleusLogger.CACHE.isDebugEnabled() && this.nucCtx.getLevel2Cache().containsOid(id)) {
                    NucleusLogger.CACHE.debug(Localiser.msg("004014", id));
                }
                if (idsToRemove == null) {
                    idsToRemove = new HashSet<Object>();
                }
                idsToRemove.add(id);
                continue;
            }
            Object obj = op.getObject();
            Object objID = this.getApiAdapter().getIdForObject(obj);
            if (objID == null || objID instanceof IdentityReference) continue;
            if (this.getApiAdapter().isDeleted(obj)) {
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("004007", StringUtils.toJVMIDString(obj), op.getInternalObjectId()));
                }
                if (idsToRemove == null) {
                    idsToRemove = new HashSet();
                }
                idsToRemove.add(objID);
                continue;
            }
            if (this.getApiAdapter().isDetached(obj)) continue;
            if (opsToCache == null) {
                opsToCache = new HashSet<ObjectProvider>();
            }
            opsToCache.add(op);
            if (this.l2CacheObjectsToEvictUponRollback == null) {
                this.l2CacheObjectsToEvictUponRollback = new LinkedList<Object>();
            }
            this.l2CacheObjectsToEvictUponRollback.add(id);
        }
        if (idsToRemove != null && !idsToRemove.isEmpty()) {
            this.nucCtx.getLevel2Cache().evictAll(idsToRemove);
        }
        if (opsToCache != null && !opsToCache.isEmpty()) {
            this.putObjectsIntoLevel2Cache((Set<ObjectProvider>)opsToCache);
        }
        this.l2CacheTxIds.clear();
        this.l2CacheTxFieldsToUpdateById.clear();
    }

    private void performDetachAllOnTxnEndPreparation() {
        ArrayList<ObjectProvider<Object>> ops = new ArrayList<ObjectProvider<Object>>();
        Collection<Object> roots = this.fetchPlan.getDetachmentRoots();
        Class[] rootClasses = this.fetchPlan.getDetachmentRootClasses();
        if (roots != null && !roots.isEmpty()) {
            for (Object root : roots) {
                ops.add(this.findObjectProvider(root));
            }
        } else if (rootClasses != null && rootClasses.length > 0) {
            ObjectProvider[] txOPs = this.enlistedOPCache.values().toArray(new ObjectProvider[this.enlistedOPCache.size()]);
            block3: for (int i = 0; i < txOPs.length; ++i) {
                for (int j = 0; j < rootClasses.length; ++j) {
                    if (txOPs[i].getObject().getClass() != rootClasses[j]) continue;
                    ops.add(txOPs[i]);
                    continue block3;
                }
            }
        } else if (this.cache != null && !this.cache.isEmpty()) {
            ops.addAll(this.cache.values());
        }
        Iterator opsIter = ops.iterator();
        while (opsIter.hasNext()) {
            ObjectProvider op = (ObjectProvider)opsIter.next();
            Object pc = op.getObject();
            if (pc == null || this.getApiAdapter().isDetached(pc) || this.getApiAdapter().isDeleted(pc)) continue;
            FetchPlanState state = new FetchPlanState();
            try {
                op.loadFieldsInFetchPlan(state);
            }
            catch (NucleusObjectNotFoundException onfe) {
                NucleusLogger.PERSISTENCE.warn(Localiser.msg("010013", StringUtils.toJVMIDString(pc), op.getInternalObjectId()));
                opsIter.remove();
            }
        }
        this.detachAllOnTxnEndOPs = ops.toArray(new ObjectProvider[ops.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDetachAllOnTxnEnd() {
        try {
            this.runningDetachAllOnTxnEnd = true;
            if (this.detachAllOnTxnEndOPs != null) {
                ObjectProvider[] opsToDetach = this.detachAllOnTxnEndOPs;
                DetachState state = new DetachState(this.getApiAdapter());
                for (int i = 0; i < opsToDetach.length; ++i) {
                    Object pc = opsToDetach[i].getObject();
                    if (pc == null) continue;
                    opsToDetach[i].detach(state);
                }
            }
        }
        finally {
            this.detachAllOnTxnEndOPs = null;
            this.runningDetachAllOnTxnEnd = false;
        }
    }

    @Override
    public boolean isRunningDetachAllOnCommit() {
        return this.runningDetachAllOnTxnEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommit() {
        if (this.properties.getFrequentProperties().getDetachAllOnCommit().booleanValue()) {
            this.performDetachAllOnTxnEnd();
        }
        ArrayList<RuntimeException> failures = null;
        try {
            ApiAdapter api = this.getApiAdapter();
            ObjectProvider[] ops = this.enlistedOPCache.values().toArray(new ObjectProvider[this.enlistedOPCache.size()]);
            for (int i = 0; i < ops.length; ++i) {
                try {
                    if (ops[i] == null || ops[i].getObject() == null || !api.isPersistent(ops[i].getObject()) && !api.isTransactional(ops[i].getObject())) continue;
                    ops[i].postCommit(this.getTransaction());
                    if (!this.properties.getFrequentProperties().getDetachAllOnCommit().booleanValue() || !api.isDetachable(ops[i].getObject())) continue;
                    this.removeObjectProviderFromCache(ops[i]);
                    continue;
                }
                catch (RuntimeException e) {
                    if (failures == null) {
                        failures = new ArrayList<RuntimeException>();
                    }
                    failures.add(e);
                }
            }
        }
        finally {
            this.resetTransactionalVariables();
        }
        if (failures != null && !failures.isEmpty()) {
            throw new CommitStateTransitionException(failures.toArray(new Exception[failures.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRollback() {
        ArrayList<RuntimeException> failures = null;
        try {
            Collection<ObjectProvider> ops = this.enlistedOPCache.values();
            for (ObjectProvider op : ops) {
                try {
                    op.preRollback(this.getTransaction());
                }
                catch (RuntimeException e) {
                    if (failures == null) {
                        failures = new ArrayList<RuntimeException>();
                    }
                    failures.add(e);
                }
            }
            this.clearDirty();
        }
        finally {
            this.resetTransactionalVariables();
        }
        if (failures != null && !failures.isEmpty()) {
            throw new RollbackStateTransitionException(failures.toArray(new Exception[failures.size()]));
        }
        if (this.getBooleanProperty("datanucleus.DetachAllOnRollback").booleanValue()) {
            this.performDetachAllOnTxnEndPreparation();
        }
    }

    public void postRollback() {
        if (this.getBooleanProperty("datanucleus.DetachAllOnRollback").booleanValue()) {
            this.performDetachAllOnTxnEnd();
        }
        if (this.l2CacheObjectsToEvictUponRollback != null) {
            this.nucCtx.getLevel2Cache().evictAll(this.l2CacheObjectsToEvictUponRollback);
            this.l2CacheObjectsToEvictUponRollback = null;
        }
    }

    private void resetTransactionalVariables() {
        if (this.pbrAtCommitHandler != null) {
            this.pbrAtCommitHandler.clear();
        }
        this.enlistedOPCache.clear();
        this.dirtyOPs.clear();
        this.indirectDirtyOPs.clear();
        this.fetchPlan.resetDetachmentRoots();
        if (this.managedRelationsHandler != null) {
            this.managedRelationsHandler.clear();
        }
        if (this.l2CacheTxIds != null) {
            this.l2CacheTxIds.clear();
        }
        if (this.l2CacheTxFieldsToUpdateById != null) {
            this.l2CacheTxFieldsToUpdateById.clear();
        }
        if (this.operationQueue != null) {
            this.operationQueue.clear();
        }
        this.opAttachDetachObjectReferenceMap = null;
        this.lockMgr.clear();
    }

    protected String getLevel2CacheRetrieveMode() {
        return this.properties.getFrequentProperties().getLevel2CacheRetrieveMode();
    }

    protected String getLevel2CacheStoreMode() {
        return this.properties.getFrequentProperties().getLevel2CacheStoreMode();
    }

    @Override
    public void putObjectIntoLevel1Cache(ObjectProvider op) {
        if (this.cache != null) {
            List<UniqueMetaData> unimds;
            Object id = op.getInternalObjectId();
            if (id == null || op.getObject() == null) {
                NucleusLogger.CACHE.warn(Localiser.msg("003006"));
                return;
            }
            if (op.getClassMetaData().getUniqueMetaData() != null && (unimds = op.getClassMetaData().getUniqueMetaData()) != null && !unimds.isEmpty()) {
                for (UniqueMetaData unimd : unimds) {
                    CacheUniqueKey uniKey = this.getCacheUniqueKeyForObjectProvider(op, unimd);
                    if (uniKey == null) continue;
                    this.cache.putUnique(uniKey, op);
                }
            }
            ObjectProvider oldOP = this.cache.put(id, op);
            if (NucleusLogger.CACHE.isDebugEnabled() && oldOP == null) {
                NucleusLogger.CACHE.debug(Localiser.msg("003004", StringUtils.toJVMIDString(op.getObject()), IdentityUtils.getPersistableIdentityForId(id), StringUtils.booleanArrayToString(op.getLoadedFields())));
            }
        }
    }

    private CacheUniqueKey getCacheUniqueKeyForObjectProvider(ObjectProvider op, UniqueMetaData unimd) {
        boolean nonNullMembers = true;
        if (unimd.getNumberOfMembers() > 0) {
            Object[] fieldVals = new Object[unimd.getNumberOfMembers()];
            for (int i = 0; i < fieldVals.length; ++i) {
                AbstractMemberMetaData mmd = op.getClassMetaData().getMetaDataForMember(unimd.getMemberNames()[i]);
                fieldVals[i] = op.provideField(mmd.getAbsoluteFieldNumber());
                if (fieldVals[i] != null) continue;
                nonNullMembers = false;
                break;
            }
            if (nonNullMembers) {
                return new CacheUniqueKey(op.getClassMetaData().getFullClassName(), unimd.getMemberNames(), fieldVals);
            }
        }
        return null;
    }

    protected void putObjectIntoLevel2Cache(ObjectProvider op, boolean updateIfPresent) {
        if (op.getInternalObjectId() == null || !this.nucCtx.isClassCacheable(op.getClassMetaData())) {
            return;
        }
        String storeMode = this.getLevel2CacheStoreMode();
        if (storeMode.equalsIgnoreCase("bypass")) {
            return;
        }
        if (this.l2CacheTxIds != null && !this.l2CacheTxIds.contains(op.getInternalObjectId())) {
            this.putObjectIntoLevel2CacheInternal(op, updateIfPresent);
        }
    }

    protected CachedPC getL2CacheableObject(ObjectProvider op, CachedPC currentCachedPC) {
        CachedPC<Object> cachedPC = null;
        int[] fieldsToUpdate = null;
        if (currentCachedPC != null) {
            BitSet fieldsToUpdateBitSet;
            cachedPC = currentCachedPC.getCopy();
            cachedPC.setVersion(op.getTransactionalVersion());
            VersionMetaData vermd = op.getClassMetaData().getVersionMetaDataForClass();
            int versionFieldNum = -1;
            if (vermd != null && vermd.getFieldName() != null) {
                versionFieldNum = op.getClassMetaData().getMetaDataForMember(vermd.getFieldName()).getAbsoluteFieldNumber();
            }
            if ((fieldsToUpdateBitSet = this.l2CacheTxFieldsToUpdateById.get(op.getInternalObjectId())) != null) {
                if (versionFieldNum >= 0 && !fieldsToUpdateBitSet.get(versionFieldNum)) {
                    fieldsToUpdateBitSet.set(versionFieldNum);
                }
                int num = 0;
                for (int i = 0; i < fieldsToUpdateBitSet.length(); ++i) {
                    if (!fieldsToUpdateBitSet.get(i)) continue;
                    ++num;
                }
                fieldsToUpdate = new int[num];
                int j = 0;
                for (int i = 0; i < fieldsToUpdateBitSet.length(); ++i) {
                    if (!fieldsToUpdateBitSet.get(i)) continue;
                    fieldsToUpdate[j++] = i;
                }
            }
            if (fieldsToUpdate == null || fieldsToUpdate.length == 0) {
                return null;
            }
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                int[] loadedFieldNums = cachedPC.getLoadedFieldNumbers();
                String fieldNames = loadedFieldNums == null || loadedFieldNums.length == 0 ? "" : StringUtils.intArrayToString(loadedFieldNums);
                NucleusLogger.CACHE.debug(Localiser.msg("004015", StringUtils.toJVMIDString(op.getObject()), op.getInternalObjectId(), fieldNames, cachedPC.getVersion(), StringUtils.intArrayToString(fieldsToUpdate)));
            }
        } else {
            int[] loadedFieldNumbers = op.getLoadedFieldNumbers();
            if (loadedFieldNumbers == null || loadedFieldNumbers.length == 0) {
                return null;
            }
            cachedPC = new CachedPC(op.getObject().getClass(), op.getLoadedFields(), op.getTransactionalVersion(), op.getInternalObjectId());
            fieldsToUpdate = loadedFieldNumbers;
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                int[] loadedFieldNums = cachedPC.getLoadedFieldNumbers();
                String fieldNames = loadedFieldNums == null || loadedFieldNums.length == 0 ? "" : StringUtils.intArrayToString(loadedFieldNums);
                NucleusLogger.CACHE.debug(Localiser.msg("004003", StringUtils.toJVMIDString(op.getObject()), op.getInternalObjectId(), fieldNames, cachedPC.getVersion()));
            }
        }
        op.provideFields(fieldsToUpdate, new L2CachePopulateFieldManager(op, cachedPC));
        return cachedPC;
    }

    protected void putObjectsIntoLevel2Cache(Set<ObjectProvider> ops) {
        int batchSize = this.nucCtx.getConfiguration().getIntProperty("datanucleus.cache.level2.batchSize");
        Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
        HashMap<Object, CachedPC> dataToUpdate = new HashMap<Object, CachedPC>();
        HashMap<CacheUniqueKey, CachedPC> dataUniqueToUpdate = new HashMap<CacheUniqueKey, CachedPC>();
        for (ObjectProvider op : ops) {
            List<UniqueMetaData> unimds;
            Object id = op.getInternalObjectId();
            if (id == null || !this.nucCtx.isClassCacheable(op.getClassMetaData())) continue;
            CachedPC currentCachedPC = l2Cache.get(id);
            CachedPC cachedPC = this.getL2CacheableObject(op, currentCachedPC);
            if (cachedPC != null && id != null && !(id instanceof IdentityReference)) {
                dataToUpdate.put(id, cachedPC);
                if (dataToUpdate.size() == batchSize) {
                    l2Cache.putAll(dataToUpdate);
                    dataToUpdate.clear();
                }
            }
            if (op.getClassMetaData().getUniqueMetaData() == null || (unimds = op.getClassMetaData().getUniqueMetaData()) == null || unimds.isEmpty()) continue;
            for (UniqueMetaData unimd : unimds) {
                CacheUniqueKey uniKey = this.getCacheUniqueKeyForObjectProvider(op, unimd);
                if (uniKey == null) continue;
                dataUniqueToUpdate.put(uniKey, cachedPC);
                if (dataUniqueToUpdate.size() != batchSize) continue;
                l2Cache.putUniqueAll(dataUniqueToUpdate);
                dataUniqueToUpdate.clear();
            }
        }
        if (!dataToUpdate.isEmpty()) {
            l2Cache.putAll(dataToUpdate);
            dataToUpdate.clear();
        }
        if (!dataUniqueToUpdate.isEmpty()) {
            l2Cache.putUniqueAll(dataUniqueToUpdate);
            dataUniqueToUpdate.clear();
        }
    }

    protected void putObjectIntoLevel2CacheInternal(ObjectProvider op, boolean updateIfPresent) {
        List<UniqueMetaData> unimds;
        Object id = op.getInternalObjectId();
        if (id == null || id instanceof IdentityReference) {
            return;
        }
        Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
        if (!updateIfPresent && l2Cache.containsOid(id)) {
            return;
        }
        CachedPC currentCachedPC = l2Cache.get(id);
        CachedPC cachedPC = this.getL2CacheableObject(op, currentCachedPC);
        if (cachedPC != null) {
            l2Cache.put(id, cachedPC);
        }
        if (op.getClassMetaData().getUniqueMetaData() != null && (unimds = op.getClassMetaData().getUniqueMetaData()) != null && !unimds.isEmpty()) {
            for (UniqueMetaData unimd : unimds) {
                CacheUniqueKey uniKey = this.getCacheUniqueKeyForObjectProvider(op, unimd);
                if (uniKey == null) continue;
                l2Cache.putUnique(uniKey, cachedPC);
            }
        }
    }

    @Override
    public void removeObjectFromLevel1Cache(Object id) {
        Object pcRemoved;
        if (id != null && this.cache != null && (pcRemoved = this.cache.remove(id)) != null && NucleusLogger.CACHE.isDebugEnabled()) {
            NucleusLogger.CACHE.debug(Localiser.msg("003009", IdentityUtils.getPersistableIdentityForId(id)));
        }
    }

    @Override
    public void removeObjectFromLevel2Cache(Object id) {
        Level2Cache l2Cache;
        if (id != null && !(id instanceof IdentityReference) && (l2Cache = this.nucCtx.getLevel2Cache()).containsOid(id)) {
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(Localiser.msg("004016", id));
            }
            l2Cache.evict(id);
        }
    }

    @Override
    public boolean hasIdentityInCache(Object id) {
        Level2Cache l2Cache;
        if (this.cache != null && this.cache.containsKey(id)) {
            return true;
        }
        return this.l2CacheEnabled && (l2Cache = this.nucCtx.getLevel2Cache()).containsOid(id);
    }

    @Override
    public Object getObjectFromCache(Object id) {
        Object pc = this.getObjectFromLevel1Cache(id);
        if (pc != null) {
            return pc;
        }
        if (id instanceof SCOID) {
            return null;
        }
        return this.getObjectFromLevel2Cache(id);
    }

    @Override
    public Object[] getObjectsFromCache(Object[] ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        Object[] objs = new Object[ids.length];
        HashSet<Object> idsNotFound = new HashSet<Object>();
        for (int i = 0; i < ids.length; ++i) {
            objs[i] = this.getObjectFromLevel1Cache(ids[i]);
            if (objs[i] != null) continue;
            idsNotFound.add(ids[i]);
        }
        if (!idsNotFound.isEmpty()) {
            Map l2ObjsById = this.getObjectsFromLevel2Cache(idsNotFound);
            for (int i = 0; i < ids.length; ++i) {
                if (objs[i] != null) continue;
                objs[i] = l2ObjsById.get(ids[i]);
            }
        }
        return objs;
    }

    public Object getObjectFromLevel1Cache(Object id) {
        Object pc = null;
        ObjectProvider op = null;
        if (this.cache != null) {
            op = (ObjectProvider)this.cache.get(id);
            if (op != null) {
                pc = op.getObject();
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("003008", StringUtils.toJVMIDString(pc), IdentityUtils.getPersistableIdentityForId(id), StringUtils.booleanArrayToString(op.getLoadedFields())));
                }
                op.resetDetachState();
                return pc;
            }
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(Localiser.msg("003007", IdentityUtils.getPersistableIdentityForId(id)));
            }
        }
        return null;
    }

    protected Object getObjectFromLevel2Cache(Object id) {
        Object pc = null;
        if (this.l2CacheEnabled) {
            if (!this.nucCtx.isClassWithIdentityCacheable(id)) {
                return null;
            }
            String cacheRetrieveMode = this.getLevel2CacheRetrieveMode();
            if ("bypass".equalsIgnoreCase(cacheRetrieveMode)) {
                return null;
            }
            Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
            CachedPC cachedPC = l2Cache.get(id);
            if (cachedPC != null) {
                ObjectProvider op = this.nucCtx.getObjectProviderFactory().newForCachedPC(this, id, cachedPC);
                pc = op.getObject();
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("004006", IdentityUtils.getPersistableIdentityForId(id), StringUtils.intArrayToString(cachedPC.getLoadedFieldNumbers()), cachedPC.getVersion(), StringUtils.toJVMIDString(pc)));
                }
                if (this.tx.isActive() && this.tx.getOptimistic()) {
                    op.makeNontransactional();
                } else if (!this.tx.isActive() && this.getApiAdapter().isTransactional(pc)) {
                    op.makeNontransactional();
                }
                return pc;
            }
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(Localiser.msg("004005", IdentityUtils.getPersistableIdentityForId(id)));
            }
        }
        return null;
    }

    protected Object getObjectFromLevel2CacheForUnique(CacheUniqueKey uniKey) {
        Object pc = null;
        if (this.l2CacheEnabled) {
            String cacheRetrieveMode = this.getLevel2CacheRetrieveMode();
            if ("bypass".equalsIgnoreCase(cacheRetrieveMode)) {
                return null;
            }
            Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
            CachedPC cachedPC = l2Cache.getUnique(uniKey);
            if (cachedPC != null) {
                Object id = cachedPC.getId();
                ObjectProvider op = this.nucCtx.getObjectProviderFactory().newForCachedPC(this, id, cachedPC);
                pc = op.getObject();
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("004006", IdentityUtils.getPersistableIdentityForId(id), StringUtils.intArrayToString(cachedPC.getLoadedFieldNumbers()), cachedPC.getVersion(), StringUtils.toJVMIDString(pc)));
                }
                if (this.tx.isActive() && this.tx.getOptimistic()) {
                    op.makeNontransactional();
                } else if (!this.tx.isActive() && this.getApiAdapter().isTransactional(pc)) {
                    op.makeNontransactional();
                }
                return pc;
            }
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(Localiser.msg("004005", uniKey));
            }
        }
        return null;
    }

    protected Map getObjectsFromLevel2Cache(Collection ids) {
        if (this.l2CacheEnabled) {
            Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
            Map<Object, CachedPC> cachedPCs = l2Cache.getAll(ids);
            HashMap pcsById = new HashMap(cachedPCs.size());
            for (Map.Entry<Object, CachedPC> entry : cachedPCs.entrySet()) {
                Object id = entry.getKey();
                CachedPC cachedPC = entry.getValue();
                if (cachedPC != null) {
                    ObjectProvider op = this.nucCtx.getObjectProviderFactory().newForCachedPC(this, id, cachedPC);
                    Object pc = op.getObject();
                    if (NucleusLogger.CACHE.isDebugEnabled()) {
                        NucleusLogger.CACHE.debug(Localiser.msg("004006", IdentityUtils.getPersistableIdentityForId(id), StringUtils.intArrayToString(cachedPC.getLoadedFieldNumbers()), cachedPC.getVersion(), StringUtils.toJVMIDString(pc)));
                    }
                    if (this.tx.isActive() && this.tx.getOptimistic()) {
                        op.makeNontransactional();
                    } else if (!this.tx.isActive() && this.getApiAdapter().isTransactional(pc)) {
                        op.makeNontransactional();
                    }
                    pcsById.put(id, pc);
                    continue;
                }
                if (!NucleusLogger.CACHE.isDebugEnabled()) continue;
                NucleusLogger.CACHE.debug(Localiser.msg("004005", IdentityUtils.getPersistableIdentityForId(id)));
            }
            return pcsById;
        }
        return null;
    }

    @Override
    public void replaceObjectId(Object pc, Object oldID, Object newID) {
        if (pc == null || newID == null) {
            NucleusLogger.CACHE.warn(Localiser.msg("003006"));
            return;
        }
        ObjectProvider op = this.findObjectProvider(pc);
        if (this.cache != null) {
            Object o;
            if (oldID != null && (o = this.cache.get(oldID)) != null) {
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("003012", StringUtils.toJVMIDString(pc), IdentityUtils.getPersistableIdentityForId(oldID), IdentityUtils.getPersistableIdentityForId(newID)));
                }
                this.cache.remove(oldID);
            }
            if (op != null) {
                this.putObjectIntoLevel1Cache(op);
            }
        }
        if (oldID != null && this.enlistedOPCache.get(oldID) != null && op != null) {
            this.enlistedOPCache.remove(oldID);
            this.enlistedOPCache.put(newID, op);
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(Localiser.msg("015018", StringUtils.toJVMIDString(pc), IdentityUtils.getPersistableIdentityForId(oldID), IdentityUtils.getPersistableIdentityForId(newID)));
            }
        }
        if (oldID != null && this.l2CacheTxIds != null && this.l2CacheTxIds.contains(oldID)) {
            this.l2CacheTxIds.remove(oldID);
            this.l2CacheTxIds.add(newID);
        }
        if (oldID != null && this.pbrAtCommitHandler != null && this.tx.isActive()) {
            this.pbrAtCommitHandler.swapObjectId(oldID, newID);
        }
    }

    @Override
    public boolean getSerializeReadForClass(String className) {
        AbstractClassMetaData cmd;
        if (this.tx.isActive() && this.tx.getSerializeRead() != null) {
            return this.tx.getSerializeRead();
        }
        if (this.getProperty("datanucleus.SerializeRead") != null) {
            return this.properties.getBooleanProperty("datanucleus.SerializeRead");
        }
        if (className != null && (cmd = this.getMetaDataManager().getMetaDataForClass(className, this.clr)) != null) {
            return cmd.isSerializeRead();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Extent<T> getExtent(Class<T> pcClass, boolean subclasses) {
        try {
            this.clr.setPrimary(pcClass.getClassLoader());
            this.assertClassPersistable(pcClass);
            Extent<T> extent = this.getStoreManager().getExtent(this, pcClass, subclasses);
            return extent;
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        if (this.callbackHandler != null) {
            return this.callbackHandler;
        }
        if (this.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.allowCallbacks")) {
            String callbackHandlerClassName = this.getNucleusContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.callbackhandler", "name", this.getNucleusContext().getApiName(), "class-name");
            if (callbackHandlerClassName != null) {
                try {
                    this.callbackHandler = (CallbackHandler)this.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.callbackhandler", "name", this.getNucleusContext().getApiName(), "class-name", new Class[]{ClassConstants.PERSISTENCE_NUCLEUS_CONTEXT}, new Object[]{this.getNucleusContext()});
                }
                catch (Exception e) {
                    NucleusLogger.PERSISTENCE.error(Localiser.msg("025000", callbackHandlerClassName, e));
                }
            }
        } else {
            this.callbackHandler = new NullCallbackHandler();
        }
        return this.callbackHandler;
    }

    @Override
    public void closeCallbackHandler() {
        if (this.callbackHandler != null) {
            this.callbackHandler.close();
        }
    }

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw new NucleusUserException(Localiser.msg("010002")).setFatal();
        }
    }

    @Override
    public void assertClassPersistable(Class cls) {
        if (cls == null) {
            return;
        }
        if (!this.getNucleusContext().getApiAdapter().isPersistable(cls) && !cls.isInterface()) {
            throw new ClassNotPersistableException(cls.getName());
        }
        if (!this.hasPersistenceInformationForClass(cls)) {
            throw new NoPersistenceInformationException(cls.getName());
        }
    }

    protected void assertDetachable(Object object) {
        if (object != null && !this.getApiAdapter().isDetachable(object)) {
            throw new ClassNotDetachableException(object.getClass().getName());
        }
    }

    protected void assertNotDetached(Object object) {
        if (object != null && this.getApiAdapter().isDetached(object)) {
            throw new ObjectDetachedException(object.getClass().getName());
        }
    }

    protected void assertActiveTransaction() {
        if (!this.tx.isActive()) {
            throw new TransactionNotActiveException();
        }
    }

    protected void assertHasImplementationCreator() {
        if (this.getNucleusContext().getImplementationCreator() == null) {
            throw new NucleusUserException(Localiser.msg("010035"));
        }
    }

    @Override
    public boolean hasPersistenceInformationForClass(Class cls) {
        if (cls == null) {
            return false;
        }
        if (this.getMetaDataManager().getMetaDataForClass(cls, this.clr) != null) {
            return true;
        }
        if (cls.isInterface()) {
            try {
                this.newInstance(cls);
            }
            catch (RuntimeException ex) {
                NucleusLogger.PERSISTENCE.warn(ex);
            }
            return this.getMetaDataManager().getMetaDataForClass(cls, this.clr) != null;
        }
        return false;
    }

    protected FetchGroupManager getFetchGroupManager() {
        if (this.fetchGrpMgr == null) {
            this.fetchGrpMgr = new FetchGroupManager(this.getNucleusContext());
        }
        return this.fetchGrpMgr;
    }

    @Override
    public void addInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().addFetchGroup(grp);
    }

    protected void removeInternalFetchGroup(FetchGroup grp) {
        if (this.fetchGrpMgr == null) {
            return;
        }
        this.getFetchGroupManager().removeFetchGroup(grp);
    }

    @Override
    public FetchGroup getInternalFetchGroup(Class cls, String name) {
        if (!cls.isInterface() && !this.getNucleusContext().getApiAdapter().isPersistable(cls)) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        if (cls.isInterface() && !this.getNucleusContext().getMetaDataManager().isPersistentInterface(cls.getName())) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        if (this.fetchGrpMgr == null) {
            return null;
        }
        return this.getFetchGroupManager().getFetchGroup(cls, name, true);
    }

    @Override
    public Set<FetchGroup> getFetchGroupsWithName(String name) {
        if (this.fetchGrpMgr == null) {
            return null;
        }
        return this.getFetchGroupManager().getFetchGroupsWithName(name);
    }

    @Override
    public ExecutionContext.EmbeddedOwnerRelation registerEmbeddedRelation(ObjectProvider ownerOP, int ownerFieldNum, ObjectProvider embOP) {
        List<ExecutionContext.EmbeddedOwnerRelation> relations;
        ExecutionContext.EmbeddedOwnerRelation relation = new ExecutionContext.EmbeddedOwnerRelation(ownerOP, ownerFieldNum, embOP);
        if (this.opEmbeddedInfoByEmbedded == null) {
            this.opEmbeddedInfoByEmbedded = new HashMap<ObjectProvider, List<ExecutionContext.EmbeddedOwnerRelation>>();
        }
        if ((relations = this.opEmbeddedInfoByEmbedded.get(embOP)) == null) {
            relations = new ArrayList<ExecutionContext.EmbeddedOwnerRelation>();
        }
        relations.add(relation);
        this.opEmbeddedInfoByEmbedded.put(embOP, relations);
        if (this.opEmbeddedInfoByOwner == null) {
            this.opEmbeddedInfoByOwner = new HashMap<ObjectProvider, List<ExecutionContext.EmbeddedOwnerRelation>>();
        }
        if ((relations = this.opEmbeddedInfoByOwner.get(ownerOP)) == null) {
            relations = new ArrayList<ExecutionContext.EmbeddedOwnerRelation>();
        }
        relations.add(relation);
        this.opEmbeddedInfoByOwner.put(ownerOP, relations);
        return relation;
    }

    @Override
    public void deregisterEmbeddedRelation(ExecutionContext.EmbeddedOwnerRelation rel) {
        if (this.opEmbeddedInfoByEmbedded != null) {
            List<ExecutionContext.EmbeddedOwnerRelation> ownerRels = this.opEmbeddedInfoByEmbedded.get(rel.getEmbeddedOP());
            ownerRels.remove(rel);
            if (ownerRels.isEmpty()) {
                this.opEmbeddedInfoByEmbedded.remove(rel.getEmbeddedOP());
                if (this.opEmbeddedInfoByEmbedded.isEmpty()) {
                    this.opEmbeddedInfoByEmbedded = null;
                }
            }
        }
        if (this.opEmbeddedInfoByOwner != null) {
            List<ExecutionContext.EmbeddedOwnerRelation> embRels = this.opEmbeddedInfoByOwner.get(rel.getOwnerOP());
            embRels.remove(rel);
            if (embRels.isEmpty()) {
                this.opEmbeddedInfoByOwner.remove(rel.getOwnerOP());
                if (this.opEmbeddedInfoByOwner.isEmpty()) {
                    this.opEmbeddedInfoByOwner = null;
                }
            }
        }
    }

    @Override
    public void removeEmbeddedOwnerRelation(ObjectProvider ownerOP, int ownerFieldNum, ObjectProvider embOP) {
        if (this.opEmbeddedInfoByOwner != null) {
            List<ExecutionContext.EmbeddedOwnerRelation> ownerRels = this.opEmbeddedInfoByOwner.get(ownerOP);
            ExecutionContext.EmbeddedOwnerRelation rel = null;
            for (ExecutionContext.EmbeddedOwnerRelation ownerRel : ownerRels) {
                if (ownerRel.getEmbeddedOP() != embOP || ownerRel.getOwnerFieldNum() != ownerFieldNum) continue;
                rel = ownerRel;
                break;
            }
            if (rel != null) {
                this.deregisterEmbeddedRelation(rel);
            }
        }
    }

    @Override
    public ObjectProvider[] getOwnersForEmbeddedObjectProvider(ObjectProvider embOP) {
        if (this.opEmbeddedInfoByEmbedded == null || !this.opEmbeddedInfoByEmbedded.containsKey(embOP)) {
            return null;
        }
        List<ExecutionContext.EmbeddedOwnerRelation> ownerRels = this.opEmbeddedInfoByEmbedded.get(embOP);
        ObjectProvider[] owners = new ObjectProvider[ownerRels.size()];
        int i = 0;
        for (ExecutionContext.EmbeddedOwnerRelation rel : ownerRels) {
            owners[i++] = rel.getOwnerOP();
        }
        return owners;
    }

    @Override
    public List<ExecutionContext.EmbeddedOwnerRelation> getOwnerInformationForEmbedded(ObjectProvider embOP) {
        if (this.opEmbeddedInfoByEmbedded == null) {
            return null;
        }
        return this.opEmbeddedInfoByEmbedded.get(embOP);
    }

    @Override
    public List<ExecutionContext.EmbeddedOwnerRelation> getEmbeddedInformationForOwner(ObjectProvider ownerOP) {
        if (this.opEmbeddedInfoByOwner == null) {
            return null;
        }
        return this.opEmbeddedInfoByOwner.get(ownerOP);
    }

    @Override
    public void setObjectProviderAssociatedValue(ObjectProvider op, Object key, Object value) {
        Map<?, ?> opMap = null;
        if (this.opAssociatedValuesMapByOP == null) {
            this.opAssociatedValuesMapByOP = new HashMap();
            opMap = new HashMap();
            this.opAssociatedValuesMapByOP.put(op, opMap);
        } else {
            opMap = this.opAssociatedValuesMapByOP.get(op);
            if (opMap == null) {
                opMap = new HashMap();
                this.opAssociatedValuesMapByOP.put(op, opMap);
            }
        }
        opMap.put(key, value);
    }

    @Override
    public Object getObjectProviderAssociatedValue(ObjectProvider op, Object key) {
        if (this.opAssociatedValuesMapByOP == null) {
            return null;
        }
        Map<?, ?> opMap = this.opAssociatedValuesMapByOP.get(op);
        return opMap == null ? null : opMap.get(key);
    }

    @Override
    public void removeObjectProviderAssociatedValue(ObjectProvider op, Object key) {
        Map<?, ?> opMap;
        if (this.opAssociatedValuesMapByOP != null && (opMap = this.opAssociatedValuesMapByOP.get(op)) != null) {
            opMap.remove(key);
        }
    }

    @Override
    public boolean containsObjectProviderAssociatedValue(ObjectProvider op, Object key) {
        if (this.opAssociatedValuesMapByOP != null && this.opAssociatedValuesMapByOP.containsKey(op)) {
            return this.opAssociatedValuesMapByOP.get(op).containsKey(key);
        }
        return false;
    }

    private static class ClassDetailsForId {
        Object id;
        String className;
        Object pc;

        public ClassDetailsForId(Object id, String className, Object pc) {
            this.id = id;
            this.className = className;
            this.pc = pc;
        }
    }

    static class ThreadContextInfo {
        int referenceCounter = 0;
        Map<Object, ObjectProvider> attachedOwnerByObject = null;
        Map attachedPCById = null;
        boolean merging = false;
        boolean nontxPersistDelete = false;

        ThreadContextInfo() {
        }
    }
}

