/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.datanucleus.FetchPlanState;
import org.datanucleus.flush.CollectionAddOperation;
import org.datanucleus.flush.CollectionRemoveOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.types.SCOCollection;
import org.datanucleus.store.types.SCOCollectionIterator;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class PriorityQueue<E>
extends java.util.PriorityQueue<E>
implements SCOCollection<java.util.PriorityQueue<E>, E>,
Cloneable {
    protected ObjectProvider ownerOP;
    protected AbstractMemberMetaData ownerMmd;
    protected java.util.PriorityQueue<E> delegate;

    public PriorityQueue(ObjectProvider ownerOP, AbstractMemberMetaData mmd) {
        super(1);
        this.ownerOP = ownerOP;
        this.ownerMmd = mmd;
    }

    @Override
    public void initialise(java.util.PriorityQueue<E> newValue, Object oldValue) {
        this.initialise(newValue);
    }

    @Override
    public void initialise(java.util.PriorityQueue c) {
        if (c != null) {
            this.initialiseDelegate();
            this.delegate.addAll(c);
        } else {
            this.initialiseDelegate();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("023003", this.getClass().getName(), this.ownerOP.getObjectAsPrintable(), this.ownerMmd.getName(), "" + this.size(), SCOUtils.getSCOWrapperOptionsMessage(true, false, false, false)));
        }
    }

    @Override
    public void initialise() {
        this.initialise(null);
    }

    protected void initialiseDelegate() {
        Comparator comparator = SCOUtils.getComparator(this.ownerMmd, this.ownerOP.getExecutionContext().getClassLoaderResolver());
        this.delegate = comparator != null ? new java.util.PriorityQueue(5, comparator) : new java.util.PriorityQueue();
    }

    @Override
    public java.util.PriorityQueue<E> getValue() {
        return this.delegate;
    }

    @Override
    public void setValue(java.util.PriorityQueue<E> value) {
        this.delegate = value;
    }

    @Override
    public void load() {
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public void updateEmbeddedElement(E element, int fieldNumber, Object value, boolean makeDirty) {
        if (makeDirty) {
            this.makeDirty();
        }
    }

    @Override
    public String getFieldName() {
        return this.ownerMmd.getName();
    }

    @Override
    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    @Override
    public void unsetOwner() {
        if (this.ownerOP != null) {
            this.ownerOP = null;
            this.ownerMmd = null;
        }
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            this.ownerOP.makeDirty(this.ownerMmd.getAbsoluteFieldNumber());
        }
    }

    @Override
    public java.util.PriorityQueue detachCopy(FetchPlanState state) {
        java.util.PriorityQueue detached = new java.util.PriorityQueue();
        SCOUtils.detachCopyForCollection(this.ownerOP, this.toArray(), state, detached);
        return detached;
    }

    @Override
    public void attachCopy(java.util.PriorityQueue value) {
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(this.ownerMmd);
        SCOUtils.attachCopyElements(this.ownerOP, this, value, elementsWithoutIdentity);
    }

    @Override
    public Object clone() {
        return null;
    }

    @Override
    public Comparator comparator() {
        return this.delegate.comparator();
    }

    @Override
    public boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new SCOCollectionIterator<E>(this, this.ownerOP, this.delegate, null, true);
    }

    @Override
    public E peek() {
        return this.delegate.peek();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("[");
        int i = 0;
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            if (i > 0) {
                s.append(',');
            }
            s.append(iter.next());
            ++i;
        }
        s.append("]");
        return s.toString();
    }

    @Override
    public boolean add(E element) {
        boolean success = this.delegate.add(element);
        if (success) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), element));
            }
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public boolean addAll(Collection elements) {
        boolean success = this.delegate.addAll(elements);
        if (success) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                for (Object element : elements) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), element));
                }
            }
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public void clear() {
        if (this.ownerOP != null && !this.delegate.isEmpty()) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                ArrayList<E> copy = new ArrayList<E>(this.delegate);
                Iterator iter = copy.iterator();
                while (iter.hasNext()) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), iter.next(), true));
                }
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                ArrayList<E> copy = new ArrayList<E>(this.delegate);
                Iterator iter = copy.iterator();
                while (iter.hasNext()) {
                    this.ownerOP.getExecutionContext().deleteObjectInternal(iter.next());
                }
            }
        }
        this.delegate.clear();
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public boolean offer(E element) {
        return this.add(element);
    }

    @Override
    public E poll() {
        E obj = this.delegate.poll();
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return obj;
    }

    @Override
    public boolean remove(Object element) {
        return this.remove(element, true);
    }

    @Override
    public boolean remove(Object element, boolean allowCascadeDelete) {
        boolean success = this.delegate.remove(element);
        if (this.ownerOP != null && allowCascadeDelete) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), element, allowCascadeDelete));
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                this.ownerOP.getExecutionContext().deleteObjectInternal(element);
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public boolean removeAll(Collection elements) {
        if (elements == null) {
            throw new NullPointerException();
        }
        if (elements.isEmpty()) {
            return true;
        }
        boolean success = this.delegate.removeAll(elements);
        if (this.ownerOP != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                Iterator iter = elements.iterator();
                while (iter.hasNext()) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), iter.next(), true));
                }
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                Iterator iter = elements.iterator();
                while (iter.hasNext()) {
                    this.ownerOP.getExecutionContext().deleteObjectInternal(iter.next());
                }
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean success = this.delegate.retainAll(c);
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new java.util.PriorityQueue<E>(this.delegate);
    }

    @Override
    public Stream stream() {
        return this.delegate.stream();
    }

    @Override
    public Stream parallelStream() {
        return this.delegate.parallelStream();
    }

    @Override
    public void forEach(Consumer action) {
        this.delegate.forEach(action);
    }

    @Override
    public boolean removeIf(Predicate filter) {
        return this.delegate.removeIf(filter);
    }
}

