/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.inmemory.InvocationEvaluator;
import org.datanucleus.query.inmemory.method.ArrayContainsMethod;
import org.datanucleus.query.inmemory.method.ArraySizeMethod;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.query.cache.JavaxCacheQueryCompilationCache;
import org.datanucleus.store.query.cache.JavaxCacheQueryDatastoreCompilationCache;
import org.datanucleus.store.query.cache.JavaxCacheQueryResultCache;
import org.datanucleus.store.query.cache.QueryCompilationCache;
import org.datanucleus.store.query.cache.QueryDatastoreCompilationCache;
import org.datanucleus.store.query.cache.QueryResultsCache;
import org.datanucleus.store.query.cache.SoftQueryCompilationCache;
import org.datanucleus.store.query.cache.SoftQueryDatastoreCompilationCache;
import org.datanucleus.store.query.cache.SoftQueryResultsCache;
import org.datanucleus.store.query.cache.StrongQueryCompilationCache;
import org.datanucleus.store.query.cache.StrongQueryDatastoreCompilationCache;
import org.datanucleus.store.query.cache.StrongQueryResultsCache;
import org.datanucleus.store.query.cache.WeakQueryCompilationCache;
import org.datanucleus.store.query.cache.WeakQueryDatastoreCompilationCache;
import org.datanucleus.store.query.cache.WeakQueryResultsCache;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class QueryManagerImpl
implements QueryManager {
    protected NucleusContext nucleusCtx;
    protected StoreManager storeMgr;
    protected final QueryCompilationCache queryCompilationCache;
    protected final QueryDatastoreCompilationCache queryCompilationCacheDatastore;
    protected final QueryResultsCache queryResultsCache;
    protected Map<String, Map<Object, InvocationEvaluator>> inmemoryQueryMethodEvaluatorMap = new ConcurrentHashMap<String, Map<Object, InvocationEvaluator>>();
    protected Map<String, String> queryMethodAliasByPrefix = null;

    public QueryManagerImpl(NucleusContext nucleusContext, StoreManager storeMgr) {
        String cacheClassName;
        this.nucleusCtx = nucleusContext;
        this.storeMgr = storeMgr;
        Configuration conf = this.nucleusCtx.getConfiguration();
        String cacheType = conf.getStringProperty("datanucleus.cache.queryCompilation.type");
        if (cacheType == null) {
            cacheType = "soft";
        }
        if ("soft".equalsIgnoreCase(cacheType)) {
            this.queryCompilationCache = new SoftQueryCompilationCache(nucleusContext);
        } else if ("weak".equalsIgnoreCase(cacheType)) {
            this.queryCompilationCache = new WeakQueryCompilationCache(this.nucleusCtx);
        } else if ("strong".equalsIgnoreCase(cacheType)) {
            this.queryCompilationCache = new StrongQueryCompilationCache(this.nucleusCtx);
        } else if ("javax.cache".equalsIgnoreCase(cacheType)) {
            this.queryCompilationCache = new JavaxCacheQueryCompilationCache(this.nucleusCtx);
        } else {
            cacheClassName = this.nucleusCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_query_compilation", "name", cacheType, "class-name");
            if (cacheClassName == null) {
                throw new NucleusUserException(Localiser.msg("021500", cacheType)).setFatal();
            }
            try {
                this.queryCompilationCache = (QueryCompilationCache)this.nucleusCtx.getPluginManager().createExecutableExtension("org.datanucleus.cache_query_compilation", "name", cacheType, "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.nucleusCtx});
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("021502", cacheClassName));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(Localiser.msg("021501", cacheType, cacheClassName), e).setFatal();
            }
        }
        cacheType = conf.getStringProperty("datanucleus.cache.queryCompilationDatastore.type");
        if (cacheType == null) {
            cacheType = "soft";
        }
        if ("soft".equalsIgnoreCase(cacheType)) {
            this.queryCompilationCacheDatastore = new SoftQueryDatastoreCompilationCache(nucleusContext);
        } else if ("weak".equalsIgnoreCase(cacheType)) {
            this.queryCompilationCacheDatastore = new WeakQueryDatastoreCompilationCache(this.nucleusCtx);
        } else if ("strong".equalsIgnoreCase(cacheType)) {
            this.queryCompilationCacheDatastore = new StrongQueryDatastoreCompilationCache(this.nucleusCtx);
        } else if ("javax.cache".equalsIgnoreCase(cacheType)) {
            this.queryCompilationCacheDatastore = new JavaxCacheQueryDatastoreCompilationCache(this.nucleusCtx);
        } else {
            cacheClassName = this.nucleusCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_query_compilation_store", "name", cacheType, "class-name");
            if (cacheClassName == null) {
                throw new NucleusUserException(Localiser.msg("021500", cacheType)).setFatal();
            }
            try {
                this.queryCompilationCacheDatastore = (QueryDatastoreCompilationCache)this.nucleusCtx.getPluginManager().createExecutableExtension("org.datanucleus.cache_query_compilation_store", "name", cacheType, "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.nucleusCtx});
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("021502", cacheClassName));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(Localiser.msg("021501", cacheType, cacheClassName), e).setFatal();
            }
        }
        cacheType = conf.getStringProperty("datanucleus.cache.queryResults.type");
        if (cacheType == null) {
            cacheType = "soft";
        }
        if ("soft".equalsIgnoreCase(cacheType)) {
            this.queryResultsCache = new SoftQueryResultsCache(nucleusContext);
        } else if ("weak".equalsIgnoreCase(cacheType)) {
            this.queryResultsCache = new WeakQueryResultsCache(this.nucleusCtx);
        } else if ("strong".equalsIgnoreCase(cacheType)) {
            this.queryResultsCache = new StrongQueryResultsCache(this.nucleusCtx);
        } else if ("javax.cache".equalsIgnoreCase(cacheType)) {
            this.queryResultsCache = new JavaxCacheQueryResultCache(this.nucleusCtx);
        } else {
            cacheClassName = this.nucleusCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_query_result", "name", cacheType, "class-name");
            if (cacheClassName == null) {
                throw new NucleusUserException(Localiser.msg("021500", cacheType)).setFatal();
            }
            try {
                this.queryResultsCache = (QueryResultsCache)this.nucleusCtx.getPluginManager().createExecutableExtension("org.datanucleus.cache_query_result", "name", cacheType, "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.nucleusCtx});
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("021502", cacheClassName));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(Localiser.msg("021501", cacheType, cacheClassName), e).setFatal();
            }
        }
        this.queryMethodAliasByPrefix = new HashMap<String, String>();
        this.queryMethodAliasByPrefix.put("JDOHelper", "JDOHelper");
        this.queryMethodAliasByPrefix.put("javax.jdo.JDOHelper", "JDOHelper");
        this.queryMethodAliasByPrefix.put("Math", "Math");
        this.queryMethodAliasByPrefix.put("java.lang.Math", "Math");
        ConfigurationElement[] queryMethodAliases = this.nucleusCtx.getPluginManager().getConfigurationElementsForExtension("org.datanucleus.query_method_prefix", (String)null, (String)null);
        if (queryMethodAliases != null && queryMethodAliases.length > 0) {
            for (int i = 0; i < queryMethodAliases.length; ++i) {
                this.queryMethodAliasByPrefix.put(queryMethodAliases[i].getAttribute("prefix"), queryMethodAliases[i].getAttribute("alias"));
            }
        }
    }

    @Override
    public void close() {
        if (this.queryCompilationCache != null) {
            this.queryCompilationCache.close();
        }
        if (this.queryCompilationCacheDatastore != null) {
            this.queryCompilationCacheDatastore.close();
        }
        if (this.queryResultsCache != null) {
            this.queryResultsCache.close();
        }
        this.inmemoryQueryMethodEvaluatorMap.clear();
        this.inmemoryQueryMethodEvaluatorMap = null;
    }

    @Override
    public Map<String, String> getQueryMethodAliasesByPrefix() {
        return this.queryMethodAliasByPrefix;
    }

    @Override
    public QueryCompilationCache getQueryCompilationCache() {
        return this.queryCompilationCache;
    }

    @Override
    public void addQueryCompilation(String language, String query, QueryCompilation compilation) {
        if (this.queryCompilationCache != null) {
            this.queryCompilationCache.put(language + ":" + query, compilation);
        }
    }

    @Override
    public void removeQueryCompilation(String language, String query) {
        if (this.queryCompilationCache != null) {
            this.queryCompilationCache.evict(language + ":" + query);
        }
    }

    @Override
    public QueryCompilation getQueryCompilationForQuery(String language, String query) {
        String queryKey;
        QueryCompilation compilation;
        if (this.queryCompilationCache != null && (compilation = this.queryCompilationCache.get(queryKey = language + ":" + query)) != null) {
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(Localiser.msg("021079", query, language));
            }
            return compilation;
        }
        return null;
    }

    @Override
    public QueryDatastoreCompilationCache getQueryDatastoreCompilationCache() {
        return this.queryCompilationCacheDatastore;
    }

    @Override
    public void addDatastoreQueryCompilation(String datastore, String language, String query, Object compilation) {
        if (this.queryCompilationCacheDatastore != null) {
            String queryKey = language + ":" + query;
            this.queryCompilationCacheDatastore.put(queryKey, compilation);
        }
    }

    @Override
    public void removeDatastoreQueryCompilation(String datastore, String language, String query) {
        if (this.queryCompilationCacheDatastore != null) {
            String queryKey = language + ":" + query;
            this.queryCompilationCacheDatastore.evict(queryKey);
        }
    }

    @Override
    public Object getDatastoreQueryCompilation(String datastore, String language, String query) {
        String queryKey;
        Object compilation;
        if (this.queryCompilationCacheDatastore != null && (compilation = this.queryCompilationCacheDatastore.get(queryKey = language + ":" + query)) != null) {
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(Localiser.msg("021080", query, language, datastore));
            }
            return compilation;
        }
        return null;
    }

    @Override
    public QueryResultsCache getQueryResultsCache() {
        return this.queryResultsCache;
    }

    @Override
    public void evictQueryResultsForType(Class cls) {
        if (this.queryResultsCache != null) {
            this.queryResultsCache.evict(cls);
        }
    }

    @Override
    public void addQueryResult(Query query, Map params, List<Object> results) {
        if (this.queryResultsCache != null) {
            String queryKey = QueryUtils.getKeyForQueryResultsCache(query, params);
            this.queryResultsCache.put(queryKey, results);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(Localiser.msg("021081", query, results.size()));
            }
        }
    }

    @Override
    public List<Object> getQueryResult(Query query, Map params) {
        if (this.queryResultsCache != null) {
            String queryKey = QueryUtils.getKeyForQueryResultsCache(query, params);
            List<Object> results = this.queryResultsCache.get(queryKey);
            if (results != null && NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(Localiser.msg("021082", query, results.size()));
            }
            return results;
        }
        return null;
    }

    @Override
    public InvocationEvaluator getInMemoryEvaluatorForMethod(Class type, String methodName) {
        Map<Object, InvocationEvaluator> evaluatorsForMethod;
        if (type != null && type.isArray()) {
            if (methodName.equals("size") || methodName.equals("length")) {
                return new ArraySizeMethod();
            }
            if (methodName.equals("contains")) {
                return new ArrayContainsMethod();
            }
        }
        if ((evaluatorsForMethod = this.inmemoryQueryMethodEvaluatorMap.get(methodName)) != null) {
            for (Map.Entry<Object, InvocationEvaluator> entry : evaluatorsForMethod.entrySet()) {
                Object clsKey = entry.getKey();
                if (clsKey instanceof Class && ((Class)clsKey).isAssignableFrom(type)) {
                    return entry.getValue();
                }
                if (!(clsKey instanceof String) || !((String)clsKey).equals("STATIC") || type != null) continue;
                return entry.getValue();
            }
            return null;
        }
        ClassLoaderResolver clr = this.nucleusCtx.getClassLoaderResolver(type != null ? type.getClassLoader() : null);
        PluginManager pluginMgr = this.nucleusCtx.getPluginManager();
        ConfigurationElement[] elems = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.query_method_evaluators", "method", methodName);
        HashMap<Object, InvocationEvaluator> evaluators = new HashMap<Object, InvocationEvaluator>();
        InvocationEvaluator requiredEvaluator = null;
        if (elems == null) {
            return null;
        }
        for (int i = 0; i < elems.length; ++i) {
            try {
                String evalName = elems[i].getAttribute("evaluator");
                InvocationEvaluator eval = (InvocationEvaluator)pluginMgr.createExecutableExtension("org.datanucleus.query_method_evaluators", new String[]{"method", "evaluator"}, new String[]{methodName, evalName}, "evaluator", null, null);
                String elemClsName = elems[i].getAttribute("class");
                if (elemClsName != null && StringUtils.isWhitespace(elemClsName)) {
                    elemClsName = null;
                }
                if (elemClsName == null) {
                    if (type == null) {
                        requiredEvaluator = eval;
                    }
                    evaluators.put("STATIC", eval);
                    continue;
                }
                Class elemCls = clr.classForName(elemClsName);
                if (elemCls.isAssignableFrom(type)) {
                    requiredEvaluator = eval;
                }
                evaluators.put(elemCls, eval);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.inmemoryQueryMethodEvaluatorMap.put(methodName, evaluators);
        return requiredEvaluator;
    }
}

