/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.EventListenerMetaData;
import org.datanucleus.metadata.FetchPlanMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetadataFileType;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.metadata.StoredProcQueryMetaData;

public class FileMetaData
extends MetaData {
    private static final long serialVersionUID = 6622356672262681288L;
    protected MetadataFileType type;
    protected String filename;
    protected String catalog;
    protected String schema;
    protected Collection<QueryMetaData> queries = null;
    protected Collection<StoredProcQueryMetaData> storedProcs = null;
    protected Collection<QueryResultMetaData> queryResultMetaData = null;
    protected Collection<FetchPlanMetaData> fetchPlans = null;
    protected List<PackageMetaData> packages = null;
    protected List<EventListenerMetaData> listeners = null;

    public FileMetaData() {
    }

    public FileMetaData(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public FileMetaData setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public FileMetaData setCatalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public FileMetaData setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public MetadataFileType getType() {
        return this.type;
    }

    public FileMetaData setType(MetadataFileType type) {
        this.type = type;
        return this;
    }

    public int getNoOfQueries() {
        return this.queries != null ? this.queries.size() : 0;
    }

    public QueryMetaData[] getQueries() {
        return this.queries == null ? null : this.queries.toArray(new QueryMetaData[this.queries.size()]);
    }

    public int getNoOfStoredProcQueries() {
        return this.storedProcs != null ? this.storedProcs.size() : 0;
    }

    public StoredProcQueryMetaData[] getStoredProcQueries() {
        return this.storedProcs == null ? null : this.storedProcs.toArray(new StoredProcQueryMetaData[this.storedProcs.size()]);
    }

    public int getNoOfFetchPlans() {
        return this.fetchPlans != null ? this.fetchPlans.size() : 0;
    }

    public FetchPlanMetaData[] getFetchPlans() {
        return this.fetchPlans == null ? null : this.fetchPlans.toArray(new FetchPlanMetaData[this.fetchPlans.size()]);
    }

    public int getNoOfPackages() {
        return this.packages != null ? this.packages.size() : 0;
    }

    public PackageMetaData getPackage(int i) {
        if (this.packages == null) {
            return null;
        }
        return this.packages.get(i);
    }

    public PackageMetaData getPackage(String name) {
        if (this.packages == null) {
            return null;
        }
        for (PackageMetaData p : this.packages) {
            if (!p.name.equals(name)) continue;
            return p;
        }
        return null;
    }

    public ClassMetaData getClass(String pkg_name, String class_name) {
        if (pkg_name == null || class_name == null) {
            return null;
        }
        PackageMetaData pmd = this.getPackage(pkg_name);
        if (pmd != null) {
            return pmd.getClass(class_name);
        }
        return null;
    }

    public QueryMetaData newQueryMetadata(String queryName) {
        QueryMetaData qmd = new QueryMetaData(queryName);
        if (this.queries == null) {
            this.queries = new HashSet<QueryMetaData>();
        }
        this.queries.add(qmd);
        qmd.parent = this;
        return qmd;
    }

    public StoredProcQueryMetaData newStoredProcQueryMetaData(String queryName) {
        StoredProcQueryMetaData qmd = new StoredProcQueryMetaData(queryName);
        if (this.storedProcs == null) {
            this.storedProcs = new HashSet<StoredProcQueryMetaData>();
        }
        this.storedProcs.add(qmd);
        qmd.parent = this;
        return qmd;
    }

    public FetchPlanMetaData newFetchPlanMetadata(String name) {
        FetchPlanMetaData fpmd = new FetchPlanMetaData(name);
        if (this.fetchPlans == null) {
            this.fetchPlans = new HashSet<FetchPlanMetaData>();
        }
        this.fetchPlans.add(fpmd);
        fpmd.parent = this;
        return fpmd;
    }

    public PackageMetaData newPackageMetadata(String name) {
        PackageMetaData pmd = new PackageMetaData(name);
        if (this.packages == null) {
            this.packages = new ArrayList<PackageMetaData>();
        } else {
            for (PackageMetaData p : this.packages) {
                if (!pmd.getName().equals(p.getName())) continue;
                return p;
            }
        }
        this.packages.add(pmd);
        pmd.parent = this;
        return pmd;
    }

    public void addListener(EventListenerMetaData listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<EventListenerMetaData>();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            listener.parent = this;
        }
    }

    public List getListeners() {
        return this.listeners;
    }

    public void addQueryResultMetaData(QueryResultMetaData resultMetaData) {
        if (this.queryResultMetaData == null) {
            this.queryResultMetaData = new HashSet<QueryResultMetaData>();
        }
        if (!this.queryResultMetaData.contains(resultMetaData)) {
            this.queryResultMetaData.add(resultMetaData);
            resultMetaData.parent = this;
        }
    }

    public QueryResultMetaData newQueryResultMetadata(String name) {
        QueryResultMetaData qrmd = new QueryResultMetaData(name);
        this.addQueryResultMetaData(qrmd);
        return qrmd;
    }

    public QueryResultMetaData[] getQueryResultMetaData() {
        if (this.queryResultMetaData == null) {
            return null;
        }
        return this.queryResultMetaData.toArray(new QueryResultMetaData[this.queryResultMetaData.size()]);
    }
}

